/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch.OpenSearchAsyncClientBase;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.CreateRequest;
import org.opensearch.client.opensearch.core.CreateResponse;
import org.opensearch.client.opensearch.core.ExplainRequest;
import org.opensearch.client.opensearch.core.ExplainResponse;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.opensearch.client.opensearch.core.GetSourceRequest;
import org.opensearch.client.opensearch.core.GetSourceResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.MgetRequest;
import org.opensearch.client.opensearch.core.MgetResponse;
import org.opensearch.client.opensearch.core.MsearchRequest;
import org.opensearch.client.opensearch.core.MsearchResponse;
import org.opensearch.client.opensearch.core.MsearchTemplateRequest;
import org.opensearch.client.opensearch.core.MsearchTemplateResponse;
import org.opensearch.client.opensearch.core.ScriptsPainlessExecuteRequest;
import org.opensearch.client.opensearch.core.ScriptsPainlessExecuteResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.SearchTemplateRequest;
import org.opensearch.client.opensearch.core.SearchTemplateResponse;
import org.opensearch.client.opensearch.core.TermvectorsRequest;
import org.opensearch.client.opensearch.core.TermvectorsResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.endpoints.EndpointWithResponseMapperAttr;
import org.opensearch.client.util.ObjectBuilder;

public class OpenSearchAsyncClient
extends OpenSearchAsyncClientBase<OpenSearchAsyncClient> {
    public OpenSearchAsyncClient(OpenSearchTransport transport) {
        super(transport, (TransportOptions)null);
    }

    public OpenSearchAsyncClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public OpenSearchAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new OpenSearchAsyncClient((OpenSearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<BulkResponse> bulk(BulkRequest request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)BulkRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<BulkResponse> bulk(Function<BulkRequest.Builder, ObjectBuilder<BulkRequest>> fn) throws IOException, OpenSearchException {
        return this.bulk(fn.apply(new BulkRequest.Builder()).build());
    }

    public CompletableFuture<BulkResponse> bulk() throws IOException, OpenSearchException {
        return ((OpenSearchTransport)this.transport).performRequestAsync(new BulkRequest.Builder().build(), BulkRequest._ENDPOINT, this.transportOptions);
    }

    public <TDocument> CompletableFuture<CreateResponse> create(CreateRequest<TDocument> request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)CreateRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<CreateResponse> create(Function<CreateRequest.Builder<TDocument>, ObjectBuilder<CreateRequest<TDocument>>> fn) throws IOException, OpenSearchException {
        return this.create(fn.apply(new CreateRequest.Builder()).build());
    }

    public <TDocument> CompletableFuture<ExplainResponse<TDocument>> explain(ExplainRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = ExplainRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.explain.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<ExplainResponse<TDocument>> explain(Function<ExplainRequest.Builder, ObjectBuilder<ExplainRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.explain(fn.apply(new ExplainRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<GetResponse<TDocument>> get(GetRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = GetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.get.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<GetResponse<TDocument>> get(Function<GetRequest.Builder, ObjectBuilder<GetRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.get(fn.apply(new GetRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<GetSourceResponse<TDocument>> getSource(GetSourceRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = GetSourceRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.get_source.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<GetSourceResponse<TDocument>> getSource(Function<GetSourceRequest.Builder, ObjectBuilder<GetSourceRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.getSource(fn.apply(new GetSourceRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<IndexResponse> index(IndexRequest<TDocument> request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)IndexRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<IndexResponse> index(Function<IndexRequest.Builder<TDocument>, ObjectBuilder<IndexRequest<TDocument>>> fn) throws IOException, OpenSearchException {
        return this.index(fn.apply(new IndexRequest.Builder()).build());
    }

    public <TDocument> CompletableFuture<MgetResponse<TDocument>> mget(MgetRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = MgetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.mget.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<MgetResponse<TDocument>> mget(Function<MgetRequest.Builder, ObjectBuilder<MgetRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.mget(fn.apply(new MgetRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<MsearchResponse<TDocument>> msearch(MsearchRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = MsearchRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.msearch.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<MsearchResponse<TDocument>> msearch(Function<MsearchRequest.Builder, ObjectBuilder<MsearchRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.msearch(fn.apply(new MsearchRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<MsearchTemplateResponse<TDocument>> msearchTemplate(MsearchTemplateRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = MsearchTemplateRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.msearch_template.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<MsearchTemplateResponse<TDocument>> msearchTemplate(Function<MsearchTemplateRequest.Builder, ObjectBuilder<MsearchTemplateRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.msearchTemplate(fn.apply(new MsearchTemplateRequest.Builder()).build(), tDocumentClass);
    }

    public <TResult> CompletableFuture<ScriptsPainlessExecuteResponse<TResult>> scriptsPainlessExecute(ScriptsPainlessExecuteRequest request, Class<TResult> tResultClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = ScriptsPainlessExecuteRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.scripts_painless_execute.TResult", this.getDeserializer(tResultClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TResult> CompletableFuture<ScriptsPainlessExecuteResponse<TResult>> scriptsPainlessExecute(Function<ScriptsPainlessExecuteRequest.Builder, ObjectBuilder<ScriptsPainlessExecuteRequest>> fn, Class<TResult> tResultClass) throws IOException, OpenSearchException {
        return this.scriptsPainlessExecute(fn.apply(new ScriptsPainlessExecuteRequest.Builder()).build(), tResultClass);
    }

    public <TDocument> CompletableFuture<ScrollResponse<TDocument>> scroll(ScrollRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = ScrollRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.scroll.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<ScrollResponse<TDocument>> scroll(Function<ScrollRequest.Builder, ObjectBuilder<ScrollRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.scroll(fn.apply(new ScrollRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<SearchResponse<TDocument>> search(SearchRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = SearchRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.search.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<SearchResponse<TDocument>> search(Function<SearchRequest.Builder, ObjectBuilder<SearchRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.search(fn.apply(new SearchRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<SearchTemplateResponse<TDocument>> searchTemplate(SearchTemplateRequest request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = SearchTemplateRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.search_template.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<SearchTemplateResponse<TDocument>> searchTemplate(Function<SearchTemplateRequest.Builder, ObjectBuilder<SearchTemplateRequest>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.searchTemplate(fn.apply(new SearchTemplateRequest.Builder()).build(), tDocumentClass);
    }

    public <TDocument> CompletableFuture<TermvectorsResponse> termvectors(TermvectorsRequest<TDocument> request) throws IOException, OpenSearchException {
        JsonEndpoint endpoint = (JsonEndpoint)TermvectorsRequest._ENDPOINT;
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument> CompletableFuture<TermvectorsResponse> termvectors(Function<TermvectorsRequest.Builder<TDocument>, ObjectBuilder<TermvectorsRequest<TDocument>>> fn) throws IOException, OpenSearchException {
        return this.termvectors(fn.apply(new TermvectorsRequest.Builder()).build());
    }

    public <TDocument, TPartialDocument> CompletableFuture<UpdateResponse<TDocument>> update(UpdateRequest<TDocument, TPartialDocument> request, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = UpdateRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "org.opensearch.client:Deserializer:_global.update.TDocument", this.getDeserializer(tDocumentClass));
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TDocument, TPartialDocument> CompletableFuture<UpdateResponse<TDocument>> update(Function<UpdateRequest.Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>>> fn, Class<TDocument> tDocumentClass) throws IOException, OpenSearchException {
        return this.update(fn.apply(new UpdateRequest.Builder()).build(), tDocumentClass);
    }
}

