/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Keyword;
import org.jooq.Operator;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class CombinedCondition
extends AbstractCondition {
    private static final long serialVersionUID = -7373293246207052549L;
    private static final Clause[] CLAUSES_AND = new Clause[]{Clause.CONDITION, Clause.CONDITION_AND};
    private static final Clause[] CLAUSES_OR = new Clause[]{Clause.CONDITION, Clause.CONDITION_OR};
    private final Operator operator;
    private final List<Condition> conditions;

    private CombinedCondition(Operator operator, int size) {
        if (operator == null) {
            throw new IllegalArgumentException("The argument 'operator' must not be null");
        }
        this.operator = operator;
        this.conditions = new ArrayList<Condition>(size);
    }

    CombinedCondition(Operator operator, Condition left, Condition right) {
        this(operator, 2);
        this.add(operator, left);
        this.add(operator, right);
    }

    CombinedCondition(Operator operator, Collection<? extends Condition> conditions) {
        this(operator, conditions.size());
        for (Condition condition : conditions) {
            this.add(operator, condition);
        }
    }

    private final void add(Operator op, Condition condition) {
        if (condition instanceof CombinedCondition) {
            CombinedCondition combinedCondition = (CombinedCondition)condition;
            if (combinedCondition.operator == op) {
                this.conditions.addAll(combinedCondition.conditions);
            } else {
                this.conditions.add(condition);
            }
        } else {
            if (condition == null) {
                throw new IllegalArgumentException("The argument 'conditions' must not contain null");
            }
            this.conditions.add(condition);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.operator == Operator.AND ? CLAUSES_AND : CLAUSES_OR;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.conditions.isEmpty()) {
            if (this.operator == Operator.AND) {
                ctx.visit(DSL.trueCondition());
            } else {
                ctx.visit(DSL.falseCondition());
            }
        } else if (this.conditions.size() == 1) {
            ctx.visit(this.conditions.get(0));
        } else {
            ctx.sql('(').formatIndentStart().formatNewLine();
            Keyword op = this.operator == Operator.AND ? Keywords.K_AND : Keywords.K_OR;
            Keyword separator = null;
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    ctx.formatSeparator();
                }
                if (separator != null) {
                    ctx.visit(separator).sql(' ');
                }
                ctx.visit(this.conditions.get(i));
                separator = op;
            }
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
    }
}

