/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.multipart;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkProtectedApi;

@SdkProtectedApi
public class S3ResumeToken {
    private final String uploadId;
    private final Long partSize;
    private final Long totalNumParts;
    private final Long numPartsCompleted;

    public S3ResumeToken(Builder builder) {
        this.uploadId = builder.uploadId;
        this.partSize = builder.partSize;
        this.totalNumParts = builder.totalNumParts;
        this.numPartsCompleted = builder.numPartsCompleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ResumeToken that = (S3ResumeToken)o;
        return this.partSize == that.partSize && this.totalNumParts == that.totalNumParts && this.numPartsCompleted == that.numPartsCompleted && Objects.equals(this.uploadId, that.uploadId);
    }

    public int hashCode() {
        return Objects.hashCode(this.uploadId);
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long partSize() {
        return this.partSize;
    }

    public Long totalNumParts() {
        return this.totalNumParts;
    }

    public Long numPartsCompleted() {
        return this.numPartsCompleted;
    }

    public static final class Builder {
        private String uploadId;
        private Long partSize;
        private Long totalNumParts;
        private Long numPartsCompleted;

        private Builder() {
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public Builder partSize(Long partSize) {
            this.partSize = partSize;
            return this;
        }

        public Builder totalNumParts(Long totalNumParts) {
            this.totalNumParts = totalNumParts;
            return this;
        }

        public Builder numPartsCompleted(Long numPartsCompleted) {
            this.numPartsCompleted = numPartsCompleted;
            return this;
        }

        public S3ResumeToken build() {
            return new S3ResumeToken(this);
        }
    }
}

