/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AArch64 target                         *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 101;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AArch64InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AArch64InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AArch64InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AArch64InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(2),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_nxv1s1,
  GILLT_nxv2s1,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv8s1,
  GILLT_nxv8s16,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
};
const static size_t NumTypeObjects = 24;
const static LLT TypeObjects[] = {
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasPAuthBit = 6,
  Feature_HasJSBit = 8,
  Feature_HasComplxNumBit = 69,
  Feature_HasRCPC_IMMOBit = 90,
  Feature_HasFPARMv8Bit = 7,
  Feature_HasNEONBit = 5,
  Feature_HasSM4Bit = 68,
  Feature_HasSHA3Bit = 67,
  Feature_HasSHA2Bit = 19,
  Feature_HasAESBit = 18,
  Feature_HasDotProdBit = 2,
  Feature_HasCRCBit = 10,
  Feature_HasCSSCBit = 20,
  Feature_HasNoCSSCBit = 32,
  Feature_HasLSEBit = 33,
  Feature_HasNoLSEBit = 100,
  Feature_HasRDMBit = 16,
  Feature_HasFullFP16Bit = 13,
  Feature_HasNoFullFP16Bit = 87,
  Feature_HasFP16FMLBit = 4,
  Feature_HasFuseAESBit = 81,
  Feature_HasSVEBit = 26,
  Feature_HasSVE2Bit = 27,
  Feature_HasSVE2p1Bit = 47,
  Feature_HasSVEAESBit = 29,
  Feature_HasSVESM4Bit = 30,
  Feature_HasSVESHA3Bit = 98,
  Feature_HasSVEBitPermBit = 40,
  Feature_HasSMEandIsNonStreamingSafeBit = 60,
  Feature_HasSMEBit = 53,
  Feature_HasSMEF64F64Bit = 55,
  Feature_HasSMEF16F16Bit = 57,
  Feature_HasSMEI16I64Bit = 58,
  Feature_HasSME2andIsNonStreamingSafeBit = 64,
  Feature_HasSME2Bit = 62,
  Feature_HasSME2p1Bit = 66,
  Feature_HasFP8Bit = 21,
  Feature_HasFAMINMAXBit = 22,
  Feature_HasFP8FMABit = 23,
  Feature_HasSSVE_FP8FMABit = 50,
  Feature_HasFP8DOT2Bit = 24,
  Feature_HasSSVE_FP8DOT2Bit = 44,
  Feature_HasFP8DOT4Bit = 25,
  Feature_HasSSVE_FP8DOT4Bit = 51,
  Feature_HasLUTBit = 52,
  Feature_HasSME_LUTv2Bit = 65,
  Feature_HasSMEF8F16Bit = 56,
  Feature_HasSMEF8F32Bit = 54,
  Feature_HasSME_MOP4Bit = 59,
  Feature_HasSME_TMOPBit = 63,
  Feature_HasCMPBRBit = 88,
  Feature_HasFPRCVTBit = 14,
  Feature_HasLSFEBit = 34,
  Feature_HasSVE_or_SMEBit = 0,
  Feature_HasNonStreamingSVE_or_SME2p1Bit = 97,
  Feature_HasNonStreamingSVE_or_SME2p2Bit = 41,
  Feature_HasNonStreamingSVE_or_SSVE_AESBit = 28,
  Feature_HasNonStreamingSVE_or_SSVE_BitPermBit = 39,
  Feature_HasNonStreamingSVE_or_SSVE_FEXPABit = 43,
  Feature_HasSVE2_or_SMEBit = 36,
  Feature_HasNonStreamingSVE2_or_SME2Bit = 49,
  Feature_HasSVE2p1_or_SMEBit = 61,
  Feature_HasSVE2p1_or_SME2Bit = 46,
  Feature_HasSVE2p1_or_SME2p1Bit = 48,
  Feature_HasSVE2p1_or_StreamingSME2Bit = 31,
  Feature_HasSVE2p2_or_SME2p2Bit = 35,
  Feature_HasNonStreamingSVE2p2_or_SME2p2Bit = 42,
  Feature_HasSMEF16F16_or_SMEF8F16Bit = 99,
  Feature_HasNEONandIsStreamingSafeBit = 17,
  Feature_HasNEONandIsSME2p2StreamingSafeBit = 77,
  Feature_HasRCPCBit = 89,
  Feature_HasFRInt3264Bit = 15,
  Feature_HasMTEBit = 11,
  Feature_HasTMEBit = 9,
  Feature_HasMatMulInt8Bit = 3,
  Feature_HasMatMulFP32Bit = 96,
  Feature_HasMatMulFP64Bit = 45,
  Feature_HasLS64Bit = 84,
  Feature_HasHBCBit = 12,
  Feature_HasRCPC3Bit = 85,
  Feature_HasGCSBit = 1,
  Feature_HasCPABit = 86,
  Feature_IsLEBit = 75,
  Feature_IsBEBit = 80,
  Feature_UseExperimentalZeroingPseudosBit = 38,
  Feature_UseAlternateSExtLoadCVTF32Bit = 79,
  Feature_UseScalarIncVLBit = 37,
  Feature_NoUseScalarIncVLBit = 93,
  Feature_HasFastIncVLBit = 94,
  Feature_UseSVEFPLD1RBit = 92,
  Feature_UseLDAPURBit = 91,
  Feature_AllowMisalignedMemAccessesBit = 95,
  Feature_NotForCodeSizeBit = 78,
  Feature_UseSTRQroBit = 76,
  Feature_TailCallX16X17Bit = 71,
  Feature_TailCallX17Bit = 82,
  Feature_TailCallNotX16Bit = 83,
  Feature_TailCallAnyBit = 70,
  Feature_SLSBLRMitigationBit = 74,
  Feature_NoSLSBLRMitigationBit = 73,
  Feature_OptimizedGISelOrOtherSelectorBit = 72,
};

PredicateBitset AArch64InstructionSelector::
computeAvailableModuleFeatures(const AArch64Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasPAuth())
    Features.set(Feature_HasPAuthBit);
  if (Subtarget->hasJS())
    Features.set(Feature_HasJSBit);
  if (Subtarget->hasComplxNum())
    Features.set(Feature_HasComplxNumBit);
  if (Subtarget->hasRCPC_IMMO())
    Features.set(Feature_HasRCPC_IMMOBit);
  if (Subtarget->hasFPARMv8())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->isNeonAvailable())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasSHA3())
    Features.set(Feature_HasSHA3Bit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasCSSC())
    Features.set(Feature_HasCSSCBit);
  if (!Subtarget->hasCSSC())
    Features.set(Feature_HasNoCSSCBit);
  if (Subtarget->hasLSE())
    Features.set(Feature_HasLSEBit);
  if (!Subtarget->hasLSE())
    Features.set(Feature_HasNoLSEBit);
  if (Subtarget->hasRDM())
    Features.set(Feature_HasRDMBit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (!Subtarget->hasFullFP16())
    Features.set(Feature_HasNoFullFP16Bit);
  if (Subtarget->hasFP16FML())
    Features.set(Feature_HasFP16FMLBit);
  if (Subtarget->hasFuseAES())
    Features.set(Feature_HasFuseAESBit);
  if (Subtarget->isSVEAvailable())
    Features.set(Feature_HasSVEBit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2())
    Features.set(Feature_HasSVE2Bit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVE2p1())
    Features.set(Feature_HasSVE2p1Bit);
  if (Subtarget->hasSVEAES())
    Features.set(Feature_HasSVEAESBit);
  if (Subtarget->isSVEAvailable() && Subtarget->hasSVESM4())
    Features.set(Feature_HasSVESM4Bit);
  if (Subtarget->hasSVESHA3())
    Features.set(Feature_HasSVESHA3Bit);
  if (Subtarget->hasSVEBitPerm())
    Features.set(Feature_HasSVEBitPermBit);
  if (Subtarget->hasSME())
    Features.set(Feature_HasSMEandIsNonStreamingSafeBit);
  if (Subtarget->isStreaming() && Subtarget->hasSME())
    Features.set(Feature_HasSMEBit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEF64F64())
    Features.set(Feature_HasSMEF64F64Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEF16F16())
    Features.set(Feature_HasSMEF16F16Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEI16I64())
    Features.set(Feature_HasSMEI16I64Bit);
  if (Subtarget->hasSME2())
    Features.set(Feature_HasSME2andIsNonStreamingSafeBit);
  if (Subtarget->isStreaming() && Subtarget->hasSME2())
    Features.set(Feature_HasSME2Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSME2p1())
    Features.set(Feature_HasSME2p1Bit);
  if (Subtarget->hasFP8())
    Features.set(Feature_HasFP8Bit);
  if (Subtarget->hasFAMINMAX())
    Features.set(Feature_HasFAMINMAXBit);
  if (Subtarget->hasFP8FMA())
    Features.set(Feature_HasFP8FMABit);
  if (Subtarget->hasSSVE_FP8FMA() || (Subtarget->hasSVE2() && Subtarget->hasFP8FMA()))
    Features.set(Feature_HasSSVE_FP8FMABit);
  if (Subtarget->hasFP8DOT2())
    Features.set(Feature_HasFP8DOT2Bit);
  if (Subtarget->hasSSVE_FP8DOT2() || (Subtarget->hasSVE2() && Subtarget->hasFP8DOT2()))
    Features.set(Feature_HasSSVE_FP8DOT2Bit);
  if (Subtarget->hasFP8DOT4())
    Features.set(Feature_HasFP8DOT4Bit);
  if (Subtarget->hasSSVE_FP8DOT4() || (Subtarget->hasSVE2() && Subtarget->hasFP8DOT4()))
    Features.set(Feature_HasSSVE_FP8DOT4Bit);
  if (Subtarget->hasLUT())
    Features.set(Feature_HasLUTBit);
  if (Subtarget->isStreaming() && Subtarget->hasSME_LUTv2())
    Features.set(Feature_HasSME_LUTv2Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEF8F16())
    Features.set(Feature_HasSMEF8F16Bit);
  if (Subtarget->isStreaming() && Subtarget->hasSMEF8F32())
    Features.set(Feature_HasSMEF8F32Bit);
  if ((Subtarget->isStreaming() && Subtarget->hasSME_MOP4()))
    Features.set(Feature_HasSME_MOP4Bit);
  if ((Subtarget->isStreaming() && Subtarget->hasSME_TMOP()))
    Features.set(Feature_HasSME_TMOPBit);
  if (Subtarget->hasCMPBR())
    Features.set(Feature_HasCMPBRBit);
  if (Subtarget->hasFPRCVT())
    Features.set(Feature_HasFPRCVTBit);
  if (Subtarget->hasLSFE())
    Features.set(Feature_HasLSFEBit);
  if (Subtarget->isSVEorStreamingSVEAvailable())
    Features.set(Feature_HasSVE_or_SMEBit);
  if (Subtarget->isSVEAvailable() ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSME2p1()))
    Features.set(Feature_HasNonStreamingSVE_or_SME2p1Bit);
  if (Subtarget->isSVEAvailable() ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSME2p2()))
    Features.set(Feature_HasNonStreamingSVE_or_SME2p2Bit);
  if (Subtarget->isSVEAvailable() ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSSVE_AES()))
    Features.set(Feature_HasNonStreamingSVE_or_SSVE_AESBit);
  if (Subtarget->isSVEAvailable() ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSSVE_BitPerm()))
    Features.set(Feature_HasNonStreamingSVE_or_SSVE_BitPermBit);
  if (Subtarget->isSVEAvailable() ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSSVE_FEXPA()))
    Features.set(Feature_HasNonStreamingSVE_or_SSVE_FEXPABit);
  if (Subtarget->isSVEorStreamingSVEAvailable() && (Subtarget->hasSVE2() || Subtarget->hasSME()))
    Features.set(Feature_HasSVE2_or_SMEBit);
  if ((Subtarget->isSVEAvailable() && Subtarget->hasSVE2()) ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSME2()))
    Features.set(Feature_HasNonStreamingSVE2_or_SME2Bit);
  if (Subtarget->isSVEorStreamingSVEAvailable() && (Subtarget->hasSVE2p1() || Subtarget->hasSME()))
    Features.set(Feature_HasSVE2p1_or_SMEBit);
  if (Subtarget->isSVEorStreamingSVEAvailable() && (Subtarget->hasSVE2p1() || Subtarget->hasSME2()))
    Features.set(Feature_HasSVE2p1_or_SME2Bit);
  if (Subtarget->isSVEorStreamingSVEAvailable() && (Subtarget->hasSVE2p1() || Subtarget->hasSME2p1()))
    Features.set(Feature_HasSVE2p1_or_SME2p1Bit);
  if ((Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSVE2p1()) ||(Subtarget->isStreaming() && Subtarget->hasSME2()))
    Features.set(Feature_HasSVE2p1_or_StreamingSME2Bit);
  if (Subtarget->isSVEorStreamingSVEAvailable() && (Subtarget->hasSVE2p2() || Subtarget->hasSME2p2()))
    Features.set(Feature_HasSVE2p2_or_SME2p2Bit);
  if ((Subtarget->isSVEAvailable() && Subtarget->hasSVE2p2()) ||(Subtarget->isSVEorStreamingSVEAvailable() && Subtarget->hasSME2p2()))
    Features.set(Feature_HasNonStreamingSVE2p2_or_SME2p2Bit);
  if (Subtarget->isStreaming() && (Subtarget->hasSMEF16F16() || Subtarget->hasSMEF8F16()))
    Features.set(Feature_HasSMEF16F16_or_SMEF8F16Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONandIsStreamingSafeBit);
  if (Subtarget->isNeonAvailable() || (Subtarget->hasNEON() && Subtarget->hasSME2p2()))
    Features.set(Feature_HasNEONandIsSME2p2StreamingSafeBit);
  if (Subtarget->hasRCPC())
    Features.set(Feature_HasRCPCBit);
  if (Subtarget->hasFRInt3264())
    Features.set(Feature_HasFRInt3264Bit);
  if (Subtarget->hasMTE())
    Features.set(Feature_HasMTEBit);
  if (Subtarget->hasTME())
    Features.set(Feature_HasTMEBit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasMatMulFP32())
    Features.set(Feature_HasMatMulFP32Bit);
  if (Subtarget->hasMatMulFP64())
    Features.set(Feature_HasMatMulFP64Bit);
  if (Subtarget->hasLS64())
    Features.set(Feature_HasLS64Bit);
  if (Subtarget->hasHBC())
    Features.set(Feature_HasHBCBit);
  if (Subtarget->hasRCPC3())
    Features.set(Feature_HasRCPC3Bit);
  if (Subtarget->hasGCS())
    Features.set(Feature_HasGCSBit);
  if (Subtarget->hasCPA())
    Features.set(Feature_HasCPABit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBEBit);
  if (Subtarget->useExperimentalZeroingPseudos())
    Features.set(Feature_UseExperimentalZeroingPseudosBit);
  if (Subtarget->useAlternateSExtLoadCVTF32Pattern())
    Features.set(Feature_UseAlternateSExtLoadCVTF32Bit);
  if (Subtarget->useScalarIncVL())
    Features.set(Feature_UseScalarIncVLBit);
  if (!Subtarget->useScalarIncVL())
    Features.set(Feature_NoUseScalarIncVLBit);
  if (!Subtarget->hasDisableFastIncVL())
    Features.set(Feature_HasFastIncVLBit);
  if (!Subtarget->noSVEFPLD1R())
    Features.set(Feature_UseSVEFPLD1RBit);
  if (!Subtarget->avoidLDAPUR())
    Features.set(Feature_UseLDAPURBit);
  if (!Subtarget->requiresStrictAlign())
    Features.set(Feature_AllowMisalignedMemAccessesBit);
  return Features;
}

void AArch64InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AArch64Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AArch64InstructionSelector::
computeAvailableFunctionFeatures(const AArch64Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!shouldOptForSize(MF))
    Features.set(Feature_NotForCodeSizeBit);
  if (!Subtarget->isSTRQroSlow() || shouldOptForSize(MF))
    Features.set(Feature_UseSTRQroBit);
  if (  MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && !MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallX16X17Bit);
  if ( MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallX17Bit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallNotX16Bit);
  if ( !MF->getInfo<AArch64FunctionInfo>()->branchTargetEnforcement() && !MF->getInfo<AArch64FunctionInfo>()->branchProtectionPAuthLR() )
    Features.set(Feature_TailCallAnyBit);
  if ( MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<AArch64Subtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (!MF->getFunction().hasOptNone() || MF->getProperties().hasFailedISel() || !MF->getProperties().hasLegalized())
    Features.set(Feature_OptimizedGISelOrOtherSelectorBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAES,
  GIFBS_HasCPA,
  GIFBS_HasCRC,
  GIFBS_HasCSSC,
  GIFBS_HasDotProd,
  GIFBS_HasFP8,
  GIFBS_HasFP8DOT2,
  GIFBS_HasFP8DOT4,
  GIFBS_HasFP8FMA,
  GIFBS_HasFPARMv8,
  GIFBS_HasFRInt3264,
  GIFBS_HasFullFP16,
  GIFBS_HasFuseAES,
  GIFBS_HasGCS,
  GIFBS_HasLSE,
  GIFBS_HasLSFE,
  GIFBS_HasLUT,
  GIFBS_HasMTE,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasNEONandIsSME2p2StreamingSafe,
  GIFBS_HasNEONandIsStreamingSafe,
  GIFBS_HasNoCSSC,
  GIFBS_HasNoFullFP16,
  GIFBS_HasNoLSE,
  GIFBS_HasNonStreamingSVE2p2_or_SME2p2,
  GIFBS_HasNonStreamingSVE_or_SME2p2,
  GIFBS_HasNonStreamingSVE_or_SSVE_FEXPA,
  GIFBS_HasPAuth,
  GIFBS_HasRCPC,
  GIFBS_HasRCPC_IMMO,
  GIFBS_HasRDM,
  GIFBS_HasSHA2,
  GIFBS_HasSHA3,
  GIFBS_HasSM4,
  GIFBS_HasSME,
  GIFBS_HasSME2,
  GIFBS_HasSMEF16F16,
  GIFBS_HasSMEF64F64,
  GIFBS_HasSMEF8F16,
  GIFBS_HasSMEF8F32,
  GIFBS_HasSMEI16I64,
  GIFBS_HasSME_MOP4,
  GIFBS_HasSMEandIsNonStreamingSafe,
  GIFBS_HasSSVE_FP8DOT2,
  GIFBS_HasSSVE_FP8DOT4,
  GIFBS_HasSSVE_FP8FMA,
  GIFBS_HasSVE,
  GIFBS_HasSVE2,
  GIFBS_HasSVE2_or_SME,
  GIFBS_HasSVE2p1_or_SME,
  GIFBS_HasSVE2p1_or_SME2,
  GIFBS_HasSVE2p1_or_SME2p1,
  GIFBS_HasSVESM4,
  GIFBS_HasSVE_or_SME,
  GIFBS_HasTME,
  GIFBS_IsBE,
  GIFBS_IsLE,
  GIFBS_OptimizedGISelOrOtherSelector,
  GIFBS_UseSTRQro,
  GIFBS_HasComplxNum_HasNEON,
  GIFBS_HasFAMINMAX_HasNEON,
  GIFBS_HasFAMINMAX_HasNonStreamingSVE2_or_SME2,
  GIFBS_HasFP16FML_HasNEON,
  GIFBS_HasFP8_HasNonStreamingSVE2_or_SME2,
  GIFBS_HasFPARMv8_HasJS,
  GIFBS_HasFPRCVT_HasNEON,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEONandIsSME2p2StreamingSafe,
  GIFBS_HasFullFP16_HasNEONandIsStreamingSafe,
  GIFBS_HasLUT_HasNonStreamingSVE2_or_SME2,
  GIFBS_HasMatMulFP32_HasSVE,
  GIFBS_HasMatMulFP64_HasSVE,
  GIFBS_HasMatMulFP64_HasSVE_or_SME,
  GIFBS_HasMatMulInt8_HasSVE,
  GIFBS_HasMatMulInt8_HasSVE_or_SME,
  GIFBS_HasNEON_HasRCPC3,
  GIFBS_HasNEON_HasRDM,
  GIFBS_HasNonStreamingSVE_or_SME2p1_HasSVESHA3,
  GIFBS_HasNonStreamingSVE_or_SSVE_AES_HasSVEAES,
  GIFBS_HasNonStreamingSVE_or_SSVE_BitPerm_HasSVEBitPerm,
  GIFBS_HasRCPC_IMMO_UseLDAPUR,
  GIFBS_HasSMEF16F16_HasSME_MOP4,
  GIFBS_HasSMEF64F64_HasSME_MOP4,
  GIFBS_HasSMEF8F16_HasSME_MOP4,
  GIFBS_HasSMEF8F32_HasSME_MOP4,
  GIFBS_HasSMEI16I64_HasSME_MOP4,
  GIFBS_HasSVE_or_SME_IsLE,
  GIFBS_HasSVE_or_SME_UseScalarIncVL,
  GIFBS_IsLE_UseSTRQro,
  GIFBS_AllowMisalignedMemAccesses_HasSVE_or_SME_IsLE,
  GIFBS_HasComplxNum_HasFullFP16_HasNEON,
  GIFBS_HasNEON_NotForCodeSize_UseAlternateSExtLoadCVTF32,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAESBit, },
  {Feature_HasCPABit, },
  {Feature_HasCRCBit, },
  {Feature_HasCSSCBit, },
  {Feature_HasDotProdBit, },
  {Feature_HasFP8Bit, },
  {Feature_HasFP8DOT2Bit, },
  {Feature_HasFP8DOT4Bit, },
  {Feature_HasFP8FMABit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFRInt3264Bit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasFuseAESBit, },
  {Feature_HasGCSBit, },
  {Feature_HasLSEBit, },
  {Feature_HasLSFEBit, },
  {Feature_HasLUTBit, },
  {Feature_HasMTEBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasNEONandIsSME2p2StreamingSafeBit, },
  {Feature_HasNEONandIsStreamingSafeBit, },
  {Feature_HasNoCSSCBit, },
  {Feature_HasNoFullFP16Bit, },
  {Feature_HasNoLSEBit, },
  {Feature_HasNonStreamingSVE2p2_or_SME2p2Bit, },
  {Feature_HasNonStreamingSVE_or_SME2p2Bit, },
  {Feature_HasNonStreamingSVE_or_SSVE_FEXPABit, },
  {Feature_HasPAuthBit, },
  {Feature_HasRCPCBit, },
  {Feature_HasRCPC_IMMOBit, },
  {Feature_HasRDMBit, },
  {Feature_HasSHA2Bit, },
  {Feature_HasSHA3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSMEBit, },
  {Feature_HasSME2Bit, },
  {Feature_HasSMEF16F16Bit, },
  {Feature_HasSMEF64F64Bit, },
  {Feature_HasSMEF8F16Bit, },
  {Feature_HasSMEF8F32Bit, },
  {Feature_HasSMEI16I64Bit, },
  {Feature_HasSME_MOP4Bit, },
  {Feature_HasSMEandIsNonStreamingSafeBit, },
  {Feature_HasSSVE_FP8DOT2Bit, },
  {Feature_HasSSVE_FP8DOT4Bit, },
  {Feature_HasSSVE_FP8FMABit, },
  {Feature_HasSVEBit, },
  {Feature_HasSVE2Bit, },
  {Feature_HasSVE2_or_SMEBit, },
  {Feature_HasSVE2p1_or_SMEBit, },
  {Feature_HasSVE2p1_or_SME2Bit, },
  {Feature_HasSVE2p1_or_SME2p1Bit, },
  {Feature_HasSVESM4Bit, },
  {Feature_HasSVE_or_SMEBit, },
  {Feature_HasTMEBit, },
  {Feature_IsBEBit, },
  {Feature_IsLEBit, },
  {Feature_OptimizedGISelOrOtherSelectorBit, },
  {Feature_UseSTRQroBit, },
  {Feature_HasComplxNumBit, Feature_HasNEONBit, },
  {Feature_HasFAMINMAXBit, Feature_HasNEONBit, },
  {Feature_HasFAMINMAXBit, Feature_HasNonStreamingSVE2_or_SME2Bit, },
  {Feature_HasFP16FMLBit, Feature_HasNEONBit, },
  {Feature_HasFP8Bit, Feature_HasNonStreamingSVE2_or_SME2Bit, },
  {Feature_HasFPARMv8Bit, Feature_HasJSBit, },
  {Feature_HasFPRCVTBit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONandIsSME2p2StreamingSafeBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONandIsStreamingSafeBit, },
  {Feature_HasLUTBit, Feature_HasNonStreamingSVE2_or_SME2Bit, },
  {Feature_HasMatMulFP32Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulFP64Bit, Feature_HasSVE_or_SMEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVEBit, },
  {Feature_HasMatMulInt8Bit, Feature_HasSVE_or_SMEBit, },
  {Feature_HasNEONBit, Feature_HasRCPC3Bit, },
  {Feature_HasNEONBit, Feature_HasRDMBit, },
  {Feature_HasNonStreamingSVE_or_SME2p1Bit, Feature_HasSVESHA3Bit, },
  {Feature_HasNonStreamingSVE_or_SSVE_AESBit, Feature_HasSVEAESBit, },
  {Feature_HasNonStreamingSVE_or_SSVE_BitPermBit, Feature_HasSVEBitPermBit, },
  {Feature_HasRCPC_IMMOBit, Feature_UseLDAPURBit, },
  {Feature_HasSMEF16F16Bit, Feature_HasSME_MOP4Bit, },
  {Feature_HasSMEF64F64Bit, Feature_HasSME_MOP4Bit, },
  {Feature_HasSMEF8F16Bit, Feature_HasSME_MOP4Bit, },
  {Feature_HasSMEF8F32Bit, Feature_HasSME_MOP4Bit, },
  {Feature_HasSMEI16I64Bit, Feature_HasSME_MOP4Bit, },
  {Feature_HasSVE_or_SMEBit, Feature_IsLEBit, },
  {Feature_HasSVE_or_SMEBit, Feature_UseScalarIncVLBit, },
  {Feature_IsLEBit, Feature_UseSTRQroBit, },
  {Feature_AllowMisalignedMemAccessesBit, Feature_HasSVE_or_SMEBit, Feature_IsLEBit, },
  {Feature_HasComplxNumBit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasNEONBit, Feature_NotForCodeSizeBit, Feature_UseAlternateSExtLoadCVTF32Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addsub_shifted_imm32,
  GICP_gi_addsub_shifted_imm64,
  GICP_gi_am_indexed128,
  GICP_gi_am_indexed16,
  GICP_gi_am_indexed32,
  GICP_gi_am_indexed64,
  GICP_gi_am_indexed8,
  GICP_gi_am_unscaled128,
  GICP_gi_am_unscaled16,
  GICP_gi_am_unscaled32,
  GICP_gi_am_unscaled64,
  GICP_gi_am_unscaled8,
  GICP_gi_arith_extended_reg32_i32,
  GICP_gi_arith_extended_reg32_i64,
  GICP_gi_arith_extended_reg32to64_i64,
  GICP_gi_arith_shifted_reg32,
  GICP_gi_arith_shifted_reg64,
  GICP_gi_extract_high_v16i8,
  GICP_gi_extract_high_v4f32,
  GICP_gi_extract_high_v4i32,
  GICP_gi_extract_high_v8f16,
  GICP_gi_extract_high_v8i16,
  GICP_gi_logical_shifted_reg32,
  GICP_gi_logical_shifted_reg64,
  GICP_gi_neg_addsub_shifted_imm32,
  GICP_gi_neg_addsub_shifted_imm64,
  GICP_gi_ro_Windexed128,
  GICP_gi_ro_Windexed16,
  GICP_gi_ro_Windexed32,
  GICP_gi_ro_Windexed64,
  GICP_gi_ro_Windexed8,
  GICP_gi_ro_Xindexed128,
  GICP_gi_ro_Xindexed16,
  GICP_gi_ro_Xindexed32,
  GICP_gi_ro_Xindexed64,
  GICP_gi_ro_Xindexed8,
};
// See constructor for table contents

AArch64InstructionSelector::ComplexMatcherMemFn
AArch64InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm32
  &AArch64InstructionSelector::selectArithImmed, // gi_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeIndexed<128>, // gi_am_indexed128
  &AArch64InstructionSelector::selectAddrModeIndexed<16>, // gi_am_indexed16
  &AArch64InstructionSelector::selectAddrModeIndexed<32>, // gi_am_indexed32
  &AArch64InstructionSelector::selectAddrModeIndexed<64>, // gi_am_indexed64
  &AArch64InstructionSelector::selectAddrModeIndexed<8>, // gi_am_indexed8
  &AArch64InstructionSelector::selectAddrModeUnscaled128, // gi_am_unscaled128
  &AArch64InstructionSelector::selectAddrModeUnscaled16, // gi_am_unscaled16
  &AArch64InstructionSelector::selectAddrModeUnscaled32, // gi_am_unscaled32
  &AArch64InstructionSelector::selectAddrModeUnscaled64, // gi_am_unscaled64
  &AArch64InstructionSelector::selectAddrModeUnscaled8, // gi_am_unscaled8
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i32
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32_i64
  &AArch64InstructionSelector::selectArithExtendedRegister, // gi_arith_extended_reg32to64_i64
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg32
  &AArch64InstructionSelector::selectArithShiftedRegister, // gi_arith_shifted_reg64
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v16i8
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v4f32
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v4i32
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v8f16
  &AArch64InstructionSelector::selectExtractHigh, // gi_extract_high_v8i16
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg32
  &AArch64InstructionSelector::selectLogicalShiftedRegister, // gi_logical_shifted_reg64
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm32
  &AArch64InstructionSelector::selectNegArithImmed, // gi_neg_addsub_shifted_imm64
  &AArch64InstructionSelector::selectAddrModeWRO<128>, // gi_ro_Windexed128
  &AArch64InstructionSelector::selectAddrModeWRO<16>, // gi_ro_Windexed16
  &AArch64InstructionSelector::selectAddrModeWRO<32>, // gi_ro_Windexed32
  &AArch64InstructionSelector::selectAddrModeWRO<64>, // gi_ro_Windexed64
  &AArch64InstructionSelector::selectAddrModeWRO<8>, // gi_ro_Windexed8
  &AArch64InstructionSelector::selectAddrModeXRO<128>, // gi_ro_Xindexed128
  &AArch64InstructionSelector::selectAddrModeXRO<16>, // gi_ro_Xindexed16
  &AArch64InstructionSelector::selectAddrModeXRO<32>, // gi_ro_Xindexed32
  &AArch64InstructionSelector::selectAddrModeXRO<64>, // gi_ro_Xindexed64
  &AArch64InstructionSelector::selectAddrModeXRO<8>, // gi_ro_Xindexed8
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_and_or_is_add = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_ldaxr_1,
  GICXXPred_MI_Predicate_ldaxr_2,
  GICXXPred_MI_Predicate_ldaxr_4,
  GICXXPred_MI_Predicate_ldaxr_8,
  GICXXPred_MI_Predicate_ldxr_1,
  GICXXPred_MI_Predicate_ldxr_2,
  GICXXPred_MI_Predicate_ldxr_4,
  GICXXPred_MI_Predicate_ldxr_8,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_stlxr_1,
  GICXXPred_MI_Predicate_stlxr_2,
  GICXXPred_MI_Predicate_stlxr_4,
  GICXXPred_MI_Predicate_stlxr_8,
  GICXXPred_MI_Predicate_stxr_1,
  GICXXPred_MI_Predicate_stxr_2,
  GICXXPred_MI_Predicate_stxr_4,
  GICXXPred_MI_Predicate_stxr_8,
};
bool AArch64InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_and_or_is_add: {
    
         return mi_match(MI, MRI, m_GAddLike(m_Reg(), m_Reg()));
      
  }
  case GICXXPred_MI_Predicate_ldaxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldaxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldaxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldaxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_ldxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_ldxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_ldxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_ldxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_stlxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stlxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stlxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stlxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  case GICXXPred_MI_Predicate_stxr_1: {
     return isLoadStoreOfNumBytes(MI, 1); 
  }
  case GICXXPred_MI_Predicate_stxr_2: {
     return isLoadStoreOfNumBytes(MI, 2); 
  }
  case GICXXPred_MI_Predicate_stxr_4: {
     return isLoadStoreOfNumBytes(MI, 4); 
  }
  case GICXXPred_MI_Predicate_stxr_8: {
     return isLoadStoreOfNumBytes(MI, 8); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_MO_Predicate_top16Zero = GICXXPred_Invalid + 1,
  GICXXPred_MO_Predicate_top32Zero,
  GICXXPred_MO_Predicate_topbitsallzero32,
  GICXXPred_MO_Predicate_topbitsallzero64,
};
bool AArch64InstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  switch (PredicateID) {
  case GICXXPred_MO_Predicate_top16Zero: {
    
        return VT && VT->maskedValueIsZero(Reg, APInt::getHighBitsSet(32, 16)); 
  }
  case GICXXPred_MO_Predicate_top32Zero: {
     
        return VT && VT->maskedValueIsZero(Reg, APInt::getHighBitsSet(64, 32)); 
  }
  case GICXXPred_MO_Predicate_topbitsallzero32: {
     
        return VT && VT->maskedValueIsZero(Reg, APInt::getHighBitsSet(32, 31)); 
  }
  case GICXXPred_MO_Predicate_topbitsallzero64: {
     
        return VT && VT->maskedValueIsZero(Reg, APInt::getHighBitsSet(64, 63)); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex0 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex0_timm,
  GICXXPred_I64_Predicate_VectorIndex1,
  GICXXPred_I64_Predicate_VectorIndex1_timm,
  GICXXPred_I64_Predicate_VectorIndex032b,
  GICXXPred_I64_Predicate_VectorIndex032b_timm,
  GICXXPred_I64_Predicate_VectorIndex132b,
  GICXXPred_I64_Predicate_VectorIndex132b_timm,
  GICXXPred_I64_Predicate_VectorIndexB,
  GICXXPred_I64_Predicate_VectorIndexB32b,
  GICXXPred_I64_Predicate_VectorIndexB32b_timm,
  GICXXPred_I64_Predicate_VectorIndexB_timm,
  GICXXPred_I64_Predicate_VectorIndexD,
  GICXXPred_I64_Predicate_VectorIndexD32b,
  GICXXPred_I64_Predicate_VectorIndexD32b_timm,
  GICXXPred_I64_Predicate_VectorIndexD_timm,
  GICXXPred_I64_Predicate_VectorIndexH,
  GICXXPred_I64_Predicate_VectorIndexH32b,
  GICXXPred_I64_Predicate_VectorIndexH32b_timm,
  GICXXPred_I64_Predicate_VectorIndexH_timm,
  GICXXPred_I64_Predicate_VectorIndexS,
  GICXXPred_I64_Predicate_VectorIndexS32b,
  GICXXPred_I64_Predicate_VectorIndexS32b_timm,
  GICXXPred_I64_Predicate_VectorIndexS_timm,
  GICXXPred_I64_Predicate_complexrotateop,
  GICXXPred_I64_Predicate_complexrotateopodd,
  GICXXPred_I64_Predicate_extq_timm32_0_1m8,
  GICXXPred_I64_Predicate_extq_timm32_0_3m4,
  GICXXPred_I64_Predicate_extq_timm32_0_7m2,
  GICXXPred_I64_Predicate_i64imm_32bit,
  GICXXPred_I64_Predicate_i64imm_32bit_tgt,
  GICXXPred_I64_Predicate_imm0_1,
  GICXXPred_I64_Predicate_imm0_3,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_127,
  GICXXPred_I64_Predicate_imm0_127_64b,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm32_0_7,
  GICXXPred_I64_Predicate_imm32_0_15,
  GICXXPred_I64_Predicate_imm32_0_31,
  GICXXPred_I64_Predicate_imm64_0_65535,
  GICXXPred_I64_Predicate_maski8_or_more,
  GICXXPred_I64_Predicate_maski16_or_more,
  GICXXPred_I64_Predicate_rprfop,
  GICXXPred_I64_Predicate_s64imm_32bit,
  GICXXPred_I64_Predicate_simm4s1,
  GICXXPred_I64_Predicate_simm4s2,
  GICXXPred_I64_Predicate_simm4s3,
  GICXXPred_I64_Predicate_simm4s4,
  GICXXPred_I64_Predicate_simm4s16,
  GICXXPred_I64_Predicate_simm4s32,
  GICXXPred_I64_Predicate_simm5_8b,
  GICXXPred_I64_Predicate_simm5_8b_tgt,
  GICXXPred_I64_Predicate_simm5_16b,
  GICXXPred_I64_Predicate_simm5_16b_tgt,
  GICXXPred_I64_Predicate_simm5_32b,
  GICXXPred_I64_Predicate_simm5_32b_tgt,
  GICXXPred_I64_Predicate_simm5_64b,
  GICXXPred_I64_Predicate_simm5_64b_tgt,
  GICXXPred_I64_Predicate_simm6_32b,
  GICXXPred_I64_Predicate_simm6s1,
  GICXXPred_I64_Predicate_simm8_32b,
  GICXXPred_I64_Predicate_simm8_64b,
  GICXXPred_I64_Predicate_simm9,
  GICXXPred_I64_Predicate_sme_elm_idx0_0,
  GICXXPred_I64_Predicate_sme_elm_idx0_1,
  GICXXPred_I64_Predicate_sme_elm_idx0_3,
  GICXXPred_I64_Predicate_sme_elm_idx0_7,
  GICXXPred_I64_Predicate_sme_elm_idx0_15,
  GICXXPred_I64_Predicate_svcr_op,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s,
  GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm,
  GICXXPred_I64_Predicate_sve_incdec_imm,
  GICXXPred_I64_Predicate_sve_pred_enum,
  GICXXPred_I64_Predicate_sve_prfop,
  GICXXPred_I64_Predicate_sve_vec_len_specifier_enum,
  GICXXPred_I64_Predicate_tbz_imm0_31_diag,
  GICXXPred_I64_Predicate_tbz_imm0_31_nodiag,
  GICXXPred_I64_Predicate_tbz_imm32_63,
  GICXXPred_I64_Predicate_timm0_1,
  GICXXPred_I64_Predicate_timm0_31,
  GICXXPred_I64_Predicate_timm0_63,
  GICXXPred_I64_Predicate_timm32_0_0,
  GICXXPred_I64_Predicate_timm32_0_1,
  GICXXPred_I64_Predicate_timm32_0_3,
  GICXXPred_I64_Predicate_timm32_0_7,
  GICXXPred_I64_Predicate_timm32_0_15,
  GICXXPred_I64_Predicate_timm32_0_31,
  GICXXPred_I64_Predicate_timm32_0_255,
  GICXXPred_I64_Predicate_timm32_0_65535,
  GICXXPred_I64_Predicate_timm32_1_1,
  GICXXPred_I64_Predicate_timm32_1_3,
  GICXXPred_I64_Predicate_timm32_1_7,
  GICXXPred_I64_Predicate_timm64_0_65535,
  GICXXPred_I64_Predicate_tuimm5s2,
  GICXXPred_I64_Predicate_tuimm5s4,
  GICXXPred_I64_Predicate_tuimm5s8,
  GICXXPred_I64_Predicate_tvecshiftL8,
  GICXXPred_I64_Predicate_tvecshiftL16,
  GICXXPred_I64_Predicate_tvecshiftL32,
  GICXXPred_I64_Predicate_tvecshiftL64,
  GICXXPred_I64_Predicate_tvecshiftR8,
  GICXXPred_I64_Predicate_tvecshiftR16,
  GICXXPred_I64_Predicate_tvecshiftR32,
  GICXXPred_I64_Predicate_tvecshiftR64,
  GICXXPred_I64_Predicate_ubsan_trap_imm,
  GICXXPred_I64_Predicate_uimm0s2range,
  GICXXPred_I64_Predicate_uimm0s4range,
  GICXXPred_I64_Predicate_uimm1s2range,
  GICXXPred_I64_Predicate_uimm1s4range,
  GICXXPred_I64_Predicate_uimm2s2range,
  GICXXPred_I64_Predicate_uimm2s4range,
  GICXXPred_I64_Predicate_uimm3s2range,
  GICXXPred_I64_Predicate_uimm3s8,
  GICXXPred_I64_Predicate_uimm5s2,
  GICXXPred_I64_Predicate_uimm5s4,
  GICXXPred_I64_Predicate_uimm5s8,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6_32b,
  GICXXPred_I64_Predicate_uimm6_64b,
  GICXXPred_I64_Predicate_uimm6s1,
  GICXXPred_I64_Predicate_uimm6s2,
  GICXXPred_I64_Predicate_uimm6s4,
  GICXXPred_I64_Predicate_uimm6s8,
  GICXXPred_I64_Predicate_uimm6s16,
  GICXXPred_I64_Predicate_uimm8_32b,
  GICXXPred_I64_Predicate_uimm8_64b,
  GICXXPred_I64_Predicate_uimm16,
  GICXXPred_I64_Predicate_vecshiftL8,
  GICXXPred_I64_Predicate_vecshiftL16,
  GICXXPred_I64_Predicate_vecshiftL32,
  GICXXPred_I64_Predicate_vecshiftL64,
  GICXXPred_I64_Predicate_vecshiftR8,
  GICXXPred_I64_Predicate_vecshiftR16,
  GICXXPred_I64_Predicate_vecshiftR16Narrow,
  GICXXPred_I64_Predicate_vecshiftR32,
  GICXXPred_I64_Predicate_vecshiftR32Narrow,
  GICXXPred_I64_Predicate_vecshiftR64,
  GICXXPred_I64_Predicate_vecshiftR64Narrow,
};
bool AArch64InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex0: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex0_timm: {
     return ((uint64_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex1_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex032b: {
     return ((uint32_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex032b_timm: {
     return ((uint32_t)Imm) == 0; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndex132b_timm: {
     return ((uint64_t)Imm) == 1; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB32b_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexB_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD32b_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexD_timm: {
     return ((uint64_t)Imm) < 2; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH32b_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexH_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS32b_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_VectorIndexS_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_complexrotateop: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_complexrotateopodd: {
     return Imm >= 0 && Imm <= 270;  
  }
  case GICXXPred_I64_Predicate_extq_timm32_0_1m8: {
    
      return ((uint32_t)Imm) < 2;
  }
  case GICXXPred_I64_Predicate_extq_timm32_0_3m4: {
    
      return ((uint32_t)Imm) < 4;
  }
  case GICXXPred_I64_Predicate_extq_timm32_0_7m2: {
    
      return ((uint32_t)Imm) < 8;
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit_tgt: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  case GICXXPred_I64_Predicate_imm0_1: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_imm0_3: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return ((uint64_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return ((uint64_t)Imm) < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_127: {
    
      return ((uint32_t)Imm) < 128;
    
  }
  case GICXXPred_I64_Predicate_imm0_127_64b: {
    
      return ((uint64_t)Imm) < 128;
    
  }
  case GICXXPred_I64_Predicate_imm0_255: {
    
      return ((uint32_t)Imm) < 256;
    
  }
  case GICXXPred_I64_Predicate_imm32_0_7: {
    
      return ((uint32_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_imm32_0_15: {
    
      return ((uint32_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_imm32_0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_imm64_0_65535: {
    
      return ((uint64_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_maski8_or_more: {
     return (Imm & 0xff) == 0xff; 
  }
  case GICXXPred_I64_Predicate_maski16_or_more: {
     return (Imm & 0xffff) == 0xffff; 
  }
  case GICXXPred_I64_Predicate_rprfop: {
    
        return (((uint32_t)Imm) <= 63);
      
  }
  case GICXXPred_I64_Predicate_s64imm_32bit: {
    
      int64_t Imm64 = static_cast<int64_t>(Imm);
      return Imm64 >= std::numeric_limits<int32_t>::min() &&
             Imm64 <= std::numeric_limits<int32_t>::max();
    
    llvm_unreachable("s64imm_32bit should have returned");
  }
  case GICXXPred_I64_Predicate_simm4s1: {
     return Imm >=-8  && Imm <= 7; 
  }
  case GICXXPred_I64_Predicate_simm4s2: {
     return Imm >=-16  && Imm <= 14 && (Imm % 2) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s3: {
     return Imm >=-24  && Imm <= 21 && (Imm % 3) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s4: {
     return Imm >=-32  && Imm <= 28 && (Imm % 4) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s16: {
     return Imm >=-128  && Imm <= 112 && (Imm % 16) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm4s32: {
     return Imm >=-256  && Imm <= 224 && (Imm % 32) == 0x0; 
  }
  case GICXXPred_I64_Predicate_simm5_8b: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_8b_tgt: {
     return (int8_t)Imm >= -16 && (int8_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_16b_tgt: {
     return (int16_t)Imm >= -16 && (int16_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_32b_tgt: {
     return (int32_t)Imm >= -16 && (int32_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b: {
     return Imm >= -16 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm5_64b_tgt: {
     return (int64_t)Imm >= -16 && (int64_t)Imm < 16; 
  }
  case GICXXPred_I64_Predicate_simm6_32b: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm6s1: {
     return Imm >= -32 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_simm8_32b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm8_64b: {
     return Imm >= -128 && Imm < 128; 
  }
  case GICXXPred_I64_Predicate_simm9: {
     return Imm >= -256 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_0: {
    
      return ((uint32_t)Imm) == 0;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_1: {
    
      return ((uint32_t)Imm) <= 1;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_3: {
    
      return ((uint32_t)Imm) <= 3;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_7: {
    
      return ((uint32_t)Imm) <= 7;
    
  }
  case GICXXPred_I64_Predicate_sme_elm_idx0_15: {
    
      return ((uint32_t)Imm) <= 15;
    
  }
  case GICXXPred_I64_Predicate_svcr_op: {
    
        return AArch64SVCR::lookupSVCRByEncoding(Imm) != nullptr;
      
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_b_timm: {
     return ((uint64_t)Imm) < 64; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_d_timm: {
     return ((uint64_t)Imm) < 8; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_h_timm: {
     return ((uint64_t)Imm) < 32; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_q_timm: {
     return ((uint64_t)Imm) < 4; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_elm_idx_extdup_s_timm: {
     return ((uint64_t)Imm) < 16; 
  }
  case GICXXPred_I64_Predicate_sve_incdec_imm: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_sve_pred_enum: {
    
      return (((uint32_t)Imm) < 32);
      
  }
  case GICXXPred_I64_Predicate_sve_prfop: {
    
        return (((uint32_t)Imm) <= 15);
      
  }
  case GICXXPred_I64_Predicate_sve_vec_len_specifier_enum: {
    
      return (((uint32_t)Imm) < 2);
      
  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_diag: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tbz_imm0_31_nodiag: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tbz_imm32_63: {
    
      return (((uint32_t)Imm) > 31) && (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_timm0_1: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_timm0_31: {
    
      return ((uint64_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_timm0_63: {
    
      return ((uint64_t)Imm) < 64;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_0: {
    
      return ((uint32_t)Imm) == 0;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_1: {
    
      return ((uint32_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_3: {
    
      return ((uint32_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_7: {
    
      return ((uint32_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_15: {
    
      return ((uint32_t)Imm) < 16;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_31: {
    
      return ((uint32_t)Imm) < 32;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_255: {
    
      return ((uint32_t)Imm) < 256;
    
  }
  case GICXXPred_I64_Predicate_timm32_0_65535: {
    
      return ((uint32_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_1: {
    
        return ((uint32_t)Imm) == 1;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_3: {
    
      return ((uint32_t)Imm) > 0 && ((uint32_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_timm32_1_7: {
    
      return ((uint32_t)Imm) > 0 && ((uint32_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_timm64_0_65535: {
    
      return ((uint64_t)Imm) < 65536;
    
  }
  case GICXXPred_I64_Predicate_tuimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_tuimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_tvecshiftL8: {
    
      return (((uint32_t)Imm) < 8);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL16: {
    
      return (((uint32_t)Imm) < 16);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL32: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftL64: {
    
      return (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR8: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR16: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR32: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  case GICXXPred_I64_Predicate_tvecshiftR64: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);
    
  }
  case GICXXPred_I64_Predicate_ubsan_trap_imm: {
    
      return isUInt<8>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm0s2range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm0s4range: {
     return Imm == 0; 
  }
  case GICXXPred_I64_Predicate_uimm1s2range: {
     return Imm >= 0 && Imm <= 2 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm1s4range: {
     return Imm >= 0 && Imm <= 4 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s2range: {
     return Imm >= 0 && Imm <= 6 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm2s4range: {
     return Imm >= 0 && Imm <= 12 && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s2range: {
     return Imm >= 0 && Imm <= 14 && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm3s8: {
     return Imm >= 0 && Imm <= 56 && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s2: {
     return Imm >= 0 && Imm < (32*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s4: {
     return Imm >= 0 && Imm < (32*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm5s8: {
     return Imm >= 0 && Imm < (32*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6_32b: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6_64b: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s1: {
     return Imm >= 0 && Imm < 64; 
  }
  case GICXXPred_I64_Predicate_uimm6s2: {
     return Imm >= 0 && Imm < (64*2) && ((Imm % 2) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s4: {
     return Imm >= 0 && Imm < (64*4) && ((Imm % 4) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s8: {
     return Imm >= 0 && Imm < (64*8) && ((Imm % 8) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm6s16: {
     return Imm >= 0 && Imm < (64*16) && ((Imm % 16) == 0); 
  }
  case GICXXPred_I64_Predicate_uimm8_32b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm8_64b: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_uimm16: {
    return Imm >= 0 && Imm < 65536;
  }
  case GICXXPred_I64_Predicate_vecshiftL8: {
    
      return (((uint32_t)Imm) < 8);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL16: {
    
      return (((uint32_t)Imm) < 16);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL32: {
    
      return (((uint32_t)Imm) < 32);
    
  }
  case GICXXPred_I64_Predicate_vecshiftL64: {
    
      return (((uint32_t)Imm) < 64);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR8: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR16: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR16Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 9);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR32: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR32Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 17);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR64: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 65);
    
  }
  case GICXXPred_I64_Predicate_vecshiftR64Narrow: {
    
      return (((uint32_t)Imm) > 0) && (((uint32_t)Imm) < 33);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm16,
  GICXXPred_APFloat_Predicate_fpimm32,
  GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4,
  GICXXPred_APFloat_Predicate_fpimm64,
  GICXXPred_APFloat_Predicate_fpimm_half,
  GICXXPred_APFloat_Predicate_fpimm_minus0,
  GICXXPred_APFloat_Predicate_fpimm_one,
  GICXXPred_APFloat_Predicate_fpimm_two,
  GICXXPred_APFloat_Predicate_fpimmbf16,
  GICXXPred_APFloat_Predicate_simdimmtype10,
};
bool AArch64InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm16: {
    
          return AArch64_AM::getFP16Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm32: {
    
          return AArch64_AM::getFP32Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm32SIMDModImmType4: {
    
          uint64_t Enc = Imm.bitcastToAPInt().getZExtValue();
          return Enc != 0 && AArch64_AM::isAdvSIMDModImmType4(Enc << 32 | Enc);
        
    llvm_unreachable("fpimm32SIMDModImmType4 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm64: {
    
          return AArch64_AM::getFP64Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_fpimm_half: {
    
      return Imm.isExactlyValue(+0.5);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_minus0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_one: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_two: {
    
      return Imm.isExactlyValue(+2.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmbf16: {
    
          return AArch64_AM::getFP16Imm(Imm) != -1;
        
  }
  case GICXXPred_APFloat_Predicate_simdimmtype10: {
    
          return AArch64_AM::isAdvSIMDModImmType10(
                     Imm.bitcastToAPInt().getZExtValue());
        
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_logical_imm32 = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_logical_imm64,
};
bool AArch64InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_logical_imm32: {
    
      return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 32);
    
  }
  case GICXXPred_APInt_Predicate_logical_imm64: {
    
      return AArch64_AM::isLogicalImmediate(Imm.getZExtValue(), 64);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AArch64InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AArch64InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderFPImm16,
  GICR_renderFPImm32,
  GICR_renderFPImm32SIMDModImmType4,
  GICR_renderFPImm64,
  GICR_renderLogicalImm32,
  GICR_renderLogicalImm64,
  GICR_renderTruncImm,
  GICR_renderUbsanTrap,
};
AArch64InstructionSelector::CustomRendererFn
AArch64InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AArch64InstructionSelector::renderFPImm16,
  &AArch64InstructionSelector::renderFPImm32,
  &AArch64InstructionSelector::renderFPImm32SIMDModImmType4,
  &AArch64InstructionSelector::renderFPImm64,
  &AArch64InstructionSelector::renderLogicalImm32,
  &AArch64InstructionSelector::renderLogicalImm64,
  &AArch64InstructionSelector::renderTruncImm,
  &AArch64InstructionSelector::renderUbsanTrap,
};

bool AArch64InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AArch64InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AArch64InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *AArch64InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(908), /*)*//*default:*//*Label 155*/ GIMT_Encode4(443543),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(3430),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(37037),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(51889),
     /*     22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(54654),
     /*     26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(54736), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(54818),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(62564),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(88103), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    114 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(100563), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(108087), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(118169),
     /*    146 */ /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(118660),
     /*    150 */ /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 12*/ GIMT_Encode4(119151),
     /*    154 */ /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 13*/ GIMT_Encode4(119419),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 14*/ GIMT_Encode4(119569),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 15*/ GIMT_Encode4(120060), GIMT_Encode4(0),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 16*/ GIMT_Encode4(120093),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 17*/ GIMT_Encode4(129031),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 18*/ GIMT_Encode4(130081), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 19*/ GIMT_Encode4(133130), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 20*/ GIMT_Encode4(146656),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 21*/ GIMT_Encode4(148007),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 22*/ GIMT_Encode4(148999),
     /*    218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 23*/ GIMT_Encode4(149991),
     /*    222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 24*/ GIMT_Encode4(151483), GIMT_Encode4(0),
     /*    230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 25*/ GIMT_Encode4(152975),
     /*    234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 26*/ GIMT_Encode4(153967),
     /*    238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 27*/ GIMT_Encode4(154959),
     /*    242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 28*/ GIMT_Encode4(155951),
     /*    246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 29*/ GIMT_Encode4(156943),
     /*    250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 30*/ GIMT_Encode4(157935),
     /*    254 */ /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 31*/ GIMT_Encode4(158927), GIMT_Encode4(0),
     /*    262 */ /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 32*/ GIMT_Encode4(159632),
     /*    266 */ /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 33*/ GIMT_Encode4(160337),
     /*    270 */ /*TargetOpcode::G_ATOMICRMW_FMAXIMUM*//*Label 34*/ GIMT_Encode4(161042),
     /*    274 */ /*TargetOpcode::G_ATOMICRMW_FMINIMUM*//*Label 35*/ GIMT_Encode4(161747), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 36*/ GIMT_Encode4(162452), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 37*/ GIMT_Encode4(162503),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 38*/ GIMT_Encode4(267690), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 39*/ GIMT_Encode4(279206),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 40*/ GIMT_Encode4(279496), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 41*/ GIMT_Encode4(280933),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 42*/ GIMT_Encode4(281053), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 43*/ GIMT_Encode4(281294),
     /*    370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 44*/ GIMT_Encode4(283192),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(284846),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(287625),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(288450),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(288994), GIMT_Encode4(0),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(289819),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(289949), GIMT_Encode4(0),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(290491), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 52*/ GIMT_Encode4(298268), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 53*/ GIMT_Encode4(299313),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 54*/ GIMT_Encode4(299797),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 55*/ GIMT_Encode4(300281),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 56*/ GIMT_Encode4(300753),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 57*/ GIMT_Encode4(303129),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 58*/ GIMT_Encode4(303601), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 59*/ GIMT_Encode4(304991),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 60*/ GIMT_Encode4(306789),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 61*/ GIMT_Encode4(307527),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 62*/ GIMT_Encode4(312143), GIMT_Encode4(0),
     /*    550 */ /*TargetOpcode::G_FDIV*//*Label 63*/ GIMT_Encode4(328416), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 64*/ GIMT_Encode4(329032),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 65*/ GIMT_Encode4(332539),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 66*/ GIMT_Encode4(332787),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 67*/ GIMT_Encode4(332975),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 68*/ GIMT_Encode4(333952),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 69*/ GIMT_Encode4(334929),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 70*/ GIMT_Encode4(339557),
     /*    626 */ /*TargetOpcode::G_FPTOSI_SAT*//*Label 71*/ GIMT_Encode4(343563),
     /*    630 */ /*TargetOpcode::G_FPTOUI_SAT*//*Label 72*/ GIMT_Encode4(343883),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 73*/ GIMT_Encode4(344203), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 74*/ GIMT_Encode4(345060),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 75*/ GIMT_Encode4(345342),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 76*/ GIMT_Encode4(345720),
     /*    658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 77*/ GIMT_Encode4(346098),
     /*    662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 78*/ GIMT_Encode4(346448),
     /*    666 */ /*TargetOpcode::G_FMINIMUM*//*Label 79*/ GIMT_Encode4(346798),
     /*    670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 80*/ GIMT_Encode4(347501), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    710 */ /*TargetOpcode::G_PTR_ADD*//*Label 81*/ GIMT_Encode4(348204), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 82*/ GIMT_Encode4(348704),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 83*/ GIMT_Encode4(349108),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 84*/ GIMT_Encode4(349512),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 85*/ GIMT_Encode4(349916),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 86*/ GIMT_Encode4(350320),
     /*    738 */ /*TargetOpcode::G_LROUND*//*Label 87*/ GIMT_Encode4(351135),
     /*    742 */ /*TargetOpcode::G_LLROUND*//*Label 88*/ GIMT_Encode4(351301),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 89*/ GIMT_Encode4(351400), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    762 */ /*TargetOpcode::G_EXTRACT_SUBVECTOR*//*Label 90*/ GIMT_Encode4(351416),
     /*    766 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 91*/ GIMT_Encode4(356788),
     /*    770 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 92*/ GIMT_Encode4(389710), GIMT_Encode4(0),
     /*    778 */ /*TargetOpcode::G_SPLAT_VECTOR*//*Label 93*/ GIMT_Encode4(392628), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    790 */ /*TargetOpcode::G_CTTZ*//*Label 94*/ GIMT_Encode4(394948), GIMT_Encode4(0),
     /*    798 */ /*TargetOpcode::G_CTLZ*//*Label 95*/ GIMT_Encode4(395100), GIMT_Encode4(0),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 96*/ GIMT_Encode4(395774),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 97*/ GIMT_Encode4(395934),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 98*/ GIMT_Encode4(396248),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 99*/ GIMT_Encode4(396402), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 100*/ GIMT_Encode4(396893),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 101*/ GIMT_Encode4(397193),
     /*    874 */ /*TargetOpcode::G_FRINT*//*Label 102*/ GIMT_Encode4(397684),
     /*    878 */ /*TargetOpcode::G_FNEARBYINT*//*Label 103*/ GIMT_Encode4(398175), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 104*/ GIMT_Encode4(398666),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 105*/ GIMT_Encode4(399792),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 106*/ GIMT_Encode4(400408),
     /*    918 */ /*TargetOpcode::G_STRICT_FDIV*//*Label 107*/ GIMT_Encode4(404130), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 108*/ GIMT_Encode4(404746),
     /*    930 */ /*TargetOpcode::G_STRICT_FSQRT*//*Label 109*/ GIMT_Encode4(420353), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    966 */ /*TargetOpcode::G_TRAP*//*Label 110*/ GIMT_Encode4(420653),
     /*    970 */ /*TargetOpcode::G_DEBUGTRAP*//*Label 111*/ GIMT_Encode4(420667),
     /*    974 */ /*TargetOpcode::G_UBSANTRAP*//*Label 112*/ GIMT_Encode4(420688), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    986 */ /*TargetOpcode::G_VECREDUCE_FADD*//*Label 113*/ GIMT_Encode4(420713), GIMT_Encode4(0),
     /*    994 */ /*TargetOpcode::G_VECREDUCE_FMAX*//*Label 114*/ GIMT_Encode4(421023),
     /*    998 */ /*TargetOpcode::G_VECREDUCE_FMIN*//*Label 115*/ GIMT_Encode4(421194),
     /*   1002 */ /*TargetOpcode::G_VECREDUCE_FMAXIMUM*//*Label 116*/ GIMT_Encode4(421365),
     /*   1006 */ /*TargetOpcode::G_VECREDUCE_FMINIMUM*//*Label 117*/ GIMT_Encode4(421536),
     /*   1010 */ /*TargetOpcode::G_VECREDUCE_ADD*//*Label 118*/ GIMT_Encode4(421707), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1030 */ /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 119*/ GIMT_Encode4(422836),
     /*   1034 */ /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 120*/ GIMT_Encode4(423039),
     /*   1038 */ /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 121*/ GIMT_Encode4(423242),
     /*   1042 */ /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 122*/ GIMT_Encode4(423445), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   3298 */ /*AArch64::G_AARCH64_PREFETCH*//*Label 123*/ GIMT_Encode4(423648), GIMT_Encode4(0),
     /*   3306 */ /*AArch64::G_BSP*//*Label 124*/ GIMT_Encode4(423788),
     /*   3310 */ /*AArch64::G_DUP*//*Label 125*/ GIMT_Encode4(424776),
     /*   3314 */ /*AArch64::G_DUPLANE16*//*Label 126*/ GIMT_Encode4(426759),
     /*   3318 */ /*AArch64::G_DUPLANE32*//*Label 127*/ GIMT_Encode4(427014),
     /*   3322 */ /*AArch64::G_DUPLANE64*//*Label 128*/ GIMT_Encode4(427269),
     /*   3326 */ /*AArch64::G_DUPLANE8*//*Label 129*/ GIMT_Encode4(427415),
     /*   3330 */ /*AArch64::G_EXT*//*Label 130*/ GIMT_Encode4(427594),
     /*   3334 */ /*AArch64::G_FCMEQ*//*Label 131*/ GIMT_Encode4(429244),
     /*   3338 */ /*AArch64::G_FCMGE*//*Label 132*/ GIMT_Encode4(429803),
     /*   3342 */ /*AArch64::G_FCMGT*//*Label 133*/ GIMT_Encode4(430895),
     /*   3346 */ /*AArch64::G_REV16*//*Label 134*/ GIMT_Encode4(431987),
     /*   3350 */ /*AArch64::G_REV32*//*Label 135*/ GIMT_Encode4(432141),
     /*   3354 */ /*AArch64::G_REV64*//*Label 136*/ GIMT_Encode4(432317),
     /*   3358 */ /*AArch64::G_SADDLP*//*Label 137*/ GIMT_Encode4(432591),
     /*   3362 */ /*AArch64::G_SADDLV*//*Label 138*/ GIMT_Encode4(432797),
     /*   3366 */ /*AArch64::G_SDOT*//*Label 139*/ GIMT_Encode4(433196),
     /*   3370 */ /*AArch64::G_SITOF*//*Label 140*/ GIMT_Encode4(433566),
     /*   3374 */ /*AArch64::G_SMULL*//*Label 141*/ GIMT_Encode4(433683),
     /*   3378 */ /*AArch64::G_TRN1*//*Label 142*/ GIMT_Encode4(434916),
     /*   3382 */ /*AArch64::G_TRN2*//*Label 143*/ GIMT_Encode4(435696),
     /*   3386 */ /*AArch64::G_UADDLP*//*Label 144*/ GIMT_Encode4(436476),
     /*   3390 */ /*AArch64::G_UADDLV*//*Label 145*/ GIMT_Encode4(436682),
     /*   3394 */ /*AArch64::G_UDOT*//*Label 146*/ GIMT_Encode4(437549),
     /*   3398 */ /*AArch64::G_UITOF*//*Label 147*/ GIMT_Encode4(437919),
     /*   3402 */ /*AArch64::G_UMULL*//*Label 148*/ GIMT_Encode4(438036),
     /*   3406 */ /*AArch64::G_UZP1*//*Label 149*/ GIMT_Encode4(439269),
     /*   3410 */ /*AArch64::G_UZP2*//*Label 150*/ GIMT_Encode4(440049),
     /*   3414 */ /*AArch64::G_VASHR*//*Label 151*/ GIMT_Encode4(440829),
     /*   3418 */ /*AArch64::G_VLSHR*//*Label 152*/ GIMT_Encode4(441527),
     /*   3422 */ /*AArch64::G_ZIP1*//*Label 153*/ GIMT_Encode4(441983),
     /*   3426 */ /*AArch64::G_ZIP2*//*Label 154*/ GIMT_Encode4(442763),
     /*   3430 */ // Label 0: @3430
     /*   3430 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(24), /*)*//*default:*//*Label 169*/ GIMT_Encode4(37036),
     /*   3441 */ /*GILLT_s32*//*Label 156*/ GIMT_Encode4(3529),
     /*   3445 */ /*GILLT_s64*//*Label 157*/ GIMT_Encode4(6308), GIMT_Encode4(0),
     /*   3453 */ /*GILLT_v2s32*//*Label 158*/ GIMT_Encode4(12248),
     /*   3457 */ /*GILLT_v2s64*//*Label 159*/ GIMT_Encode4(15856),
     /*   3461 */ /*GILLT_v4s16*//*Label 160*/ GIMT_Encode4(21758),
     /*   3465 */ /*GILLT_v4s32*//*Label 161*/ GIMT_Encode4(25256),
     /*   3469 */ /*GILLT_v8s8*//*Label 162*/ GIMT_Encode4(31434),
     /*   3473 */ /*GILLT_v8s16*//*Label 163*/ GIMT_Encode4(32284),
     /*   3477 */ /*GILLT_v16s8*//*Label 164*/ GIMT_Encode4(35862), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   3497 */ /*GILLT_nxv2s64*//*Label 165*/ GIMT_Encode4(36586), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   3509 */ /*GILLT_nxv4s32*//*Label 166*/ GIMT_Encode4(36958), GIMT_Encode4(0),
     /*   3517 */ /*GILLT_nxv8s16*//*Label 167*/ GIMT_Encode4(36984), GIMT_Encode4(0),
     /*   3525 */ /*GILLT_nxv16s8*//*Label 168*/ GIMT_Encode4(37010),
     /*   3529 */ // Label 156: @3529
     /*   3529 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(6307),
     /*   3534 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   3537 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   3540 */   GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(3573), // Rule ID 13503 //
     /*   3545 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   3549 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   3553 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm32),
     /*   3560 */     // (add:{ *:[i32] } addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
     /*   3560 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWri),
     /*   3563 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3565 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   3567 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   3571 */     GIR_RootConstrainSelectedInstOperands,
     /*   3572 */     // GIR_Coverage, 13503,
     /*   3572 */     GIR_EraseRootFromParent_Done,
     /*   3573 */   // Label 171: @3573
     /*   3573 */   GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(3725), // Rule ID 13942 //
     /*   3578 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   3581 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3585 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3589 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   3593 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   3597 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3601 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   3605 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   3608 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
     /*   3613 */     // MIs[2] pattern
     /*   3613 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   3616 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   3621 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3625 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   3627 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1342:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   3627 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   3630 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   3634 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3639 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   3641 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   3644 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   3648 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3653 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   3656 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
     /*   3660 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   3663 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3668 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3673 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3678 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   3681 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
     /*   3685 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3690 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   3693 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   3697 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   3700 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   3702 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   3705 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3707 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   3714 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3719 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   3724 */     // GIR_Coverage, 13942,
     /*   3724 */     GIR_EraseRootFromParent_Done,
     /*   3725 */   // Label 172: @3725
     /*   3725 */   GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(3877), // Rule ID 15804 //
     /*   3730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   3733 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3737 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3741 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   3745 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   3749 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3753 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   3757 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   3760 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
     /*   3765 */     // MIs[2] pattern
     /*   3765 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   3768 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   3773 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3777 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   3779 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1344:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   3779 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   3782 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   3786 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3791 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   3793 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   3796 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   3800 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3805 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   3808 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
     /*   3812 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   3815 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3820 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3825 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3830 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   3833 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
     /*   3837 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3842 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   3845 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   3849 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   3852 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   3854 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   3857 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3859 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   3866 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3871 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   3876 */     // GIR_Coverage, 15804,
     /*   3876 */     GIR_EraseRootFromParent_Done,
     /*   3877 */   // Label 173: @3877
     /*   3877 */   GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(4029), // Rule ID 15816 //
     /*   3882 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   3885 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3889 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3893 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   3897 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   3901 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3905 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   3909 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   3912 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
     /*   3917 */     // MIs[2] pattern
     /*   3917 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   3920 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   3925 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3929 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   3931 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1350:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   3931 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   3934 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   3938 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3943 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   3945 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   3948 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   3952 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3957 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   3960 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
     /*   3964 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   3967 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3972 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   3977 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   3982 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   3985 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
     /*   3989 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   3994 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   3997 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4001 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4004 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4006 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4009 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4011 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4018 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4023 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4028 */     // GIR_Coverage, 15816,
     /*   4028 */     GIR_EraseRootFromParent_Done,
     /*   4029 */   // Label 174: @4029
     /*   4029 */   GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(4181), // Rule ID 15828 //
     /*   4034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   4037 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4049 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4053 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4057 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4061 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   4064 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
     /*   4069 */     // MIs[2] pattern
     /*   4069 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   4072 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   4077 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4081 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4083 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1343:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)), GPR32:{ *:[i32] }:$Rdn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   4083 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4086 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4090 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4095 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4097 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4100 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4104 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4109 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4112 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rdn
     /*   4116 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4119 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4124 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4129 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4134 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4137 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
     /*   4141 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4146 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4149 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4153 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4156 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4158 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4161 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4163 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4170 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4175 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4180 */     // GIR_Coverage, 15828,
     /*   4180 */     GIR_EraseRootFromParent_Done,
     /*   4181 */   // Label 175: @4181
     /*   4181 */   GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(4214), // Rule ID 91 //
     /*   4186 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   4190 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   4194 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm32),
     /*   4201 */     // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (ADDWri:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, addsub_shifted_imm32:{ *:[i32] }:$imm)
     /*   4201 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWri),
     /*   4204 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4206 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   4208 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   4212 */     GIR_RootConstrainSelectedInstOperands,
     /*   4213 */     // GIR_Coverage, 91,
     /*   4213 */     GIR_EraseRootFromParent_Done,
     /*   4214 */   // Label 176: @4214
     /*   4214 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(4366), // Rule ID 2656 //
     /*   4219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   4222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4226 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4230 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4234 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4238 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4242 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4246 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4250 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   4253 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
     /*   4258 */     // MIs[2] pattern
     /*   4258 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   4261 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   4266 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4268 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1342:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCB_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   4268 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4271 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4275 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4280 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4282 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4285 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4289 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4294 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4297 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
     /*   4301 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4304 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4309 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4314 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4319 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4322 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
     /*   4326 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4331 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4334 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4338 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4341 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4343 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4346 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4348 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4355 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4360 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4365 */     // GIR_Coverage, 2656,
     /*   4365 */     GIR_EraseRootFromParent_Done,
     /*   4366 */   // Label 177: @4366
     /*   4366 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(4518), // Rule ID 10068 //
     /*   4371 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   4374 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4378 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4382 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4386 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4390 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4394 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4398 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4402 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   4405 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
     /*   4410 */     // MIs[2] pattern
     /*   4410 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   4413 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   4418 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4420 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1344:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCH_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   4420 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4423 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4427 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4432 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4434 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4437 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4441 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4446 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4449 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
     /*   4453 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4456 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4461 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4466 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4471 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4474 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
     /*   4478 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4483 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4486 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4490 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4493 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4495 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4498 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4500 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4507 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4512 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4517 */     // GIR_Coverage, 10068,
     /*   4517 */     GIR_EraseRootFromParent_Done,
     /*   4518 */   // Label 178: @4518
     /*   4518 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(4670), // Rule ID 10080 //
     /*   4523 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   4526 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4530 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4534 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4538 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4542 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4546 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4550 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4554 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   4557 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
     /*   4562 */     // MIs[2] pattern
     /*   4562 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   4565 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   4570 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4572 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1350:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCW_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   4572 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4575 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4579 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4584 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4586 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4589 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4593 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4598 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4601 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
     /*   4605 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4608 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4613 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4618 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4623 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4626 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
     /*   4630 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4635 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4638 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4642 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4645 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4647 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4650 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4652 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4659 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4664 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4669 */     // GIR_Coverage, 10080,
     /*   4669 */     GIR_EraseRootFromParent_Done,
     /*   4670 */   // Label 179: @4670
     /*   4670 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(4822), // Rule ID 10092 //
     /*   4675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   4678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4682 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4698 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4702 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4706 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/3,
     /*   4709 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
     /*   4714 */     // MIs[2] pattern
     /*   4714 */     GIM_CheckIsImm, /*MI*/2, /*Op*/2,
     /*   4717 */     GIM_CheckImmOperandPredicate, /*MI*/2, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   4722 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4724 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rdn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1343:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern)))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCD_XPiI:{ *:[i64] } (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rdn, sub_32:{ *:[i32] }), (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] }), sub_32:{ *:[i32] })
     /*   4724 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4727 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4731 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4736 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4738 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4741 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4745 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4750 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4753 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rdn
     /*   4757 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4760 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4765 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4770 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4775 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4778 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
     /*   4782 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4787 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4790 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pattern
     /*   4794 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   4797 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4799 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4802 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4804 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4811 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4816 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4821 */     // GIR_Coverage, 10092,
     /*   4821 */     GIR_EraseRootFromParent_Done,
     /*   4822 */   // Label 180: @4822
     /*   4822 */   GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(4979), // Rule ID 15847 //
     /*   4827 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   4830 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4834 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4838 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4842 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   4846 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4850 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   4854 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   4857 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   4862 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv16s1,
     /*   4866 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   4868 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   4873 */     // MIs[2] pred
     /*   4873 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   4878 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4882 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4884 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv16i1] }:$pred, PPRAny:{ *:[nxv16i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>), GPR32:{ *:[i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_B:{ *:[i64] } PPRAny:{ *:[nxv16i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   4884 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   4887 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   4891 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4896 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   4898 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   4901 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   4905 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4910 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   4913 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   4917 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   4920 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4925 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   4930 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4935 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   4938 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_B),
     /*   4942 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   4947 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   4951 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   4954 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   4956 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   4959 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4961 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   4968 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4973 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   4978 */     // GIR_Coverage, 15847,
     /*   4978 */     GIR_EraseRootFromParent_Done,
     /*   4979 */   // Label 181: @4979
     /*   4979 */   GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(5136), // Rule ID 15848 //
     /*   4984 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   4987 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   4991 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4995 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   4999 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5003 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5007 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5011 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5014 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5019 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv8s1,
     /*   5023 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5025 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5030 */     // MIs[2] pred
     /*   5030 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5035 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5039 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5041 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv8i1] }:$pred, PPRAny:{ *:[nxv8i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>), GPR32:{ *:[i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_H:{ *:[i64] } PPRAny:{ *:[nxv8i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5041 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5044 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5048 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5053 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5055 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5058 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5062 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5067 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5070 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   5074 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5077 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5082 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5087 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5092 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5095 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_H),
     /*   5099 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5104 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5108 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5111 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5113 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5116 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5118 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5125 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5130 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5135 */     // GIR_Coverage, 15848,
     /*   5135 */     GIR_EraseRootFromParent_Done,
     /*   5136 */   // Label 182: @5136
     /*   5136 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(5293), // Rule ID 15849 //
     /*   5141 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5160 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5164 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5168 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5171 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv4s1,
     /*   5180 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5182 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5187 */     // MIs[2] pred
     /*   5187 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5192 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5196 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5198 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv4i1] }:$pred, PPRAny:{ *:[nxv4i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>), GPR32:{ *:[i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_S:{ *:[i64] } PPRAny:{ *:[nxv4i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5198 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5201 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5205 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5210 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5212 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5215 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5219 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5224 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5227 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   5231 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5234 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5239 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5244 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5249 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5252 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_S),
     /*   5256 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5261 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5265 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5268 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5270 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5273 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5275 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5282 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5287 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5292 */     // GIR_Coverage, 15849,
     /*   5292 */     GIR_EraseRootFromParent_Done,
     /*   5293 */   // Label 183: @5293
     /*   5293 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(5450), // Rule ID 15850 //
     /*   5298 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5301 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5305 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5309 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5313 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5317 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5321 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5325 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5328 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5333 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv2s1,
     /*   5337 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5339 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5344 */     // MIs[2] pred
     /*   5344 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5349 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5353 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5355 */     // (add:{ *:[i32] } (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv2i1] }:$pred, PPRAny:{ *:[nxv2i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>), GPR32:{ *:[i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_D:{ *:[i64] } PPRAny:{ *:[nxv2i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5355 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5358 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5362 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5367 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5369 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5372 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5376 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5381 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5384 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   5388 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5391 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5396 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5401 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5406 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5409 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_D),
     /*   5413 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5418 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5422 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5425 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5427 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5430 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5432 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5439 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5444 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5449 */     // GIR_Coverage, 15850,
     /*   5449 */     GIR_EraseRootFromParent_Done,
     /*   5450 */   // Label 184: @5450
     /*   5450 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(5607), // Rule ID 10184 //
     /*   5455 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5458 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5462 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5466 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5470 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5474 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5478 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5482 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5486 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5489 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5494 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv16s1,
     /*   5498 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5500 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5505 */     // MIs[2] pred
     /*   5505 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5510 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5512 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv16i1] }:$pred, PPRAny:{ *:[nxv16i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_B:{ *:[i64] } PPRAny:{ *:[nxv16i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5512 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5515 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5519 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5524 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5526 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5529 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5533 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5538 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5541 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*   5545 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5548 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5553 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5558 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5563 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5566 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_B),
     /*   5570 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5575 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5579 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5582 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5584 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5587 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5589 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5596 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5601 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5606 */     // GIR_Coverage, 10184,
     /*   5606 */     GIR_EraseRootFromParent_Done,
     /*   5607 */   // Label 185: @5607
     /*   5607 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5764), // Rule ID 10185 //
     /*   5612 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5615 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5619 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5623 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5627 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5631 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5635 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5639 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5643 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5646 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5651 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv8s1,
     /*   5655 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5657 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5662 */     // MIs[2] pred
     /*   5662 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5667 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5669 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv8i1] }:$pred, PPRAny:{ *:[nxv8i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_H:{ *:[i64] } PPRAny:{ *:[nxv8i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5669 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5672 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5676 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5681 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5683 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5686 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5690 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5695 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5698 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*   5702 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5705 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5710 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5715 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5720 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5723 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_H),
     /*   5727 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5732 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5736 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5739 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5746 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5753 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5758 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5763 */     // GIR_Coverage, 10185,
     /*   5763 */     GIR_EraseRootFromParent_Done,
     /*   5764 */   // Label 186: @5764
     /*   5764 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5921), // Rule ID 10186 //
     /*   5769 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5772 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5776 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5780 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5784 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5788 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5792 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5796 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5800 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5803 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5808 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv4s1,
     /*   5812 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5814 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5819 */     // MIs[2] pred
     /*   5819 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5824 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5826 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv4i1] }:$pred, PPRAny:{ *:[nxv4i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_S:{ *:[i64] } PPRAny:{ *:[nxv4i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5826 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5829 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5833 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5838 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5840 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   5843 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   5847 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5852 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   5855 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*   5859 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   5862 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5867 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   5872 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5877 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   5880 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_S),
     /*   5884 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5889 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   5893 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   5896 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   5898 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   5901 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5903 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   5910 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5915 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   5920 */     // GIR_Coverage, 10186,
     /*   5920 */     GIR_EraseRootFromParent_Done,
     /*   5921 */   // Label 187: @5921
     /*   5921 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(6078), // Rule ID 10187 //
     /*   5926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*   5929 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5933 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   5937 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5941 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*   5945 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5949 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5953 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   5957 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*   5960 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*   5965 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_nxv2s1,
     /*   5969 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   5971 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*   5976 */     // MIs[2] pred
     /*   5976 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/3, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5981 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5983 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, (trunc:{ *:[i32] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv2i1] }:$pred, PPRAny:{ *:[nxv2i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>))  =>  (EXTRACT_SUBREG:{ *:[i32] } (INCP_XP_D:{ *:[i64] } PPRAny:{ *:[nxv2i1] }:$pred, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$Rn, sub_32:{ *:[i32] })), sub_32:{ *:[i32] })
     /*   5983 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*   5986 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   5990 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   5995 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   5997 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*   6000 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   6004 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6009 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   6012 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*   6016 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/20,
     /*   6019 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   6024 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64allRegClassID),
     /*   6029 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6034 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   6037 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_D),
     /*   6041 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6046 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // pred
     /*   6050 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   6053 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6055 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6058 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6060 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::sub_32),
     /*   6067 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6072 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   6077 */     // GIR_Coverage, 10187,
     /*   6077 */     GIR_EraseRootFromParent_Done,
     /*   6078 */   // Label 188: @6078
     /*   6078 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(6111), // Rule ID 13507 //
     /*   6083 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   6087 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   6091 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32_i32),
     /*   6098 */     // (add:{ *:[i32] } arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend, GPR32sp:{ *:[i32] }:$Rn)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
     /*   6098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrx),
     /*   6101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6103 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   6105 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
     /*   6109 */     GIR_RootConstrainSelectedInstOperands,
     /*   6110 */     // GIR_Coverage, 13507,
     /*   6110 */     GIR_EraseRootFromParent_Done,
     /*   6111 */   // Label 189: @6111
     /*   6111 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(6147), // Rule ID 14087 //
     /*   6116 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6120 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6124 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm32),
     /*   6131 */     // (add:{ *:[i32] } neg_addsub_shifted_imm32:{ *:[i32] }:$imm, GPR32:{ *:[i32] }:$Rn)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
     /*   6131 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWri),
     /*   6134 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6136 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   6138 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   6142 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
     /*   6145 */     GIR_RootConstrainSelectedInstOperands,
     /*   6146 */     // GIR_Coverage, 14087,
     /*   6146 */     GIR_EraseRootFromParent_Done,
     /*   6147 */   // Label 190: @6147
     /*   6147 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(6180), // Rule ID 97 //
     /*   6152 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   6156 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32spRegClassID),
     /*   6160 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32_i32),
     /*   6167 */     // (add:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)  =>  (ADDWrx:{ *:[i32] } GPR32sp:{ *:[i32] }:$Rn, arith_extended_reg32_i32:{ *:[i32] }:$Rm_and_extend)
     /*   6167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrx),
     /*   6170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6172 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6174 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
     /*   6178 */     GIR_RootConstrainSelectedInstOperands,
     /*   6179 */     // GIR_Coverage, 97,
     /*   6179 */     GIR_EraseRootFromParent_Done,
     /*   6180 */   // Label 191: @6180
     /*   6180 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(6216), // Rule ID 3954 //
     /*   6185 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6189 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6193 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm32),
     /*   6200 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)  =>  (SUBSWri:{ *:[i32] }:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, neg_addsub_shifted_imm32:{ *:[i32] }:$imm)
     /*   6200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSWri),
     /*   6203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6205 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6207 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   6211 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
     /*   6214 */     GIR_RootConstrainSelectedInstOperands,
     /*   6215 */     // GIR_Coverage, 3954,
     /*   6215 */     GIR_EraseRootFromParent_Done,
     /*   6216 */   // Label 192: @6216
     /*   6216 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(6249), // Rule ID 13505 //
     /*   6221 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6225 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6229 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg32),
     /*   6236 */     // (add:{ *:[i32] } arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift, GPR32:{ *:[i32] }:$Rn)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
     /*   6236 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrs),
     /*   6239 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6241 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   6243 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
     /*   6247 */     GIR_RootConstrainSelectedInstOperands,
     /*   6248 */     // GIR_Coverage, 13505,
     /*   6248 */     GIR_EraseRootFromParent_Done,
     /*   6249 */   // Label 193: @6249
     /*   6249 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(6282), // Rule ID 95 //
     /*   6254 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6258 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6262 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg32),
     /*   6269 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)  =>  (ADDWrs:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, arith_shifted_reg32:{ *:[i32] }:$Rm_and_shift)
     /*   6269 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDWrs),
     /*   6272 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6274 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6276 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
     /*   6280 */     GIR_RootConstrainSelectedInstOperands,
     /*   6281 */     // GIR_Coverage, 95,
     /*   6281 */     GIR_EraseRootFromParent_Done,
     /*   6282 */   // Label 194: @6282
     /*   6282 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(6306), // Rule ID 93 //
     /*   6287 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6291 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6295 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   6299 */     // (add:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)  =>  (ADDWrr:{ *:[i32] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm)
     /*   6299 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDWrr),
     /*   6304 */     GIR_RootConstrainSelectedInstOperands,
     /*   6305 */     // GIR_Coverage, 93,
     /*   6305 */     GIR_Done,
     /*   6306 */   // Label 195: @6306
     /*   6306 */   GIM_Reject,
     /*   6307 */ // Label 170: @6307
     /*   6307 */ GIM_Reject,
     /*   6308 */ // Label 157: @6308
     /*   6308 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(12247),
     /*   6313 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   6316 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   6319 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(6455), // Rule ID 5425 //
     /*   6324 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6328 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6332 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6336 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6340 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6344 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   6348 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6352 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6357 */     // MIs[1] Operand 2
     /*   6357 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   6368 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6372 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6376 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6380 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6384 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   6388 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6392 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6397 */     // MIs[3] Operand 2
     /*   6397 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*   6408 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   6410 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   6410 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   6413 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*   6417 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6422 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   6426 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*   6430 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6437 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   6444 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6449 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   6454 */     // GIR_Coverage, 5425,
     /*   6454 */     GIR_EraseRootFromParent_Done,
     /*   6455 */   // Label 197: @6455
     /*   6455 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(6591), // Rule ID 5424 //
     /*   6460 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6464 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6468 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6472 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6476 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6480 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   6484 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6488 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6493 */     // MIs[1] Operand 2
     /*   6493 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   6504 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6508 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6512 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6516 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6520 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   6524 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6528 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6533 */     // MIs[3] Operand 2
     /*   6533 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*   6544 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   6546 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   6546 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   6549 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*   6553 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6558 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   6562 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*   6566 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6573 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   6580 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6585 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   6590 */     // GIR_Coverage, 5424,
     /*   6590 */     GIR_EraseRootFromParent_Done,
     /*   6591 */   // Label 198: @6591
     /*   6591 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(6727), // Rule ID 5434 //
     /*   6596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6608 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6612 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6616 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   6620 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6624 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6629 */     // MIs[1] Operand 2
     /*   6629 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   6640 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6644 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6648 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6652 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6656 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   6660 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6664 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6669 */     // MIs[3] Operand 2
     /*   6669 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*   6680 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   6682 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v1i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   6682 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   6685 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDLv2i32_v2i64),
     /*   6689 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6694 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   6698 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*   6702 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6709 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   6716 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6721 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   6726 */     // GIR_Coverage, 5434,
     /*   6726 */     GIR_EraseRootFromParent_Done,
     /*   6727 */   // Label 199: @6727
     /*   6727 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(6863), // Rule ID 5423 //
     /*   6732 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6736 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6740 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6744 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6748 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6752 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   6756 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6760 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6765 */     // MIs[1] Operand 2
     /*   6765 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   6776 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6780 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6784 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6788 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6792 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   6796 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6800 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6805 */     // MIs[3] Operand 2
     /*   6805 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*   6816 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   6818 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   6818 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   6821 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*   6825 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6830 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   6834 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*   6838 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6840 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6843 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6845 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   6852 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6857 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   6862 */     // GIR_Coverage, 5423,
     /*   6862 */     GIR_EraseRootFromParent_Done,
     /*   6863 */   // Label 200: @6863
     /*   6863 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(6999), // Rule ID 5422 //
     /*   6868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6872 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6876 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6880 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6884 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6888 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   6892 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6896 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6901 */     // MIs[1] Operand 2
     /*   6901 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   6912 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6916 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   6920 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   6924 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6928 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   6932 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6936 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6941 */     // MIs[3] Operand 2
     /*   6941 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*   6952 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   6954 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   6954 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   6957 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*   6961 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   6966 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   6970 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*   6974 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   6976 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   6979 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6981 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   6988 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   6993 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   6998 */     // GIR_Coverage, 5422,
     /*   6998 */     GIR_EraseRootFromParent_Done,
     /*   6999 */   // Label 201: @6999
     /*   6999 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(7067), // Rule ID 6989 //
     /*   7004 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   7008 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7012 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /*   7016 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   7020 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7024 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   7029 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
     /*   7033 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7037 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /*   7041 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*   7045 */     // MIs[2] Rn
     /*   7045 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*   7050 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*   7054 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7056 */     // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
     /*   7056 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64p),
     /*   7059 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7061 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   7065 */     GIR_RootConstrainSelectedInstOperands,
     /*   7066 */     // GIR_Coverage, 6989,
     /*   7066 */     GIR_EraseRootFromParent_Done,
     /*   7067 */   // Label 202: @7067
     /*   7067 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(7135), // Rule ID 14245 //
     /*   7072 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   7076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /*   7084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   7088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7092 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   7097 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*   7101 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7105 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /*   7109 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*   7113 */     // MIs[2] Rn
     /*   7113 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*   7118 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
     /*   7122 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7124 */     // (add:{ *:[i64] } (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 1:{ *:[i64] }), (vector_extract:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn, 0:{ *:[i64] }))  =>  (ADDPv2i64p:{ *:[i64] } FPR128:{ *:[v2i64] }:$Rn)
     /*   7124 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64p),
     /*   7127 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7129 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   7133 */     GIR_RootConstrainSelectedInstOperands,
     /*   7134 */     // GIR_Coverage, 14245,
     /*   7134 */     GIR_EraseRootFromParent_Done,
     /*   7135 */   // Label 203: @7135
     /*   7135 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(7168), // Rule ID 13504 //
     /*   7140 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*   7144 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*   7148 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm64),
     /*   7155 */     // (add:{ *:[i64] } addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
     /*   7155 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXri),
     /*   7158 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7160 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   7162 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   7166 */     GIR_RootConstrainSelectedInstOperands,
     /*   7167 */     // GIR_Coverage, 13504,
     /*   7167 */     GIR_EraseRootFromParent_Done,
     /*   7168 */   // Label 204: @7168
     /*   7168 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(7301), // Rule ID 4006 //
     /*   7173 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7177 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7181 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7185 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7189 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7193 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7197 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   7201 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*   7205 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7210 */     // MIs[2] Operand 2
     /*   7210 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(32),
     /*   7221 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7225 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7229 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
     /*   7233 */     // MIs[3] Operand 1
     /*   7233 */     // No operand predicates
     /*   7233 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7237 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7239 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (sext_inreg:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, i32:{ *:[Other] }), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7239 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*   7242 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7246 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7251 */     GIR_CustomRenderer, /*InsnID*/2, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7256 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*   7258 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7261 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   7265 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7270 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   7276 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7281 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   7289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7291 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7294 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*   7297 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   7299 */     GIR_RootConstrainSelectedInstOperands,
     /*   7300 */     // GIR_Coverage, 4006,
     /*   7300 */     GIR_EraseRootFromParent_Done,
     /*   7301 */   // Label 205: @7301
     /*   7301 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(7396), // Rule ID 4004 //
     /*   7306 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7310 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7314 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7318 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7322 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7326 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7330 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7334 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7338 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7343 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7347 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7351 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
     /*   7355 */     // MIs[3] Operand 1
     /*   7355 */     // No operand predicates
     /*   7355 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7359 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7361 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7361 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7364 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7368 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7373 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7378 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   7380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   7383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7385 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   7389 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7392 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   7394 */     GIR_RootConstrainSelectedInstOperands,
     /*   7395 */     // GIR_Coverage, 4004,
     /*   7395 */     GIR_EraseRootFromParent_Done,
     /*   7396 */   // Label 206: @7396
     /*   7396 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(7491), // Rule ID 4005 //
     /*   7401 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7405 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7409 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7413 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7417 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7421 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7425 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7429 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7433 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7438 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7442 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7446 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
     /*   7450 */     // MIs[3] Operand 1
     /*   7450 */     // No operand predicates
     /*   7450 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7454 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7456 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7456 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7459 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7463 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7468 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7473 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   7475 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   7478 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7480 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   7484 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7487 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   7489 */     GIR_RootConstrainSelectedInstOperands,
     /*   7490 */     // GIR_Coverage, 4005,
     /*   7490 */     GIR_EraseRootFromParent_Done,
     /*   7491 */   // Label 207: @7491
     /*   7491 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(7524), // Rule ID 92 //
     /*   7496 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*   7500 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*   7504 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addsub_shifted_imm64),
     /*   7511 */     // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (ADDXri:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, addsub_shifted_imm64:{ *:[i64] }:$imm)
     /*   7511 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXri),
     /*   7514 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7516 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   7518 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*   7522 */     GIR_RootConstrainSelectedInstOperands,
     /*   7523 */     // GIR_Coverage, 92,
     /*   7523 */     GIR_EraseRootFromParent_Done,
     /*   7524 */   // Label 208: @7524
     /*   7524 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(7657), // Rule ID 14097 //
     /*   7529 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7533 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7537 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7541 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7545 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7549 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7553 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7557 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   7561 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*   7565 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7570 */     // MIs[2] Operand 2
     /*   7570 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(32),
     /*   7581 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7585 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7589 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
     /*   7593 */     // MIs[3] Operand 1
     /*   7593 */     // No operand predicates
     /*   7593 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7595 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext_inreg:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, i32:{ *:[Other] }), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7595 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*   7598 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7602 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7607 */     GIR_CustomRenderer, /*InsnID*/2, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7612 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*   7614 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7617 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   7621 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7626 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   7632 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7637 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7642 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   7645 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7647 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7650 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*   7653 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   7655 */     GIR_RootConstrainSelectedInstOperands,
     /*   7656 */     // GIR_Coverage, 14097,
     /*   7656 */     GIR_EraseRootFromParent_Done,
     /*   7657 */   // Label 209: @7657
     /*   7657 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(7752), // Rule ID 14095 //
     /*   7662 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7666 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7670 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7674 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7678 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7682 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7686 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7690 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7694 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7698 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7703 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7707 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7711 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_s64imm_32bit),
     /*   7715 */     // MIs[3] Operand 1
     /*   7715 */     // No operand predicates
     /*   7715 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7717 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_s64imm_32bit>>:$C))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7717 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7720 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7724 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7729 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7734 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   7736 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   7739 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7741 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   7745 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7748 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   7750 */     GIR_RootConstrainSelectedInstOperands,
     /*   7751 */     // GIR_Coverage, 14095,
     /*   7751 */     GIR_EraseRootFromParent_Done,
     /*   7752 */   // Label 210: @7752
     /*   7752 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(7847), // Rule ID 14096 //
     /*   7757 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7761 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7765 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7769 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7773 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7777 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7781 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7785 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7789 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7793 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7798 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7802 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7806 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64imm_32bit),
     /*   7810 */     // MIs[3] Operand 1
     /*   7810 */     // No operand predicates
     /*   7810 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7812 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (imm:{ *:[i64] })<<P:Predicate_i64imm_32bit>>:$C))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, (MOVi32imm:{ *:[i32] } (trunc_imm:{ *:[i32] } (imm:{ *:[i64] }):$C)), GPR64:{ *:[i64] }:$Ra)
     /*   7812 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   7815 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::MOVi32imm),
     /*   7819 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   7824 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/3, /*Renderer*/GIMT_Encode2(GICR_renderTruncImm), // C
     /*   7829 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   7831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   7834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   7840 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   7843 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   7845 */     GIR_RootConstrainSelectedInstOperands,
     /*   7846 */     // GIR_Coverage, 14096,
     /*   7846 */     GIR_EraseRootFromParent_Done,
     /*   7847 */   // Label 211: @7847
     /*   7847 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(7929), // Rule ID 13515 //
     /*   7852 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7856 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7860 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7864 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7868 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7872 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7876 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7880 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7884 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7889 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7893 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7897 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   7901 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7906 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7910 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7912 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   7912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   7915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7917 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   7921 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   7925 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   7927 */     GIR_RootConstrainSelectedInstOperands,
     /*   7928 */     // GIR_Coverage, 13515,
     /*   7928 */     GIR_EraseRootFromParent_Done,
     /*   7929 */   // Label 212: @7929
     /*   7929 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(8011), // Rule ID 13516 //
     /*   7934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7946 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   7950 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   7954 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7958 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7962 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   7966 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7971 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   7975 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7979 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   7983 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   7988 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   7992 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   7994 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   7994 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   7997 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   7999 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   8003 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   8007 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   8009 */     GIR_RootConstrainSelectedInstOperands,
     /*   8010 */     // GIR_Coverage, 13516,
     /*   8010 */     GIR_EraseRootFromParent_Done,
     /*   8011 */   // Label 213: @8011
     /*   8011 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(8093), // Rule ID 123 //
     /*   8016 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8020 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8024 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8028 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8032 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8036 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8040 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8044 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8048 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8052 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8057 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   8061 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8065 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   8069 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8074 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   8076 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (sext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (SMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8076 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMADDLrrr),
     /*   8079 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   8081 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   8085 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   8089 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   8091 */     GIR_RootConstrainSelectedInstOperands,
     /*   8092 */     // GIR_Coverage, 123,
     /*   8092 */     GIR_EraseRootFromParent_Done,
     /*   8093 */   // Label 214: @8093
     /*   8093 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(8175), // Rule ID 125 //
     /*   8098 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8102 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8106 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8110 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8114 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8118 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8122 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8126 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8130 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8134 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8139 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   8143 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8147 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   8151 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8156 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   8158 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rn), (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } GPR32:{ *:[i32] }:$Rn, GPR32:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8158 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   8161 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   8163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   8167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   8171 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   8173 */     GIR_RootConstrainSelectedInstOperands,
     /*   8174 */     // GIR_Coverage, 125,
     /*   8174 */     GIR_EraseRootFromParent_Done,
     /*   8175 */   // Label 215: @8175
     /*   8175 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(8233), // Rule ID 13937 //
     /*   8180 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8183 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8187 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8191 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8195 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8198 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
     /*   8203 */     // MIs[1] pattern
     /*   8203 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8206 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8211 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8215 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8217 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1342:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8217 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
     /*   8220 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8222 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
     /*   8224 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8228 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8231 */     GIR_RootConstrainSelectedInstOperands,
     /*   8232 */     // GIR_Coverage, 13937,
     /*   8232 */     GIR_EraseRootFromParent_Done,
     /*   8233 */   // Label 216: @8233
     /*   8233 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(8291), // Rule ID 15799 //
     /*   8238 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8241 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8245 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8249 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8253 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8256 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
     /*   8261 */     // MIs[1] pattern
     /*   8261 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8264 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8269 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8273 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8275 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1344:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8275 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
     /*   8278 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8280 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
     /*   8282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8286 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8289 */     GIR_RootConstrainSelectedInstOperands,
     /*   8290 */     // GIR_Coverage, 15799,
     /*   8290 */     GIR_EraseRootFromParent_Done,
     /*   8291 */   // Label 217: @8291
     /*   8291 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(8349), // Rule ID 15811 //
     /*   8296 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8299 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8303 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8307 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8311 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8314 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
     /*   8319 */     // MIs[1] pattern
     /*   8319 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8322 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8327 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8331 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8333 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1350:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8333 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
     /*   8336 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8338 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
     /*   8340 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8344 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8347 */     GIR_RootConstrainSelectedInstOperands,
     /*   8348 */     // GIR_Coverage, 15811,
     /*   8348 */     GIR_EraseRootFromParent_Done,
     /*   8349 */   // Label 218: @8349
     /*   8349 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(8407), // Rule ID 15823 //
     /*   8354 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8357 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8361 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8365 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8369 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8372 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
     /*   8377 */     // MIs[1] pattern
     /*   8377 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8380 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8385 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8389 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8391 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1343:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern), GPR64:{ *:[i64] }:$Rdn)  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8391 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
     /*   8394 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8396 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rdn
     /*   8398 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8402 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8405 */     GIR_RootConstrainSelectedInstOperands,
     /*   8406 */     // GIR_Coverage, 15823,
     /*   8406 */     GIR_EraseRootFromParent_Done,
     /*   8407 */   // Label 219: @8407
     /*   8407 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(8504), // Rule ID 4021 //
     /*   8412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8416 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8420 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8424 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8428 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8432 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/1, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*   8437 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   8441 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8445 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8449 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8454 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8458 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8460 */     // (add:{ *:[i64] } (mul:{ *:[i64] } GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn, (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), ?:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8460 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   8463 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   8467 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   8472 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   8478 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8483 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   8491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   8493 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   8496 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   8500 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   8502 */     GIR_RootConstrainSelectedInstOperands,
     /*   8503 */     // GIR_Coverage, 4021,
     /*   8503 */     GIR_EraseRootFromParent_Done,
     /*   8504 */   // Label 220: @8504
     /*   8504 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(8601), // Rule ID 14107 //
     /*   8509 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8513 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8517 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8521 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8525 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8529 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8533 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8537 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8541 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8546 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*   8551 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8555 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8557 */     // (add:{ *:[i64] } (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm), GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), ?:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8557 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   8560 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   8564 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   8569 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   8575 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8580 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   8588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   8590 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   8593 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   8597 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   8599 */     GIR_RootConstrainSelectedInstOperands,
     /*   8600 */     // GIR_Coverage, 14107,
     /*   8600 */     GIR_EraseRootFromParent_Done,
     /*   8601 */   // Label 221: @8601
     /*   8601 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(8659), // Rule ID 2653 //
     /*   8606 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8609 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8613 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8617 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8621 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8625 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8628 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntb),
     /*   8633 */     // MIs[1] pattern
     /*   8633 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8636 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8641 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8643 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1342:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCB_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8643 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCB_XPiI),
     /*   8646 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8648 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
     /*   8650 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8657 */     GIR_RootConstrainSelectedInstOperands,
     /*   8658 */     // GIR_Coverage, 2653,
     /*   8658 */     GIR_EraseRootFromParent_Done,
     /*   8659 */   // Label 222: @8659
     /*   8659 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(8717), // Rule ID 10065 //
     /*   8664 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8667 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8671 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8675 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8679 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8683 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8686 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cnth),
     /*   8691 */     // MIs[1] pattern
     /*   8691 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8694 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8699 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8701 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1344:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCH_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8701 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCH_XPiI),
     /*   8704 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8706 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
     /*   8708 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8712 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8715 */     GIR_RootConstrainSelectedInstOperands,
     /*   8716 */     // GIR_Coverage, 10065,
     /*   8716 */     GIR_EraseRootFromParent_Done,
     /*   8717 */   // Label 223: @8717
     /*   8717 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(8775), // Rule ID 10077 //
     /*   8722 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8725 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8729 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8733 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8737 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8741 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8744 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntw),
     /*   8749 */     // MIs[1] pattern
     /*   8749 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8752 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8757 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8759 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1350:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCW_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCW_XPiI),
     /*   8762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8764 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
     /*   8766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8770 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8773 */     GIR_RootConstrainSelectedInstOperands,
     /*   8774 */     // GIR_Coverage, 10077,
     /*   8774 */     GIR_EraseRootFromParent_Done,
     /*   8775 */   // Label 224: @8775
     /*   8775 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(8833), // Rule ID 10089 //
     /*   8780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME_UseScalarIncVL),
     /*   8783 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8787 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8791 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8795 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*   8799 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*   8802 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntd),
     /*   8807 */     // MIs[1] pattern
     /*   8807 */     GIM_CheckIsImm, /*MI*/1, /*Op*/2,
     /*   8810 */     GIM_CheckImmOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_sve_pred_enum),
     /*   8815 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8817 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (intrinsic_wo_chain:{ *:[i64] } 1343:{ *:[iPTR] }, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern))  =>  (INCD_XPiI:{ *:[i64] } GPR64:{ *:[i64] }:$Rdn, (timm:{ *:[i32] })<<P:Predicate_sve_pred_enum>>:$pattern, 1:{ *:[i32] })
     /*   8817 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCD_XPiI),
     /*   8820 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   8822 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rdn
     /*   8824 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pattern
     /*   8828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   8831 */     GIR_RootConstrainSelectedInstOperands,
     /*   8832 */     // GIR_Coverage, 10089,
     /*   8832 */     GIR_EraseRootFromParent_Done,
     /*   8833 */   // Label 225: @8833
     /*   8833 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(8930), // Rule ID 14108 //
     /*   8838 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8842 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8846 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8850 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8854 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8858 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8862 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/1, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*   8867 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   8871 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8875 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8879 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8884 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8886 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn, (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm)))  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), ?:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8886 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   8889 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   8893 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   8898 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   8904 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8909 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8914 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   8917 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   8919 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   8922 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   8926 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   8928 */     GIR_RootConstrainSelectedInstOperands,
     /*   8929 */     // GIR_Coverage, 14108,
     /*   8929 */     GIR_EraseRootFromParent_Done,
     /*   8930 */   // Label 226: @8930
     /*   8930 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(9027), // Rule ID 14109 //
     /*   8935 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8939 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   8943 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8947 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8951 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   8955 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   8959 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8963 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8967 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   8971 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   8976 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*   8981 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8983 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } (zext:{ *:[i64] } GPR32:{ *:[i32] }:$Rm), GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn))  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), ?:{ *:[i32] }:$Rm, GPR64:{ *:[i64] }:$Ra)
     /*   8983 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*   8986 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   8990 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   8995 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*   9001 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*   9006 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*   9011 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*   9014 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   9016 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   9019 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   9023 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   9025 */     GIR_RootConstrainSelectedInstOperands,
     /*   9026 */     // GIR_Coverage, 14109,
     /*   9026 */     GIR_EraseRootFromParent_Done,
     /*   9027 */   // Label 227: @9027
     /*   9027 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(9190), // Rule ID 14217 //
     /*   9032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9036 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9040 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9044 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9048 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9052 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*   9056 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9060 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   9064 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9069 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9074 */     // MIs[1] Operand 2
     /*   9074 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9085 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9089 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9091 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v1i64] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (SMLALv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9091 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9094 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9098 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9103 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9105 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9108 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9112 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9117 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9120 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*   9124 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9127 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9132 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9137 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9142 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9145 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
     /*   9149 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9154 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9157 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   9161 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*   9165 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9172 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9179 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9184 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9189 */     // GIR_Coverage, 14217,
     /*   9189 */     GIR_EraseRootFromParent_Done,
     /*   9190 */   // Label 228: @9190
     /*   9190 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(9353), // Rule ID 14214 //
     /*   9195 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9199 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9203 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9207 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9211 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9215 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*   9219 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9223 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   9227 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9232 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9237 */     // MIs[1] Operand 2
     /*   9237 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9248 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9252 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9254 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v1i64] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UMLALv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9254 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9257 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9261 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9266 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9268 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9271 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9275 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9280 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9283 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*   9287 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9290 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9295 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9300 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9305 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9308 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
     /*   9312 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9317 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9320 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   9324 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*   9328 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9330 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9333 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9335 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9342 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9347 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9352 */     // GIR_Coverage, 14214,
     /*   9352 */     GIR_EraseRootFromParent_Done,
     /*   9353 */   // Label 229: @9353
     /*   9353 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(9503), // Rule ID 14223 //
     /*   9358 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9362 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9366 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9370 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9374 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9378 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9382 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9386 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9391 */     // MIs[1] Operand 2
     /*   9391 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9402 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9406 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9408 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v1i64] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9408 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9411 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9415 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9420 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9422 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9425 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9429 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9434 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9437 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   9441 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9444 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9449 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9454 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9459 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9462 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*   9466 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9471 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9474 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   9478 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9480 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9483 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9485 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9492 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9497 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9502 */     // GIR_Coverage, 14223,
     /*   9502 */     GIR_EraseRootFromParent_Done,
     /*   9503 */   // Label 230: @9503
     /*   9503 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(9653), // Rule ID 14226 //
     /*   9508 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9512 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9516 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9520 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9524 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9528 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   9532 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9536 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9541 */     // MIs[1] Operand 2
     /*   9541 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9552 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9556 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9558 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v1i64] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (SADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9558 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9561 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9565 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9570 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9572 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9575 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9579 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9584 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9587 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   9591 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9594 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9599 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9604 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9609 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9612 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
     /*   9616 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9621 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9624 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   9628 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9630 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9633 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9635 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9642 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9647 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9652 */     // GIR_Coverage, 14226,
     /*   9652 */     GIR_EraseRootFromParent_Done,
     /*   9653 */   // Label 231: @9653
     /*   9653 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(9803), // Rule ID 14222 //
     /*   9658 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9670 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9674 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9678 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9682 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9686 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9691 */     // MIs[1] Operand 2
     /*   9691 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9702 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9706 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9708 */     // (add:{ *:[v1i64] } (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v1i64] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9708 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9711 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9715 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9720 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9722 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9725 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9729 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9734 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9737 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*   9741 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9744 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9749 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9754 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9759 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9762 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*   9766 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9771 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9774 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   9778 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9785 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9792 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9797 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9802 */     // GIR_Coverage, 14222,
     /*   9802 */     GIR_EraseRootFromParent_Done,
     /*   9803 */   // Label 232: @9803
     /*   9803 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(9966), // Rule ID 5407 //
     /*   9808 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9812 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9816 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9820 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9824 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9828 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9832 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*   9836 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   9840 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   9844 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9849 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9854 */     // MIs[1] Operand 2
     /*   9854 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*   9865 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9867 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Ra, (extract_subvector:{ *:[v1i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (SMLALv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*   9867 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*   9870 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   9874 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9879 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*   9881 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*   9884 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*   9888 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9893 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*   9896 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*   9900 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*   9903 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9908 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9913 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9918 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*   9921 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
     /*   9925 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   9930 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*   9933 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   9937 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*   9941 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   9943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*   9946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9948 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*   9955 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9960 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*   9965 */     // GIR_Coverage, 5407,
     /*   9965 */     GIR_EraseRootFromParent_Done,
     /*   9966 */   // Label 233: @9966
     /*   9966 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(10129), // Rule ID 5404 //
     /*   9971 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9975 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*   9979 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9983 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*   9987 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   9991 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9995 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*   9999 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  10003 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  10007 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10012 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10017 */     // MIs[1] Operand 2
     /*  10017 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  10028 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  10030 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Ra, (extract_subvector:{ *:[v1i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UMLALv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*  10030 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*  10033 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10037 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10042 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  10044 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*  10047 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  10051 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10056 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  10059 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*  10063 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  10066 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10071 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10076 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10081 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*  10084 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
     /*  10088 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10093 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  10096 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  10100 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  10104 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  10106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10111 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  10118 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10123 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10128 */     // GIR_Coverage, 5404,
     /*  10128 */     GIR_EraseRootFromParent_Done,
     /*  10129 */   // Label 234: @10129
     /*  10129 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(10279), // Rule ID 5431 //
     /*  10134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10138 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10142 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10146 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  10150 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  10154 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10158 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  10162 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  10166 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10171 */     // MIs[1] Operand 2
     /*  10171 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  10182 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  10184 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn, (extract_subvector:{ *:[v1i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*  10184 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*  10187 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10191 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10196 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  10198 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*  10201 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  10205 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10210 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  10213 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  10217 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  10220 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10225 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10230 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10235 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*  10238 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  10242 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10247 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  10250 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  10254 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  10256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10261 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  10268 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10273 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10278 */     // GIR_Coverage, 5431,
     /*  10278 */     GIR_EraseRootFromParent_Done,
     /*  10279 */   // Label 235: @10279
     /*  10279 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(10429), // Rule ID 5437 //
     /*  10284 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10288 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10292 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10296 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  10300 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  10304 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10308 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  10312 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  10316 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10321 */     // MIs[1] Operand 2
     /*  10321 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  10332 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  10334 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn, (extract_subvector:{ *:[v1i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (SADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*  10334 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*  10337 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10341 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10346 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  10348 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*  10351 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  10355 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10360 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  10363 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  10367 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  10370 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10375 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10380 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10385 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*  10388 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
     /*  10392 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10397 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  10400 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  10404 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  10406 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10409 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10411 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  10418 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10423 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10428 */     // GIR_Coverage, 5437,
     /*  10428 */     GIR_EraseRootFromParent_Done,
     /*  10429 */   // Label 236: @10429
     /*  10429 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(10579), // Rule ID 5430 //
     /*  10434 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10438 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10442 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10446 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  10450 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  10454 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10458 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  10462 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  10466 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10471 */     // MIs[1] Operand 2
     /*  10471 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  10482 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  10484 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rn, (extract_subvector:{ *:[v1i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v1i64] } (UADDWv2i32_v2i64:{ *:[v2i64] } (INSERT_SUBREG:{ *:[v2i64] } (IMPLICIT_DEF:{ *:[v2i64] }), V64:{ *:[v1i64] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v2i32] }:$Rm), dsub:{ *:[i32] })
     /*  10484 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v2s64,
     /*  10487 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10491 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10496 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  10498 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v2s64,
     /*  10501 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  10505 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10510 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  10513 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  10517 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  10520 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10525 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10530 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10535 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v2s64,
     /*  10538 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  10542 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10547 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  10550 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  10554 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  10556 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10559 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10561 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  10568 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  10573 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  10578 */     // GIR_Coverage, 5430,
     /*  10578 */     GIR_EraseRootFromParent_Done,
     /*  10579 */   // Label 237: @10579
     /*  10579 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(10612), // Rule ID 13508 //
     /*  10584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*  10588 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*  10592 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32to64_i64),
     /*  10599 */     // (add:{ *:[i64] } arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend, GPR64sp:{ *:[i64] }:$Rn)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
     /*  10599 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrx),
     /*  10602 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10604 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10606 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
     /*  10610 */     GIR_RootConstrainSelectedInstOperands,
     /*  10611 */     // GIR_Coverage, 13508,
     /*  10611 */     GIR_EraseRootFromParent_Done,
     /*  10612 */   // Label 238: @10612
     /*  10612 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(10648), // Rule ID 14088 //
     /*  10617 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10621 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10625 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm64),
     /*  10632 */     // (add:{ *:[i64] } neg_addsub_shifted_imm64:{ *:[i64] }:$imm, GPR64:{ *:[i64] }:$Rn)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
     /*  10632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXri),
     /*  10635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10637 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10639 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*  10643 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
     /*  10646 */     GIR_RootConstrainSelectedInstOperands,
     /*  10647 */     // GIR_Coverage, 14088,
     /*  10647 */     GIR_EraseRootFromParent_Done,
     /*  10648 */   // Label 239: @10648
     /*  10648 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(10760), // Rule ID 4020 //
     /*  10653 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10657 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10661 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10665 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  10669 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  10673 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/1, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*  10678 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*  10683 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10687 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10689 */     // (add:{ *:[i64] } (mul:{ *:[i64] } GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn, GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rm), GPR64:{ *:[i64] }:$Ra)  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rm, sub_32:{ *:[i32] }), GPR64:{ *:[i64] }:$Ra)
     /*  10689 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  10692 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10696 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10701 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(20), // Rm
     /*  10707 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*  10712 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10717 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  10720 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10724 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10729 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*  10735 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*  10740 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10745 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*  10748 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10750 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  10753 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  10756 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*  10758 */     GIR_RootConstrainSelectedInstOperands,
     /*  10759 */     // GIR_Coverage, 4020,
     /*  10759 */     GIR_EraseRootFromParent_Done,
     /*  10760 */   // Label 240: @10760
     /*  10760 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(10793), // Rule ID 98 //
     /*  10765 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*  10769 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64spRegClassID),
     /*  10773 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_extended_reg32to64_i64),
     /*  10780 */     // (add:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)  =>  (ADDXrx:{ *:[i64] } GPR64sp:{ *:[i64] }:$Rn, arith_extended_reg32to64_i64:{ *:[i64] }:$Rm_and_extend)
     /*  10780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrx),
     /*  10783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10785 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10787 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_extend
     /*  10791 */     GIR_RootConstrainSelectedInstOperands,
     /*  10792 */     // GIR_Coverage, 98,
     /*  10792 */     GIR_EraseRootFromParent_Done,
     /*  10793 */   // Label 241: @10793
     /*  10793 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(10829), // Rule ID 3955 //
     /*  10798 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10802 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10806 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_neg_addsub_shifted_imm64),
     /*  10813 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)  =>  (SUBSXri:{ *:[i64] }:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, neg_addsub_shifted_imm64:{ *:[i64] }:$imm)
     /*  10813 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SUBSXri),
     /*  10816 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10818 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10820 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // imm
     /*  10824 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AArch64::NZCV*/0,
     /*  10827 */     GIR_RootConstrainSelectedInstOperands,
     /*  10828 */     // GIR_Coverage, 3955,
     /*  10828 */     GIR_EraseRootFromParent_Done,
     /*  10829 */   // Label 242: @10829
     /*  10829 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(10941), // Rule ID 14106 //
     /*  10834 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10838 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10842 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10846 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10850 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  10854 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  10858 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/1, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*  10863 */     GIM_CheckLeafOperandPredicate, /*MI*/1, /*MO*/2, /*Predicate*/GIMT_Encode2(GICXXPred_MO_Predicate_top32Zero),
     /*  10868 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10870 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Ra, (mul:{ *:[i64] } GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rn, GPR64:{ *:[i64] }<<P:Predicate_top32Zero>>:$Rm))  =>  (UMADDLrrr:{ *:[i64] } (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rn, sub_32:{ *:[i32] }), (EXTRACT_SUBREG:{ *:[i32] } GPR64:{ *:[i64] }:$Rm, sub_32:{ *:[i32] }), GPR64:{ *:[i64] }:$Ra)
     /*  10870 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  10873 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10877 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10882 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, /*SubRegIdx*/GIMT_Encode2(20), // Rm
     /*  10888 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*  10893 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10898 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  10901 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  10905 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10910 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(20), // Rn
     /*  10916 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AArch64::GPR32RegClassID),
     /*  10921 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10926 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMADDLrrr),
     /*  10929 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10931 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  10934 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  10937 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*  10939 */     GIR_RootConstrainSelectedInstOperands,
     /*  10940 */     // GIR_Coverage, 14106,
     /*  10940 */     GIR_EraseRootFromParent_Done,
     /*  10941 */   // Label 243: @10941
     /*  10941 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(10974), // Rule ID 13506 //
     /*  10946 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10950 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10954 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg64),
     /*  10961 */     // (add:{ *:[i64] } arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift, GPR64:{ *:[i64] }:$Rn)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
     /*  10961 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrs),
     /*  10964 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10966 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10968 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
     /*  10972 */     GIR_RootConstrainSelectedInstOperands,
     /*  10973 */     // GIR_Coverage, 13506,
     /*  10973 */     GIR_EraseRootFromParent_Done,
     /*  10974 */   // Label 244: @10974
     /*  10974 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(11037), // Rule ID 15839 //
     /*  10979 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  10982 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  10986 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10990 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  10994 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  10997 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11002 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
     /*  11006 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11008 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11013 */     // MIs[1] pred
     /*  11013 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11018 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11022 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11024 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv16i1] }:$pred, PPRAny:{ *:[nxv16i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>, GPR64:{ *:[i64] }:$Rn)  =>  (INCP_XP_B:{ *:[i64] } PPRAny:{ *:[nxv16i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11024 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_B),
     /*  11027 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11029 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11033 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  11035 */     GIR_RootConstrainSelectedInstOperands,
     /*  11036 */     // GIR_Coverage, 15839,
     /*  11036 */     GIR_EraseRootFromParent_Done,
     /*  11037 */   // Label 245: @11037
     /*  11037 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(11100), // Rule ID 15840 //
     /*  11042 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11045 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11049 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11053 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11057 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11060 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11065 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
     /*  11069 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11071 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11076 */     // MIs[1] pred
     /*  11076 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11081 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11085 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11087 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv8i1] }:$pred, PPRAny:{ *:[nxv8i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>, GPR64:{ *:[i64] }:$Rn)  =>  (INCP_XP_H:{ *:[i64] } PPRAny:{ *:[nxv8i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11087 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_H),
     /*  11090 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11092 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11096 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  11098 */     GIR_RootConstrainSelectedInstOperands,
     /*  11099 */     // GIR_Coverage, 15840,
     /*  11099 */     GIR_EraseRootFromParent_Done,
     /*  11100 */   // Label 246: @11100
     /*  11100 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(11163), // Rule ID 15841 //
     /*  11105 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11108 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11112 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11116 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11120 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11123 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11128 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
     /*  11132 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11134 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11139 */     // MIs[1] pred
     /*  11139 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11144 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11148 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11150 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv4i1] }:$pred, PPRAny:{ *:[nxv4i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>, GPR64:{ *:[i64] }:$Rn)  =>  (INCP_XP_S:{ *:[i64] } PPRAny:{ *:[nxv4i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11150 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_S),
     /*  11153 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11155 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11159 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  11161 */     GIR_RootConstrainSelectedInstOperands,
     /*  11162 */     // GIR_Coverage, 15841,
     /*  11162 */     GIR_EraseRootFromParent_Done,
     /*  11163 */   // Label 247: @11163
     /*  11163 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(11226), // Rule ID 15842 //
     /*  11168 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11171 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11175 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11179 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11183 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11186 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11191 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
     /*  11195 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11197 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11202 */     // MIs[1] pred
     /*  11202 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11207 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11211 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11213 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv2i1] }:$pred, PPRAny:{ *:[nxv2i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>, GPR64:{ *:[i64] }:$Rn)  =>  (INCP_XP_D:{ *:[i64] } PPRAny:{ *:[nxv2i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11213 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_D),
     /*  11216 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11218 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11222 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  11224 */     GIR_RootConstrainSelectedInstOperands,
     /*  11225 */     // GIR_Coverage, 15842,
     /*  11225 */     GIR_EraseRootFromParent_Done,
     /*  11226 */   // Label 248: @11226
     /*  11226 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(11259), // Rule ID 96 //
     /*  11231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11235 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11239 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_arith_shifted_reg64),
     /*  11246 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)  =>  (ADDXrs:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, arith_shifted_reg64:{ *:[i64] }:$Rm_and_shift)
     /*  11246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDXrs),
     /*  11249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  11251 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11253 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // Rm_and_shift
     /*  11257 */     GIR_RootConstrainSelectedInstOperands,
     /*  11258 */     // GIR_Coverage, 96,
     /*  11258 */     GIR_EraseRootFromParent_Done,
     /*  11259 */   // Label 249: @11259
     /*  11259 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(11322), // Rule ID 10176 //
     /*  11264 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11267 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11271 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11275 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11279 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11283 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11286 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv16s1,
     /*  11295 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11297 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11302 */     // MIs[1] pred
     /*  11302 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11307 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11309 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv16i1] }:$pred, PPRAny:{ *:[nxv16i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>)  =>  (INCP_XP_B:{ *:[i64] } PPRAny:{ *:[nxv16i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11309 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_B),
     /*  11312 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11318 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11320 */     GIR_RootConstrainSelectedInstOperands,
     /*  11321 */     // GIR_Coverage, 10176,
     /*  11321 */     GIR_EraseRootFromParent_Done,
     /*  11322 */   // Label 250: @11322
     /*  11322 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(11385), // Rule ID 10177 //
     /*  11327 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11330 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11334 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11338 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11342 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11346 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11349 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11354 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv8s1,
     /*  11358 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11360 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11365 */     // MIs[1] pred
     /*  11365 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11370 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11372 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv8i1] }:$pred, PPRAny:{ *:[nxv8i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>)  =>  (INCP_XP_H:{ *:[i64] } PPRAny:{ *:[nxv8i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_H),
     /*  11375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11381 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11383 */     GIR_RootConstrainSelectedInstOperands,
     /*  11384 */     // GIR_Coverage, 10177,
     /*  11384 */     GIR_EraseRootFromParent_Done,
     /*  11385 */   // Label 251: @11385
     /*  11385 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(11448), // Rule ID 10178 //
     /*  11390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11409 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11412 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11417 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s1,
     /*  11421 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11423 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11428 */     // MIs[1] pred
     /*  11428 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11433 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11435 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv4i1] }:$pred, PPRAny:{ *:[nxv4i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>)  =>  (INCP_XP_S:{ *:[i64] } PPRAny:{ *:[nxv4i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11435 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_S),
     /*  11438 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11440 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11444 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11446 */     GIR_RootConstrainSelectedInstOperands,
     /*  11447 */     // GIR_Coverage, 10178,
     /*  11447 */     GIR_EraseRootFromParent_Done,
     /*  11448 */   // Label 252: @11448
     /*  11448 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(11511), // Rule ID 10179 //
     /*  11453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSVE_or_SME),
     /*  11456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11460 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  11464 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11468 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11472 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  11475 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_sve_cntp),
     /*  11480 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s1,
     /*  11484 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  11486 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::PPRRegClassID),
     /*  11491 */     // MIs[1] pred
     /*  11491 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11496 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11498 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, (intrinsic_wo_chain:{ *:[i64] } 1345:{ *:[iPTR] }, PPRAny:{ *:[nxv2i1] }:$pred, PPRAny:{ *:[nxv2i1] }:$pred)<<P:Predicate_int_aarch64_sve_cntp_oneuse>>)  =>  (INCP_XP_D:{ *:[i64] } PPRAny:{ *:[nxv2i1] }:$pred, ?:{ *:[i64] }:$Rn)
     /*  11498 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::INCP_XP_D),
     /*  11501 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  11503 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // pred
     /*  11507 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11509 */     GIR_RootConstrainSelectedInstOperands,
     /*  11510 */     // GIR_Coverage, 10179,
     /*  11510 */     GIR_EraseRootFromParent_Done,
     /*  11511 */   // Label 253: @11511
     /*  11511 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(11567), // Rule ID 13616 //
     /*  11516 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11519 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11523 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11527 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11531 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  11534 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  11539 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11543 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11548 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11552 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11554 */     // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 670:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  11554 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
     /*  11557 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11559 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  11561 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  11565 */     GIR_RootConstrainSelectedInstOperands,
     /*  11566 */     // GIR_Coverage, 13616,
     /*  11566 */     GIR_EraseRootFromParent_Done,
     /*  11567 */   // Label 254: @11567
     /*  11567 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(11623), // Rule ID 13628 //
     /*  11572 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11575 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11579 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11583 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11587 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  11590 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  11595 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11599 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11604 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11608 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11610 */     // (add:{ *:[v1i64] } (intrinsic_wo_chain:{ *:[v1i64] } 735:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  11610 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
     /*  11613 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11615 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  11617 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  11621 */     GIR_RootConstrainSelectedInstOperands,
     /*  11622 */     // GIR_Coverage, 13628,
     /*  11622 */     GIR_EraseRootFromParent_Done,
     /*  11623 */   // Label 255: @11623
     /*  11623 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(11690), // Rule ID 13844 //
     /*  11628 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11631 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11635 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11639 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  11643 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  11647 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11652 */     // MIs[1] imm
     /*  11652 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  11656 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11660 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  11664 */     // MIs[2] Operand 1
     /*  11664 */     // No operand predicates
     /*  11664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11668 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  11672 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11674 */     // (add:{ *:[v1i64] } (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  11674 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
     /*  11677 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11679 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  11681 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  11685 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  11688 */     GIR_RootConstrainSelectedInstOperands,
     /*  11689 */     // GIR_Coverage, 13844,
     /*  11689 */     GIR_EraseRootFromParent_Done,
     /*  11690 */   // Label 256: @11690
     /*  11690 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(11757), // Rule ID 13847 //
     /*  11695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  11710 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  11714 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11719 */     // MIs[1] imm
     /*  11719 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  11723 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11727 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  11731 */     // MIs[2] Operand 1
     /*  11731 */     // No operand predicates
     /*  11731 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11735 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  11739 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11741 */     // (add:{ *:[v1i64] } (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), FPR64:{ *:[v1i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  11741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
     /*  11744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11746 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  11748 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  11752 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  11755 */     GIR_RootConstrainSelectedInstOperands,
     /*  11756 */     // GIR_Coverage, 13847,
     /*  11756 */     GIR_EraseRootFromParent_Done,
     /*  11757 */   // Label 257: @11757
     /*  11757 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(11813), // Rule ID 1001 //
     /*  11762 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11765 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11769 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11773 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11777 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11781 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  11784 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  11789 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11793 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11798 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11800 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 670:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  11800 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
     /*  11803 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11805 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  11807 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  11811 */     GIR_RootConstrainSelectedInstOperands,
     /*  11812 */     // GIR_Coverage, 1001,
     /*  11812 */     GIR_EraseRootFromParent_Done,
     /*  11813 */   // Label 258: @11813
     /*  11813 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(11869), // Rule ID 1062 //
     /*  11818 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11821 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11825 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11829 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11833 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  11837 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  11840 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  11845 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11849 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11854 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11856 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (intrinsic_wo_chain:{ *:[v1i64] } 735:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  11856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
     /*  11859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11861 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  11863 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  11867 */     GIR_RootConstrainSelectedInstOperands,
     /*  11868 */     // GIR_Coverage, 1062,
     /*  11868 */     GIR_EraseRootFromParent_Done,
     /*  11869 */   // Label 259: @11869
     /*  11869 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(11936), // Rule ID 2125 //
     /*  11874 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11877 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11881 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11885 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11889 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  11893 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  11897 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11902 */     // MIs[1] imm
     /*  11902 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  11906 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11910 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  11914 */     // MIs[2] Operand 1
     /*  11914 */     // No operand predicates
     /*  11914 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  11918 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11920 */     // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vashr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  11920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAd),
     /*  11923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11925 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  11927 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  11931 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  11934 */     GIR_RootConstrainSelectedInstOperands,
     /*  11935 */     // GIR_Coverage, 2125,
     /*  11935 */     GIR_EraseRootFromParent_Done,
     /*  11936 */   // Label 260: @11936
     /*  11936 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(12003), // Rule ID 2134 //
     /*  11941 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11948 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11952 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11956 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  11960 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  11964 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  11969 */     // MIs[1] imm
     /*  11969 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  11973 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11977 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  11981 */     // MIs[2] Operand 1
     /*  11981 */     // No operand predicates
     /*  11981 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  11985 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11987 */     // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, (AArch64vlshr:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAd:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rd, FPR64:{ *:[v1i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  11987 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAd),
     /*  11990 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11992 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  11994 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  11998 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  12001 */     GIR_RootConstrainSelectedInstOperands,
     /*  12002 */     // GIR_Coverage, 2134,
     /*  12002 */     GIR_EraseRootFromParent_Done,
     /*  12003 */   // Label 261: @12003
     /*  12003 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(12051), // Rule ID 13615 //
     /*  12008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12015 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12019 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  12023 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12027 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12032 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12036 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12038 */     // (add:{ *:[v1i64] } (AArch64saddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  12038 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
     /*  12041 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12043 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  12045 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  12049 */     GIR_RootConstrainSelectedInstOperands,
     /*  12050 */     // GIR_Coverage, 13615,
     /*  12050 */     GIR_EraseRootFromParent_Done,
     /*  12051 */   // Label 262: @12051
     /*  12051 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(12099), // Rule ID 13627 //
     /*  12056 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12059 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12063 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12067 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  12071 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12075 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12080 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12084 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12086 */     // (add:{ *:[v1i64] } (AArch64uaddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn), V64:{ *:[v1i64] }:$Rd)  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  12086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
     /*  12089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12091 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  12093 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  12097 */     GIR_RootConstrainSelectedInstOperands,
     /*  12098 */     // GIR_Coverage, 13627,
     /*  12098 */     GIR_EraseRootFromParent_Done,
     /*  12099 */   // Label 263: @12099
     /*  12099 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(12147), // Rule ID 1000 //
     /*  12104 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12107 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12111 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12115 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12119 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  12123 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12127 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12132 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12134 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (AArch64saddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn))  =>  (SADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  12134 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv2i32_v1i64),
     /*  12137 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12139 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  12141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  12145 */     GIR_RootConstrainSelectedInstOperands,
     /*  12146 */     // GIR_Coverage, 1000,
     /*  12146 */     GIR_EraseRootFromParent_Done,
     /*  12147 */   // Label 264: @12147
     /*  12147 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(12195), // Rule ID 1061 //
     /*  12152 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12155 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12159 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12163 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12167 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  12171 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12175 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12180 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12182 */     // (add:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, (AArch64uaddlp_n:{ *:[v1i64] } V64:{ *:[v2i32] }:$Rn))  =>  (UADALPv2i32_v1i64:{ *:[v1i64] } V64:{ *:[v1i64] }:$Rd, V64:{ *:[v2i32] }:$Rn)
     /*  12182 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv2i32_v1i64),
     /*  12185 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12187 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  12189 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  12193 */     GIR_RootConstrainSelectedInstOperands,
     /*  12194 */     // GIR_Coverage, 1061,
     /*  12194 */     GIR_EraseRootFromParent_Done,
     /*  12195 */   // Label 265: @12195
     /*  12195 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(12219), // Rule ID 94 //
     /*  12200 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  12204 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  12208 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::GPR64RegClassID),
     /*  12212 */     // (add:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)  =>  (ADDXrr:{ *:[i64] } GPR64:{ *:[i64] }:$Rn, GPR64:{ *:[i64] }:$Rm)
     /*  12212 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDXrr),
     /*  12217 */     GIR_RootConstrainSelectedInstOperands,
     /*  12218 */     // GIR_Coverage, 94,
     /*  12218 */     GIR_Done,
     /*  12219 */   // Label 266: @12219
     /*  12219 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(12246), // Rule ID 1611 //
     /*  12224 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12227 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12231 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12235 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12239 */     // (add:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)  =>  (ADDv1i64:{ *:[v1i64] } FPR64:{ *:[v1i64] }:$Rn, FPR64:{ *:[v1i64] }:$Rm)
     /*  12239 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv1i64),
     /*  12244 */     GIR_RootConstrainSelectedInstOperands,
     /*  12245 */     // GIR_Coverage, 1611,
     /*  12245 */     GIR_Done,
     /*  12246 */   // Label 267: @12246
     /*  12246 */   GIM_Reject,
     /*  12247 */ // Label 196: @12247
     /*  12247 */ GIM_Reject,
     /*  12248 */ // Label 158: @12248
     /*  12248 */ GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(15855),
     /*  12253 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12256 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  12259 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(12447), // Rule ID 7010 //
     /*  12264 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12268 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12272 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_ZIP1),
     /*  12276 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12280 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  12284 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12288 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12292 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12296 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12301 */     // MIs[2] Operand 2
     /*  12301 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  12312 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  12316 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12320 */     // MIs[3] Rn
     /*  12320 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12325 */     // MIs[3] Operand 2
     /*  12325 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(2),
     /*  12336 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  12340 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AArch64::G_ZIP2),
     /*  12344 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12348 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  12352 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  12356 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12360 */     // MIs[5] Rn
     /*  12360 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12365 */     // MIs[5] Operand 2
     /*  12365 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(0),
     /*  12376 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/2, // MIs[6]
     /*  12380 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12384 */     // MIs[6] Rn
     /*  12384 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12389 */     // MIs[6] Operand 2
     /*  12389 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(2),
     /*  12400 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12402 */     // (add:{ *:[v2i32] } (AArch64zip1:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 2:{ *:[i64] })), (AArch64zip2:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 2:{ *:[i64] })))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (ADDPv4i32:{ *:[f128] } ?:{ *:[v4i32] }:$Rn, ?:{ *:[v4i32] }:$Rn), dsub:{ *:[i32] })
     /*  12402 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  12405 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv4i32),
     /*  12409 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12414 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12418 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12422 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12424 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12427 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12429 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  12436 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12441 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12446 */     // GIR_Coverage, 7010,
     /*  12446 */     GIR_EraseRootFromParent_Done,
     /*  12447 */   // Label 269: @12447
     /*  12447 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(12635), // Rule ID 14256 //
     /*  12452 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_ZIP2),
     /*  12464 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12468 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  12472 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12476 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12480 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12484 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12489 */     // MIs[2] Operand 2
     /*  12489 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  12500 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  12504 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12508 */     // MIs[3] Rn
     /*  12508 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12513 */     // MIs[3] Operand 2
     /*  12513 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(2),
     /*  12524 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  12528 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AArch64::G_ZIP1),
     /*  12532 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  12536 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  12540 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  12544 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12548 */     // MIs[5] Rn
     /*  12548 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12553 */     // MIs[5] Operand 2
     /*  12553 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(0),
     /*  12564 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/2, // MIs[6]
     /*  12568 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12572 */     // MIs[6] Rn
     /*  12572 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12577 */     // MIs[6] Operand 2
     /*  12577 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(2),
     /*  12588 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12590 */     // (add:{ *:[v2i32] } (AArch64zip2:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 2:{ *:[i64] })), (AArch64zip1:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } FPR128:{ *:[v4i32] }:$Rn, 2:{ *:[i64] })))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (ADDPv4i32:{ *:[f128] } ?:{ *:[v4i32] }:$Rn, ?:{ *:[v4i32] }:$Rn), dsub:{ *:[i32] })
     /*  12590 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  12593 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv4i32),
     /*  12597 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12602 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12606 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12610 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12612 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12615 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12617 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  12624 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12629 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12634 */     // GIR_Coverage, 14256,
     /*  12634 */     GIR_EraseRootFromParent_Done,
     /*  12635 */   // Label 270: @12635
     /*  12635 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(12771), // Rule ID 5421 //
     /*  12640 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12644 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12648 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12652 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12656 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12660 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12664 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12668 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12673 */     // MIs[1] Operand 2
     /*  12673 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  12684 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12688 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12692 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12696 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12700 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12704 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12708 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12713 */     // MIs[3] Operand 2
     /*  12713 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  12724 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  12726 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  12726 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  12729 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  12733 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12738 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12742 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  12746 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12748 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12751 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12753 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  12760 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12765 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12770 */     // GIR_Coverage, 5421,
     /*  12770 */     GIR_EraseRootFromParent_Done,
     /*  12771 */   // Label 271: @12771
     /*  12771 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(12907), // Rule ID 5420 //
     /*  12776 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12780 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12784 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12788 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12792 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12796 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12800 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12804 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12809 */     // MIs[1] Operand 2
     /*  12809 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  12820 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12824 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12828 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12832 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12836 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12840 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12844 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12849 */     // MIs[3] Operand 2
     /*  12849 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  12860 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  12862 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  12862 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  12865 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  12869 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12874 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  12878 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  12882 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12889 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  12896 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12901 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  12906 */     // GIR_Coverage, 5420,
     /*  12906 */     GIR_EraseRootFromParent_Done,
     /*  12907 */   // Label 272: @12907
     /*  12907 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(13043), // Rule ID 5433 //
     /*  12912 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12916 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12920 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12924 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12928 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12932 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12936 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12940 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12945 */     // MIs[1] Operand 2
     /*  12945 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  12956 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12960 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  12964 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12968 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12972 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12976 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12980 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  12985 */     // MIs[3] Operand 2
     /*  12985 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  12996 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  12998 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  12998 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13001 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDLv4i16_v4i32),
     /*  13005 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13010 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  13014 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  13018 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13020 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13023 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13025 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13032 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13037 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13042 */     // GIR_Coverage, 5433,
     /*  13042 */     GIR_EraseRootFromParent_Done,
     /*  13043 */   // Label 273: @13043
     /*  13043 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(13179), // Rule ID 5419 //
     /*  13048 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13052 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13056 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13060 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13064 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13068 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13072 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13076 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13081 */     // MIs[1] Operand 2
     /*  13081 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13092 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13096 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13100 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13104 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13108 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  13112 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13116 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13121 */     // MIs[3] Operand 2
     /*  13121 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  13132 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  13134 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13134 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13137 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  13141 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13146 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  13150 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  13154 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13161 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13168 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13173 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13178 */     // GIR_Coverage, 5419,
     /*  13178 */     GIR_EraseRootFromParent_Done,
     /*  13179 */   // Label 274: @13179
     /*  13179 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(13315), // Rule ID 5418 //
     /*  13184 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13188 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13192 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13196 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13200 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13204 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13208 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13212 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13217 */     // MIs[1] Operand 2
     /*  13217 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13228 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13232 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13236 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13240 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13244 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13248 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13252 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13257 */     // MIs[3] Operand 2
     /*  13257 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  13268 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  13270 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13270 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13273 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  13277 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13282 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  13286 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  13290 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13292 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13295 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13297 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13304 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13309 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13314 */     // GIR_Coverage, 5418,
     /*  13314 */     GIR_EraseRootFromParent_Done,
     /*  13315 */   // Label 275: @13315
     /*  13315 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(13478), // Rule ID 14216 //
     /*  13320 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13324 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13328 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13332 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13336 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13340 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*  13344 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13348 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  13352 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13357 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13362 */     // MIs[1] Operand 2
     /*  13362 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13373 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13377 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13379 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (SMLALv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13379 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  13382 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13386 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13391 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13393 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  13396 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13400 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13405 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13408 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*  13412 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  13415 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13420 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13425 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13430 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13433 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
     /*  13437 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13442 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13445 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  13449 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  13453 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13455 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13458 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13460 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13467 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13472 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13477 */     // GIR_Coverage, 14216,
     /*  13477 */     GIR_EraseRootFromParent_Done,
     /*  13478 */   // Label 276: @13478
     /*  13478 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(13641), // Rule ID 14213 //
     /*  13483 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13487 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13491 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13495 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13499 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13503 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*  13507 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13511 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  13515 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13520 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13525 */     // MIs[1] Operand 2
     /*  13525 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13536 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13540 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13542 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UMLALv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13542 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  13545 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13549 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13554 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13556 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  13559 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13563 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13568 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13571 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*  13575 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  13578 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13583 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13588 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13593 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13596 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
     /*  13600 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13605 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13608 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  13612 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  13616 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13618 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13621 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13623 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13630 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13635 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13640 */     // GIR_Coverage, 14213,
     /*  13640 */     GIR_EraseRootFromParent_Done,
     /*  13641 */   // Label 277: @13641
     /*  13641 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(13791), // Rule ID 14221 //
     /*  13646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13650 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13654 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13658 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13662 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13666 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  13670 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13674 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13679 */     // MIs[1] Operand 2
     /*  13679 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13690 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13694 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13696 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13696 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  13699 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13703 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13708 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13710 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  13713 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13717 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13722 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13725 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  13729 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  13732 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13737 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13742 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13747 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13750 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  13754 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13759 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13762 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  13766 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13768 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13771 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13773 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13780 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13785 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13790 */     // GIR_Coverage, 14221,
     /*  13790 */     GIR_EraseRootFromParent_Done,
     /*  13791 */   // Label 278: @13791
     /*  13791 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(13941), // Rule ID 14225 //
     /*  13796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13812 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13816 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  13820 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13824 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13829 */     // MIs[1] Operand 2
     /*  13829 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13840 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13844 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13846 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (SADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13846 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  13849 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13853 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13858 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13860 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  13863 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13867 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13872 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13875 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  13879 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  13882 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13887 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13892 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13897 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13900 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
     /*  13904 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13909 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13912 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  13916 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13918 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13921 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13923 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  13930 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13935 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  13940 */     // GIR_Coverage, 14225,
     /*  13940 */     GIR_EraseRootFromParent_Done,
     /*  13941 */   // Label 279: @13941
     /*  13941 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(14091), // Rule ID 14220 //
     /*  13946 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13950 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13954 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  13958 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13962 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13966 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13970 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  13974 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13979 */     // MIs[1] Operand 2
     /*  13979 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  13990 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  13994 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13996 */     // (add:{ *:[v2i32] } (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  13996 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  13999 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14003 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14008 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14010 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14013 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14017 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14022 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14025 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  14029 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14032 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14037 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14042 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14047 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14050 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  14054 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14059 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14062 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14066 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14073 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14080 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14085 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14090 */     // GIR_Coverage, 14220,
     /*  14090 */     GIR_EraseRootFromParent_Done,
     /*  14091 */   // Label 280: @14091
     /*  14091 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(14254), // Rule ID 5406 //
     /*  14096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14100 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  14112 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14116 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14120 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*  14124 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14128 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  14132 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14137 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14142 */     // MIs[1] Operand 2
     /*  14142 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  14153 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14155 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Ra, (extract_subvector:{ *:[v2i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (SMLALv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  14155 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  14158 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14162 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14167 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14169 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14172 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14176 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14181 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14184 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*  14188 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14191 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14196 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14201 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14206 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14209 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
     /*  14213 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14218 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14221 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  14225 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  14229 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14231 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14234 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14236 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14243 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14248 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14253 */     // GIR_Coverage, 5406,
     /*  14253 */     GIR_EraseRootFromParent_Done,
     /*  14254 */   // Label 281: @14254
     /*  14254 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(14417), // Rule ID 5403 //
     /*  14259 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14263 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14267 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14271 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  14275 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14279 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14283 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*  14287 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14291 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  14295 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14300 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14305 */     // MIs[1] Operand 2
     /*  14305 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  14316 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14318 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Ra, (extract_subvector:{ *:[v2i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UMLALv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  14318 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  14321 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14325 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14330 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14332 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14335 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14339 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14344 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14347 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*  14351 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14354 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14359 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14364 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14369 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14372 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
     /*  14376 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14381 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14384 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  14388 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  14392 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14394 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14397 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14399 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14406 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14411 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14416 */     // GIR_Coverage, 5403,
     /*  14416 */     GIR_EraseRootFromParent_Done,
     /*  14417 */   // Label 282: @14417
     /*  14417 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(14567), // Rule ID 5429 //
     /*  14422 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14426 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14430 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14434 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  14438 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14442 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14446 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  14450 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14454 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14459 */     // MIs[1] Operand 2
     /*  14459 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  14470 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14472 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  14472 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  14475 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14479 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14484 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14486 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14489 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14493 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14498 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14501 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  14505 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14508 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14513 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14518 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14523 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14526 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  14530 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14535 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14538 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14542 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14549 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14556 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14561 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14566 */     // GIR_Coverage, 5429,
     /*  14566 */     GIR_EraseRootFromParent_Done,
     /*  14567 */   // Label 283: @14567
     /*  14567 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(14717), // Rule ID 5436 //
     /*  14572 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14576 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14580 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14584 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  14588 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14592 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14596 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  14600 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14604 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14609 */     // MIs[1] Operand 2
     /*  14609 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  14620 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14622 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (SADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  14622 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  14625 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14629 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14634 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14636 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14639 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14643 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14648 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14651 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  14655 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14658 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14663 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14668 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14673 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14676 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
     /*  14680 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14685 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14688 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14692 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14699 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14706 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14711 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14716 */     // GIR_Coverage, 5436,
     /*  14716 */     GIR_EraseRootFromParent_Done,
     /*  14717 */   // Label 284: @14717
     /*  14717 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(14867), // Rule ID 5428 //
     /*  14722 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14726 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14730 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14734 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  14738 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14742 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14746 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  14750 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14754 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14759 */     // MIs[1] Operand 2
     /*  14759 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  14770 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14772 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v2i32] } (UADDWv4i16_v4i32:{ *:[v4i32] } (INSERT_SUBREG:{ *:[v4i32] } (IMPLICIT_DEF:{ *:[v4i32] }), V64:{ *:[v2i32] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v4i16] }:$Rm), dsub:{ *:[i32] })
     /*  14772 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v4s32,
     /*  14775 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14779 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14784 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  14786 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v4s32,
     /*  14789 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  14793 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14798 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  14801 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  14805 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  14808 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14813 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14818 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14823 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14826 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  14830 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14835 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14838 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14842 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14844 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14847 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14849 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  14856 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14861 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  14866 */     // GIR_Coverage, 5428,
     /*  14866 */     GIR_EraseRootFromParent_Done,
     /*  14867 */   // Label 285: @14867
     /*  14867 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(14936), // Rule ID 13650 //
     /*  14872 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14875 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14879 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14883 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  14887 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  14890 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  14895 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  14899 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  14903 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14908 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14913 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14917 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14919 */     // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  14919 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv2i32),
     /*  14922 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14924 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  14926 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  14930 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  14934 */     GIR_RootConstrainSelectedInstOperands,
     /*  14935 */     // GIR_Coverage, 13650,
     /*  14935 */     GIR_EraseRootFromParent_Done,
     /*  14936 */   // Label 286: @14936
     /*  14936 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(15005), // Rule ID 13662 //
     /*  14941 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14948 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14952 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  14956 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  14959 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  14964 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  14968 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  14972 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14977 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14982 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  14986 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14988 */     // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V64:{ *:[v2i32] }:$Rd)  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  14988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv2i32),
     /*  14991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14993 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  14995 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  14999 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  15003 */     GIR_RootConstrainSelectedInstOperands,
     /*  15004 */     // GIR_Coverage, 13662,
     /*  15004 */     GIR_EraseRootFromParent_Done,
     /*  15005 */   // Label 287: @15005
     /*  15005 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(15061), // Rule ID 13612 //
     /*  15010 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15017 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15021 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15025 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  15028 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  15033 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  15037 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15042 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15046 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15048 */     // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 670:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
     /*  15051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15053 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15055 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15059 */     GIR_RootConstrainSelectedInstOperands,
     /*  15060 */     // GIR_Coverage, 13612,
     /*  15060 */     GIR_EraseRootFromParent_Done,
     /*  15061 */   // Label 288: @15061
     /*  15061 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(15117), // Rule ID 13624 //
     /*  15066 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15069 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15073 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15077 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15081 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  15084 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  15089 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  15093 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15098 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15102 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15104 */     // (add:{ *:[v2i32] } (intrinsic_wo_chain:{ *:[v2i32] } 735:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15104 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
     /*  15107 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15109 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15115 */     GIR_RootConstrainSelectedInstOperands,
     /*  15116 */     // GIR_Coverage, 13624,
     /*  15116 */     GIR_EraseRootFromParent_Done,
     /*  15117 */   // Label 289: @15117
     /*  15117 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(15184), // Rule ID 13864 //
     /*  15122 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15125 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15129 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15133 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  15137 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  15141 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15146 */     // MIs[1] imm
     /*  15146 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15150 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15154 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  15158 */     // MIs[2] Operand 1
     /*  15158 */     // No operand predicates
     /*  15158 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15162 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  15166 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15168 */     // (add:{ *:[v2i32] } (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  15168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
     /*  15171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15173 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15175 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15179 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  15182 */     GIR_RootConstrainSelectedInstOperands,
     /*  15183 */     // GIR_Coverage, 13864,
     /*  15183 */     GIR_EraseRootFromParent_Done,
     /*  15184 */   // Label 290: @15184
     /*  15184 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(15251), // Rule ID 13885 //
     /*  15189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15192 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15196 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15200 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  15204 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  15208 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15213 */     // MIs[1] imm
     /*  15213 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15217 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15221 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  15225 */     // MIs[2] Operand 1
     /*  15225 */     // No operand predicates
     /*  15225 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15229 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  15233 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15235 */     // (add:{ *:[v2i32] } (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V64:{ *:[v2i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  15235 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
     /*  15238 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15240 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15246 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  15249 */     GIR_RootConstrainSelectedInstOperands,
     /*  15250 */     // GIR_Coverage, 13885,
     /*  15250 */     GIR_EraseRootFromParent_Done,
     /*  15251 */   // Label 291: @15251
     /*  15251 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(15320), // Rule ID 1369 //
     /*  15256 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15259 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15263 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15267 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15271 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15275 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  15278 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  15283 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  15287 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  15291 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15296 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15301 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15303 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  15303 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv2i32),
     /*  15306 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15308 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15310 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  15318 */     GIR_RootConstrainSelectedInstOperands,
     /*  15319 */     // GIR_Coverage, 1369,
     /*  15319 */     GIR_EraseRootFromParent_Done,
     /*  15320 */   // Label 292: @15320
     /*  15320 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(15389), // Rule ID 1492 //
     /*  15325 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15328 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15332 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15336 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15340 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15344 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  15347 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  15352 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  15356 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  15360 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15365 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15370 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15372 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UABAv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  15372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv2i32),
     /*  15375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15377 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15379 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15383 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  15387 */     GIR_RootConstrainSelectedInstOperands,
     /*  15388 */     // GIR_Coverage, 1492,
     /*  15388 */     GIR_EraseRootFromParent_Done,
     /*  15389 */   // Label 293: @15389
     /*  15389 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(15445), // Rule ID 997 //
     /*  15394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15401 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15405 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15409 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15413 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  15416 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  15421 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  15425 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15430 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15432 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 670:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
     /*  15435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15437 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15439 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15443 */     GIR_RootConstrainSelectedInstOperands,
     /*  15444 */     // GIR_Coverage, 997,
     /*  15444 */     GIR_EraseRootFromParent_Done,
     /*  15445 */   // Label 294: @15445
     /*  15445 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(15501), // Rule ID 1058 //
     /*  15450 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15453 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15457 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15461 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15465 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  15469 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  15472 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  15477 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  15481 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15486 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15488 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (intrinsic_wo_chain:{ *:[v2i32] } 735:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
     /*  15491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15493 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  15499 */     GIR_RootConstrainSelectedInstOperands,
     /*  15500 */     // GIR_Coverage, 1058,
     /*  15500 */     GIR_EraseRootFromParent_Done,
     /*  15501 */   // Label 295: @15501
     /*  15501 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(15568), // Rule ID 2242 //
     /*  15506 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15509 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15513 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15517 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15521 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  15525 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  15529 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15534 */     // MIs[1] imm
     /*  15534 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15538 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15542 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  15546 */     // MIs[2] Operand 1
     /*  15546 */     // No operand predicates
     /*  15546 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  15550 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15552 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vashr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  15552 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i32_shift),
     /*  15555 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15557 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15559 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15563 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  15566 */     GIR_RootConstrainSelectedInstOperands,
     /*  15567 */     // GIR_Coverage, 2242,
     /*  15567 */     GIR_EraseRootFromParent_Done,
     /*  15568 */   // Label 296: @15568
     /*  15568 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(15635), // Rule ID 2301 //
     /*  15573 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15576 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15580 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15584 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15588 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  15592 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  15596 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15601 */     // MIs[1] imm
     /*  15601 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15605 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15609 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  15613 */     // MIs[2] Operand 1
     /*  15613 */     // No operand predicates
     /*  15613 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  15617 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15619 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64vlshr:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i32_shift:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v2i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  15619 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i32_shift),
     /*  15622 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15624 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15630 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  15633 */     GIR_RootConstrainSelectedInstOperands,
     /*  15634 */     // GIR_Coverage, 2301,
     /*  15634 */     GIR_EraseRootFromParent_Done,
     /*  15635 */   // Label 297: @15635
     /*  15635 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(15683), // Rule ID 13611 //
     /*  15640 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15643 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15647 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15651 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  15655 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  15659 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15668 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15670 */     // (add:{ *:[v2i32] } (AArch64saddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15670 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
     /*  15673 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15675 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15677 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15681 */     GIR_RootConstrainSelectedInstOperands,
     /*  15682 */     // GIR_Coverage, 13611,
     /*  15682 */     GIR_EraseRootFromParent_Done,
     /*  15683 */   // Label 298: @15683
     /*  15683 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(15731), // Rule ID 13623 //
     /*  15688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15695 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15699 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  15703 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  15707 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15712 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15716 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15718 */     // (add:{ *:[v2i32] } (AArch64uaddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn), V64:{ *:[v2i32] }:$Rd)  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
     /*  15721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15723 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15725 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15729 */     GIR_RootConstrainSelectedInstOperands,
     /*  15730 */     // GIR_Coverage, 13623,
     /*  15730 */     GIR_EraseRootFromParent_Done,
     /*  15731 */   // Label 299: @15731
     /*  15731 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(15779), // Rule ID 996 //
     /*  15736 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15739 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15743 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15747 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15751 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  15755 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  15759 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15764 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15766 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64saddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn))  =>  (SADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15766 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i16_v2i32),
     /*  15769 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15771 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15773 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15777 */     GIR_RootConstrainSelectedInstOperands,
     /*  15778 */     // GIR_Coverage, 996,
     /*  15778 */     GIR_EraseRootFromParent_Done,
     /*  15779 */   // Label 300: @15779
     /*  15779 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(15827), // Rule ID 1057 //
     /*  15784 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15787 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15791 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15795 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15799 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  15803 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  15807 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15812 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15814 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, (AArch64uaddlp_n:{ *:[v2i32] } V64:{ *:[v4i16] }:$Rn))  =>  (UADALPv4i16_v2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rd, V64:{ *:[v4i16] }:$Rn)
     /*  15814 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i16_v2i32),
     /*  15817 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15819 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  15821 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  15825 */     GIR_RootConstrainSelectedInstOperands,
     /*  15826 */     // GIR_Coverage, 1057,
     /*  15826 */     GIR_EraseRootFromParent_Done,
     /*  15827 */   // Label 301: @15827
     /*  15827 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(15854), // Rule ID 1108 //
     /*  15832 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15835 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15839 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15843 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  15847 */     // (add:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)  =>  (ADDv2i32:{ *:[v2i32] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  15847 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv2i32),
     /*  15852 */     GIR_RootConstrainSelectedInstOperands,
     /*  15853 */     // GIR_Coverage, 1108,
     /*  15853 */     GIR_Done,
     /*  15854 */   // Label 302: @15854
     /*  15854 */   GIM_Reject,
     /*  15855 */ // Label 268: @15855
     /*  15855 */ GIM_Reject,
     /*  15856 */ // Label 159: @15856
     /*  15856 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(21757),
     /*  15861 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  15864 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  15867 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(15985), // Rule ID 13793 //
     /*  15872 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15875 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  15879 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15883 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  15887 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  15891 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  15895 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15899 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  15903 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15907 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  15911 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  15915 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15919 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  15923 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  15928 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  15932 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15936 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  15940 */     // MIs[4] Operand 1
     /*  15940 */     // No operand predicates
     /*  15940 */     // MIs[2] Operand 2
     /*  15940 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  15951 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  15955 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  15957 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  15964 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] })), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  15964 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_indexed),
     /*  15967 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15969 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  15971 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  15976 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  15980 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  15983 */     GIR_RootConstrainSelectedInstOperands,
     /*  15984 */     // GIR_Coverage, 13793,
     /*  15984 */     GIR_EraseRootFromParent_Done,
     /*  15985 */   // Label 304: @15985
     /*  15985 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(16103), // Rule ID 13794 //
     /*  15990 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15993 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  15997 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16001 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  16005 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16009 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16013 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16017 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16021 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16025 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16029 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16033 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16037 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16041 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16046 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16050 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16054 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16058 */     // MIs[4] Operand 1
     /*  16058 */     // No operand predicates
     /*  16058 */     // MIs[2] Operand 2
     /*  16058 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16069 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16073 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16075 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16082 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] }), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16082 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_indexed),
     /*  16085 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16087 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  16089 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16098 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16101 */     GIR_RootConstrainSelectedInstOperands,
     /*  16102 */     // GIR_Coverage, 13794,
     /*  16102 */     GIR_EraseRootFromParent_Done,
     /*  16103 */   // Label 305: @16103
     /*  16103 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(16221), // Rule ID 13829 //
     /*  16108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16111 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16115 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16119 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  16123 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16127 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16131 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16135 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16139 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16143 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16147 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16151 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16155 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16159 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16164 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16168 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16172 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16176 */     // MIs[4] Operand 1
     /*  16176 */     // No operand predicates
     /*  16176 */     // MIs[2] Operand 2
     /*  16176 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16187 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16191 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16193 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16200 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] })), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_indexed),
     /*  16203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16205 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  16207 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16212 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16216 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16219 */     GIR_RootConstrainSelectedInstOperands,
     /*  16220 */     // GIR_Coverage, 13829,
     /*  16220 */     GIR_EraseRootFromParent_Done,
     /*  16221 */   // Label 306: @16221
     /*  16221 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(16339), // Rule ID 13830 //
     /*  16226 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16229 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16233 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16237 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  16241 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16245 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16249 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16253 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16257 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16261 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16265 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16269 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16273 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16277 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16282 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16286 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16290 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16294 */     // MIs[4] Operand 1
     /*  16294 */     // No operand predicates
     /*  16294 */     // MIs[2] Operand 2
     /*  16294 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16305 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16309 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16311 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16318 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] }), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_indexed),
     /*  16321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16323 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  16325 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16330 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16334 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16337 */     GIR_RootConstrainSelectedInstOperands,
     /*  16338 */     // GIR_Coverage, 13830,
     /*  16338 */     GIR_EraseRootFromParent_Done,
     /*  16339 */   // Label 307: @16339
     /*  16339 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(16457), // Rule ID 2046 //
     /*  16344 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16347 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16351 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16355 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16359 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  16363 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16367 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16371 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16375 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16379 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16383 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16387 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16391 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16395 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16399 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16404 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16408 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16412 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16416 */     // MIs[4] Operand 1
     /*  16416 */     // No operand predicates
     /*  16416 */     // MIs[2] Operand 2
     /*  16416 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16427 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16429 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16436 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] })))  =>  (SMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16436 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_indexed),
     /*  16439 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16441 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  16443 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16448 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16452 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16455 */     GIR_RootConstrainSelectedInstOperands,
     /*  16456 */     // GIR_Coverage, 2046,
     /*  16456 */     GIR_EraseRootFromParent_Done,
     /*  16457 */   // Label 308: @16457
     /*  16457 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(16575), // Rule ID 13792 //
     /*  16462 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16465 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16469 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16473 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16477 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  16481 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16485 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16489 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16493 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16497 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16501 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16505 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16509 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16513 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16517 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16522 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16526 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16530 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16534 */     // MIs[4] Operand 1
     /*  16534 */     // No operand predicates
     /*  16534 */     // MIs[2] Operand 2
     /*  16534 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16545 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16547 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16554 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] }), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)))  =>  (SMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16554 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_indexed),
     /*  16557 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16559 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  16561 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16566 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16570 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16573 */     GIR_RootConstrainSelectedInstOperands,
     /*  16574 */     // GIR_Coverage, 13792,
     /*  16574 */     GIR_EraseRootFromParent_Done,
     /*  16575 */   // Label 309: @16575
     /*  16575 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(16693), // Rule ID 2098 //
     /*  16580 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16583 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16587 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16591 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16595 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  16599 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16603 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16607 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16611 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16615 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16619 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16623 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16627 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16631 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16635 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16640 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16644 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16648 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16652 */     // MIs[4] Operand 1
     /*  16652 */     // No operand predicates
     /*  16652 */     // MIs[2] Operand 2
     /*  16652 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16663 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16665 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16672 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] })))  =>  (UMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16672 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_indexed),
     /*  16675 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16677 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  16679 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16684 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16688 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16691 */     GIR_RootConstrainSelectedInstOperands,
     /*  16692 */     // GIR_Coverage, 2098,
     /*  16692 */     GIR_EraseRootFromParent_Done,
     /*  16693 */   // Label 310: @16693
     /*  16693 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(16811), // Rule ID 13828 //
     /*  16698 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16701 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16705 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16709 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16713 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  16717 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16721 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16725 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16729 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  16733 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16737 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  16741 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  16745 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16749 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  16753 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16758 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  16762 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16766 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  16770 */     // MIs[4] Operand 1
     /*  16770 */     // No operand predicates
     /*  16770 */     // MIs[2] Operand 2
     /*  16770 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(2),
     /*  16781 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  16783 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16790 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 2:{ *:[i64] }), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)))  =>  (UMLALv4i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  16790 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_indexed),
     /*  16793 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16795 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  16797 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  16806 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  16809 */     GIR_RootConstrainSelectedInstOperands,
     /*  16810 */     // GIR_Coverage, 13828,
     /*  16810 */     GIR_EraseRootFromParent_Done,
     /*  16811 */   // Label 311: @16811
     /*  16811 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(16898), // Rule ID 13694 //
     /*  16816 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16819 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16823 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16827 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  16831 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16835 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16839 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16843 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  16846 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  16851 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16855 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  16859 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16863 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16865 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16872 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16879 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  16879 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i32_v2i64),
     /*  16882 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16884 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  16886 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16891 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  16896 */     GIR_RootConstrainSelectedInstOperands,
     /*  16897 */     // GIR_Coverage, 13694,
     /*  16897 */     GIR_EraseRootFromParent_Done,
     /*  16898 */   // Label 312: @16898
     /*  16898 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(16985), // Rule ID 13722 //
     /*  16903 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16910 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16914 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  16918 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  16922 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16926 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16930 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  16933 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  16938 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  16942 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  16946 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16950 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16952 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16959 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  16966 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  16966 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i32_v2i64),
     /*  16969 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16971 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  16973 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  16978 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  16983 */     GIR_RootConstrainSelectedInstOperands,
     /*  16984 */     // GIR_Coverage, 13722,
     /*  16984 */     GIR_EraseRootFromParent_Done,
     /*  16985 */   // Label 313: @16985
     /*  16985 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(17072), // Rule ID 1703 //
     /*  16990 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  16993 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  16997 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17001 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17005 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17009 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17013 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  17017 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17021 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  17024 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  17029 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17033 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  17037 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17039 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17046 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17053 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))))  =>  (SABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17053 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i32_v2i64),
     /*  17056 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17058 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  17060 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17065 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17070 */     GIR_RootConstrainSelectedInstOperands,
     /*  17071 */     // GIR_Coverage, 1703,
     /*  17071 */     GIR_EraseRootFromParent_Done,
     /*  17072 */   // Label 314: @17072
     /*  17072 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(17159), // Rule ID 1781 //
     /*  17077 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17080 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17084 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17088 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17092 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17096 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17100 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  17104 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17108 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  17111 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  17116 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17120 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  17124 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17126 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17133 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17140 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm))))  =>  (UABALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17140 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i32_v2i64),
     /*  17143 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17145 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  17147 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17152 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17157 */     GIR_RootConstrainSelectedInstOperands,
     /*  17158 */     // GIR_Coverage, 1781,
     /*  17158 */     GIR_EraseRootFromParent_Done,
     /*  17159 */   // Label 315: @17159
     /*  17159 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(17274), // Rule ID 13788 //
     /*  17164 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17167 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17171 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17175 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  17179 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17183 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17187 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  17191 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  17195 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17199 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  17203 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  17207 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17211 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  17215 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17220 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  17224 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17228 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  17232 */     // MIs[4] Operand 1
     /*  17232 */     // No operand predicates
     /*  17232 */     // MIs[2] Operand 2
     /*  17232 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  17243 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  17248 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17252 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  17254 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  17254 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  17257 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17259 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  17261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  17265 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  17269 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  17272 */     GIR_RootConstrainSelectedInstOperands,
     /*  17273 */     // GIR_Coverage, 13788,
     /*  17273 */     GIR_EraseRootFromParent_Done,
     /*  17274 */   // Label 316: @17274
     /*  17274 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(17389), // Rule ID 13787 //
     /*  17279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17286 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17290 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  17294 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17298 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17302 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  17307 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17311 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  17315 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17319 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  17323 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  17327 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17331 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  17335 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17340 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  17344 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17348 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  17352 */     // MIs[4] Operand 1
     /*  17352 */     // No operand predicates
     /*  17352 */     // MIs[2] Operand 2
     /*  17352 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  17363 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17367 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  17369 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] })), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  17369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  17372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17374 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  17376 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  17380 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  17384 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  17387 */     GIR_RootConstrainSelectedInstOperands,
     /*  17388 */     // GIR_Coverage, 13787,
     /*  17388 */     GIR_EraseRootFromParent_Done,
     /*  17389 */   // Label 317: @17389
     /*  17389 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(17504), // Rule ID 13824 //
     /*  17394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  17409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17413 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17417 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  17421 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  17425 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17429 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  17433 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  17437 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17441 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  17445 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17450 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  17454 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17458 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  17462 */     // MIs[4] Operand 1
     /*  17462 */     // No operand predicates
     /*  17462 */     // MIs[2] Operand 2
     /*  17462 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  17473 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  17478 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17482 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  17484 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  17484 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  17487 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17489 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  17491 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  17495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  17499 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  17502 */     GIR_RootConstrainSelectedInstOperands,
     /*  17503 */     // GIR_Coverage, 13824,
     /*  17503 */     GIR_EraseRootFromParent_Done,
     /*  17504 */   // Label 318: @17504
     /*  17504 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(17619), // Rule ID 13823 //
     /*  17509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17512 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  17524 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17528 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17532 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  17537 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17541 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  17545 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17549 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  17553 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  17557 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17561 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  17565 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17570 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  17574 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17578 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  17582 */     // MIs[4] Operand 1
     /*  17582 */     // No operand predicates
     /*  17582 */     // MIs[2] Operand 2
     /*  17582 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  17593 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17597 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  17599 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] })), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  17599 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  17602 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17604 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  17606 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  17610 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  17614 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  17617 */     GIR_RootConstrainSelectedInstOperands,
     /*  17618 */     // GIR_Coverage, 13823,
     /*  17618 */     GIR_EraseRootFromParent_Done,
     /*  17619 */   // Label 319: @17619
     /*  17619 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(17688), // Rule ID 1805 //
     /*  17624 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17627 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17631 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17635 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  17639 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17643 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17647 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  17651 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17655 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17657 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17664 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17671 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17671 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
     /*  17674 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17676 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17681 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17686 */     GIR_RootConstrainSelectedInstOperands,
     /*  17687 */     // GIR_Coverage, 1805,
     /*  17687 */     GIR_EraseRootFromParent_Done,
     /*  17688 */   // Label 320: @17688
     /*  17688 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(17757), // Rule ID 1804 //
     /*  17693 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17696 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17700 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17704 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  17708 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17712 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17716 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17720 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17724 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17726 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17733 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17740 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17740 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
     /*  17743 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17745 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17750 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17755 */     GIR_RootConstrainSelectedInstOperands,
     /*  17756 */     // GIR_Coverage, 1804,
     /*  17756 */     GIR_EraseRootFromParent_Done,
     /*  17757 */   // Label 321: @17757
     /*  17757 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(17826), // Rule ID 1721 //
     /*  17762 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17765 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17769 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17773 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  17777 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17781 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17785 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  17789 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17793 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17795 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17802 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17809 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17809 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv4i32_v2i64),
     /*  17812 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17814 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17819 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17824 */     GIR_RootConstrainSelectedInstOperands,
     /*  17825 */     // GIR_Coverage, 1721,
     /*  17825 */     GIR_EraseRootFromParent_Done,
     /*  17826 */   // Label 322: @17826
     /*  17826 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(17895), // Rule ID 1803 //
     /*  17831 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17834 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17838 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17842 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17846 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17850 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17854 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  17858 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17862 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17864 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17871 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17878 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17878 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
     /*  17881 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17883 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17888 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17893 */     GIR_RootConstrainSelectedInstOperands,
     /*  17894 */     // GIR_Coverage, 1803,
     /*  17894 */     GIR_EraseRootFromParent_Done,
     /*  17895 */   // Label 323: @17895
     /*  17895 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(17964), // Rule ID 1802 //
     /*  17900 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17903 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17907 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17911 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17915 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17919 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17923 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  17927 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17931 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17933 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17940 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  17947 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn)), (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDLv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  17947 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i32_v2i64),
     /*  17950 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17952 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  17957 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  17962 */     GIR_RootConstrainSelectedInstOperands,
     /*  17963 */     // GIR_Coverage, 1802,
     /*  17963 */     GIR_EraseRootFromParent_Done,
     /*  17964 */   // Label 324: @17964
     /*  17964 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(18079), // Rule ID 13786 //
     /*  17969 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17972 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17976 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  17980 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17984 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  17988 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17992 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17996 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18000 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  18004 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18008 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  18012 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  18016 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18020 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  18024 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18029 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  18033 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  18037 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  18041 */     // MIs[4] Operand 1
     /*  18041 */     // No operand predicates
     /*  18041 */     // MIs[2] Operand 2
     /*  18041 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  18052 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18057 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  18059 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  18059 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  18062 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18064 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18066 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  18070 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  18074 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  18077 */     GIR_RootConstrainSelectedInstOperands,
     /*  18078 */     // GIR_Coverage, 13786,
     /*  18078 */     GIR_EraseRootFromParent_Done,
     /*  18079 */   // Label 325: @18079
     /*  18079 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(18194), // Rule ID 2044 //
     /*  18084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18087 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18091 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18095 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18099 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  18103 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18107 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18111 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18116 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18120 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  18124 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18128 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  18132 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  18136 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18140 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  18144 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18149 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  18153 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  18157 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  18161 */     // MIs[4] Operand 1
     /*  18161 */     // No operand predicates
     /*  18161 */     // MIs[2] Operand 2
     /*  18161 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  18172 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  18174 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] })))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  18174 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  18177 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18179 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18181 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  18185 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  18189 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  18192 */     GIR_RootConstrainSelectedInstOperands,
     /*  18193 */     // GIR_Coverage, 2044,
     /*  18193 */     GIR_EraseRootFromParent_Done,
     /*  18194 */   // Label 326: @18194
     /*  18194 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(18309), // Rule ID 13822 //
     /*  18199 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18202 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18206 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18210 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18214 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  18218 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18222 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18226 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18230 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  18234 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18238 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  18242 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  18246 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18250 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  18254 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18259 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  18263 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  18267 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  18271 */     // MIs[4] Operand 1
     /*  18271 */     // No operand predicates
     /*  18271 */     // MIs[2] Operand 2
     /*  18271 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  18282 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18287 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  18289 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] }), V64:{ *:[v2i32] }:$Rn))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  18289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  18292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18294 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18296 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  18300 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  18304 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  18307 */     GIR_RootConstrainSelectedInstOperands,
     /*  18308 */     // GIR_Coverage, 13822,
     /*  18308 */     GIR_EraseRootFromParent_Done,
     /*  18309 */   // Label 327: @18309
     /*  18309 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(18424), // Rule ID 2096 //
     /*  18314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18317 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18321 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18325 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18329 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  18333 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18337 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18341 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18346 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18350 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  18354 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18358 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  18362 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  18366 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18370 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  18374 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18379 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  18383 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  18387 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  18391 */     // MIs[4] Operand 1
     /*  18391 */     // No operand predicates
     /*  18391 */     // MIs[2] Operand 2
     /*  18391 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  18402 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  18404 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (extract_subvector:{ *:[v2i32] } (AArch64duplane32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), 0:{ *:[i64] })))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  18404 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  18407 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18409 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18411 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  18415 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  18419 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  18422 */     GIR_RootConstrainSelectedInstOperands,
     /*  18423 */     // GIR_Coverage, 2096,
     /*  18423 */     GIR_EraseRootFromParent_Done,
     /*  18424 */   // Label 328: @18424
     /*  18424 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(18491), // Rule ID 13706 //
     /*  18429 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18432 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18436 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18440 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  18444 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18448 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18452 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18456 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18458 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18465 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18472 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  18472 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_v2i64),
     /*  18475 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18477 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  18479 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  18484 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  18489 */     GIR_RootConstrainSelectedInstOperands,
     /*  18490 */     // GIR_Coverage, 13706,
     /*  18490 */     GIR_EraseRootFromParent_Done,
     /*  18491 */   // Label 329: @18491
     /*  18491 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(18558), // Rule ID 13740 //
     /*  18496 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18499 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18503 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18507 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  18511 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18515 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18519 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18523 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18525 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18532 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18539 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  18539 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_v2i64),
     /*  18542 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18544 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  18546 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  18551 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  18556 */     GIR_RootConstrainSelectedInstOperands,
     /*  18557 */     // GIR_Coverage, 13740,
     /*  18557 */     GIR_EraseRootFromParent_Done,
     /*  18558 */   // Label 330: @18558
     /*  18558 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(18625), // Rule ID 1733 //
     /*  18563 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18566 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18570 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18574 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18578 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  18582 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18586 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18590 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18592 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18599 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18606 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  18606 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i32_v2i64),
     /*  18609 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18611 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18613 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  18618 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  18623 */     GIR_RootConstrainSelectedInstOperands,
     /*  18624 */     // GIR_Coverage, 1733,
     /*  18624 */     GIR_EraseRootFromParent_Done,
     /*  18625 */   // Label 331: @18625
     /*  18625 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(18692), // Rule ID 1823 //
     /*  18630 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18633 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18637 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18641 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18645 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  18649 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18653 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18657 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18659 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18666 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  18673 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rn), (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UMLALv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  18673 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i32_v2i64),
     /*  18676 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18678 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18680 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  18685 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  18690 */     GIR_RootConstrainSelectedInstOperands,
     /*  18691 */     // GIR_Coverage, 1823,
     /*  18691 */     GIR_EraseRootFromParent_Done,
     /*  18692 */   // Label 332: @18692
     /*  18692 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(18773), // Rule ID 13692 //
     /*  18697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18700 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18704 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18708 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  18712 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18716 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18720 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18724 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  18727 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  18732 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18736 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  18740 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18745 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18750 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18754 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18756 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  18756 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv2i32_v2i64),
     /*  18759 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18761 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  18763 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  18767 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  18771 */     GIR_RootConstrainSelectedInstOperands,
     /*  18772 */     // GIR_Coverage, 13692,
     /*  18772 */     GIR_EraseRootFromParent_Done,
     /*  18773 */   // Label 333: @18773
     /*  18773 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(18854), // Rule ID 13720 //
     /*  18778 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18781 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18785 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18789 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  18793 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18797 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18801 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18805 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  18808 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  18813 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18817 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  18821 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18826 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18831 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18835 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18837 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)), V128:{ *:[v2i64] }:$Rd)  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  18837 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv2i32_v2i64),
     /*  18840 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18842 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  18844 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  18848 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  18852 */     GIR_RootConstrainSelectedInstOperands,
     /*  18853 */     // GIR_Coverage, 13720,
     /*  18853 */     GIR_EraseRootFromParent_Done,
     /*  18854 */   // Label 334: @18854
     /*  18854 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(18935), // Rule ID 1701 //
     /*  18859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18862 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18866 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18870 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18874 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  18878 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18882 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18886 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18890 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  18893 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  18898 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18902 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  18906 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18911 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18916 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18918 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 669:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (SABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  18918 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv2i32_v2i64),
     /*  18921 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18923 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  18925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  18929 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  18933 */     GIR_RootConstrainSelectedInstOperands,
     /*  18934 */     // GIR_Coverage, 1701,
     /*  18934 */     GIR_EraseRootFromParent_Done,
     /*  18935 */   // Label 335: @18935
     /*  18935 */   GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(19016), // Rule ID 1779 //
     /*  18940 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18943 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18947 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  18951 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18955 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  18959 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  18963 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18967 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18971 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  18974 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  18979 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  18983 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v2s32,
     /*  18987 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18992 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  18997 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18999 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (zext:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i32] } 734:{ *:[iPTR] }, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)))  =>  (UABALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  18999 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv2i32_v2i64),
     /*  19002 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19004 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  19006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  19010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  19014 */     GIR_RootConstrainSelectedInstOperands,
     /*  19015 */     // GIR_Coverage, 1779,
     /*  19015 */     GIR_EraseRootFromParent_Done,
     /*  19016 */   // Label 336: @19016
     /*  19016 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(19108), // Rule ID 13791 //
     /*  19021 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19024 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19028 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19032 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  19036 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19040 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19044 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19048 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19052 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19056 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19060 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19065 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19069 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19073 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19077 */     // MIs[3] Operand 1
     /*  19077 */     // No operand predicates
     /*  19077 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19082 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19086 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19088 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19088 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  19091 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19093 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  19095 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  19099 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19103 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19106 */     GIR_RootConstrainSelectedInstOperands,
     /*  19107 */     // GIR_Coverage, 13791,
     /*  19107 */     GIR_EraseRootFromParent_Done,
     /*  19108 */   // Label 337: @19108
     /*  19108 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(19200), // Rule ID 13790 //
     /*  19113 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19116 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19120 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19124 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  19128 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19132 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19136 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19141 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19145 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19149 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19153 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19157 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19162 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19166 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19170 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19174 */     // MIs[3] Operand 1
     /*  19174 */     // No operand predicates
     /*  19174 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19178 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19180 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19180 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  19183 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19185 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  19187 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  19191 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19195 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19198 */     GIR_RootConstrainSelectedInstOperands,
     /*  19199 */     // GIR_Coverage, 13790,
     /*  19199 */     GIR_EraseRootFromParent_Done,
     /*  19200 */   // Label 338: @19200
     /*  19200 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(19292), // Rule ID 13827 //
     /*  19205 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19208 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19212 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19216 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  19220 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19224 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19228 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19232 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19236 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19240 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19244 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19249 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19253 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19257 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19261 */     // MIs[3] Operand 1
     /*  19261 */     // No operand predicates
     /*  19261 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19266 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19270 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19272 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  19275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19277 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  19279 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  19283 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19287 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19290 */     GIR_RootConstrainSelectedInstOperands,
     /*  19291 */     // GIR_Coverage, 13827,
     /*  19291 */     GIR_EraseRootFromParent_Done,
     /*  19292 */   // Label 339: @19292
     /*  19292 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(19384), // Rule ID 13826 //
     /*  19297 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19304 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19308 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  19312 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19316 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19320 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19325 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19329 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19333 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19337 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19341 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19346 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19350 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19354 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19358 */     // MIs[3] Operand 1
     /*  19358 */     // No operand predicates
     /*  19358 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19362 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19364 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19364 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  19367 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19369 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  19371 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  19375 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19379 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19382 */     GIR_RootConstrainSelectedInstOperands,
     /*  19383 */     // GIR_Coverage, 13826,
     /*  19383 */     GIR_EraseRootFromParent_Done,
     /*  19384 */   // Label 340: @19384
     /*  19384 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(19476), // Rule ID 13789 //
     /*  19389 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19392 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19396 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  19408 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19412 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19416 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19420 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19424 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19428 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19432 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19437 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19441 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19445 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19449 */     // MIs[3] Operand 1
     /*  19449 */     // No operand predicates
     /*  19449 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19454 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19456 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19456 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  19459 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19461 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  19463 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  19467 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19471 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19474 */     GIR_RootConstrainSelectedInstOperands,
     /*  19475 */     // GIR_Coverage, 13789,
     /*  19475 */     GIR_EraseRootFromParent_Done,
     /*  19476 */   // Label 341: @19476
     /*  19476 */   GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(19568), // Rule ID 2045 //
     /*  19481 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19484 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19488 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19492 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19496 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  19500 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19504 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19508 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19513 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19517 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19521 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19525 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19529 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19534 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19538 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19542 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19546 */     // MIs[3] Operand 1
     /*  19546 */     // No operand predicates
     /*  19546 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19548 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (SMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_indexed),
     /*  19551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19553 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  19555 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  19559 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19563 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19566 */     GIR_RootConstrainSelectedInstOperands,
     /*  19567 */     // GIR_Coverage, 2045,
     /*  19567 */     GIR_EraseRootFromParent_Done,
     /*  19568 */   // Label 342: @19568
     /*  19568 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(19660), // Rule ID 13825 //
     /*  19573 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19576 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19580 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19584 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19588 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  19592 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19596 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19600 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19604 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19608 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19612 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19616 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19621 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19625 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19629 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19633 */     // MIs[3] Operand 1
     /*  19633 */     // No operand predicates
     /*  19633 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19638 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19640 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx), V64:{ *:[v2i32] }:$Rn))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19640 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  19643 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19645 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  19647 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  19651 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19655 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19658 */     GIR_RootConstrainSelectedInstOperands,
     /*  19659 */     // GIR_Coverage, 13825,
     /*  19659 */     GIR_EraseRootFromParent_Done,
     /*  19660 */   // Label 343: @19660
     /*  19660 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(19752), // Rule ID 2097 //
     /*  19665 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19668 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19672 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19676 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19680 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  19684 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19688 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  19692 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  19697 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19701 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE32),
     /*  19705 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19709 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19713 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19718 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19722 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19726 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexS),
     /*  19730 */     // MIs[3] Operand 1
     /*  19730 */     // No operand predicates
     /*  19730 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  19732 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, (AArch64duplane32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexS>>:$idx)))  =>  (UMLALv2i32_indexed:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V128:{ *:[v4i32] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  19732 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_indexed),
     /*  19735 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19737 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  19739 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  19743 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19747 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  19750 */     GIR_RootConstrainSelectedInstOperands,
     /*  19751 */     // GIR_Coverage, 2097,
     /*  19751 */     GIR_EraseRootFromParent_Done,
     /*  19752 */   // Label 344: @19752
     /*  19752 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(19803), // Rule ID 13734 //
     /*  19757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19764 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19768 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  19772 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19776 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19780 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19782 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  19789 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  19789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
     /*  19792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19794 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  19796 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  19801 */     GIR_RootConstrainSelectedInstOperands,
     /*  19802 */     // GIR_Coverage, 13734,
     /*  19802 */     GIR_EraseRootFromParent_Done,
     /*  19803 */   // Label 345: @19803
     /*  19803 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(19854), // Rule ID 13700 //
     /*  19808 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19811 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19815 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19819 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  19823 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19827 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19831 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19833 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  19840 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  19840 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i32_v2i64),
     /*  19843 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19845 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  19847 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  19852 */     GIR_RootConstrainSelectedInstOperands,
     /*  19853 */     // GIR_Coverage, 13700,
     /*  19853 */     GIR_EraseRootFromParent_Done,
     /*  19854 */   // Label 346: @19854
     /*  19854 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(19905), // Rule ID 13733 //
     /*  19859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19862 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19866 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19870 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  19874 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19878 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19882 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19884 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  19891 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  19891 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
     /*  19894 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19896 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  19898 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  19903 */     GIR_RootConstrainSelectedInstOperands,
     /*  19904 */     // GIR_Coverage, 13733,
     /*  19904 */     GIR_EraseRootFromParent_Done,
     /*  19905 */   // Label 347: @19905
     /*  19905 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(19956), // Rule ID 1817 //
     /*  19910 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19913 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19917 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19921 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19925 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  19929 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19933 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19935 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  19942 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  19942 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
     /*  19945 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19947 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  19949 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  19954 */     GIR_RootConstrainSelectedInstOperands,
     /*  19955 */     // GIR_Coverage, 1817,
     /*  19955 */     GIR_EraseRootFromParent_Done,
     /*  19956 */   // Label 348: @19956
     /*  19956 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(20007), // Rule ID 1727 //
     /*  19961 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  19964 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19968 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  19972 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19976 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  19980 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  19984 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19986 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  19993 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (SADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  19993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i32_v2i64),
     /*  19996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19998 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  20000 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  20005 */     GIR_RootConstrainSelectedInstOperands,
     /*  20006 */     // GIR_Coverage, 1727,
     /*  20006 */     GIR_EraseRootFromParent_Done,
     /*  20007 */   // Label 349: @20007
     /*  20007 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(20058), // Rule ID 1816 //
     /*  20012 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20015 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20019 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20023 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20027 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  20031 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20035 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20037 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v4i32),
     /*  20044 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } (extract_high_v4i32:{ *:[v2i32] } V128:{ *:[v4i32] }:$Rm)))  =>  (UADDWv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  20044 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i32_v2i64),
     /*  20047 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20049 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  20051 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  20056 */     GIR_RootConstrainSelectedInstOperands,
     /*  20057 */     // GIR_Coverage, 1816,
     /*  20057 */     GIR_EraseRootFromParent_Done,
     /*  20058 */   // Label 350: @20058
     /*  20058 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(20114), // Rule ID 13618 //
     /*  20063 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20066 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20070 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20074 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20078 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  20081 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  20086 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20090 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20095 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20099 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20101 */     // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 670:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  20101 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
     /*  20104 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20106 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  20108 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  20112 */     GIR_RootConstrainSelectedInstOperands,
     /*  20113 */     // GIR_Coverage, 13618,
     /*  20113 */     GIR_EraseRootFromParent_Done,
     /*  20114 */   // Label 351: @20114
     /*  20114 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(20170), // Rule ID 13630 //
     /*  20119 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20122 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20126 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20130 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20134 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  20137 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  20142 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20146 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20151 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20155 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20157 */     // (add:{ *:[v2i64] } (intrinsic_wo_chain:{ *:[v2i64] } 735:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  20157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
     /*  20160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20162 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  20164 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  20168 */     GIR_RootConstrainSelectedInstOperands,
     /*  20169 */     // GIR_Coverage, 13630,
     /*  20169 */     GIR_EraseRootFromParent_Done,
     /*  20170 */   // Label 352: @20170
     /*  20170 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(20237), // Rule ID 13868 //
     /*  20175 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20178 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20182 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20186 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  20190 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20194 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20199 */     // MIs[1] imm
     /*  20199 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20203 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20207 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  20211 */     // MIs[2] Operand 1
     /*  20211 */     // No operand predicates
     /*  20211 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20215 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  20219 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20221 */     // (add:{ *:[v2i64] } (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  20221 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
     /*  20224 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20226 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  20228 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20232 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  20235 */     GIR_RootConstrainSelectedInstOperands,
     /*  20236 */     // GIR_Coverage, 13868,
     /*  20236 */     GIR_EraseRootFromParent_Done,
     /*  20237 */   // Label 353: @20237
     /*  20237 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(20304), // Rule ID 13889 //
     /*  20242 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20245 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20249 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20253 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  20257 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20261 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20266 */     // MIs[1] imm
     /*  20266 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20270 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20274 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  20278 */     // MIs[2] Operand 1
     /*  20278 */     // No operand predicates
     /*  20278 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20282 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  20286 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20288 */     // (add:{ *:[v2i64] } (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm), V128:{ *:[v2i64] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  20288 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
     /*  20291 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20293 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  20295 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20299 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  20302 */     GIR_RootConstrainSelectedInstOperands,
     /*  20303 */     // GIR_Coverage, 13889,
     /*  20303 */     GIR_EraseRootFromParent_Done,
     /*  20304 */   // Label 354: @20304
     /*  20304 */   GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(20360), // Rule ID 1003 //
     /*  20309 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20312 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20316 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20320 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20324 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20328 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  20331 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  20336 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20340 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20345 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20347 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 670:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  20347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
     /*  20350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20352 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  20354 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  20358 */     GIR_RootConstrainSelectedInstOperands,
     /*  20359 */     // GIR_Coverage, 1003,
     /*  20359 */     GIR_EraseRootFromParent_Done,
     /*  20360 */   // Label 355: @20360
     /*  20360 */   GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(20416), // Rule ID 1064 //
     /*  20365 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20368 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20372 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20376 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20380 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20384 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  20387 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  20392 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20396 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20401 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20403 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (intrinsic_wo_chain:{ *:[v2i64] } 735:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  20403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
     /*  20406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20408 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  20410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  20414 */     GIR_RootConstrainSelectedInstOperands,
     /*  20415 */     // GIR_Coverage, 1064,
     /*  20415 */     GIR_EraseRootFromParent_Done,
     /*  20416 */   // Label 356: @20416
     /*  20416 */   GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(20483), // Rule ID 2246 //
     /*  20421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20424 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20428 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20432 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20436 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  20440 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20444 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20449 */     // MIs[1] imm
     /*  20449 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20453 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20457 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  20461 */     // MIs[2] Operand 1
     /*  20461 */     // No operand predicates
     /*  20461 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  20465 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20467 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vashr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  20467 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv2i64_shift),
     /*  20470 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20472 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  20474 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20478 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  20481 */     GIR_RootConstrainSelectedInstOperands,
     /*  20482 */     // GIR_Coverage, 2246,
     /*  20482 */     GIR_EraseRootFromParent_Done,
     /*  20483 */   // Label 357: @20483
     /*  20483 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(20550), // Rule ID 2305 //
     /*  20488 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20491 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20495 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  20507 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20511 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20516 */     // MIs[1] imm
     /*  20516 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20520 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20524 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR64),
     /*  20528 */     // MIs[2] Operand 1
     /*  20528 */     // No operand predicates
     /*  20528 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  20532 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20534 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64vlshr:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR64>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv2i64_shift:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v2i64] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  20534 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv2i64_shift),
     /*  20537 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20539 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  20541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20545 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  20548 */     GIR_RootConstrainSelectedInstOperands,
     /*  20549 */     // GIR_Coverage, 2305,
     /*  20549 */     GIR_EraseRootFromParent_Done,
     /*  20550 */   // Label 358: @20550
     /*  20550 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(20620), // Rule ID 7006 //
     /*  20555 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20559 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20563 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_ZIP1),
     /*  20567 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20571 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  20575 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20580 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20585 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20589 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_ZIP2),
     /*  20593 */     // MIs[2] Rn
     /*  20593 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20598 */     // MIs[2] Rm
     /*  20598 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  20603 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20605 */     // (add:{ *:[v2i64] } (AArch64zip1:{ *:[v2i64] } FPR128:{ *:[v2i64] }:$Rn, FPR128:{ *:[v2i64] }:$Rm), (AArch64zip2:{ *:[v2i64] } FPR128:{ *:[v2i64] }:$Rn, FPR128:{ *:[v2i64] }:$Rm))  =>  (ADDPv2i64:{ *:[v2i64] } ?:{ *:[v2i64] }:$Rn, ?:{ *:[v2i64] }:$Rm)
     /*  20605 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64),
     /*  20608 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20610 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  20618 */     GIR_RootConstrainSelectedInstOperands,
     /*  20619 */     // GIR_Coverage, 7006,
     /*  20619 */     GIR_EraseRootFromParent_Done,
     /*  20620 */   // Label 359: @20620
     /*  20620 */   GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(20690), // Rule ID 14252 //
     /*  20625 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_ZIP2),
     /*  20637 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20641 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  20645 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20650 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20655 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20659 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_ZIP1),
     /*  20663 */     // MIs[2] Rn
     /*  20663 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20668 */     // MIs[2] Rm
     /*  20668 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  20673 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20675 */     // (add:{ *:[v2i64] } (AArch64zip2:{ *:[v2i64] } FPR128:{ *:[v2i64] }:$Rn, FPR128:{ *:[v2i64] }:$Rm), (AArch64zip1:{ *:[v2i64] } FPR128:{ *:[v2i64] }:$Rn, FPR128:{ *:[v2i64] }:$Rm))  =>  (ADDPv2i64:{ *:[v2i64] } ?:{ *:[v2i64] }:$Rn, ?:{ *:[v2i64] }:$Rm)
     /*  20675 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv2i64),
     /*  20678 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20680 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20684 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  20688 */     GIR_RootConstrainSelectedInstOperands,
     /*  20689 */     // GIR_Coverage, 14252,
     /*  20689 */     GIR_EraseRootFromParent_Done,
     /*  20690 */   // Label 360: @20690
     /*  20690 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(20753), // Rule ID 1801 //
     /*  20695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  20710 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20714 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20719 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20723 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  20727 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20731 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20736 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20738 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  20738 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*  20741 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20743 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20747 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20751 */     GIR_RootConstrainSelectedInstOperands,
     /*  20752 */     // GIR_Coverage, 1801,
     /*  20752 */     GIR_EraseRootFromParent_Done,
     /*  20753 */   // Label 361: @20753
     /*  20753 */   GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(20816), // Rule ID 1800 //
     /*  20758 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20761 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20765 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20769 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  20773 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20777 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20782 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20786 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  20790 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20794 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20799 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20801 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  20801 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*  20804 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20806 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20810 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20814 */     GIR_RootConstrainSelectedInstOperands,
     /*  20815 */     // GIR_Coverage, 1800,
     /*  20815 */     GIR_EraseRootFromParent_Done,
     /*  20816 */   // Label 362: @20816
     /*  20816 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(20879), // Rule ID 1720 //
     /*  20821 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20824 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20828 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20832 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  20836 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20840 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20845 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20849 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  20853 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20857 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20862 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20864 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  20864 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv2i32_v2i64),
     /*  20867 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20869 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20873 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20877 */     GIR_RootConstrainSelectedInstOperands,
     /*  20878 */     // GIR_Coverage, 1720,
     /*  20878 */     GIR_EraseRootFromParent_Done,
     /*  20879 */   // Label 363: @20879
     /*  20879 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(20942), // Rule ID 1799 //
     /*  20884 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20887 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20891 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20895 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  20899 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20903 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20908 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20912 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  20916 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20920 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20925 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20927 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  20927 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*  20930 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20940 */     GIR_RootConstrainSelectedInstOperands,
     /*  20941 */     // GIR_Coverage, 1799,
     /*  20941 */     GIR_EraseRootFromParent_Done,
     /*  20942 */   // Label 364: @20942
     /*  20942 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(21005), // Rule ID 1798 //
     /*  20947 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  20950 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  20954 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20958 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  20962 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20966 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20971 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20975 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  20979 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  20983 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  20988 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20990 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn), (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDLv2i32_v2i64:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  20990 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv2i32_v2i64),
     /*  20993 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20995 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20999 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  21003 */     GIR_RootConstrainSelectedInstOperands,
     /*  21004 */     // GIR_Coverage, 1798,
     /*  21004 */     GIR_EraseRootFromParent_Done,
     /*  21005 */   // Label 365: @21005
     /*  21005 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(21066), // Rule ID 13705 //
     /*  21010 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21017 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21021 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  21025 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21029 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  21033 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21038 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21043 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21047 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21049 */     // (add:{ *:[v2i64] } (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21049 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
     /*  21052 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21054 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  21056 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21060 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  21064 */     GIR_RootConstrainSelectedInstOperands,
     /*  21065 */     // GIR_Coverage, 13705,
     /*  21065 */     GIR_EraseRootFromParent_Done,
     /*  21066 */   // Label 366: @21066
     /*  21066 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(21127), // Rule ID 13739 //
     /*  21071 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21074 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21078 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21082 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  21086 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21090 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  21094 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21099 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21104 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21108 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21110 */     // (add:{ *:[v2i64] } (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rd)  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21110 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
     /*  21113 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21115 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  21117 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21121 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  21125 */     GIR_RootConstrainSelectedInstOperands,
     /*  21126 */     // GIR_Coverage, 13739,
     /*  21126 */     GIR_EraseRootFromParent_Done,
     /*  21127 */   // Label 367: @21127
     /*  21127 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(21175), // Rule ID 13732 //
     /*  21132 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21135 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21139 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21143 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  21147 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21151 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21156 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21160 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21162 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21162 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  21165 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21167 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  21169 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21173 */     GIR_RootConstrainSelectedInstOperands,
     /*  21174 */     // GIR_Coverage, 13732,
     /*  21174 */     GIR_EraseRootFromParent_Done,
     /*  21175 */   // Label 368: @21175
     /*  21175 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(21223), // Rule ID 13617 //
     /*  21180 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21183 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21187 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21191 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  21195 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21199 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21204 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21208 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21210 */     // (add:{ *:[v2i64] } (AArch64saddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  21210 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
     /*  21213 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21215 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  21217 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21221 */     GIR_RootConstrainSelectedInstOperands,
     /*  21222 */     // GIR_Coverage, 13617,
     /*  21222 */     GIR_EraseRootFromParent_Done,
     /*  21223 */   // Label 369: @21223
     /*  21223 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(21271), // Rule ID 13699 //
     /*  21228 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21235 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21239 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  21243 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21247 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21252 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21256 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21258 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21258 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
     /*  21261 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21263 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  21265 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21269 */     GIR_RootConstrainSelectedInstOperands,
     /*  21270 */     // GIR_Coverage, 13699,
     /*  21270 */     GIR_EraseRootFromParent_Done,
     /*  21271 */   // Label 370: @21271
     /*  21271 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(21319), // Rule ID 13629 //
     /*  21276 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21279 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21283 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21287 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  21291 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21295 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21300 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21304 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21306 */     // (add:{ *:[v2i64] } (AArch64uaddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn), V128:{ *:[v2i64] }:$Rd)  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  21306 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
     /*  21309 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21311 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  21313 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21317 */     GIR_RootConstrainSelectedInstOperands,
     /*  21318 */     // GIR_Coverage, 13629,
     /*  21318 */     GIR_EraseRootFromParent_Done,
     /*  21319 */   // Label 371: @21319
     /*  21319 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(21367), // Rule ID 13731 //
     /*  21324 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21327 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21331 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21335 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  21339 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21343 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21348 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21352 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21354 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm), V128:{ *:[v2i64] }:$Rn)  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21354 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  21357 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21359 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  21361 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21365 */     GIR_RootConstrainSelectedInstOperands,
     /*  21366 */     // GIR_Coverage, 13731,
     /*  21366 */     GIR_EraseRootFromParent_Done,
     /*  21367 */   // Label 372: @21367
     /*  21367 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(21428), // Rule ID 1732 //
     /*  21372 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21375 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21379 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21383 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21387 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  21391 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21395 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  21399 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21404 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21409 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21411 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64smull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (SMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21411 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv2i32_v2i64),
     /*  21414 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21416 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  21418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21422 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  21426 */     GIR_RootConstrainSelectedInstOperands,
     /*  21427 */     // GIR_Coverage, 1732,
     /*  21427 */     GIR_EraseRootFromParent_Done,
     /*  21428 */   // Label 373: @21428
     /*  21428 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(21489), // Rule ID 1822 //
     /*  21433 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21436 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21440 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  21452 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21456 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  21460 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21465 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21470 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21472 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64umull:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm))  =>  (UMLALv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V64:{ *:[v2i32] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21472 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv2i32_v2i64),
     /*  21475 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21477 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  21479 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21483 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  21487 */     GIR_RootConstrainSelectedInstOperands,
     /*  21488 */     // GIR_Coverage, 1822,
     /*  21488 */     GIR_EraseRootFromParent_Done,
     /*  21489 */   // Label 374: @21489
     /*  21489 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(21537), // Rule ID 1815 //
     /*  21494 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21497 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21501 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21505 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21509 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  21513 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21517 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21522 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21524 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (anyext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21524 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  21527 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21529 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  21531 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21535 */     GIR_RootConstrainSelectedInstOperands,
     /*  21536 */     // GIR_Coverage, 1815,
     /*  21536 */     GIR_EraseRootFromParent_Done,
     /*  21537 */   // Label 375: @21537
     /*  21537 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(21585), // Rule ID 1002 //
     /*  21542 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21545 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21549 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21553 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21557 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  21561 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21565 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21570 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21572 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64saddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn))  =>  (SADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  21572 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv4i32_v2i64),
     /*  21575 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21577 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  21579 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21583 */     GIR_RootConstrainSelectedInstOperands,
     /*  21584 */     // GIR_Coverage, 1002,
     /*  21584 */     GIR_EraseRootFromParent_Done,
     /*  21585 */   // Label 376: @21585
     /*  21585 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(21633), // Rule ID 1726 //
     /*  21590 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21593 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21597 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21601 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21605 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  21609 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21613 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21618 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21620 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (sext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (SADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv2i32_v2i64),
     /*  21623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21625 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  21627 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21631 */     GIR_RootConstrainSelectedInstOperands,
     /*  21632 */     // GIR_Coverage, 1726,
     /*  21632 */     GIR_EraseRootFromParent_Done,
     /*  21633 */   // Label 377: @21633
     /*  21633 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(21681), // Rule ID 1063 //
     /*  21638 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21641 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21645 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21649 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21653 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  21657 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21661 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21666 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21668 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, (AArch64uaddlp_n:{ *:[v2i64] } V128:{ *:[v4i32] }:$Rn))  =>  (UADALPv4i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rd, V128:{ *:[v4i32] }:$Rn)
     /*  21668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv4i32_v2i64),
     /*  21671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21673 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  21675 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21679 */     GIR_RootConstrainSelectedInstOperands,
     /*  21680 */     // GIR_Coverage, 1063,
     /*  21680 */     GIR_EraseRootFromParent_Done,
     /*  21681 */   // Label 378: @21681
     /*  21681 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(21729), // Rule ID 1814 //
     /*  21686 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21689 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21693 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21697 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21701 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  21705 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  21709 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21714 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21716 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, (zext:{ *:[v2i64] } V64:{ *:[v2i32] }:$Rm))  =>  (UADDWv2i32_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V64:{ *:[v2i32] }:$Rm)
     /*  21716 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv2i32_v2i64),
     /*  21719 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21721 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  21723 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21727 */     GIR_RootConstrainSelectedInstOperands,
     /*  21728 */     // GIR_Coverage, 1814,
     /*  21728 */     GIR_EraseRootFromParent_Done,
     /*  21729 */   // Label 379: @21729
     /*  21729 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(21756), // Rule ID 1110 //
     /*  21734 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  21737 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21741 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21745 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21749 */     // (add:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)  =>  (ADDv2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$Rn, V128:{ *:[v2i64] }:$Rm)
     /*  21749 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv2i64),
     /*  21754 */     GIR_RootConstrainSelectedInstOperands,
     /*  21755 */     // GIR_Coverage, 1110,
     /*  21755 */     GIR_Done,
     /*  21756 */   // Label 380: @21756
     /*  21756 */   GIM_Reject,
     /*  21757 */ // Label 303: @21757
     /*  21757 */ GIM_Reject,
     /*  21758 */ // Label 160: @21758
     /*  21758 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(25255),
     /*  21763 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  21766 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  21769 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(21905), // Rule ID 5417 //
     /*  21774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21778 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  21786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  21790 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21794 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  21798 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  21802 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21807 */     // MIs[1] Operand 2
     /*  21807 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  21818 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21822 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  21826 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  21830 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21834 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  21838 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  21842 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21847 */     // MIs[3] Operand 2
     /*  21847 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  21858 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  21860 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  21860 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  21863 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  21867 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21872 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  21876 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  21880 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  21882 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21885 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21887 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  21894 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21899 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  21904 */     // GIR_Coverage, 5417,
     /*  21904 */     GIR_EraseRootFromParent_Done,
     /*  21905 */   // Label 382: @21905
     /*  21905 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(22041), // Rule ID 5416 //
     /*  21910 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21914 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21918 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  21922 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  21926 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21930 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  21934 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  21938 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21943 */     // MIs[1] Operand 2
     /*  21943 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  21954 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21958 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  21962 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  21966 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21970 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  21974 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  21978 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  21983 */     // MIs[3] Operand 2
     /*  21983 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  21994 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  21996 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  21996 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  21999 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  22003 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22008 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22012 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  22016 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22018 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22021 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22023 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22030 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22035 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22040 */     // GIR_Coverage, 5416,
     /*  22040 */     GIR_EraseRootFromParent_Done,
     /*  22041 */   // Label 383: @22041
     /*  22041 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(22177), // Rule ID 5432 //
     /*  22046 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22050 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22054 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22058 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22062 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22066 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  22070 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22074 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22079 */     // MIs[1] Operand 2
     /*  22079 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22090 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22094 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22098 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22102 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22106 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  22110 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22114 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22119 */     // MIs[3] Operand 2
     /*  22119 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  22130 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  22132 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v4i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  22132 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  22135 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDLv8i8_v8i16),
     /*  22139 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22144 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22148 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  22152 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22154 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22157 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22159 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22166 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22171 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22176 */     // GIR_Coverage, 5432,
     /*  22176 */     GIR_EraseRootFromParent_Done,
     /*  22177 */   // Label 384: @22177
     /*  22177 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(22313), // Rule ID 5415 //
     /*  22182 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22186 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22190 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22194 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22198 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22202 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  22206 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22210 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22215 */     // MIs[1] Operand 2
     /*  22215 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22226 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22230 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22234 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22238 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22242 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  22246 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22250 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22255 */     // MIs[3] Operand 2
     /*  22255 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  22266 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  22268 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  22268 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  22271 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  22275 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22280 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22284 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  22288 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22290 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22293 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22295 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22302 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22307 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22312 */     // GIR_Coverage, 5415,
     /*  22312 */     GIR_EraseRootFromParent_Done,
     /*  22313 */   // Label 385: @22313
     /*  22313 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(22449), // Rule ID 5414 //
     /*  22318 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22322 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22326 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22330 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22334 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22338 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  22342 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22346 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22351 */     // MIs[1] Operand 2
     /*  22351 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22362 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22366 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22370 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22374 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22378 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  22382 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22386 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22391 */     // MIs[3] Operand 2
     /*  22391 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  22402 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  22404 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), 0:{ *:[i64] }), (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  22404 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  22407 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  22411 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22416 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22420 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/4, /*OpIdx*/1, // Rm
     /*  22424 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22426 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22429 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22431 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22438 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22443 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22448 */     // GIR_Coverage, 5414,
     /*  22448 */     GIR_EraseRootFromParent_Done,
     /*  22449 */   // Label 386: @22449
     /*  22449 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(22582), // Rule ID 14257 //
     /*  22454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22458 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22462 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22466 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22470 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22474 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP2),
     /*  22478 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22482 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  22486 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22491 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  22495 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /*  22499 */     // MIs[1] Operand 2
     /*  22499 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22510 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  22514 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  22518 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22522 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  22526 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /*  22530 */     // MIs[5] Rn
     /*  22530 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22535 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  22537 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (AArch64uzp2:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, (undef:{ *:[v8i16] })), 0:{ *:[i64] }), (trunc:{ *:[v4i16] } (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$Rn)))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (ADDPv8i16:{ *:[f128] } ?:{ *:[v8i16] }:$Rn, ?:{ *:[v8i16] }:$Rn), dsub:{ *:[i32] })
     /*  22537 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  22540 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv8i16),
     /*  22544 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22549 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22553 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22557 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22559 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22562 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22564 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22571 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22576 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22581 */     // GIR_Coverage, 14257,
     /*  22581 */     GIR_EraseRootFromParent_Done,
     /*  22582 */   // Label 387: @22582
     /*  22582 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(22715), // Rule ID 7011 //
     /*  22587 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22591 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22595 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  22599 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22603 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22607 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /*  22611 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22615 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22620 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22624 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22628 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22632 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22636 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AArch64::G_UZP2),
     /*  22640 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  22644 */     // MIs[4] Rn
     /*  22644 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22649 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22653 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /*  22657 */     // MIs[3] Operand 2
     /*  22657 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  22668 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  22670 */     // (add:{ *:[v4i16] } (trunc:{ *:[v4i16] } (bitconvert:{ *:[v4i32] } FPR128:{ *:[v8i16] }:$Rn)), (extract_subvector:{ *:[v4i16] } (AArch64uzp2:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, (undef:{ *:[v8i16] })), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (ADDPv8i16:{ *:[f128] } ?:{ *:[v8i16] }:$Rn, ?:{ *:[v8i16] }:$Rn), dsub:{ *:[i32] })
     /*  22670 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  22673 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv8i16),
     /*  22677 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22682 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22686 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22690 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22692 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22695 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22697 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22704 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22709 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22714 */     // GIR_Coverage, 7011,
     /*  22714 */     GIR_EraseRootFromParent_Done,
     /*  22715 */   // Label 388: @22715
     /*  22715 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(22878), // Rule ID 14215 //
     /*  22720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22732 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22736 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22740 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*  22744 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22748 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  22752 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22757 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22762 */     // MIs[1] Operand 2
     /*  22762 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22773 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22777 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22779 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (SMLALv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  22779 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  22782 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  22786 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22791 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  22793 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  22796 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  22800 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22805 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  22808 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*  22812 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  22815 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22820 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22825 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22830 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  22833 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
     /*  22837 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22842 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  22845 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  22849 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  22853 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22855 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22858 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22860 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  22867 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22872 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22877 */     // GIR_Coverage, 14215,
     /*  22877 */     GIR_EraseRootFromParent_Done,
     /*  22878 */   // Label 389: @22878
     /*  22878 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(23041), // Rule ID 14212 //
     /*  22883 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22887 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22891 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  22895 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22899 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22903 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*  22907 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  22911 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  22915 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22920 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22925 */     // MIs[1] Operand 2
     /*  22925 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  22936 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22940 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22942 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Ra)  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UMLALv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  22942 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  22945 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  22949 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22954 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  22956 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  22959 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  22963 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22968 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  22971 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Ra
     /*  22975 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  22978 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22983 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  22988 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  22993 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  22996 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
     /*  23000 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23005 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23008 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  23012 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  23016 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23018 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23021 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23023 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23030 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23035 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23040 */     // GIR_Coverage, 14212,
     /*  23040 */     GIR_EraseRootFromParent_Done,
     /*  23041 */   // Label 390: @23041
     /*  23041 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(23191), // Rule ID 14219 //
     /*  23046 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23050 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23054 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23058 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23062 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23066 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  23070 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23074 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23079 */     // MIs[1] Operand 2
     /*  23079 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23090 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23094 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23096 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23096 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23099 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23103 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23108 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23110 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23113 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23117 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23122 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23125 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  23129 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23132 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23137 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23142 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23147 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23150 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  23154 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23159 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23162 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  23166 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23173 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23180 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23185 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23190 */     // GIR_Coverage, 14219,
     /*  23190 */     GIR_EraseRootFromParent_Done,
     /*  23191 */   // Label 391: @23191
     /*  23191 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(23341), // Rule ID 14224 //
     /*  23196 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23200 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23204 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23208 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23212 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23216 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  23220 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23224 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23229 */     // MIs[1] Operand 2
     /*  23229 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23240 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23244 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23246 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (SADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23246 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23249 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23253 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23258 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23260 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23263 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23267 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23272 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23275 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  23279 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23282 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23287 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23292 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23297 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23300 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
     /*  23304 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23309 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23312 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  23316 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23323 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23330 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23335 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23340 */     // GIR_Coverage, 14224,
     /*  23340 */     GIR_EraseRootFromParent_Done,
     /*  23341 */   // Label 392: @23341
     /*  23341 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(23491), // Rule ID 14218 //
     /*  23346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23358 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23362 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23366 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  23370 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23374 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23379 */     // MIs[1] Operand 2
     /*  23379 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23390 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23394 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23396 */     // (add:{ *:[v4i16] } (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn)  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23396 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23399 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23403 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23408 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23410 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23413 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23417 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23422 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23425 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // Rn
     /*  23429 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23432 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23437 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23442 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23447 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23450 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  23454 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23459 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23462 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  23466 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23468 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23471 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23473 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23480 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23485 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23490 */     // GIR_Coverage, 14218,
     /*  23490 */     GIR_EraseRootFromParent_Done,
     /*  23491 */   // Label 393: @23491
     /*  23491 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(23654), // Rule ID 5405 //
     /*  23496 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23500 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23512 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23516 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23520 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_SMULL),
     /*  23524 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23528 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  23532 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23537 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23542 */     // MIs[1] Operand 2
     /*  23542 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23553 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23555 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Ra, (extract_subvector:{ *:[v4i16] } (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (SMLALv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23555 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23558 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23562 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23567 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23569 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23572 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23576 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23581 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23584 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*  23588 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23591 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23596 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23601 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23606 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23609 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
     /*  23613 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23618 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23621 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  23625 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  23629 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23631 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23634 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23636 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23643 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23648 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23653 */     // GIR_Coverage, 5405,
     /*  23653 */     GIR_EraseRootFromParent_Done,
     /*  23654 */   // Label 394: @23654
     /*  23654 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(23817), // Rule ID 5402 //
     /*  23659 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23663 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23667 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23671 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23675 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23679 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23683 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UMULL),
     /*  23687 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23691 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  23695 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23700 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23705 */     // MIs[1] Operand 2
     /*  23705 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23716 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23718 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Ra, (extract_subvector:{ *:[v4i16] } (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UMLALv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Ra, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23718 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23721 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23725 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23730 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23732 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23735 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23739 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23744 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23747 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Ra
     /*  23751 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23754 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23759 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23764 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23769 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23772 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
     /*  23776 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23781 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23784 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  23788 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/2, // Rm
     /*  23792 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23794 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23797 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23799 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23806 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23811 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23816 */     // GIR_Coverage, 5402,
     /*  23816 */     GIR_EraseRootFromParent_Done,
     /*  23817 */   // Label 395: @23817
     /*  23817 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(23967), // Rule ID 5427 //
     /*  23822 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23826 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23830 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23834 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23838 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23842 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23846 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  23850 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  23854 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23859 */     // MIs[1] Operand 2
     /*  23859 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  23870 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23872 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  23872 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  23875 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23879 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23884 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  23886 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  23889 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  23893 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23898 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  23901 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  23905 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  23908 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23913 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23918 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23923 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  23926 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  23930 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23935 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23938 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  23942 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23944 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23947 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23949 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  23956 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23961 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  23966 */     // GIR_Coverage, 5427,
     /*  23966 */     GIR_EraseRootFromParent_Done,
     /*  23967 */   // Label 396: @23967
     /*  23967 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(24117), // Rule ID 5435 //
     /*  23972 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23976 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  23980 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23984 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  23988 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  23992 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23996 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  24000 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  24004 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24009 */     // MIs[1] Operand 2
     /*  24009 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  24020 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24022 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (SADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  24022 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  24025 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  24029 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24034 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  24036 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  24039 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  24043 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24048 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  24051 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  24055 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  24058 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24063 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24068 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24073 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  24076 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
     /*  24080 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24085 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  24088 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  24092 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  24094 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24097 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24099 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  24106 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24111 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24116 */     // GIR_Coverage, 5435,
     /*  24116 */     GIR_EraseRootFromParent_Done,
     /*  24117 */   // Label 397: @24117
     /*  24117 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(24267), // Rule ID 5426 //
     /*  24122 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24126 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24130 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24134 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  24138 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  24142 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  24146 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  24150 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  24154 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24159 */     // MIs[1] Operand 2
     /*  24159 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  24170 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24172 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v4i16] } (UADDWv8i8_v8i16:{ *:[v8i16] } (INSERT_SUBREG:{ *:[v8i16] } (IMPLICIT_DEF:{ *:[v8i16] }), V64:{ *:[v4i16] }:$Rn, dsub:{ *:[i32] }), V64:{ *:[v8i8] }:$Rm), dsub:{ *:[i32] })
     /*  24172 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s16,
     /*  24175 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  24179 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24184 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  24186 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
     /*  24189 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  24193 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24198 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  24201 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // Rn
     /*  24205 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/3,
     /*  24208 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24213 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24218 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24223 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*  24226 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  24230 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24235 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  24238 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  24242 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  24244 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24247 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24249 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  24256 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24261 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  24266 */     // GIR_Coverage, 5426,
     /*  24266 */     GIR_EraseRootFromParent_Done,
     /*  24267 */   // Label 398: @24267
     /*  24267 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(24336), // Rule ID 13646 //
     /*  24272 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24275 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24279 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24283 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24287 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24290 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  24295 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  24299 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  24303 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24308 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24313 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24317 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24319 */     // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  24319 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i16),
     /*  24322 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24324 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24326 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24330 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  24334 */     GIR_RootConstrainSelectedInstOperands,
     /*  24335 */     // GIR_Coverage, 13646,
     /*  24335 */     GIR_EraseRootFromParent_Done,
     /*  24336 */   // Label 399: @24336
     /*  24336 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(24405), // Rule ID 13658 //
     /*  24341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24356 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24359 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  24364 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  24368 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  24372 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24377 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24382 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24386 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24388 */     // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V64:{ *:[v4i16] }:$Rd)  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  24388 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i16),
     /*  24391 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24393 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24395 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24399 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  24403 */     GIR_RootConstrainSelectedInstOperands,
     /*  24404 */     // GIR_Coverage, 13658,
     /*  24404 */     GIR_EraseRootFromParent_Done,
     /*  24405 */   // Label 400: @24405
     /*  24405 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(24461), // Rule ID 13608 //
     /*  24410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24413 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24417 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24421 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24425 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  24428 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  24433 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  24437 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24442 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24446 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24448 */     // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 670:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  24448 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
     /*  24451 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24453 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24455 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24459 */     GIR_RootConstrainSelectedInstOperands,
     /*  24460 */     // GIR_Coverage, 13608,
     /*  24460 */     GIR_EraseRootFromParent_Done,
     /*  24461 */   // Label 401: @24461
     /*  24461 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(24517), // Rule ID 13620 //
     /*  24466 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24469 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24473 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24477 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24481 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  24484 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  24489 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  24493 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24498 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24502 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24504 */     // (add:{ *:[v4i16] } (intrinsic_wo_chain:{ *:[v4i16] } 735:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  24504 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
     /*  24507 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24509 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24511 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24515 */     GIR_RootConstrainSelectedInstOperands,
     /*  24516 */     // GIR_Coverage, 13620,
     /*  24516 */     GIR_EraseRootFromParent_Done,
     /*  24517 */   // Label 402: @24517
     /*  24517 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(24584), // Rule ID 13860 //
     /*  24522 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24525 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24529 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24533 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  24537 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  24541 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24546 */     // MIs[1] imm
     /*  24546 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24550 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24554 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  24558 */     // MIs[2] Operand 1
     /*  24558 */     // No operand predicates
     /*  24558 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24562 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  24566 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24568 */     // (add:{ *:[v4i16] } (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  24568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i16_shift),
     /*  24571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24573 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24575 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  24579 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  24582 */     GIR_RootConstrainSelectedInstOperands,
     /*  24583 */     // GIR_Coverage, 13860,
     /*  24583 */     GIR_EraseRootFromParent_Done,
     /*  24584 */   // Label 403: @24584
     /*  24584 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(24651), // Rule ID 13881 //
     /*  24589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24596 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  24604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  24608 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24613 */     // MIs[1] imm
     /*  24613 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24617 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24621 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  24625 */     // MIs[2] Operand 1
     /*  24625 */     // No operand predicates
     /*  24625 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24629 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  24633 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24635 */     // (add:{ *:[v4i16] } (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V64:{ *:[v4i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  24635 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i16_shift),
     /*  24638 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24640 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  24642 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  24646 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  24649 */     GIR_RootConstrainSelectedInstOperands,
     /*  24650 */     // GIR_Coverage, 13881,
     /*  24650 */     GIR_EraseRootFromParent_Done,
     /*  24651 */   // Label 404: @24651
     /*  24651 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(24720), // Rule ID 1365 //
     /*  24656 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24659 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24663 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24667 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24671 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24675 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24678 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  24683 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  24687 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  24691 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24696 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24701 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24703 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  24703 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i16),
     /*  24706 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24708 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  24710 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24714 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  24718 */     GIR_RootConstrainSelectedInstOperands,
     /*  24719 */     // GIR_Coverage, 1365,
     /*  24719 */     GIR_EraseRootFromParent_Done,
     /*  24720 */   // Label 405: @24720
     /*  24720 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(24789), // Rule ID 1488 //
     /*  24725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24728 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24732 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24736 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24740 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24744 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24747 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  24752 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  24756 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  24760 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24765 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24770 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24772 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UABAv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  24772 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i16),
     /*  24775 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24777 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  24779 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24783 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  24787 */     GIR_RootConstrainSelectedInstOperands,
     /*  24788 */     // GIR_Coverage, 1488,
     /*  24788 */     GIR_EraseRootFromParent_Done,
     /*  24789 */   // Label 406: @24789
     /*  24789 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(24845), // Rule ID 993 //
     /*  24794 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24797 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24801 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24805 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24809 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24813 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  24816 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  24821 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  24825 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24830 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24832 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 670:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  24832 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
     /*  24835 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24837 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  24839 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24843 */     GIR_RootConstrainSelectedInstOperands,
     /*  24844 */     // GIR_Coverage, 993,
     /*  24844 */     GIR_EraseRootFromParent_Done,
     /*  24845 */   // Label 407: @24845
     /*  24845 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(24901), // Rule ID 1054 //
     /*  24850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24857 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24861 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24865 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24869 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  24872 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  24877 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  24881 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24886 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24888 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (intrinsic_wo_chain:{ *:[v4i16] } 735:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  24888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
     /*  24891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24893 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  24895 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  24899 */     GIR_RootConstrainSelectedInstOperands,
     /*  24900 */     // GIR_Coverage, 1054,
     /*  24900 */     GIR_EraseRootFromParent_Done,
     /*  24901 */   // Label 408: @24901
     /*  24901 */   GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(24968), // Rule ID 2238 //
     /*  24906 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24909 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24913 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24917 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24921 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  24925 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  24929 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24934 */     // MIs[1] imm
     /*  24934 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24938 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24942 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  24946 */     // MIs[2] Operand 1
     /*  24946 */     // No operand predicates
     /*  24946 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  24950 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24952 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vashr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  24952 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i16_shift),
     /*  24955 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24957 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  24959 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  24963 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  24966 */     GIR_RootConstrainSelectedInstOperands,
     /*  24967 */     // GIR_Coverage, 2238,
     /*  24967 */     GIR_EraseRootFromParent_Done,
     /*  24968 */   // Label 409: @24968
     /*  24968 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(25035), // Rule ID 2297 //
     /*  24973 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24976 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24980 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  24984 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24988 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  24992 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  24996 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25001 */     // MIs[1] imm
     /*  25001 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25005 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25009 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  25013 */     // MIs[2] Operand 1
     /*  25013 */     // No operand predicates
     /*  25013 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  25017 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  25019 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64vlshr:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i16_shift:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v4i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  25019 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i16_shift),
     /*  25022 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25024 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  25026 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  25030 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  25033 */     GIR_RootConstrainSelectedInstOperands,
     /*  25034 */     // GIR_Coverage, 2297,
     /*  25034 */     GIR_EraseRootFromParent_Done,
     /*  25035 */   // Label 410: @25035
     /*  25035 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(25083), // Rule ID 13607 //
     /*  25040 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25043 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25047 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25051 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  25055 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  25059 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25064 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25068 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25070 */     // (add:{ *:[v4i16] } (AArch64saddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  25070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
     /*  25073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25075 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25077 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  25081 */     GIR_RootConstrainSelectedInstOperands,
     /*  25082 */     // GIR_Coverage, 13607,
     /*  25082 */     GIR_EraseRootFromParent_Done,
     /*  25083 */   // Label 411: @25083
     /*  25083 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(25131), // Rule ID 13619 //
     /*  25088 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25091 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25095 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25099 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  25103 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  25107 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25112 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25116 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25118 */     // (add:{ *:[v4i16] } (AArch64uaddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn), V64:{ *:[v4i16] }:$Rd)  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  25118 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
     /*  25121 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25123 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25125 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  25129 */     GIR_RootConstrainSelectedInstOperands,
     /*  25130 */     // GIR_Coverage, 13619,
     /*  25130 */     GIR_EraseRootFromParent_Done,
     /*  25131 */   // Label 412: @25131
     /*  25131 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(25179), // Rule ID 992 //
     /*  25136 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25139 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25143 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25147 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25151 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  25155 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  25159 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25164 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25166 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64saddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn))  =>  (SADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  25166 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i8_v4i16),
     /*  25169 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25171 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  25173 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  25177 */     GIR_RootConstrainSelectedInstOperands,
     /*  25178 */     // GIR_Coverage, 992,
     /*  25178 */     GIR_EraseRootFromParent_Done,
     /*  25179 */   // Label 413: @25179
     /*  25179 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(25227), // Rule ID 1053 //
     /*  25184 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25187 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25191 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25195 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25199 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  25203 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  25207 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25212 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25214 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, (AArch64uaddlp_n:{ *:[v4i16] } V64:{ *:[v8i8] }:$Rn))  =>  (UADALPv8i8_v4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rd, V64:{ *:[v8i8] }:$Rn)
     /*  25214 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i8_v4i16),
     /*  25217 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25219 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  25221 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  25225 */     GIR_RootConstrainSelectedInstOperands,
     /*  25226 */     // GIR_Coverage, 1053,
     /*  25226 */     GIR_EraseRootFromParent_Done,
     /*  25227 */   // Label 414: @25227
     /*  25227 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(25254), // Rule ID 1106 //
     /*  25232 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25235 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25239 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25243 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  25247 */     // (add:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)  =>  (ADDv4i16:{ *:[v4i16] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  25247 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv4i16),
     /*  25252 */     GIR_RootConstrainSelectedInstOperands,
     /*  25253 */     // GIR_Coverage, 1106,
     /*  25253 */     GIR_Done,
     /*  25254 */   // Label 415: @25254
     /*  25254 */   GIM_Reject,
     /*  25255 */ // Label 381: @25255
     /*  25255 */ GIM_Reject,
     /*  25256 */ // Label 161: @25256
     /*  25256 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(31433),
     /*  25261 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25264 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25267 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(25385), // Rule ID 13784 //
     /*  25272 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25275 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25279 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25283 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  25287 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25295 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25299 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25303 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25307 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25311 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25315 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25319 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25323 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25328 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25332 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25336 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25340 */     // MIs[4] Operand 1
     /*  25340 */     // No operand predicates
     /*  25340 */     // MIs[2] Operand 2
     /*  25340 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25351 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25355 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25357 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25364 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] })), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25364 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_indexed),
     /*  25367 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25369 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25371 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25376 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25380 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25383 */     GIR_RootConstrainSelectedInstOperands,
     /*  25384 */     // GIR_Coverage, 13784,
     /*  25384 */     GIR_EraseRootFromParent_Done,
     /*  25385 */   // Label 417: @25385
     /*  25385 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(25503), // Rule ID 13785 //
     /*  25390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25397 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25401 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  25405 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25409 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25413 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25417 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25421 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25425 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25429 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25433 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25437 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25441 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25446 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25450 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25454 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25458 */     // MIs[4] Operand 1
     /*  25458 */     // No operand predicates
     /*  25458 */     // MIs[2] Operand 2
     /*  25458 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25469 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25473 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25475 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25482 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] }), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25482 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_indexed),
     /*  25485 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25487 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25489 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25494 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25498 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25501 */     GIR_RootConstrainSelectedInstOperands,
     /*  25502 */     // GIR_Coverage, 13785,
     /*  25502 */     GIR_EraseRootFromParent_Done,
     /*  25503 */   // Label 418: @25503
     /*  25503 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(25621), // Rule ID 13820 //
     /*  25508 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25511 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25515 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25519 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  25523 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25527 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25531 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25535 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25539 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25543 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25547 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25551 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25555 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25559 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25564 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25568 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25572 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25576 */     // MIs[4] Operand 1
     /*  25576 */     // No operand predicates
     /*  25576 */     // MIs[2] Operand 2
     /*  25576 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25587 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25591 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25593 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25600 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] })), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25600 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_indexed),
     /*  25603 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25605 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25607 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25612 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25616 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25619 */     GIR_RootConstrainSelectedInstOperands,
     /*  25620 */     // GIR_Coverage, 13820,
     /*  25620 */     GIR_EraseRootFromParent_Done,
     /*  25621 */   // Label 419: @25621
     /*  25621 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(25739), // Rule ID 13821 //
     /*  25626 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25629 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25633 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25637 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  25641 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25645 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25649 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25653 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25657 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25661 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25665 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25669 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25673 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25677 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25682 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25686 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25690 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25694 */     // MIs[4] Operand 1
     /*  25694 */     // No operand predicates
     /*  25694 */     // MIs[2] Operand 2
     /*  25694 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25705 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25709 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25711 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25718 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] }), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_indexed),
     /*  25721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25723 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  25725 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25734 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25737 */     GIR_RootConstrainSelectedInstOperands,
     /*  25738 */     // GIR_Coverage, 13821,
     /*  25738 */     GIR_EraseRootFromParent_Done,
     /*  25739 */   // Label 420: @25739
     /*  25739 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(25857), // Rule ID 2043 //
     /*  25744 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25747 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25751 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25755 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25759 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  25763 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25767 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25771 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25775 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25779 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25783 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25787 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25791 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25795 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25799 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25804 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25808 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25812 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25816 */     // MIs[4] Operand 1
     /*  25816 */     // No operand predicates
     /*  25816 */     // MIs[2] Operand 2
     /*  25816 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25827 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25829 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25836 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] })))  =>  (SMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25836 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_indexed),
     /*  25839 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25841 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  25843 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25848 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25852 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25855 */     GIR_RootConstrainSelectedInstOperands,
     /*  25856 */     // GIR_Coverage, 2043,
     /*  25856 */     GIR_EraseRootFromParent_Done,
     /*  25857 */   // Label 421: @25857
     /*  25857 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(25975), // Rule ID 13783 //
     /*  25862 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25865 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25869 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25873 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25877 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  25881 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25885 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25889 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25893 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  25897 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25901 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25905 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  25909 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25913 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  25917 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  25922 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  25926 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25930 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  25934 */     // MIs[4] Operand 1
     /*  25934 */     // No operand predicates
     /*  25934 */     // MIs[2] Operand 2
     /*  25934 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  25945 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  25947 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  25954 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] }), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)))  =>  (SMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  25954 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_indexed),
     /*  25957 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25959 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  25961 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  25966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  25970 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  25973 */     GIR_RootConstrainSelectedInstOperands,
     /*  25974 */     // GIR_Coverage, 13783,
     /*  25974 */     GIR_EraseRootFromParent_Done,
     /*  25975 */   // Label 422: @25975
     /*  25975 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(26093), // Rule ID 2095 //
     /*  25980 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25983 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25987 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  25991 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25995 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  25999 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26003 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26007 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26011 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26015 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26019 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26023 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26027 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26031 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26035 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26040 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26044 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26048 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26052 */     // MIs[4] Operand 1
     /*  26052 */     // No operand predicates
     /*  26052 */     // MIs[2] Operand 2
     /*  26052 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  26063 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26065 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26072 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] })))  =>  (UMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26072 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_indexed),
     /*  26075 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26077 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  26079 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  26088 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  26091 */     GIR_RootConstrainSelectedInstOperands,
     /*  26092 */     // GIR_Coverage, 2095,
     /*  26092 */     GIR_EraseRootFromParent_Done,
     /*  26093 */   // Label 423: @26093
     /*  26093 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(26211), // Rule ID 13819 //
     /*  26098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26101 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26105 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26109 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26113 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  26117 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26121 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26125 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26129 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26133 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26137 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26141 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26145 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26149 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26153 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26158 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26162 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26166 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26170 */     // MIs[4] Operand 1
     /*  26170 */     // No operand predicates
     /*  26170 */     // MIs[2] Operand 2
     /*  26170 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4),
     /*  26181 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26183 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26190 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 4:{ *:[i64] }), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)))  =>  (UMLALv8i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26190 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_indexed),
     /*  26193 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26195 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  26197 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26202 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  26206 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  26209 */     GIR_RootConstrainSelectedInstOperands,
     /*  26210 */     // GIR_Coverage, 13819,
     /*  26210 */     GIR_EraseRootFromParent_Done,
     /*  26211 */   // Label 424: @26211
     /*  26211 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(26298), // Rule ID 13690 //
     /*  26216 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26219 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26223 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26227 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  26231 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26235 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26239 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26243 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  26246 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  26251 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26255 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  26259 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26263 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26265 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26272 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26279 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  26279 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i16_v4i32),
     /*  26282 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26284 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  26286 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26291 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  26296 */     GIR_RootConstrainSelectedInstOperands,
     /*  26297 */     // GIR_Coverage, 13690,
     /*  26297 */     GIR_EraseRootFromParent_Done,
     /*  26298 */   // Label 425: @26298
     /*  26298 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(26385), // Rule ID 13718 //
     /*  26303 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26306 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26310 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26314 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  26318 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26322 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26326 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26330 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  26333 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  26338 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26342 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  26346 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26350 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26352 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26359 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26366 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  26366 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i16_v4i32),
     /*  26369 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26371 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  26373 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26378 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  26383 */     GIR_RootConstrainSelectedInstOperands,
     /*  26384 */     // GIR_Coverage, 13718,
     /*  26384 */     GIR_EraseRootFromParent_Done,
     /*  26385 */   // Label 426: @26385
     /*  26385 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(26472), // Rule ID 1699 //
     /*  26390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  26409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26413 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26417 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26421 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  26424 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  26429 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26433 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  26437 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26439 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26446 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26453 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))))  =>  (SABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  26453 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i16_v4i32),
     /*  26456 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26458 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  26460 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26465 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  26470 */     GIR_RootConstrainSelectedInstOperands,
     /*  26471 */     // GIR_Coverage, 1699,
     /*  26471 */     GIR_EraseRootFromParent_Done,
     /*  26472 */   // Label 427: @26472
     /*  26472 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(26559), // Rule ID 1777 //
     /*  26477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26484 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  26496 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26500 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26504 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26508 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  26511 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  26516 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26520 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  26524 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26526 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26533 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  26540 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm))))  =>  (UABALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  26540 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i16_v4i32),
     /*  26543 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26545 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  26547 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  26552 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  26557 */     GIR_RootConstrainSelectedInstOperands,
     /*  26558 */     // GIR_Coverage, 1777,
     /*  26558 */     GIR_EraseRootFromParent_Done,
     /*  26559 */   // Label 428: @26559
     /*  26559 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(26674), // Rule ID 13779 //
     /*  26564 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26567 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26571 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26575 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  26579 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26583 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26587 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26591 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26595 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26599 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26603 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26607 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26611 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26615 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26620 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26624 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26628 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26632 */     // MIs[4] Operand 1
     /*  26632 */     // No operand predicates
     /*  26632 */     // MIs[2] Operand 2
     /*  26632 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  26643 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  26648 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26652 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26654 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  26657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26659 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  26661 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  26665 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  26669 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  26672 */     GIR_RootConstrainSelectedInstOperands,
     /*  26673 */     // GIR_Coverage, 13779,
     /*  26673 */     GIR_EraseRootFromParent_Done,
     /*  26674 */   // Label 429: @26674
     /*  26674 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(26789), // Rule ID 13778 //
     /*  26679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26682 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  26694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26698 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26702 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  26707 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26711 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26715 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26719 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26723 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26727 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26731 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26735 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26740 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26744 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26748 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26752 */     // MIs[4] Operand 1
     /*  26752 */     // No operand predicates
     /*  26752 */     // MIs[2] Operand 2
     /*  26752 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  26763 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26767 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26769 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] })), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26769 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  26772 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26774 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  26776 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  26780 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  26784 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  26787 */     GIR_RootConstrainSelectedInstOperands,
     /*  26788 */     // GIR_Coverage, 13778,
     /*  26788 */     GIR_EraseRootFromParent_Done,
     /*  26789 */   // Label 430: @26789
     /*  26789 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(26904), // Rule ID 13815 //
     /*  26794 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26797 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26801 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26805 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  26809 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26813 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26817 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26821 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26825 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26829 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26833 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26837 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26841 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26845 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26850 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26854 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26858 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26862 */     // MIs[4] Operand 1
     /*  26862 */     // No operand predicates
     /*  26862 */     // MIs[2] Operand 2
     /*  26862 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  26873 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  26878 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26882 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26884 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  26887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26889 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  26891 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  26895 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  26899 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  26902 */     GIR_RootConstrainSelectedInstOperands,
     /*  26903 */     // GIR_Coverage, 13815,
     /*  26903 */     GIR_EraseRootFromParent_Done,
     /*  26904 */   // Label 431: @26904
     /*  26904 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(27019), // Rule ID 13814 //
     /*  26909 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26912 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26916 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26920 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  26924 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26928 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26932 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  26937 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26941 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  26945 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26949 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26953 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  26957 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  26961 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  26965 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  26970 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  26974 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26978 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  26982 */     // MIs[4] Operand 1
     /*  26982 */     // No operand predicates
     /*  26982 */     // MIs[2] Operand 2
     /*  26982 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  26993 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  26997 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  26999 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] })), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  26999 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  27002 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27004 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  27006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  27010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  27014 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  27017 */     GIR_RootConstrainSelectedInstOperands,
     /*  27018 */     // GIR_Coverage, 13814,
     /*  27018 */     GIR_EraseRootFromParent_Done,
     /*  27019 */   // Label 432: @27019
     /*  27019 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(27088), // Rule ID 1797 //
     /*  27024 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27027 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27031 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27035 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  27039 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27043 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27047 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  27051 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27055 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27057 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27064 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27071 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
     /*  27074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  27076 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27081 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27086 */     GIR_RootConstrainSelectedInstOperands,
     /*  27087 */     // GIR_Coverage, 1797,
     /*  27087 */     GIR_EraseRootFromParent_Done,
     /*  27088 */   // Label 433: @27088
     /*  27088 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(27157), // Rule ID 1796 //
     /*  27093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27100 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  27108 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27112 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27116 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  27120 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27124 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27126 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27133 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27140 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27140 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
     /*  27143 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  27145 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27150 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27155 */     GIR_RootConstrainSelectedInstOperands,
     /*  27156 */     // GIR_Coverage, 1796,
     /*  27156 */     GIR_EraseRootFromParent_Done,
     /*  27157 */   // Label 434: @27157
     /*  27157 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(27226), // Rule ID 1719 //
     /*  27162 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27165 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27169 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27173 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  27177 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27181 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27185 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  27189 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27193 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27195 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27202 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27209 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27209 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv8i16_v4i32),
     /*  27212 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  27214 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27219 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27224 */     GIR_RootConstrainSelectedInstOperands,
     /*  27225 */     // GIR_Coverage, 1719,
     /*  27225 */     GIR_EraseRootFromParent_Done,
     /*  27226 */   // Label 435: @27226
     /*  27226 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(27295), // Rule ID 1795 //
     /*  27231 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27234 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27238 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27242 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  27246 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27250 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27254 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  27258 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27262 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27264 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27271 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27278 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27278 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
     /*  27281 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  27283 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27288 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27293 */     GIR_RootConstrainSelectedInstOperands,
     /*  27294 */     // GIR_Coverage, 1795,
     /*  27294 */     GIR_EraseRootFromParent_Done,
     /*  27295 */   // Label 436: @27295
     /*  27295 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(27364), // Rule ID 1794 //
     /*  27300 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27303 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27307 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27311 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  27315 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27319 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27323 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  27327 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27331 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27333 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27340 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27347 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn)), (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDLv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i16_v4i32),
     /*  27350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  27352 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27357 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27362 */     GIR_RootConstrainSelectedInstOperands,
     /*  27363 */     // GIR_Coverage, 1794,
     /*  27363 */     GIR_EraseRootFromParent_Done,
     /*  27364 */   // Label 437: @27364
     /*  27364 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(27479), // Rule ID 13777 //
     /*  27369 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27372 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27376 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27380 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27384 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  27388 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27392 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27396 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27400 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  27404 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27408 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27412 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  27416 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27420 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  27424 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  27429 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  27433 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27437 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  27441 */     // MIs[4] Operand 1
     /*  27441 */     // No operand predicates
     /*  27441 */     // MIs[2] Operand 2
     /*  27441 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  27452 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  27457 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  27459 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  27459 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  27462 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27464 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  27466 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  27470 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  27474 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  27477 */     GIR_RootConstrainSelectedInstOperands,
     /*  27478 */     // GIR_Coverage, 13777,
     /*  27478 */     GIR_EraseRootFromParent_Done,
     /*  27479 */   // Label 438: @27479
     /*  27479 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(27594), // Rule ID 2041 //
     /*  27484 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27487 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27491 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27495 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27499 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  27503 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27507 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27511 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  27516 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27520 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  27524 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27528 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27532 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  27536 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27540 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  27544 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  27549 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  27553 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27557 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  27561 */     // MIs[4] Operand 1
     /*  27561 */     // No operand predicates
     /*  27561 */     // MIs[2] Operand 2
     /*  27561 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  27572 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  27574 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] })))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  27574 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  27577 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27579 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  27581 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  27585 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  27589 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  27592 */     GIR_RootConstrainSelectedInstOperands,
     /*  27593 */     // GIR_Coverage, 2041,
     /*  27593 */     GIR_EraseRootFromParent_Done,
     /*  27594 */   // Label 439: @27594
     /*  27594 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(27709), // Rule ID 13813 //
     /*  27599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27602 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27606 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27610 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27614 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  27618 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27622 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27626 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27630 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  27634 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27638 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27642 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  27646 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27650 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  27654 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  27659 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  27663 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27667 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  27671 */     // MIs[4] Operand 1
     /*  27671 */     // No operand predicates
     /*  27671 */     // MIs[2] Operand 2
     /*  27671 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  27682 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  27687 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  27689 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] }), V64:{ *:[v4i16] }:$Rn))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  27689 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  27692 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27694 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  27696 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  27700 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  27704 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  27707 */     GIR_RootConstrainSelectedInstOperands,
     /*  27708 */     // GIR_Coverage, 13813,
     /*  27708 */     GIR_EraseRootFromParent_Done,
     /*  27709 */   // Label 440: @27709
     /*  27709 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(27824), // Rule ID 2093 //
     /*  27714 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27717 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27721 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27725 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27729 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  27733 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27737 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27741 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  27746 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27750 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  27754 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27758 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27762 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  27766 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  27770 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s64,
     /*  27774 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  27779 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  27783 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27787 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  27791 */     // MIs[4] Operand 1
     /*  27791 */     // No operand predicates
     /*  27791 */     // MIs[2] Operand 2
     /*  27791 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(0),
     /*  27802 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  27804 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (extract_subvector:{ *:[v4i16] } (AArch64duplane16:{ *:[v8i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), 0:{ *:[i64] })))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  27804 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  27807 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27809 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  27811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  27815 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  27819 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // idx
     /*  27822 */     GIR_RootConstrainSelectedInstOperands,
     /*  27823 */     // GIR_Coverage, 2093,
     /*  27823 */     GIR_EraseRootFromParent_Done,
     /*  27824 */   // Label 441: @27824
     /*  27824 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(27891), // Rule ID 13704 //
     /*  27829 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27832 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27836 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27840 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  27844 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27848 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27856 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27858 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27865 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27872 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27872 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_v4i32),
     /*  27875 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27877 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  27879 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27884 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27889 */     GIR_RootConstrainSelectedInstOperands,
     /*  27890 */     // GIR_Coverage, 13704,
     /*  27890 */     GIR_EraseRootFromParent_Done,
     /*  27891 */   // Label 442: @27891
     /*  27891 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(27958), // Rule ID 13738 //
     /*  27896 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27899 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27903 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27907 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  27911 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27915 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27919 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27923 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27925 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27932 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27939 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  27939 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_v4i32),
     /*  27942 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27944 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  27946 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  27951 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  27956 */     GIR_RootConstrainSelectedInstOperands,
     /*  27957 */     // GIR_Coverage, 13738,
     /*  27957 */     GIR_EraseRootFromParent_Done,
     /*  27958 */   // Label 443: @27958
     /*  27958 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(28025), // Rule ID 1731 //
     /*  27963 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27970 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  27974 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27978 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  27982 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27986 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  27990 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27992 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  27999 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  28006 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  28006 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i16_v4i32),
     /*  28009 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28011 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28013 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  28018 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  28023 */     GIR_RootConstrainSelectedInstOperands,
     /*  28024 */     // GIR_Coverage, 1731,
     /*  28024 */     GIR_EraseRootFromParent_Done,
     /*  28025 */   // Label 444: @28025
     /*  28025 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(28092), // Rule ID 1821 //
     /*  28030 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28033 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28037 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  28049 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28053 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28057 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28059 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  28066 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  28073 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rn), (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UMLALv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  28073 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i16_v4i32),
     /*  28076 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28078 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28080 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  28085 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  28090 */     GIR_RootConstrainSelectedInstOperands,
     /*  28091 */     // GIR_Coverage, 1821,
     /*  28091 */     GIR_EraseRootFromParent_Done,
     /*  28092 */   // Label 445: @28092
     /*  28092 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(28173), // Rule ID 13688 //
     /*  28097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28100 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  28112 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28116 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28120 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28124 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28127 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  28132 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28136 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  28140 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28145 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28150 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28154 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28156 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  28156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i16_v4i32),
     /*  28159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28161 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  28167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  28171 */     GIR_RootConstrainSelectedInstOperands,
     /*  28172 */     // GIR_Coverage, 13688,
     /*  28172 */     GIR_EraseRootFromParent_Done,
     /*  28173 */   // Label 446: @28173
     /*  28173 */   GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(28254), // Rule ID 13716 //
     /*  28178 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28181 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28185 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28189 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  28193 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28197 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28201 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28205 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28208 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  28213 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28217 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  28221 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28226 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28231 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28235 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28237 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)), V128:{ *:[v4i32] }:$Rd)  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  28237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i16_v4i32),
     /*  28240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28242 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28244 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  28248 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  28252 */     GIR_RootConstrainSelectedInstOperands,
     /*  28253 */     // GIR_Coverage, 13716,
     /*  28253 */     GIR_EraseRootFromParent_Done,
     /*  28254 */   // Label 447: @28254
     /*  28254 */   GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(28335), // Rule ID 1697 //
     /*  28259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28266 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28270 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28274 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  28278 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28282 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28286 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28290 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28293 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  28298 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28302 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  28306 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28311 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28316 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28318 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 669:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (SABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  28318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv4i16_v4i32),
     /*  28321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28323 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28325 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  28329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  28333 */     GIR_RootConstrainSelectedInstOperands,
     /*  28334 */     // GIR_Coverage, 1697,
     /*  28334 */     GIR_EraseRootFromParent_Done,
     /*  28335 */   // Label 448: @28335
     /*  28335 */   GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(28416), // Rule ID 1775 //
     /*  28340 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28343 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28347 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28351 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28355 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  28359 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28363 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28367 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28371 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28374 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  28379 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28383 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v4s16,
     /*  28387 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28392 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28397 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28399 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (zext:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i16] } 734:{ *:[iPTR] }, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)))  =>  (UABALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  28399 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv4i16_v4i32),
     /*  28402 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28404 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28406 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  28410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  28414 */     GIR_RootConstrainSelectedInstOperands,
     /*  28415 */     // GIR_Coverage, 1775,
     /*  28415 */     GIR_EraseRootFromParent_Done,
     /*  28416 */   // Label 449: @28416
     /*  28416 */   GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(28508), // Rule ID 13782 //
     /*  28421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28424 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28428 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28432 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  28436 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28440 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28444 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28448 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28452 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28456 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28460 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28465 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28469 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28473 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28477 */     // MIs[3] Operand 1
     /*  28477 */     // No operand predicates
     /*  28477 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28482 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28486 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28488 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  28491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28493 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  28499 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28503 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28506 */     GIR_RootConstrainSelectedInstOperands,
     /*  28507 */     // GIR_Coverage, 13782,
     /*  28507 */     GIR_EraseRootFromParent_Done,
     /*  28508 */   // Label 450: @28508
     /*  28508 */   GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(28600), // Rule ID 13781 //
     /*  28513 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28520 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28524 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  28528 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28532 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28536 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28541 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28545 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28549 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28553 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28557 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28562 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28566 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28570 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28574 */     // MIs[3] Operand 1
     /*  28574 */     // No operand predicates
     /*  28574 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28578 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28580 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28580 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  28583 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28585 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28587 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  28591 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28595 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28598 */     GIR_RootConstrainSelectedInstOperands,
     /*  28599 */     // GIR_Coverage, 13781,
     /*  28599 */     GIR_EraseRootFromParent_Done,
     /*  28600 */   // Label 451: @28600
     /*  28600 */   GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(28692), // Rule ID 13818 //
     /*  28605 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28608 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28612 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28616 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  28620 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28624 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28628 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28632 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28636 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28640 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28644 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28649 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28653 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28657 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28661 */     // MIs[3] Operand 1
     /*  28661 */     // No operand predicates
     /*  28661 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28666 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28670 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28672 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28672 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  28675 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28677 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28679 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  28683 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28687 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28690 */     GIR_RootConstrainSelectedInstOperands,
     /*  28691 */     // GIR_Coverage, 13818,
     /*  28691 */     GIR_EraseRootFromParent_Done,
     /*  28692 */   // Label 452: @28692
     /*  28692 */   GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(28784), // Rule ID 13817 //
     /*  28697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28700 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28704 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28708 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  28712 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28716 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28720 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28725 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28729 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28733 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28737 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28741 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28746 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28750 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28754 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28758 */     // MIs[3] Operand 1
     /*  28758 */     // No operand predicates
     /*  28758 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28762 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28764 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  28767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28769 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  28771 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  28775 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28779 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28782 */     GIR_RootConstrainSelectedInstOperands,
     /*  28783 */     // GIR_Coverage, 13817,
     /*  28783 */     GIR_EraseRootFromParent_Done,
     /*  28784 */   // Label 453: @28784
     /*  28784 */   GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(28876), // Rule ID 13780 //
     /*  28789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28792 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28796 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  28808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28812 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28816 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28820 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28824 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28828 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28832 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28837 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28841 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28845 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28849 */     // MIs[3] Operand 1
     /*  28849 */     // No operand predicates
     /*  28849 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28854 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28856 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  28859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28861 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28863 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  28867 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28871 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28874 */     GIR_RootConstrainSelectedInstOperands,
     /*  28875 */     // GIR_Coverage, 13780,
     /*  28875 */     GIR_EraseRootFromParent_Done,
     /*  28876 */   // Label 454: @28876
     /*  28876 */   GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(28968), // Rule ID 2042 //
     /*  28881 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28884 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28888 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28892 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28896 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  28900 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28904 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  28908 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  28913 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  28917 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  28921 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28925 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28929 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  28934 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28938 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  28942 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  28946 */     // MIs[3] Operand 1
     /*  28946 */     // No operand predicates
     /*  28946 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  28948 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (SMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  28948 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_indexed),
     /*  28951 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28953 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  28955 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  28959 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  28963 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  28966 */     GIR_RootConstrainSelectedInstOperands,
     /*  28967 */     // GIR_Coverage, 2042,
     /*  28967 */     GIR_EraseRootFromParent_Done,
     /*  28968 */   // Label 455: @28968
     /*  28968 */   GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(29060), // Rule ID 13816 //
     /*  28973 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28976 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28980 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  28984 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28988 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  28992 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28996 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  29000 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29004 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  29008 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29012 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  29016 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  29021 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29025 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29029 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  29033 */     // MIs[3] Operand 1
     /*  29033 */     // No operand predicates
     /*  29033 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  29038 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  29040 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx), V64:{ *:[v4i16] }:$Rn))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  29040 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  29043 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29045 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  29047 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29051 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  29055 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  29058 */     GIR_RootConstrainSelectedInstOperands,
     /*  29059 */     // GIR_Coverage, 13816,
     /*  29059 */     GIR_EraseRootFromParent_Done,
     /*  29060 */   // Label 456: @29060
     /*  29060 */   GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(29152), // Rule ID 2094 //
     /*  29065 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29068 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29072 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  29084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  29092 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  29097 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  29101 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_DUPLANE16),
     /*  29105 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29109 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  29113 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128_loRegClassID),
     /*  29118 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29122 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29126 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_VectorIndexH),
     /*  29130 */     // MIs[3] Operand 1
     /*  29130 */     // No operand predicates
     /*  29130 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  29132 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, (AArch64duplane16:{ *:[v4i16] } V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] })<<P:Predicate_VectorIndexH>>:$idx)))  =>  (UMLALv4i16_indexed:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V128_lo:{ *:[v8i16] }:$Rm, (imm:{ *:[i64] }):$idx)
     /*  29132 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_indexed),
     /*  29135 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29137 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  29139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  29143 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  29147 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // idx
     /*  29150 */     GIR_RootConstrainSelectedInstOperands,
     /*  29151 */     // GIR_Coverage, 2094,
     /*  29151 */     GIR_EraseRootFromParent_Done,
     /*  29152 */   // Label 457: @29152
     /*  29152 */   GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(29203), // Rule ID 13730 //
     /*  29157 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29160 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29164 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29168 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  29172 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29176 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29180 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29182 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29189 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29189 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
     /*  29192 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29194 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  29196 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29201 */     GIR_RootConstrainSelectedInstOperands,
     /*  29202 */     // GIR_Coverage, 13730,
     /*  29202 */     GIR_EraseRootFromParent_Done,
     /*  29203 */   // Label 458: @29203
     /*  29203 */   GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(29254), // Rule ID 13698 //
     /*  29208 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29211 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29215 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29219 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  29223 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29227 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29231 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29233 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29240 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29240 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i16_v4i32),
     /*  29243 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29245 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  29247 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29252 */     GIR_RootConstrainSelectedInstOperands,
     /*  29253 */     // GIR_Coverage, 13698,
     /*  29253 */     GIR_EraseRootFromParent_Done,
     /*  29254 */   // Label 459: @29254
     /*  29254 */   GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(29305), // Rule ID 13729 //
     /*  29259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29262 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29266 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29270 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  29274 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29278 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29282 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29284 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29291 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29291 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
     /*  29294 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29296 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  29298 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29303 */     GIR_RootConstrainSelectedInstOperands,
     /*  29304 */     // GIR_Coverage, 13729,
     /*  29304 */     GIR_EraseRootFromParent_Done,
     /*  29305 */   // Label 460: @29305
     /*  29305 */   GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(29356), // Rule ID 1813 //
     /*  29310 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29313 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29317 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29321 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29325 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  29329 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29333 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29335 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29342 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29342 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
     /*  29345 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29347 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  29349 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29354 */     GIR_RootConstrainSelectedInstOperands,
     /*  29355 */     // GIR_Coverage, 1813,
     /*  29355 */     GIR_EraseRootFromParent_Done,
     /*  29356 */   // Label 461: @29356
     /*  29356 */   GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(29407), // Rule ID 1725 //
     /*  29361 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29364 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29368 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29372 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29376 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  29380 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29384 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29386 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29393 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (SADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29393 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i16_v4i32),
     /*  29396 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29398 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  29400 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29405 */     GIR_RootConstrainSelectedInstOperands,
     /*  29406 */     // GIR_Coverage, 1725,
     /*  29406 */     GIR_EraseRootFromParent_Done,
     /*  29407 */   // Label 462: @29407
     /*  29407 */   GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(29458), // Rule ID 1812 //
     /*  29412 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29415 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29419 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29423 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29427 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  29431 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  29435 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29437 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v8i16),
     /*  29444 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } (extract_high_v8i16:{ *:[v4i16] } V128:{ *:[v8i16] }:$Rm)))  =>  (UADDWv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  29444 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i16_v4i32),
     /*  29447 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  29449 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  29451 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  29456 */     GIR_RootConstrainSelectedInstOperands,
     /*  29457 */     // GIR_Coverage, 1812,
     /*  29457 */     GIR_EraseRootFromParent_Done,
     /*  29458 */   // Label 463: @29458
     /*  29458 */   GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(29527), // Rule ID 13652 //
     /*  29463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29466 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29470 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29474 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29478 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  29481 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  29486 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29490 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
     /*  29494 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29499 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29504 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29508 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29510 */     // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 669:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  29510 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i32),
     /*  29513 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29515 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29517 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29521 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  29525 */     GIR_RootConstrainSelectedInstOperands,
     /*  29526 */     // GIR_Coverage, 13652,
     /*  29526 */     GIR_EraseRootFromParent_Done,
     /*  29527 */   // Label 464: @29527
     /*  29527 */   GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(29596), // Rule ID 13664 //
     /*  29532 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29535 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29539 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29543 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29547 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  29550 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  29555 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29559 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
     /*  29563 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29568 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29573 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29577 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29579 */     // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 734:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  29579 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i32),
     /*  29582 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29584 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29586 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  29594 */     GIR_RootConstrainSelectedInstOperands,
     /*  29595 */     // GIR_Coverage, 13664,
     /*  29595 */     GIR_EraseRootFromParent_Done,
     /*  29596 */   // Label 465: @29596
     /*  29596 */   GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(29652), // Rule ID 13614 //
     /*  29601 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29604 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29608 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29612 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29616 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  29619 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  29624 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  29628 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29633 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29637 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29639 */     // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 670:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  29639 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
     /*  29642 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29644 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29646 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29650 */     GIR_RootConstrainSelectedInstOperands,
     /*  29651 */     // GIR_Coverage, 13614,
     /*  29651 */     GIR_EraseRootFromParent_Done,
     /*  29652 */   // Label 466: @29652
     /*  29652 */   GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(29708), // Rule ID 13626 //
     /*  29657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29664 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29668 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29672 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  29675 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  29680 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  29684 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29689 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29695 */     // (add:{ *:[v4i32] } (intrinsic_wo_chain:{ *:[v4i32] } 735:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  29695 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
     /*  29698 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29700 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29706 */     GIR_RootConstrainSelectedInstOperands,
     /*  29707 */     // GIR_Coverage, 13626,
     /*  29707 */     GIR_EraseRootFromParent_Done,
     /*  29708 */   // Label 467: @29708
     /*  29708 */   GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(29775), // Rule ID 13866 //
     /*  29713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29720 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29724 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  29728 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29732 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29737 */     // MIs[1] imm
     /*  29737 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  29741 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29745 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  29749 */     // MIs[2] Operand 1
     /*  29749 */     // No operand predicates
     /*  29749 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29753 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  29757 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  29759 */     // (add:{ *:[v4i32] } (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  29759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i32_shift),
     /*  29762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29764 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  29770 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  29773 */     GIR_RootConstrainSelectedInstOperands,
     /*  29774 */     // GIR_Coverage, 13866,
     /*  29774 */     GIR_EraseRootFromParent_Done,
     /*  29775 */   // Label 468: @29775
     /*  29775 */   GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(29842), // Rule ID 13887 //
     /*  29780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29783 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29787 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29791 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  29795 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29799 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29804 */     // MIs[1] imm
     /*  29804 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  29808 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29812 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  29816 */     // MIs[2] Operand 1
     /*  29816 */     // No operand predicates
     /*  29816 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29820 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  29824 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  29826 */     // (add:{ *:[v4i32] } (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm), V128:{ *:[v4i32] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  29826 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i32_shift),
     /*  29829 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29831 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  29833 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  29837 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  29840 */     GIR_RootConstrainSelectedInstOperands,
     /*  29841 */     // GIR_Coverage, 13887,
     /*  29841 */     GIR_EraseRootFromParent_Done,
     /*  29842 */   // Label 469: @29842
     /*  29842 */   GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(29911), // Rule ID 1371 //
     /*  29847 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29850 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29854 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29858 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29862 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29866 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  29869 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  29874 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29878 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
     /*  29882 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29887 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29892 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29894 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 669:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (SABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  29894 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv4i32),
     /*  29897 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29899 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  29901 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29905 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  29909 */     GIR_RootConstrainSelectedInstOperands,
     /*  29910 */     // GIR_Coverage, 1371,
     /*  29910 */     GIR_EraseRootFromParent_Done,
     /*  29911 */   // Label 470: @29911
     /*  29911 */   GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(29980), // Rule ID 1494 //
     /*  29916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29919 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29923 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29927 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29931 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29935 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  29938 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  29943 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29947 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v4s32,
     /*  29951 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29956 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29961 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29963 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 734:{ *:[iPTR] }, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm))  =>  (UABAv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  29963 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv4i32),
     /*  29966 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29968 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  29970 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  29974 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  29978 */     GIR_RootConstrainSelectedInstOperands,
     /*  29979 */     // GIR_Coverage, 1494,
     /*  29979 */     GIR_EraseRootFromParent_Done,
     /*  29980 */   // Label 471: @29980
     /*  29980 */   GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(30036), // Rule ID 999 //
     /*  29985 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  29988 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29992 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  29996 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30000 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30004 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  30007 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  30012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  30016 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30021 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30023 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 670:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  30023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
     /*  30026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30028 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  30030 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  30034 */     GIR_RootConstrainSelectedInstOperands,
     /*  30035 */     // GIR_Coverage, 999,
     /*  30035 */     GIR_EraseRootFromParent_Done,
     /*  30036 */   // Label 472: @30036
     /*  30036 */   GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(30092), // Rule ID 1060 //
     /*  30041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30044 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30048 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30052 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30056 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30060 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  30063 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  30068 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  30072 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30077 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30079 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (intrinsic_wo_chain:{ *:[v4i32] } 735:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  30079 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
     /*  30082 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30084 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  30086 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  30090 */     GIR_RootConstrainSelectedInstOperands,
     /*  30091 */     // GIR_Coverage, 1060,
     /*  30091 */     GIR_EraseRootFromParent_Done,
     /*  30092 */   // Label 473: @30092
     /*  30092 */   GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(30159), // Rule ID 2244 //
     /*  30097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30100 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30104 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30108 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30112 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  30116 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30120 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30125 */     // MIs[1] imm
     /*  30125 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  30129 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  30133 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  30137 */     // MIs[2] Operand 1
     /*  30137 */     // No operand predicates
     /*  30137 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  30141 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30143 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vashr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  30143 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv4i32_shift),
     /*  30146 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30148 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  30150 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30154 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  30157 */     GIR_RootConstrainSelectedInstOperands,
     /*  30158 */     // GIR_Coverage, 2244,
     /*  30158 */     GIR_EraseRootFromParent_Done,
     /*  30159 */   // Label 474: @30159
     /*  30159 */   GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(30226), // Rule ID 2303 //
     /*  30164 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30167 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30171 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30175 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30179 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  30183 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30187 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30192 */     // MIs[1] imm
     /*  30192 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  30196 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  30200 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR32),
     /*  30204 */     // MIs[2] Operand 1
     /*  30204 */     // No operand predicates
     /*  30204 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  30208 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30210 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64vlshr:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR32>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv4i32_shift:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v4i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  30210 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv4i32_shift),
     /*  30213 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30215 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  30217 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30221 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  30224 */     GIR_RootConstrainSelectedInstOperands,
     /*  30225 */     // GIR_Coverage, 2303,
     /*  30225 */     GIR_EraseRootFromParent_Done,
     /*  30226 */   // Label 475: @30226
     /*  30226 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(30296), // Rule ID 7007 //
     /*  30231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30235 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30239 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UZP1),
     /*  30243 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30247 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30251 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30256 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30261 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30265 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP2),
     /*  30269 */     // MIs[2] Rn
     /*  30269 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  30274 */     // MIs[2] Rm
     /*  30274 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  30279 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30281 */     // (add:{ *:[v4i32] } (AArch64uzp1:{ *:[v4i32] } FPR128:{ *:[v4i32] }:$Rn, FPR128:{ *:[v4i32] }:$Rm), (AArch64uzp2:{ *:[v4i32] } FPR128:{ *:[v4i32] }:$Rn, FPR128:{ *:[v4i32] }:$Rm))  =>  (ADDPv4i32:{ *:[v4i32] } ?:{ *:[v4i32] }:$Rn, ?:{ *:[v4i32] }:$Rm)
     /*  30281 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv4i32),
     /*  30284 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30286 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30290 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  30294 */     GIR_RootConstrainSelectedInstOperands,
     /*  30295 */     // GIR_Coverage, 7007,
     /*  30295 */     GIR_EraseRootFromParent_Done,
     /*  30296 */   // Label 476: @30296
     /*  30296 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(30366), // Rule ID 14253 //
     /*  30301 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30305 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30309 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UZP2),
     /*  30313 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30317 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30321 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30326 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30331 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30335 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP1),
     /*  30339 */     // MIs[2] Rn
     /*  30339 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  30344 */     // MIs[2] Rm
     /*  30344 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  30349 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30351 */     // (add:{ *:[v4i32] } (AArch64uzp2:{ *:[v4i32] } FPR128:{ *:[v4i32] }:$Rn, FPR128:{ *:[v4i32] }:$Rm), (AArch64uzp1:{ *:[v4i32] } FPR128:{ *:[v4i32] }:$Rn, FPR128:{ *:[v4i32] }:$Rm))  =>  (ADDPv4i32:{ *:[v4i32] } ?:{ *:[v4i32] }:$Rn, ?:{ *:[v4i32] }:$Rm)
     /*  30351 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv4i32),
     /*  30354 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30360 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  30364 */     GIR_RootConstrainSelectedInstOperands,
     /*  30365 */     // GIR_Coverage, 14253,
     /*  30365 */     GIR_EraseRootFromParent_Done,
     /*  30366 */   // Label 477: @30366
     /*  30366 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(30429), // Rule ID 1793 //
     /*  30371 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30374 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30378 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30382 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  30386 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30390 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30395 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30399 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  30403 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30407 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30412 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30414 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30414 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  30417 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30419 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30423 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  30427 */     GIR_RootConstrainSelectedInstOperands,
     /*  30428 */     // GIR_Coverage, 1793,
     /*  30428 */     GIR_EraseRootFromParent_Done,
     /*  30429 */   // Label 478: @30429
     /*  30429 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(30492), // Rule ID 1792 //
     /*  30434 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30437 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30441 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30445 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  30449 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30453 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30458 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30462 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  30466 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30470 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30475 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30477 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  30480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30482 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  30490 */     GIR_RootConstrainSelectedInstOperands,
     /*  30491 */     // GIR_Coverage, 1792,
     /*  30491 */     GIR_EraseRootFromParent_Done,
     /*  30492 */   // Label 479: @30492
     /*  30492 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(30555), // Rule ID 1718 //
     /*  30497 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30500 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  30512 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30516 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30521 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30525 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  30529 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30533 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30538 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30540 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30540 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv4i16_v4i32),
     /*  30543 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30545 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30549 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  30553 */     GIR_RootConstrainSelectedInstOperands,
     /*  30554 */     // GIR_Coverage, 1718,
     /*  30554 */     GIR_EraseRootFromParent_Done,
     /*  30555 */   // Label 480: @30555
     /*  30555 */   GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(30618), // Rule ID 1791 //
     /*  30560 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30563 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30567 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30571 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  30575 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30579 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30584 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30588 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  30592 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30596 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30601 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30603 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30603 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  30606 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30608 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30612 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  30616 */     GIR_RootConstrainSelectedInstOperands,
     /*  30617 */     // GIR_Coverage, 1791,
     /*  30617 */     GIR_EraseRootFromParent_Done,
     /*  30618 */   // Label 481: @30618
     /*  30618 */   GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(30681), // Rule ID 1790 //
     /*  30623 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30626 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30630 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30634 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  30638 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30642 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30647 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  30651 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  30655 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30659 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30664 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  30666 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn), (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDLv4i16_v4i32:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30666 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv4i16_v4i32),
     /*  30669 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30671 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30675 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  30679 */     GIR_RootConstrainSelectedInstOperands,
     /*  30680 */     // GIR_Coverage, 1790,
     /*  30680 */     GIR_EraseRootFromParent_Done,
     /*  30681 */   // Label 482: @30681
     /*  30681 */   GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(30742), // Rule ID 13703 //
     /*  30686 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30689 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30693 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30697 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  30701 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30705 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  30709 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30714 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30719 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30723 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30725 */     // (add:{ *:[v4i32] } (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30725 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
     /*  30728 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30730 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  30732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30736 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  30740 */     GIR_RootConstrainSelectedInstOperands,
     /*  30741 */     // GIR_Coverage, 13703,
     /*  30741 */     GIR_EraseRootFromParent_Done,
     /*  30742 */   // Label 483: @30742
     /*  30742 */   GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(30803), // Rule ID 13737 //
     /*  30747 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30750 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30754 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30758 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  30762 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30766 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  30770 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30775 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30780 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30784 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30786 */     // (add:{ *:[v4i32] } (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rd)  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30786 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
     /*  30789 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30791 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  30793 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30797 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  30801 */     GIR_RootConstrainSelectedInstOperands,
     /*  30802 */     // GIR_Coverage, 13737,
     /*  30802 */     GIR_EraseRootFromParent_Done,
     /*  30803 */   // Label 484: @30803
     /*  30803 */   GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(30851), // Rule ID 13728 //
     /*  30808 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30811 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30815 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30819 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  30823 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30827 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30832 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30836 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30838 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30838 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  30841 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30843 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  30845 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  30849 */     GIR_RootConstrainSelectedInstOperands,
     /*  30850 */     // GIR_Coverage, 13728,
     /*  30850 */     GIR_EraseRootFromParent_Done,
     /*  30851 */   // Label 485: @30851
     /*  30851 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(30899), // Rule ID 13613 //
     /*  30856 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30859 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30863 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30867 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  30871 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30875 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30880 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30884 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30886 */     // (add:{ *:[v4i32] } (AArch64saddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  30886 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
     /*  30889 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30891 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  30893 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30897 */     GIR_RootConstrainSelectedInstOperands,
     /*  30898 */     // GIR_Coverage, 13613,
     /*  30898 */     GIR_EraseRootFromParent_Done,
     /*  30899 */   // Label 486: @30899
     /*  30899 */   GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(30947), // Rule ID 13697 //
     /*  30904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30907 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30911 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30915 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  30919 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30923 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  30928 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30932 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30934 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  30934 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
     /*  30937 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  30939 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  30941 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  30945 */     GIR_RootConstrainSelectedInstOperands,
     /*  30946 */     // GIR_Coverage, 13697,
     /*  30946 */     GIR_EraseRootFromParent_Done,
     /*  30947 */   // Label 487: @30947
     /*  30947 */   GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(30995), // Rule ID 13625 //
     /*  30952 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30955 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30959 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30963 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  30967 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30971 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30976 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  30980 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30982 */     // (add:{ *:[v4i32] } (AArch64uaddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn), V128:{ *:[v4i32] }:$Rd)  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  30982 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
     /*  30985 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30987 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  30989 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  30993 */     GIR_RootConstrainSelectedInstOperands,
     /*  30994 */     // GIR_Coverage, 13625,
     /*  30994 */     GIR_EraseRootFromParent_Done,
     /*  30995 */   // Label 488: @30995
     /*  30995 */   GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(31043), // Rule ID 13727 //
     /*  31000 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31003 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31007 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31011 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  31015 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31019 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31024 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31028 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31030 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm), V128:{ *:[v4i32] }:$Rn)  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31030 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  31033 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  31035 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  31037 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  31041 */     GIR_RootConstrainSelectedInstOperands,
     /*  31042 */     // GIR_Coverage, 13727,
     /*  31042 */     GIR_EraseRootFromParent_Done,
     /*  31043 */   // Label 489: @31043
     /*  31043 */   GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(31104), // Rule ID 1730 //
     /*  31048 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31051 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31055 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31059 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31063 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  31067 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31071 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  31075 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31080 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31085 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31087 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64smull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (SMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31087 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv4i16_v4i32),
     /*  31090 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31092 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  31094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31098 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  31102 */     GIR_RootConstrainSelectedInstOperands,
     /*  31103 */     // GIR_Coverage, 1730,
     /*  31103 */     GIR_EraseRootFromParent_Done,
     /*  31104 */   // Label 490: @31104
     /*  31104 */   GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(31165), // Rule ID 1820 //
     /*  31109 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31112 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31116 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31120 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31124 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  31128 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31132 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  31136 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31141 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31146 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31148 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64umull:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm))  =>  (UMLALv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V64:{ *:[v4i16] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31148 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv4i16_v4i32),
     /*  31151 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31153 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  31155 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31159 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  31163 */     GIR_RootConstrainSelectedInstOperands,
     /*  31164 */     // GIR_Coverage, 1820,
     /*  31164 */     GIR_EraseRootFromParent_Done,
     /*  31165 */   // Label 491: @31165
     /*  31165 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(31213), // Rule ID 1811 //
     /*  31170 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31173 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31177 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31181 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31185 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  31189 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31193 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31198 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31200 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (anyext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31200 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  31203 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  31205 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  31207 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  31211 */     GIR_RootConstrainSelectedInstOperands,
     /*  31212 */     // GIR_Coverage, 1811,
     /*  31212 */     GIR_EraseRootFromParent_Done,
     /*  31213 */   // Label 492: @31213
     /*  31213 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(31261), // Rule ID 998 //
     /*  31218 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31221 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31225 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31229 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31233 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  31237 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31241 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31246 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31248 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64saddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn))  =>  (SADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  31248 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv8i16_v4i32),
     /*  31251 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31253 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  31255 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31259 */     GIR_RootConstrainSelectedInstOperands,
     /*  31260 */     // GIR_Coverage, 998,
     /*  31260 */     GIR_EraseRootFromParent_Done,
     /*  31261 */   // Label 493: @31261
     /*  31261 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(31309), // Rule ID 1724 //
     /*  31266 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31269 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31273 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31277 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31281 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  31285 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31289 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31294 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31296 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (sext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (SADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31296 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv4i16_v4i32),
     /*  31299 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  31301 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  31303 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  31307 */     GIR_RootConstrainSelectedInstOperands,
     /*  31308 */     // GIR_Coverage, 1724,
     /*  31308 */     GIR_EraseRootFromParent_Done,
     /*  31309 */   // Label 494: @31309
     /*  31309 */   GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(31357), // Rule ID 1059 //
     /*  31314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31317 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31321 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31325 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31329 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  31333 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31337 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31342 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31344 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, (AArch64uaddlp_n:{ *:[v4i32] } V128:{ *:[v8i16] }:$Rn))  =>  (UADALPv8i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rd, V128:{ *:[v8i16] }:$Rn)
     /*  31344 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv8i16_v4i32),
     /*  31347 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31349 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  31351 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31355 */     GIR_RootConstrainSelectedInstOperands,
     /*  31356 */     // GIR_Coverage, 1059,
     /*  31356 */     GIR_EraseRootFromParent_Done,
     /*  31357 */   // Label 495: @31357
     /*  31357 */   GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(31405), // Rule ID 1810 //
     /*  31362 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31365 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31369 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31373 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31377 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  31381 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  31385 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31390 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31392 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, (zext:{ *:[v4i32] } V64:{ *:[v4i16] }:$Rm))  =>  (UADDWv4i16_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V64:{ *:[v4i16] }:$Rm)
     /*  31392 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv4i16_v4i32),
     /*  31395 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  31397 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  31399 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  31403 */     GIR_RootConstrainSelectedInstOperands,
     /*  31404 */     // GIR_Coverage, 1810,
     /*  31404 */     GIR_EraseRootFromParent_Done,
     /*  31405 */   // Label 496: @31405
     /*  31405 */   GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(31432), // Rule ID 1109 //
     /*  31410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31413 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31417 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31421 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31425 */     // (add:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)  =>  (ADDv4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$Rn, V128:{ *:[v4i32] }:$Rm)
     /*  31425 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv4i32),
     /*  31430 */     GIR_RootConstrainSelectedInstOperands,
     /*  31431 */     // GIR_Coverage, 1109,
     /*  31431 */     GIR_Done,
     /*  31432 */   // Label 497: @31432
     /*  31432 */   GIM_Reject,
     /*  31433 */ // Label 416: @31433
     /*  31433 */ GIM_Reject,
     /*  31434 */ // Label 162: @31434
     /*  31434 */ GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(32283),
     /*  31439 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  31442 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  31445 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(31578), // Rule ID 14258 //
     /*  31450 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31454 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31458 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  31462 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31466 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31470 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP2),
     /*  31474 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31478 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  31482 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31487 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  31491 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /*  31495 */     // MIs[1] Operand 2
     /*  31495 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(0),
     /*  31506 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  31510 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  31514 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31518 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  31522 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /*  31526 */     // MIs[5] Rn
     /*  31526 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  31531 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  31533 */     // (add:{ *:[v8i8] } (extract_subvector:{ *:[v8i8] } (AArch64uzp2:{ *:[v16i8] } FPR128:{ *:[v16i8] }:$Rn, (undef:{ *:[v16i8] })), 0:{ *:[i64] }), (trunc:{ *:[v8i8] } (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$Rn)))  =>  (EXTRACT_SUBREG:{ *:[v8i8] } (ADDPv16i8:{ *:[f128] } ?:{ *:[v16i8] }:$Rn, ?:{ *:[v16i8] }:$Rn), dsub:{ *:[i32] })
     /*  31533 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  31536 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv16i8),
     /*  31540 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  31545 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  31549 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  31553 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  31555 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31558 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31560 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  31567 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31572 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31577 */     // GIR_Coverage, 14258,
     /*  31577 */     GIR_EraseRootFromParent_Done,
     /*  31578 */   // Label 499: @31578
     /*  31578 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(31711), // Rule ID 7012 //
     /*  31583 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31587 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31591 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  31595 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31599 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31603 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /*  31607 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31611 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31616 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  31620 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_EXTRACT_SUBVECTOR),
     /*  31624 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31628 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  31632 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AArch64::G_UZP2),
     /*  31636 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  31640 */     // MIs[4] Rn
     /*  31640 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  31645 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  31649 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /*  31653 */     // MIs[3] Operand 2
     /*  31653 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(0),
     /*  31664 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  31666 */     // (add:{ *:[v8i8] } (trunc:{ *:[v8i8] } (bitconvert:{ *:[v8i16] } FPR128:{ *:[v16i8] }:$Rn)), (extract_subvector:{ *:[v8i8] } (AArch64uzp2:{ *:[v16i8] } FPR128:{ *:[v16i8] }:$Rn, (undef:{ *:[v16i8] })), 0:{ *:[i64] }))  =>  (EXTRACT_SUBREG:{ *:[v8i8] } (ADDPv16i8:{ *:[f128] } ?:{ *:[v16i8] }:$Rn, ?:{ *:[v16i8] }:$Rn), dsub:{ *:[i32] })
     /*  31666 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
     /*  31669 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AArch64::ADDPv16i8),
     /*  31673 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  31678 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  31682 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  31686 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  31688 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31691 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31693 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AArch64::dsub),
     /*  31700 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31705 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  31710 */     // GIR_Coverage, 7012,
     /*  31710 */     GIR_EraseRootFromParent_Done,
     /*  31711 */   // Label 500: @31711
     /*  31711 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(31780), // Rule ID 13642 //
     /*  31716 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31719 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31723 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31727 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31731 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  31734 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  31739 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  31743 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  31747 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31752 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31757 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31761 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31763 */     // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  31763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i8),
     /*  31766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31768 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  31770 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  31774 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  31778 */     GIR_RootConstrainSelectedInstOperands,
     /*  31779 */     // GIR_Coverage, 13642,
     /*  31779 */     GIR_EraseRootFromParent_Done,
     /*  31780 */   // Label 501: @31780
     /*  31780 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(31849), // Rule ID 13654 //
     /*  31785 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31792 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31796 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31800 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  31803 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  31808 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  31812 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  31816 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31821 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31826 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31830 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31832 */     // (add:{ *:[v8i8] } (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V64:{ *:[v8i8] }:$Rd)  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  31832 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i8),
     /*  31835 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31837 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  31839 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  31843 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  31847 */     GIR_RootConstrainSelectedInstOperands,
     /*  31848 */     // GIR_Coverage, 13654,
     /*  31848 */     GIR_EraseRootFromParent_Done,
     /*  31849 */   // Label 502: @31849
     /*  31849 */   GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(31916), // Rule ID 13856 //
     /*  31854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31857 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31861 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31865 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  31869 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  31873 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31878 */     // MIs[1] imm
     /*  31878 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  31882 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  31886 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
     /*  31890 */     // MIs[2] Operand 1
     /*  31890 */     // No operand predicates
     /*  31890 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31894 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  31898 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  31900 */     // (add:{ *:[v8i8] } (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  31900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i8_shift),
     /*  31903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31905 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  31907 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31911 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  31914 */     GIR_RootConstrainSelectedInstOperands,
     /*  31915 */     // GIR_Coverage, 13856,
     /*  31915 */     GIR_EraseRootFromParent_Done,
     /*  31916 */   // Label 503: @31916
     /*  31916 */   GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(31983), // Rule ID 13877 //
     /*  31921 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31924 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31928 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31932 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  31936 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  31940 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31945 */     // MIs[1] imm
     /*  31945 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  31949 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  31953 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
     /*  31957 */     // MIs[2] Operand 1
     /*  31957 */     // No operand predicates
     /*  31957 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31961 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  31965 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  31967 */     // (add:{ *:[v8i8] } (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm), V64:{ *:[v8i8] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  31967 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i8_shift),
     /*  31970 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31972 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  31974 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  31978 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  31981 */     GIR_RootConstrainSelectedInstOperands,
     /*  31982 */     // GIR_Coverage, 13877,
     /*  31982 */     GIR_EraseRootFromParent_Done,
     /*  31983 */   // Label 504: @31983
     /*  31983 */   GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(32052), // Rule ID 1361 //
     /*  31988 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  31991 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31995 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  31999 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32003 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32007 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32010 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  32015 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32019 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32023 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32028 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32033 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32035 */     // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  32035 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i8),
     /*  32038 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32040 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  32046 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  32050 */     GIR_RootConstrainSelectedInstOperands,
     /*  32051 */     // GIR_Coverage, 1361,
     /*  32051 */     GIR_EraseRootFromParent_Done,
     /*  32052 */   // Label 505: @32052
     /*  32052 */   GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(32121), // Rule ID 1484 //
     /*  32057 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32060 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32064 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32068 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32072 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32076 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32079 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  32084 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32088 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32092 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32097 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32102 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32104 */     // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UABAv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  32104 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i8),
     /*  32107 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32109 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  32115 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  32119 */     GIR_RootConstrainSelectedInstOperands,
     /*  32120 */     // GIR_Coverage, 1484,
     /*  32120 */     GIR_EraseRootFromParent_Done,
     /*  32121 */   // Label 506: @32121
     /*  32121 */   GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(32188), // Rule ID 2234 //
     /*  32126 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32129 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32133 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  32145 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32149 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32154 */     // MIs[1] imm
     /*  32154 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32158 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  32162 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
     /*  32166 */     // MIs[2] Operand 1
     /*  32166 */     // No operand predicates
     /*  32166 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  32170 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32172 */     // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vashr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  32172 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i8_shift),
     /*  32175 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32177 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32179 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  32183 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  32186 */     GIR_RootConstrainSelectedInstOperands,
     /*  32187 */     // GIR_Coverage, 2234,
     /*  32187 */     GIR_EraseRootFromParent_Done,
     /*  32188 */   // Label 507: @32188
     /*  32188 */   GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(32255), // Rule ID 2293 //
     /*  32193 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32196 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32200 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32204 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32208 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  32212 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32216 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32221 */     // MIs[1] imm
     /*  32221 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32225 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  32229 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR8),
     /*  32233 */     // MIs[2] Operand 1
     /*  32233 */     // No operand predicates
     /*  32233 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  32237 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32239 */     // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, (AArch64vlshr:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR8>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i8_shift:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rd, V64:{ *:[v8i8] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  32239 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i8_shift),
     /*  32242 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32244 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  32250 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  32253 */     GIR_RootConstrainSelectedInstOperands,
     /*  32254 */     // GIR_Coverage, 2293,
     /*  32254 */     GIR_EraseRootFromParent_Done,
     /*  32255 */   // Label 508: @32255
     /*  32255 */   GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(32282), // Rule ID 1104 //
     /*  32260 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32263 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32267 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32271 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  32275 */     // (add:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)  =>  (ADDv8i8:{ *:[v8i8] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  32275 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AArch64::ADDv8i8),
     /*  32280 */     GIR_RootConstrainSelectedInstOperands,
     /*  32281 */     // GIR_Coverage, 1104,
     /*  32281 */     GIR_Done,
     /*  32282 */   // Label 509: @32282
     /*  32282 */   GIM_Reject,
     /*  32283 */ // Label 498: @32283
     /*  32283 */ GIM_Reject,
     /*  32284 */ // Label 163: @32284
     /*  32284 */ GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(35861),
     /*  32289 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32292 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  32295 */   GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(32382), // Rule ID 13686 //
     /*  32300 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32303 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32307 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32311 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32315 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32319 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32323 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32327 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32330 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  32335 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32339 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32343 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32347 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32349 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32356 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32363 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32363 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv16i8_v8i16),
     /*  32366 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32368 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  32370 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32375 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32380 */     GIR_RootConstrainSelectedInstOperands,
     /*  32381 */     // GIR_Coverage, 13686,
     /*  32381 */     GIR_EraseRootFromParent_Done,
     /*  32382 */   // Label 511: @32382
     /*  32382 */   GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(32469), // Rule ID 13714 //
     /*  32387 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32390 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32402 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32406 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32410 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32414 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32417 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  32422 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32426 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32430 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32434 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32436 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32443 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32450 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32450 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv16i8_v8i16),
     /*  32453 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32455 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  32457 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32462 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32467 */     GIR_RootConstrainSelectedInstOperands,
     /*  32468 */     // GIR_Coverage, 13714,
     /*  32468 */     GIR_EraseRootFromParent_Done,
     /*  32469 */   // Label 512: @32469
     /*  32469 */   GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(32556), // Rule ID 1695 //
     /*  32474 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32477 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32481 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32485 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32489 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32493 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32497 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32501 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32505 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32508 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  32513 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32517 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32521 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32523 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32530 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32537 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))))  =>  (SABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32537 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv16i8_v8i16),
     /*  32540 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32542 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32544 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32549 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32554 */     GIR_RootConstrainSelectedInstOperands,
     /*  32555 */     // GIR_Coverage, 1695,
     /*  32555 */     GIR_EraseRootFromParent_Done,
     /*  32556 */   // Label 513: @32556
     /*  32556 */   GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(32643), // Rule ID 1773 //
     /*  32561 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32564 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32568 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32572 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32576 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32580 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32584 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32588 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32592 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32595 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  32600 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  32604 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  32608 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32610 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32617 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/3, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32624 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm))))  =>  (UABALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv16i8_v8i16),
     /*  32627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32629 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  32631 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32636 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32641 */     GIR_RootConstrainSelectedInstOperands,
     /*  32642 */     // GIR_Coverage, 1773,
     /*  32642 */     GIR_EraseRootFromParent_Done,
     /*  32643 */   // Label 514: @32643
     /*  32643 */   GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(32712), // Rule ID 1789 //
     /*  32648 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32651 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32655 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32659 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  32663 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32667 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  32671 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  32675 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32679 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32681 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32688 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32695 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32695 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
     /*  32698 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  32700 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32705 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32710 */     GIR_RootConstrainSelectedInstOperands,
     /*  32711 */     // GIR_Coverage, 1789,
     /*  32711 */     GIR_EraseRootFromParent_Done,
     /*  32712 */   // Label 515: @32712
     /*  32712 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(32781), // Rule ID 1788 //
     /*  32717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  32732 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32736 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  32740 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32744 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32748 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32750 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32757 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32764 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
     /*  32767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  32769 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32774 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32779 */     GIR_RootConstrainSelectedInstOperands,
     /*  32780 */     // GIR_Coverage, 1788,
     /*  32780 */     GIR_EraseRootFromParent_Done,
     /*  32781 */   // Label 516: @32781
     /*  32781 */   GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(32850), // Rule ID 1717 //
     /*  32786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32789 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32793 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32797 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  32801 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32805 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  32809 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  32813 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32817 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32819 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32826 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32833 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32833 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv16i8_v8i16),
     /*  32836 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  32838 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32843 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32848 */     GIR_RootConstrainSelectedInstOperands,
     /*  32849 */     // GIR_Coverage, 1717,
     /*  32849 */     GIR_EraseRootFromParent_Done,
     /*  32850 */   // Label 517: @32850
     /*  32850 */   GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(32919), // Rule ID 1787 //
     /*  32855 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32858 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32862 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32866 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32870 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32874 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  32878 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  32882 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32886 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32888 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32895 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32902 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32902 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
     /*  32905 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  32907 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32912 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32917 */     GIR_RootConstrainSelectedInstOperands,
     /*  32918 */     // GIR_Coverage, 1787,
     /*  32918 */     GIR_EraseRootFromParent_Done,
     /*  32919 */   // Label 518: @32919
     /*  32919 */   GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(32988), // Rule ID 1786 //
     /*  32924 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32927 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  32931 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32935 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32939 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32943 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  32947 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  32951 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  32955 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  32957 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32964 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  32971 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn)), (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDLv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  32971 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv16i8_v8i16),
     /*  32974 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  32976 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  32981 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  32986 */     GIR_RootConstrainSelectedInstOperands,
     /*  32987 */     // GIR_Coverage, 1786,
     /*  32987 */     GIR_EraseRootFromParent_Done,
     /*  32988 */   // Label 519: @32988
     /*  32988 */   GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(33055), // Rule ID 13702 //
     /*  32993 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  33008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33016 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33020 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33022 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33029 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33036 */     // (add:{ *:[v8i16] } (AArch64smull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33036 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv16i8_v8i16),
     /*  33039 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33041 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  33043 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  33048 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  33053 */     GIR_RootConstrainSelectedInstOperands,
     /*  33054 */     // GIR_Coverage, 13702,
     /*  33054 */     GIR_EraseRootFromParent_Done,
     /*  33055 */   // Label 520: @33055
     /*  33055 */   GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(33122), // Rule ID 13736 //
     /*  33060 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33063 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33067 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33071 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  33075 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33079 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33083 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33087 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33089 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33096 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33103 */     // (add:{ *:[v8i16] } (AArch64umull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv16i8_v8i16),
     /*  33106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33108 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  33110 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  33115 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  33120 */     GIR_RootConstrainSelectedInstOperands,
     /*  33121 */     // GIR_Coverage, 13736,
     /*  33121 */     GIR_EraseRootFromParent_Done,
     /*  33122 */   // Label 521: @33122
     /*  33122 */   GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(33189), // Rule ID 1729 //
     /*  33127 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33130 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33134 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33138 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33142 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  33146 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33150 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33154 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33156 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33163 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33170 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33170 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv16i8_v8i16),
     /*  33173 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33175 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  33177 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  33182 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  33187 */     GIR_RootConstrainSelectedInstOperands,
     /*  33188 */     // GIR_Coverage, 1729,
     /*  33188 */     GIR_EraseRootFromParent_Done,
     /*  33189 */   // Label 522: @33189
     /*  33189 */   GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(33256), // Rule ID 1819 //
     /*  33194 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33197 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33201 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33205 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33209 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  33213 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33217 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33221 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33223 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33230 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33237 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rn), (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UMLALv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv16i8_v8i16),
     /*  33240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33242 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  33244 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rn
     /*  33249 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // Rm
     /*  33254 */     GIR_RootConstrainSelectedInstOperands,
     /*  33255 */     // GIR_Coverage, 1819,
     /*  33255 */     GIR_EraseRootFromParent_Done,
     /*  33256 */   // Label 523: @33256
     /*  33256 */   GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(33337), // Rule ID 13684 //
     /*  33261 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33264 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33268 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33272 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33276 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33280 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33284 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33288 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33291 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  33296 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33300 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  33304 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33309 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33314 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33318 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  33320 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  33320 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i8_v8i16),
     /*  33323 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33325 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  33327 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  33331 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  33335 */     GIR_RootConstrainSelectedInstOperands,
     /*  33336 */     // GIR_Coverage, 13684,
     /*  33336 */     GIR_EraseRootFromParent_Done,
     /*  33337 */   // Label 524: @33337
     /*  33337 */   GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(33418), // Rule ID 13712 //
     /*  33342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33345 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33349 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33353 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33357 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33361 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33365 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33369 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33372 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  33377 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33381 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  33385 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33390 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33395 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33399 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  33401 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)), V128:{ *:[v8i16] }:$Rd)  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  33401 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i8_v8i16),
     /*  33404 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33406 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  33408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  33412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  33416 */     GIR_RootConstrainSelectedInstOperands,
     /*  33417 */     // GIR_Coverage, 13712,
     /*  33417 */     GIR_EraseRootFromParent_Done,
     /*  33418 */   // Label 525: @33418
     /*  33418 */   GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(33499), // Rule ID 1693 //
     /*  33423 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33426 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33430 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33434 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33438 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33442 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33446 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33450 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33454 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33457 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  33462 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33466 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  33470 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33475 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33480 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  33482 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 669:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (SABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  33482 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABALv8i8_v8i16),
     /*  33485 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33487 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  33489 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  33493 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  33497 */     GIR_RootConstrainSelectedInstOperands,
     /*  33498 */     // GIR_Coverage, 1693,
     /*  33498 */     GIR_EraseRootFromParent_Done,
     /*  33499 */   // Label 526: @33499
     /*  33499 */   GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(33580), // Rule ID 1771 //
     /*  33504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33507 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33511 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33515 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33519 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33523 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33527 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33531 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33535 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33538 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  33543 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  33547 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_v8s8,
     /*  33551 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33556 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  33561 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  33563 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (zext:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i8] } 734:{ *:[iPTR] }, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)))  =>  (UABALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  33563 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABALv8i8_v8i16),
     /*  33566 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33568 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  33570 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // Rn
     /*  33574 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // Rm
     /*  33578 */     GIR_RootConstrainSelectedInstOperands,
     /*  33579 */     // GIR_Coverage, 1771,
     /*  33579 */     GIR_EraseRootFromParent_Done,
     /*  33580 */   // Label 527: @33580
     /*  33580 */   GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(33631), // Rule ID 13726 //
     /*  33585 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33588 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33592 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33596 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  33600 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33604 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33608 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33610 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33617 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33617 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
     /*  33620 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33622 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  33624 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33629 */     GIR_RootConstrainSelectedInstOperands,
     /*  33630 */     // GIR_Coverage, 13726,
     /*  33630 */     GIR_EraseRootFromParent_Done,
     /*  33631 */   // Label 528: @33631
     /*  33631 */   GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(33682), // Rule ID 13696 //
     /*  33636 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33639 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33643 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33647 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  33651 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33655 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33659 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33661 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33668 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv16i8_v8i16),
     /*  33671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33673 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  33675 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33680 */     GIR_RootConstrainSelectedInstOperands,
     /*  33681 */     // GIR_Coverage, 13696,
     /*  33681 */     GIR_EraseRootFromParent_Done,
     /*  33682 */   // Label 529: @33682
     /*  33682 */   GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(33733), // Rule ID 13725 //
     /*  33687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33690 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33702 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33706 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33710 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33712 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33719 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
     /*  33722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33724 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  33726 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33731 */     GIR_RootConstrainSelectedInstOperands,
     /*  33732 */     // GIR_Coverage, 13725,
     /*  33732 */     GIR_EraseRootFromParent_Done,
     /*  33733 */   // Label 530: @33733
     /*  33733 */   GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(33784), // Rule ID 1809 //
     /*  33738 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33741 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33745 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33749 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33753 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  33757 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33761 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33763 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33770 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33770 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
     /*  33773 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33775 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  33777 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33782 */     GIR_RootConstrainSelectedInstOperands,
     /*  33783 */     // GIR_Coverage, 1809,
     /*  33783 */     GIR_EraseRootFromParent_Done,
     /*  33784 */   // Label 531: @33784
     /*  33784 */   GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(33835), // Rule ID 1723 //
     /*  33789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33792 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33796 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  33808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33812 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33814 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33821 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (SADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33821 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv16i8_v8i16),
     /*  33824 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33826 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  33828 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33833 */     GIR_RootConstrainSelectedInstOperands,
     /*  33834 */     // GIR_Coverage, 1723,
     /*  33834 */     GIR_EraseRootFromParent_Done,
     /*  33835 */   // Label 532: @33835
     /*  33835 */   GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(33886), // Rule ID 1808 //
     /*  33840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33843 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33847 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33851 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33855 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  33859 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  33863 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33865 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_extract_high_v16i8),
     /*  33872 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (zext:{ *:[v8i16] } (extract_high_v16i8:{ *:[v8i8] } V128:{ *:[v16i8] }:$Rm)))  =>  (UADDWv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V128:{ *:[v16i8] }:$Rm)
     /*  33872 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv16i8_v8i16),
     /*  33875 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  33877 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  33879 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // Rm
     /*  33884 */     GIR_RootConstrainSelectedInstOperands,
     /*  33885 */     // GIR_Coverage, 1808,
     /*  33885 */     GIR_EraseRootFromParent_Done,
     /*  33886 */   // Label 533: @33886
     /*  33886 */   GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(33955), // Rule ID 13648 //
     /*  33891 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33894 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33898 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33902 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33906 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33909 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  33914 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  33918 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
     /*  33922 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33927 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33932 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33936 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33938 */     // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 669:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  33938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i16),
     /*  33941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  33943 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  33945 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  33949 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  33953 */     GIR_RootConstrainSelectedInstOperands,
     /*  33954 */     // GIR_Coverage, 13648,
     /*  33954 */     GIR_EraseRootFromParent_Done,
     /*  33955 */   // Label 534: @33955
     /*  33955 */   GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(34024), // Rule ID 13660 //
     /*  33960 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  33963 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33967 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33971 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33975 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33978 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  33983 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  33987 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
     /*  33991 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  33996 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34001 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34005 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34007 */     // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 734:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  34007 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i16),
     /*  34010 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34012 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  34014 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34018 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  34022 */     GIR_RootConstrainSelectedInstOperands,
     /*  34023 */     // GIR_Coverage, 13660,
     /*  34023 */     GIR_EraseRootFromParent_Done,
     /*  34024 */   // Label 535: @34024
     /*  34024 */   GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(34080), // Rule ID 13610 //
     /*  34029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34036 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34040 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34044 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  34047 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  34052 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  34056 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34061 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34065 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34067 */     // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 670:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  34067 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
     /*  34070 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34072 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  34074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34078 */     GIR_RootConstrainSelectedInstOperands,
     /*  34079 */     // GIR_Coverage, 13610,
     /*  34079 */     GIR_EraseRootFromParent_Done,
     /*  34080 */   // Label 536: @34080
     /*  34080 */   GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(34136), // Rule ID 13622 //
     /*  34085 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34088 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34092 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34096 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34100 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  34103 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  34108 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  34112 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34117 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34121 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34123 */     // (add:{ *:[v8i16] } (intrinsic_wo_chain:{ *:[v8i16] } 735:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  34123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
     /*  34126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34128 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  34130 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34134 */     GIR_RootConstrainSelectedInstOperands,
     /*  34135 */     // GIR_Coverage, 13622,
     /*  34135 */     GIR_EraseRootFromParent_Done,
     /*  34136 */   // Label 537: @34136
     /*  34136 */   GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(34203), // Rule ID 13862 //
     /*  34141 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  34156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34160 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34165 */     // MIs[1] imm
     /*  34165 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34169 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34173 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  34177 */     // MIs[2] Operand 1
     /*  34177 */     // No operand predicates
     /*  34177 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34181 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  34185 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34187 */     // (add:{ *:[v8i16] } (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  34187 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i16_shift),
     /*  34190 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34192 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  34194 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34198 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  34201 */     GIR_RootConstrainSelectedInstOperands,
     /*  34202 */     // GIR_Coverage, 13862,
     /*  34202 */     GIR_EraseRootFromParent_Done,
     /*  34203 */   // Label 538: @34203
     /*  34203 */   GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(34270), // Rule ID 13883 //
     /*  34208 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34211 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34215 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34219 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  34223 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34227 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34232 */     // MIs[1] imm
     /*  34232 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34236 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34240 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  34244 */     // MIs[2] Operand 1
     /*  34244 */     // No operand predicates
     /*  34244 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34248 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  34252 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34254 */     // (add:{ *:[v8i16] } (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm), V128:{ *:[v8i16] }:$Rd)<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  34254 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i16_shift),
     /*  34257 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34259 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  34261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34265 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  34268 */     GIR_RootConstrainSelectedInstOperands,
     /*  34269 */     // GIR_Coverage, 13883,
     /*  34269 */     GIR_EraseRootFromParent_Done,
     /*  34270 */   // Label 539: @34270
     /*  34270 */   GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(34339), // Rule ID 1367 //
     /*  34275 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34278 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34282 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34286 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34290 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34294 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34297 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_sabd),
     /*  34302 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  34306 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
     /*  34310 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34315 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34320 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34322 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 669:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (SABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  34322 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SABAv8i16),
     /*  34325 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34327 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34333 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  34337 */     GIR_RootConstrainSelectedInstOperands,
     /*  34338 */     // GIR_Coverage, 1367,
     /*  34338 */     GIR_EraseRootFromParent_Done,
     /*  34339 */   // Label 540: @34339
     /*  34339 */   GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(34408), // Rule ID 1490 //
     /*  34344 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34347 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34351 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34355 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34359 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34363 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34366 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uabd),
     /*  34371 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  34375 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v8s16,
     /*  34379 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34384 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34389 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34391 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 734:{ *:[iPTR] }, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm))  =>  (UABAv8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, V128:{ *:[v8i16] }:$Rm)
     /*  34391 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UABAv8i16),
     /*  34394 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34396 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34398 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34402 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // Rm
     /*  34406 */     GIR_RootConstrainSelectedInstOperands,
     /*  34407 */     // GIR_Coverage, 1490,
     /*  34407 */     GIR_EraseRootFromParent_Done,
     /*  34408 */   // Label 541: @34408
     /*  34408 */   GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(34464), // Rule ID 995 //
     /*  34413 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34416 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34420 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34424 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34428 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34432 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  34435 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_saddlp),
     /*  34440 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  34444 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34449 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34451 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 670:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  34451 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
     /*  34454 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34456 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34458 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34462 */     GIR_RootConstrainSelectedInstOperands,
     /*  34463 */     // GIR_Coverage, 995,
     /*  34463 */     GIR_EraseRootFromParent_Done,
     /*  34464 */   // Label 542: @34464
     /*  34464 */   GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(34520), // Rule ID 1056 //
     /*  34469 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34476 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34480 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34484 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34488 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /*  34491 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::aarch64_neon_uaddlp),
     /*  34496 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  34500 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34505 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34507 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (intrinsic_wo_chain:{ *:[v8i16] } 735:{ *:[iPTR] }, V128:{ *:[v16i8] }:$Rn))  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  34507 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
     /*  34510 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34512 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34514 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*  34518 */     GIR_RootConstrainSelectedInstOperands,
     /*  34519 */     // GIR_Coverage, 1056,
     /*  34519 */     GIR_EraseRootFromParent_Done,
     /*  34520 */   // Label 543: @34520
     /*  34520 */   GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(34587), // Rule ID 2240 //
     /*  34525 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34528 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34532 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34536 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34540 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VASHR),
     /*  34544 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34548 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34553 */     // MIs[1] imm
     /*  34553 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34557 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34561 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  34565 */     // MIs[2] Operand 1
     /*  34565 */     // No operand predicates
     /*  34565 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  34569 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34571 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vashr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (SSRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  34571 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SSRAv8i16_shift),
     /*  34574 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34576 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34578 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34582 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  34585 */     GIR_RootConstrainSelectedInstOperands,
     /*  34586 */     // GIR_Coverage, 2240,
     /*  34586 */     GIR_EraseRootFromParent_Done,
     /*  34587 */   // Label 544: @34587
     /*  34587 */   GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(34654), // Rule ID 2299 //
     /*  34592 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34595 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34599 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34603 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34607 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_VLSHR),
     /*  34611 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34615 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34620 */     // MIs[1] imm
     /*  34620 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34624 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34628 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_vecshiftR16),
     /*  34632 */     // MIs[2] Operand 1
     /*  34632 */     // No operand predicates
     /*  34632 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_and_or_is_add),
     /*  34636 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34638 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64vlshr:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_vecshiftR16>>:$imm))<<P:Predicate_add_and_or_is_add>>  =>  (USRAv8i16_shift:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v8i16] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  34638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::USRAv8i16_shift),
     /*  34641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  34643 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  34645 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34649 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  34652 */     GIR_RootConstrainSelectedInstOperands,
     /*  34653 */     // GIR_Coverage, 2299,
     /*  34653 */     GIR_EraseRootFromParent_Done,
     /*  34654 */   // Label 545: @34654
     /*  34654 */   GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(34724), // Rule ID 7008 //
     /*  34659 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34663 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34667 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UZP1),
     /*  34671 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34675 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  34679 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34684 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34689 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  34693 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP2),
     /*  34697 */     // MIs[2] Rn
     /*  34697 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  34702 */     // MIs[2] Rm
     /*  34702 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  34707 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34709 */     // (add:{ *:[v8i16] } (AArch64uzp1:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, FPR128:{ *:[v8i16] }:$Rm), (AArch64uzp2:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, FPR128:{ *:[v8i16] }:$Rm))  =>  (ADDPv8i16:{ *:[v8i16] } ?:{ *:[v8i16] }:$Rn, ?:{ *:[v8i16] }:$Rm)
     /*  34709 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv8i16),
     /*  34712 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  34714 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34718 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  34722 */     GIR_RootConstrainSelectedInstOperands,
     /*  34723 */     // GIR_Coverage, 7008,
     /*  34723 */     GIR_EraseRootFromParent_Done,
     /*  34724 */   // Label 546: @34724
     /*  34724 */   GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(34794), // Rule ID 14254 //
     /*  34729 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34733 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34737 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UZP2),
     /*  34741 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34745 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  34749 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34754 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34759 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  34763 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AArch64::G_UZP1),
     /*  34767 */     // MIs[2] Rn
     /*  34767 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  34772 */     // MIs[2] Rm
     /*  34772 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  34777 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34779 */     // (add:{ *:[v8i16] } (AArch64uzp2:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, FPR128:{ *:[v8i16] }:$Rm), (AArch64uzp1:{ *:[v8i16] } FPR128:{ *:[v8i16] }:$Rn, FPR128:{ *:[v8i16] }:$Rm))  =>  (ADDPv8i16:{ *:[v8i16] } ?:{ *:[v8i16] }:$Rn, ?:{ *:[v8i16] }:$Rm)
     /*  34779 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::ADDPv8i16),
     /*  34782 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  34784 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  34792 */     GIR_RootConstrainSelectedInstOperands,
     /*  34793 */     // GIR_Coverage, 14254,
     /*  34793 */     GIR_EraseRootFromParent_Done,
     /*  34794 */   // Label 547: @34794
     /*  34794 */   GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(34857), // Rule ID 1785 //
     /*  34799 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34802 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34806 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34810 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  34814 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34818 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34823 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  34827 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  34831 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34835 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34840 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34842 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  34842 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  34845 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  34847 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34851 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  34855 */     GIR_RootConstrainSelectedInstOperands,
     /*  34856 */     // GIR_Coverage, 1785,
     /*  34856 */     GIR_EraseRootFromParent_Done,
     /*  34857 */   // Label 548: @34857
     /*  34857 */   GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(34920), // Rule ID 1784 //
     /*  34862 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34865 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34869 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34873 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  34877 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34881 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34886 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  34890 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  34894 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34898 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34903 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34905 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  34905 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  34908 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  34910 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34914 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  34918 */     GIR_RootConstrainSelectedInstOperands,
     /*  34919 */     // GIR_Coverage, 1784,
     /*  34919 */     GIR_EraseRootFromParent_Done,
     /*  34920 */   // Label 549: @34920
     /*  34920 */   GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(34983), // Rule ID 1716 //
     /*  34925 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34932 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34936 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  34940 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34944 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34949 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  34953 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  34957 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  34961 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  34966 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  34968 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  34968 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDLv8i8_v8i16),
     /*  34971 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  34973 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  34977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  34981 */     GIR_RootConstrainSelectedInstOperands,
     /*  34982 */     // GIR_Coverage, 1716,
     /*  34982 */     GIR_EraseRootFromParent_Done,
     /*  34983 */   // Label 550: @34983
     /*  34983 */   GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(35046), // Rule ID 1783 //
     /*  34988 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  34991 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  34995 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34999 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  35003 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35007 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35012 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  35016 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  35020 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35024 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35029 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  35031 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  35034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35036 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  35044 */     GIR_RootConstrainSelectedInstOperands,
     /*  35045 */     // GIR_Coverage, 1783,
     /*  35045 */     GIR_EraseRootFromParent_Done,
     /*  35046 */   // Label 551: @35046
     /*  35046 */   GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(35109), // Rule ID 1782 //
     /*  35051 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35054 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35058 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35062 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  35066 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35070 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35075 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  35079 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  35083 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35087 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35092 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  35094 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn), (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDLv8i8_v8i16:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35094 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDLv8i8_v8i16),
     /*  35097 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35099 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35103 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  35107 */     GIR_RootConstrainSelectedInstOperands,
     /*  35108 */     // GIR_Coverage, 1782,
     /*  35108 */     GIR_EraseRootFromParent_Done,
     /*  35109 */   // Label 552: @35109
     /*  35109 */   GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(35170), // Rule ID 13701 //
     /*  35114 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35117 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35121 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35125 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  35129 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35133 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  35137 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35142 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35147 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35151 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35153 */     // (add:{ *:[v8i16] } (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35153 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
     /*  35156 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35158 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  35160 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35164 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  35168 */     GIR_RootConstrainSelectedInstOperands,
     /*  35169 */     // GIR_Coverage, 13701,
     /*  35169 */     GIR_EraseRootFromParent_Done,
     /*  35170 */   // Label 553: @35170
     /*  35170 */   GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(35231), // Rule ID 13735 //
     /*  35175 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35178 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35182 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35186 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  35190 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35194 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  35198 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35203 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35208 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35212 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35214 */     // (add:{ *:[v8i16] } (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rd)  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35214 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
     /*  35217 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35219 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  35221 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35225 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  35229 */     GIR_RootConstrainSelectedInstOperands,
     /*  35230 */     // GIR_Coverage, 13735,
     /*  35230 */     GIR_EraseRootFromParent_Done,
     /*  35231 */   // Label 554: @35231
     /*  35231 */   GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(35279), // Rule ID 13724 //
     /*  35236 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35239 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35243 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35247 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  35251 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35255 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35260 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35264 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35266 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35266 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  35269 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35271 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  35273 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  35277 */     GIR_RootConstrainSelectedInstOperands,
     /*  35278 */     // GIR_Coverage, 13724,
     /*  35278 */     GIR_EraseRootFromParent_Done,
     /*  35279 */   // Label 555: @35279
     /*  35279 */   GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(35327), // Rule ID 13609 //
     /*  35284 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35287 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35291 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35295 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  35299 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  35303 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35308 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35312 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35314 */     // (add:{ *:[v8i16] } (AArch64saddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  35314 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
     /*  35317 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35319 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  35321 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35325 */     GIR_RootConstrainSelectedInstOperands,
     /*  35326 */     // GIR_Coverage, 13609,
     /*  35326 */     GIR_EraseRootFromParent_Done,
     /*  35327 */   // Label 556: @35327
     /*  35327 */   GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(35375), // Rule ID 13695 //
     /*  35332 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35335 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35339 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35343 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  35347 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35351 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35356 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35360 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35362 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35362 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
     /*  35365 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35367 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  35369 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  35373 */     GIR_RootConstrainSelectedInstOperands,
     /*  35374 */     // GIR_Coverage, 13695,
     /*  35374 */     GIR_EraseRootFromParent_Done,
     /*  35375 */   // Label 557: @35375
     /*  35375 */   GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(35423), // Rule ID 13621 //
     /*  35380 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35383 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35387 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35391 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UADDLP),
     /*  35395 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  35399 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35404 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35408 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35410 */     // (add:{ *:[v8i16] } (AArch64uaddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn), V128:{ *:[v8i16] }:$Rd)  =>  (UADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  35410 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADALPv16i8_v8i16),
     /*  35413 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35415 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rd
     /*  35417 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35421 */     GIR_RootConstrainSelectedInstOperands,
     /*  35422 */     // GIR_Coverage, 13621,
     /*  35422 */     GIR_EraseRootFromParent_Done,
     /*  35423 */   // Label 558: @35423
     /*  35423 */   GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(35471), // Rule ID 13723 //
     /*  35428 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35431 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35435 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35439 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  35443 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35447 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35452 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35456 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35458 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm), V128:{ *:[v8i16] }:$Rn)  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35458 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  35461 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35463 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  35465 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  35469 */     GIR_RootConstrainSelectedInstOperands,
     /*  35470 */     // GIR_Coverage, 13723,
     /*  35470 */     GIR_EraseRootFromParent_Done,
     /*  35471 */   // Label 559: @35471
     /*  35471 */   GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(35532), // Rule ID 1728 //
     /*  35476 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35479 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35483 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35487 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35491 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SMULL),
     /*  35495 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35499 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  35503 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35508 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35513 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35515 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64smull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (SMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35515 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SMLALv8i8_v8i16),
     /*  35518 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35520 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  35522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  35530 */     GIR_RootConstrainSelectedInstOperands,
     /*  35531 */     // GIR_Coverage, 1728,
     /*  35531 */     GIR_EraseRootFromParent_Done,
     /*  35532 */   // Label 560: @35532
     /*  35532 */   GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(35593), // Rule ID 1818 //
     /*  35537 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35540 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35544 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35548 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35552 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_UMULL),
     /*  35556 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35560 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  35564 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35569 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35574 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35576 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64umull:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm))  =>  (UMLALv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V64:{ *:[v8i8] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35576 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UMLALv8i8_v8i16),
     /*  35579 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35581 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  35583 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35587 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  35591 */     GIR_RootConstrainSelectedInstOperands,
     /*  35592 */     // GIR_Coverage, 1818,
     /*  35592 */     GIR_EraseRootFromParent_Done,
     /*  35593 */   // Label 561: @35593
     /*  35593 */   GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(35641), // Rule ID 1807 //
     /*  35598 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35601 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35605 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35609 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35613 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  35617 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35621 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35626 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35628 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (anyext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (UADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::UADDWv8i8_v8i16),
     /*  35631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35633 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  35635 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  35639 */     GIR_RootConstrainSelectedInstOperands,
     /*  35640 */     // GIR_Coverage, 1807,
     /*  35640 */     GIR_EraseRootFromParent_Done,
     /*  35641 */   // Label 562: @35641
     /*  35641 */   GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(35689), // Rule ID 994 //
     /*  35646 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35649 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35653 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35657 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35661 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AArch64::G_SADDLP),
     /*  35665 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  35669 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35674 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35676 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, (AArch64saddlp_n:{ *:[v8i16] } V128:{ *:[v16i8] }:$Rn))  =>  (SADALPv16i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rd, V128:{ *:[v16i8] }:$Rn)
     /*  35676 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADALPv16i8_v8i16),
     /*  35679 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35681 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rd
     /*  35683 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  35687 */     GIR_RootConstrainSelectedInstOperands,
     /*  35688 */     // GIR_Coverage, 994,
     /*  35688 */     GIR_EraseRootFromParent_Done,
     /*  35689 */   // Label 563: @35689
     /*  35689 */   GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(35737), // Rule ID 1722 //
     /*  35694 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  35697 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35701 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR128RegClassID),
     /*  35705 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35709 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  35713 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  35717 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AArch64::FPR64RegClassID),
     /*  35722 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35724 */     // (add:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, (sext:{ *:[v8i16] } V64:{ *:[v8i8] }:$Rm))  =>  (SADDWv8i8_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$Rn, V64:{ *:[v8i8] }:$Rm)
     /*  35724 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AArch64::SADDWv8i8_v8i16),
     /*  35727 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  35729 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  35731 */     GIR_Copy, /*NewInsnID*/0