#include "nv_push_clc9b0.h"

#include <stdio.h>





const char *P_PARSE_NVC7B0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC7B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NVC9B0_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NVC7B0_MTHD(idx);

                                                                            case NVC9B0_SET_CONTROL_PARAMS:
        return "NVC9B0_SET_CONTROL_PARAMS";
                                                                                                                                                                                                                                                                                                            case NVC9B0_VP9_SET_HINT_DUMP_BUF_OFFSET:
        return "NVC9B0_VP9_SET_HINT_DUMP_BUF_OFFSET";
                                                                        case NVC9B0_AV1_SET_HINT_DUMP_BUF_OFFSET:
        return "NVC9B0_AV1_SET_HINT_DUMP_BUF_OFFSET";
                                                                                                    
    }
}

void
P_DUMP_NVC9B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NVC7B0_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                          
    case NVC9B0_SET_CONTROL_PARAMS:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.CODEC_TYPE = ", prefix);
        switch (parsed) {
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1:
            fprintf(fp, "MPEG1\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2:
            fprintf(fp, "MPEG2\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1:
            fprintf(fp, "VC1\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264:
            fprintf(fp, "H264\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4:
            fprintf(fp, "MPEG4\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8:
            fprintf(fp, "VP8\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC:
            fprintf(fp, "HEVC\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9:
            fprintf(fp, "VP9\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_CODEC_TYPE_AV1:
            fprintf(fp, "AV1\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 1) - 1);
        fprintf(fp, "%s.GPTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 5) & ((1u << 1) - 1);
        fprintf(fp, "%s.RET_ERROR = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 6) & ((1u << 1) - 1);
        fprintf(fp, "%s.ERR_CONCEAL_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 7) & ((1u << 6) - 1);
        fprintf(fp, "%s.ERROR_FRM_IDX = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 13) & ((1u << 1) - 1);
        fprintf(fp, "%s.MBTIMER_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 1) - 1);
        fprintf(fp, "%s.EC_INTRA_FRAME_USING_PSLC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 15) & ((1u << 1) - 1);
        fprintf(fp, "%s.IGNORE_SOME_FIELDS_CRC_CHECK = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.EVENT_TRACE_LOGGING_ON = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.ALL_INTRA_FRAME = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 2) - 1);
        fprintf(fp, "%s.TESTRUN_ENV = ", prefix);
        switch (parsed) {
        case NVC9B0_SET_CONTROL_PARAMS_TESTRUN_ENV_TRACE3D_RUN:
            fprintf(fp, "TRACE3D_RUN\n");
            break;
        case NVC9B0_SET_CONTROL_PARAMS_TESTRUN_ENV_PROD_RUN:
            fprintf(fp, "PROD_RUN\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 20) & ((1u << 1) - 1);
        fprintf(fp, "%s.HINT_DUMP_EN = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 21) & ((1u << 5) - 1);
        fprintf(fp, "%s.RESERVED = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 26) & ((1u << 1) - 1);
        fprintf(fp, "%s.NVDECSIM_SKIP_SCP = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 27) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE_ENCRYPT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 28) & ((1u << 4) - 1);
        fprintf(fp, "%s.ENCRYPTMODE = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                          
    case NVC9B0_VP9_SET_HINT_DUMP_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                      
    case NVC9B0_AV1_SET_HINT_DUMP_BUF_OFFSET:

    
        parsed = data;
        fprintf(fp, "%s.OFFSET = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                        }
}
