/* App.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from App.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2013-2014 Akshay Shekher
 *           2011-2012 Giulio Collura
 *           2020-2021 Justin Haygood
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_APP_0_PROPERTY,
	SLINGSHOT_BACKEND_APP_NAME_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY,
	SLINGSHOT_BACKEND_APP_EXEC_PROPERTY,
	SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY,
	SLINGSHOT_BACKEND_APP_ICON_PROPERTY,
	SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY,
	SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY,
	SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY,
	SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY,
	SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY,
	SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY,
	SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY,
	SLINGSHOT_BACKEND_APP_MATCH_PROPERTY,
	SLINGSHOT_BACKEND_APP_TARGET_PROPERTY,
	SLINGSHOT_BACKEND_APP_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_BACKEND_APP_NUM_SIGNALS
};
static guint slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_NUM_SIGNALS] = {0};

struct _SlingshotBackendAppPrivate {
	gchar* _name;
	gchar* _description;
	gchar* _desktop_id;
	gchar* _exec;
	gchar** _keywords;
	gint _keywords_length1;
	gint __keywords_size_;
	GIcon* _icon;
	gdouble _popularity;
	gchar* _desktop_path;
	gchar* _categories;
	gchar* _generic_name;
	gboolean _prefers_default_gpu;
	SlingshotBackendAppAppType _app_type;
	gboolean _terminal;
	SynapseMatch* _match;
	SynapseMatch* _target;
	SlingshotBackendSwitcherooControl* switcheroo_control;
};

static gint SlingshotBackendApp_private_offset;
static gpointer slingshot_backend_app_parent_class = NULL;
static GType slingshot_backend_app_type_id = 0;

static void slingshot_backend_app_set_app_type (SlingshotBackendApp* self,
                                         SlingshotBackendAppAppType value);
static void slingshot_backend_app_set_description (SlingshotBackendApp* self,
                                            const gchar* value);
static void slingshot_backend_app_set_exec (SlingshotBackendApp* self,
                                     const gchar* value);
static void slingshot_backend_app_set_desktop_path (SlingshotBackendApp* self,
                                             const gchar* value);
static void slingshot_backend_app_set_keywords (SlingshotBackendApp* self,
                                         gchar** value,
                                         gint value_length1);
static void slingshot_backend_app_set_categories (SlingshotBackendApp* self,
                                           const gchar* value);
static void slingshot_backend_app_set_generic_name (SlingshotBackendApp* self,
                                             const gchar* value);
static void slingshot_backend_app_set_prefers_default_gpu (SlingshotBackendApp* self,
                                                    gboolean value);
static void slingshot_backend_app_set_terminal (SlingshotBackendApp* self,
                                         gboolean value);
static void slingshot_backend_app_set_icon (SlingshotBackendApp* self,
                                     GIcon* value);
static void slingshot_backend_app_set_match (SlingshotBackendApp* self,
                                      SynapseMatch* value);
static void slingshot_backend_app_set_target (SlingshotBackendApp* self,
                                       SynapseMatch* value);
static void _____lambda15_ (SlingshotBackendApp* self,
                     GPid pid,
                     gint status);
static void ______lambda15__gchild_watch_func (GPid pid,
                                        gint wait_status,
                                        gpointer self);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GObject * slingshot_backend_app_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void slingshot_backend_app_finalize (GObject * obj);
static void _vala_slingshot_backend_app_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_slingshot_backend_app_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_backend_app_get_instance_private (SlingshotBackendApp* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendApp_private_offset);
}

static GType
slingshot_backend_app_app_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SLINGSHOT_BACKEND_APP_APP_TYPE_APP, "SLINGSHOT_BACKEND_APP_APP_TYPE_APP", "app"}, {SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND, "SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND", "command"}, {SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE, "SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE", "synapse"}, {0, NULL, NULL}};
	GType slingshot_backend_app_app_type_type_id;
	slingshot_backend_app_app_type_type_id = g_enum_register_static ("SlingshotBackendAppAppType", values);
	return slingshot_backend_app_app_type_type_id;
}

GType
slingshot_backend_app_app_type_get_type (void)
{
	static volatile gsize slingshot_backend_app_app_type_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_app_app_type_type_id__once)) {
		GType slingshot_backend_app_app_type_type_id;
		slingshot_backend_app_app_type_type_id = slingshot_backend_app_app_type_get_type_once ();
		g_once_init_leave (&slingshot_backend_app_app_type_type_id__once, slingshot_backend_app_app_type_type_id);
	}
	return slingshot_backend_app_app_type_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SlingshotBackendApp*
slingshot_backend_app_construct (GType object_type,
                                 GDesktopAppInfo* info)
{
	SlingshotBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GIcon* desktop_icon = NULL;
	GIcon* _tmp11_;
	GIcon* _tmp12_;
	GIcon* _tmp13_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp15_;
	GtkIconTheme* _tmp16_;
	GIcon* _tmp17_;
	GtkIconInfo* _tmp18_;
	GtkIconInfo* _tmp19_;
	gboolean _tmp20_;
	g_return_val_if_fail (info != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_APP);
	_tmp0_ = g_app_info_get_display_name ((GAppInfo*) info);
	slingshot_backend_app_set_name (self, _tmp0_);
	_tmp2_ = g_app_info_get_description ((GAppInfo*) info);
	_tmp1_ = _tmp2_;
	if (_tmp1_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_name;
		_tmp1_ = _tmp3_;
	}
	slingshot_backend_app_set_description (self, _tmp1_);
	_tmp4_ = g_app_info_get_commandline ((GAppInfo*) info);
	slingshot_backend_app_set_exec (self, _tmp4_);
	_tmp5_ = g_app_info_get_id ((GAppInfo*) info);
	slingshot_backend_app_set_desktop_id (self, _tmp5_);
	_tmp6_ = g_desktop_app_info_get_filename (info);
	slingshot_backend_app_set_desktop_path (self, _tmp6_);
	_tmp8_ = _tmp7_ = g_desktop_app_info_get_keywords (info);
	slingshot_backend_app_set_keywords (self, _tmp8_, _vala_array_length (_tmp7_));
	_tmp9_ = g_desktop_app_info_get_categories (info);
	slingshot_backend_app_set_categories (self, _tmp9_);
	_tmp10_ = g_desktop_app_info_get_generic_name (info);
	slingshot_backend_app_set_generic_name (self, _tmp10_);
	slingshot_backend_app_set_prefers_default_gpu (self, !g_desktop_app_info_get_boolean (info, "PrefersNonDefaultGPU"));
	slingshot_backend_app_set_terminal (self, g_desktop_app_info_get_boolean (info, "Terminal"));
	_tmp11_ = g_app_info_get_icon ((GAppInfo*) info);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	desktop_icon = _tmp12_;
	_tmp13_ = desktop_icon;
	if (_tmp13_ != NULL) {
		GIcon* _tmp14_;
		_tmp14_ = desktop_icon;
		slingshot_backend_app_set_icon (self, _tmp14_);
	}
	_tmp15_ = gtk_icon_theme_get_default ();
	theme = _tmp15_;
	_tmp16_ = theme;
	_tmp17_ = self->priv->_icon;
	_tmp18_ = gtk_icon_theme_lookup_by_gicon (_tmp16_, _tmp17_, 64, GTK_ICON_LOOKUP_USE_BUILTIN);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_ == NULL;
	_g_object_unref0 (_tmp19_);
	if (_tmp20_) {
		GThemedIcon* _tmp21_;
		GThemedIcon* _tmp22_;
		_tmp21_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_tmp22_ = _tmp21_;
		slingshot_backend_app_set_icon (self, (GIcon*) _tmp22_);
		_g_object_unref0 (_tmp22_);
	}
	_g_object_unref0 (desktop_icon);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new (GDesktopAppInfo* info)
{
	return slingshot_backend_app_construct (SLINGSHOT_BACKEND_TYPE_APP, info);
}

SlingshotBackendApp*
slingshot_backend_app_construct_from_command (GType object_type,
                                              const gchar* command)
{
	SlingshotBackendApp * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	g_return_val_if_fail (command != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND);
	slingshot_backend_app_set_name (self, command);
	slingshot_backend_app_set_description (self, _ ("Run this command…"));
	slingshot_backend_app_set_exec (self, command);
	slingshot_backend_app_set_desktop_id (self, command);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-run");
	_tmp1_ = _tmp0_;
	slingshot_backend_app_set_icon (self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new_from_command (const gchar* command)
{
	return slingshot_backend_app_construct_from_command (SLINGSHOT_BACKEND_TYPE_APP, command);
}

SlingshotBackendApp*
slingshot_backend_app_construct_from_synapse_match (GType object_type,
                                                    SynapseMatch* match,
                                                    SynapseMatch* target)
{
	SlingshotBackendApp * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	SynapseMatchType _tmp5_;
	SynapseMatchType _tmp6_;
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp21_;
	GtkIconTheme* _tmp22_;
	GIcon* _tmp23_;
	GtkIconInfo* _tmp24_;
	GtkIconInfo* _tmp25_;
	gboolean _tmp26_;
	g_return_val_if_fail (match != NULL, NULL);
	self = (SlingshotBackendApp*) g_object_new (object_type, NULL);
	slingshot_backend_app_set_app_type (self, SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE);
	_tmp0_ = synapse_match_get_title (match);
	_tmp1_ = _tmp0_;
	slingshot_backend_app_set_name (self, _tmp1_);
	_tmp2_ = synapse_match_get_description (match);
	_tmp3_ = _tmp2_;
	slingshot_backend_app_set_description (self, _tmp3_);
	_tmp5_ = synapse_match_get_match_type (match);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == SYNAPSE_MATCH_TYPE_CONTACT) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = synapse_match_get_has_thumbnail (match);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GFile* file = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFileIcon* _tmp13_;
		GFileIcon* _tmp14_;
		_tmp9_ = synapse_match_get_thumbnail_path (match);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_new_for_path (_tmp10_);
		file = _tmp11_;
		_tmp12_ = file;
		_tmp13_ = (GFileIcon*) g_file_icon_new (_tmp12_);
		_tmp14_ = _tmp13_;
		slingshot_backend_app_set_icon (self, (GIcon*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (file);
	} else {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = synapse_match_get_icon_name (match);
		_tmp16_ = _tmp15_;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			GThemedIcon* _tmp19_;
			GThemedIcon* _tmp20_;
			_tmp17_ = synapse_match_get_icon_name (match);
			_tmp18_ = _tmp17_;
			_tmp19_ = (GThemedIcon*) g_themed_icon_new (_tmp18_);
			_tmp20_ = _tmp19_;
			slingshot_backend_app_set_icon (self, (GIcon*) _tmp20_);
			_g_object_unref0 (_tmp20_);
		}
	}
	_tmp21_ = gtk_icon_theme_get_default ();
	theme = _tmp21_;
	_tmp22_ = theme;
	_tmp23_ = self->priv->_icon;
	_tmp24_ = gtk_icon_theme_lookup_by_gicon (_tmp22_, _tmp23_, 64, GTK_ICON_LOOKUP_USE_BUILTIN);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_ == NULL;
	_g_object_unref0 (_tmp25_);
	if (_tmp26_) {
		GThemedIcon* _tmp27_;
		GThemedIcon* _tmp28_;
		_tmp27_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
		_tmp28_ = _tmp27_;
		slingshot_backend_app_set_icon (self, (GIcon*) _tmp28_);
		_g_object_unref0 (_tmp28_);
	}
	if (SYNAPSE_IS_APPLICATION_MATCH (match)) {
		SynapseApplicationMatch* app_match = NULL;
		SynapseApplicationMatch* _tmp29_;
		GAppInfo* app_info = NULL;
		SynapseApplicationMatch* _tmp30_;
		GAppInfo* _tmp31_;
		GAppInfo* _tmp32_;
		GAppInfo* _tmp33_;
		GAppInfo* _tmp34_;
		const gchar* _tmp35_;
		GAppInfo* _tmp36_;
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (match, SYNAPSE_TYPE_APPLICATION_MATCH, SynapseApplicationMatch));
		app_match = _tmp29_;
		_tmp30_ = app_match;
		_tmp31_ = synapse_application_match_get_app_info (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _g_object_ref0 (_tmp32_);
		app_info = _tmp33_;
		_tmp34_ = app_info;
		_tmp35_ = g_app_info_get_id (_tmp34_);
		slingshot_backend_app_set_desktop_id (self, _tmp35_);
		_tmp36_ = app_info;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, G_TYPE_DESKTOP_APP_INFO)) {
			GDesktopAppInfo* desktop_app_info = NULL;
			GAppInfo* _tmp37_;
			GDesktopAppInfo* _tmp38_;
			GDesktopAppInfo* _tmp39_;
			const gchar* _tmp40_;
			GDesktopAppInfo* _tmp41_;
			_tmp37_ = app_info;
			_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
			desktop_app_info = _tmp38_;
			_tmp39_ = desktop_app_info;
			_tmp40_ = g_desktop_app_info_get_filename (_tmp39_);
			slingshot_backend_app_set_desktop_path (self, _tmp40_);
			_tmp41_ = desktop_app_info;
			slingshot_backend_app_set_prefers_default_gpu (self, !g_desktop_app_info_get_boolean (_tmp41_, "PrefersNonDefaultGPU"));
			_g_object_unref0 (desktop_app_info);
		}
		_g_object_unref0 (app_info);
		_g_object_unref0 (app_match);
	}
	slingshot_backend_app_set_match (self, match);
	slingshot_backend_app_set_target (self, target);
	return self;
}

SlingshotBackendApp*
slingshot_backend_app_new_from_synapse_match (SynapseMatch* match,
                                              SynapseMatch* target)
{
	return slingshot_backend_app_construct_from_synapse_match (SLINGSHOT_BACKEND_TYPE_APP, match, target);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_____lambda15_ (SlingshotBackendApp* self,
                GPid pid,
                gint status)
{
	g_spawn_close_pid (pid);
}

static void
______lambda15__gchild_watch_func (GPid pid,
                                   gint wait_status,
                                   gpointer self)
{
	_____lambda15_ ((SlingshotBackendApp*) self, pid, wait_status);
}

gboolean
slingshot_backend_app_launch (SlingshotBackendApp* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		SlingshotBackendAppAppType _tmp0_;
		_tmp0_ = self->priv->_app_type;
		switch (_tmp0_) {
			case SLINGSHOT_BACKEND_APP_APP_TYPE_COMMAND:
			{
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp1_ = self->priv->_name;
				_tmp2_ = string_to_string (_tmp1_);
				_tmp3_ = g_strconcat ("Launching command: ", _tmp2_, NULL);
				_tmp4_ = _tmp3_;
				g_debug ("App.vala:137: %s", _tmp4_);
				_g_free0 (_tmp4_);
				_tmp5_ = self->priv->_exec;
				g_spawn_command_line_async (_tmp5_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				break;
			}
			case SLINGSHOT_BACKEND_APP_APP_TYPE_APP:
			{
				GDesktopAppInfo* info = NULL;
				const gchar* _tmp6_;
				GDesktopAppInfo* _tmp7_;
				gchar* commandline = NULL;
				GDesktopAppInfo* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar** spawn_args = NULL;
				gchar** _tmp11_;
				gint spawn_args_length1;
				gint _spawn_args_size_;
				static const char checkstr[] = "pkexec";
				const gchar* _tmp12_;
				gboolean _tmp16_ = FALSE;
				gchar** _tmp17_;
				gint _tmp17__length1;
				g_signal_emit (self, slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL], 0, self);
				_tmp6_ = self->priv->_desktop_id;
				_tmp7_ = g_desktop_app_info_new (_tmp6_);
				info = _tmp7_;
				_tmp8_ = info;
				_tmp9_ = g_app_info_get_commandline ((GAppInfo*) _tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				commandline = _tmp10_;
				_tmp11_ = g_new0 (gchar*, 0 + 1);
				spawn_args = _tmp11_;
				spawn_args_length1 = 0;
				_spawn_args_size_ = spawn_args_length1;
				_tmp12_ = commandline;
				if (string_contains (_tmp12_, checkstr)) {
					const gchar* _tmp13_;
					gchar** _tmp14_;
					gchar** _tmp15_;
					_tmp13_ = commandline;
					_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, " ", 0);
					spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
					spawn_args = _tmp15_;
					spawn_args_length1 = _vala_array_length (_tmp14_);
					_spawn_args_size_ = spawn_args_length1;
				}
				_tmp17_ = spawn_args;
				_tmp17__length1 = spawn_args_length1;
				if (_tmp17__length1 >= 2) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					_tmp18_ = spawn_args;
					_tmp18__length1 = spawn_args_length1;
					_tmp19_ = _tmp18_[0];
					_tmp16_ = g_strcmp0 (_tmp19_, checkstr) == 0;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					gchar** spawn_env = NULL;
					gchar** _tmp20_;
					gchar** _tmp21_;
					gint spawn_env_length1;
					gint _spawn_env_size_;
					GPid child_pid = 0;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gchar** _tmp23_;
					gint _tmp23__length1;
					GPid _tmp24_ = 0;
					_tmp21_ = _tmp20_ = g_get_environ ();
					spawn_env = _tmp21_;
					spawn_env_length1 = _vala_array_length (_tmp20_);
					_spawn_env_size_ = spawn_env_length1;
					_tmp22_ = spawn_args;
					_tmp22__length1 = spawn_args_length1;
					_tmp23_ = spawn_env;
					_tmp23__length1 = spawn_env_length1;
					g_spawn_async ("/", _tmp22_, _tmp23_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp24_, &_inner_error0_);
					child_pid = _tmp24_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
						spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (commandline);
						_g_object_unref0 (info);
						goto __catch0_g_error;
					}
					g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, child_pid, ______lambda15__gchild_watch_func, g_object_ref (self), g_object_unref);
					spawn_env = (_vala_array_free (spawn_env, spawn_env_length1, (GDestroyNotify) g_free), NULL);
				} else {
					GAppLaunchContext* context = NULL;
					GAppLaunchContext* _tmp25_;
					SlingshotBackendSwitcherooControl* _tmp26_;
					GAppLaunchContext* _tmp27_;
					gboolean _tmp28_;
					const gchar* _tmp29_;
					GDesktopAppInfo* _tmp30_;
					GDesktopAppInfo* _tmp31_;
					GAppLaunchContext* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp25_ = g_app_launch_context_new ();
					context = _tmp25_;
					_tmp26_ = self->priv->switcheroo_control;
					_tmp27_ = context;
					_tmp28_ = self->priv->_prefers_default_gpu;
					slingshot_backend_switcheroo_control_apply_gpu_environment (_tmp26_, _tmp27_, _tmp28_);
					_tmp29_ = self->priv->_desktop_id;
					_tmp30_ = g_desktop_app_info_new (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = context;
					g_app_info_launch ((GAppInfo*) _tmp31_, NULL, _tmp32_, &_inner_error0_);
					_g_object_unref0 (_tmp31_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (context);
						spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (commandline);
						_g_object_unref0 (info);
						goto __catch0_g_error;
					}
					_tmp33_ = self->priv->_name;
					_tmp34_ = string_to_string (_tmp33_);
					_tmp35_ = g_strconcat ("Launching application: ", _tmp34_, NULL);
					_tmp36_ = _tmp35_;
					g_debug ("App.vala:172: %s", _tmp36_);
					_g_free0 (_tmp36_);
					_g_object_unref0 (context);
				}
				spawn_args = (_vala_array_free (spawn_args, spawn_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (commandline);
				_g_object_unref0 (info);
				break;
			}
			case SLINGSHOT_BACKEND_APP_APP_TYPE_SYNAPSE:
			{
				SynapseMatch* _tmp37_;
				SynapseMatchType _tmp38_;
				SynapseMatchType _tmp39_;
				_tmp37_ = self->priv->_match;
				_tmp38_ = synapse_match_get_match_type (_tmp37_);
				_tmp39_ = _tmp38_;
				if (_tmp39_ == SYNAPSE_MATCH_TYPE_SEARCH) {
					result = FALSE;
					return result;
				} else {
					SynapseMatch* _tmp40_;
					_tmp40_ = self->priv->_target;
					if (_tmp40_ == NULL) {
						SynapseMatch* _tmp41_;
						GeeList* _tmp42_;
						GeeList* _tmp43_;
						gpointer _tmp44_;
						SynapseMatch* _tmp45_;
						SynapseMatch* _tmp46_;
						_tmp41_ = self->priv->_match;
						_tmp42_ = slingshot_backend_synapse_search_find_actions_for_match (_tmp41_);
						_tmp43_ = _tmp42_;
						_tmp44_ = gee_list_get (_tmp43_, 0);
						_tmp45_ = (SynapseMatch*) _tmp44_;
						_tmp46_ = self->priv->_match;
						synapse_match_execute_with_target (_tmp45_, _tmp46_, NULL);
						_g_object_unref0 (_tmp45_);
						_g_object_unref0 (_tmp43_);
					} else {
						SynapseMatch* _tmp47_;
						SynapseMatch* _tmp48_;
						_tmp47_ = self->priv->_match;
						_tmp48_ = self->priv->_target;
						synapse_match_execute_with_target (_tmp47_, _tmp48_, NULL);
					}
				}
				break;
			}
			default:
			break;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		g_clear_error (&_inner_error0_);
		_tmp49_ = self->priv->_name;
		_tmp50_ = self->priv->_exec;
		g_warning ("App.vala:188: Failed to launch %s: %s", _tmp49_, _tmp50_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp51_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp51_;
	}
	result = TRUE;
	return result;
}

const gchar*
slingshot_backend_app_get_name (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
slingshot_backend_app_set_name (SlingshotBackendApp* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NAME_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_description (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_description (SlingshotBackendApp* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_desktop_id (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_id;
	result = _tmp0_;
	return result;
}

void
slingshot_backend_app_set_desktop_id (SlingshotBackendApp* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_desktop_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_id);
		self->priv->_desktop_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_exec (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_exec;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_exec (SlingshotBackendApp* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_exec (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_exec);
		self->priv->_exec = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_EXEC_PROPERTY]);
	}
}

gchar**
slingshot_backend_app_get_keywords (SlingshotBackendApp* self,
                                    gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_keywords;
	_tmp0__length1 = self->priv->_keywords_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
slingshot_backend_app_set_keywords (SlingshotBackendApp* self,
                                    gchar** value,
                                    gint value_length1)
{
	gchar** old_value;
	gint old_value_length;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_keywords (self, &old_value_length);
	if (old_value != value) {
		gchar** _tmp0_;
		gint _tmp0__length1;
		_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
		_tmp0__length1 = value_length1;
		self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_keywords = _tmp0_;
		self->priv->_keywords_length1 = _tmp0__length1;
		self->priv->__keywords_size_ = self->priv->_keywords_length1;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY]);
	}
}

GIcon*
slingshot_backend_app_get_icon (SlingshotBackendApp* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_icon (SlingshotBackendApp* self,
                                GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ICON_PROPERTY]);
	}
}

gdouble
slingshot_backend_app_get_popularity (SlingshotBackendApp* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_popularity;
	return result;
}

void
slingshot_backend_app_set_popularity (SlingshotBackendApp* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_popularity (self);
	if (old_value != value) {
		self->priv->_popularity = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_desktop_path (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desktop_path;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_desktop_path (SlingshotBackendApp* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_desktop_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desktop_path);
		self->priv->_desktop_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_categories (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_categories;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_categories (SlingshotBackendApp* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_categories (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_categories);
		self->priv->_categories = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY]);
	}
}

const gchar*
slingshot_backend_app_get_generic_name (SlingshotBackendApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_generic_name;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_generic_name (SlingshotBackendApp* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_generic_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_generic_name);
		self->priv->_generic_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY]);
	}
}

gboolean
slingshot_backend_app_get_prefers_default_gpu (SlingshotBackendApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prefers_default_gpu;
	return result;
}

static void
slingshot_backend_app_set_prefers_default_gpu (SlingshotBackendApp* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_prefers_default_gpu (self);
	if (old_value != value) {
		self->priv->_prefers_default_gpu = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY]);
	}
}

SlingshotBackendAppAppType
slingshot_backend_app_get_app_type (SlingshotBackendApp* self)
{
	SlingshotBackendAppAppType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_app_type;
	return result;
}

static void
slingshot_backend_app_set_app_type (SlingshotBackendApp* self,
                                    SlingshotBackendAppAppType value)
{
	SlingshotBackendAppAppType old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_app_type (self);
	if (old_value != value) {
		self->priv->_app_type = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY]);
	}
}

gboolean
slingshot_backend_app_get_terminal (SlingshotBackendApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_terminal;
	return result;
}

static void
slingshot_backend_app_set_terminal (SlingshotBackendApp* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_terminal (self);
	if (old_value != value) {
		self->priv->_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY]);
	}
}

SynapseMatch*
slingshot_backend_app_get_match (SlingshotBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_match;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_match (SlingshotBackendApp* self,
                                 SynapseMatch* value)
{
	SynapseMatch* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_match (self);
	if (old_value != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_match);
		self->priv->_match = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_MATCH_PROPERTY]);
	}
}

SynapseMatch*
slingshot_backend_app_get_target (SlingshotBackendApp* self)
{
	SynapseMatch* result;
	SynapseMatch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_set_target (SlingshotBackendApp* self,
                                  SynapseMatch* value)
{
	SynapseMatch* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_get_target (self);
	if (old_value != value) {
		SynapseMatch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_target);
		self->priv->_target = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TARGET_PROPERTY]);
	}
}

static GObject *
slingshot_backend_app_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendApp * self;
	SlingshotBackendSwitcherooControl* _tmp0_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_app_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	_tmp0_ = slingshot_backend_switcheroo_control_new ();
	_g_object_unref0 (self->priv->switcheroo_control);
	self->priv->switcheroo_control = _tmp0_;
	return obj;
}

static void
slingshot_backend_app_class_init (SlingshotBackendAppClass * klass,
                                  gpointer klass_data)
{
	slingshot_backend_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_app_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_app_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_NAME_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY] = g_param_spec_string ("desktop-id", "desktop-id", "desktop-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_EXEC_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_EXEC_PROPERTY] = g_param_spec_string ("exec", "exec", "exec", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY] = g_param_spec_boxed ("keywords", "keywords", "keywords", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_ICON_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY] = g_param_spec_double ("popularity", "popularity", "popularity", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY] = g_param_spec_string ("desktop-path", "desktop-path", "desktop-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY] = g_param_spec_string ("categories", "categories", "categories", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY] = g_param_spec_string ("generic-name", "generic-name", "generic-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY] = g_param_spec_boolean ("prefers-default-gpu", "prefers-default-gpu", "prefers-default-gpu", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY] = g_param_spec_enum ("app-type", "app-type", "app-type", SLINGSHOT_BACKEND_APP_TYPE_APP_TYPE, SLINGSHOT_BACKEND_APP_APP_TYPE_APP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY] = g_param_spec_boolean ("terminal", "terminal", "terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_MATCH_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_MATCH_PROPERTY] = g_param_spec_object ("match", "match", "match", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_TARGET_PROPERTY, slingshot_backend_app_properties[SLINGSHOT_BACKEND_APP_TARGET_PROPERTY] = g_param_spec_object ("target", "target", "target", SYNAPSE_TYPE_MATCH, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_backend_app_signals[SLINGSHOT_BACKEND_APP_LAUNCHED_SIGNAL] = g_signal_new ("launched", SLINGSHOT_BACKEND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, SLINGSHOT_BACKEND_TYPE_APP);
}

static void
slingshot_backend_app_instance_init (SlingshotBackendApp * self,
                                     gpointer klass)
{
	gchar* _tmp0_;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_;
	self->priv = slingshot_backend_app_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_description = _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
	self->priv->_icon = (GIcon*) _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_generic_name = _tmp2_;
	self->priv->_prefers_default_gpu = FALSE;
	self->priv->_app_type = SLINGSHOT_BACKEND_APP_APP_TYPE_APP;
	self->priv->_terminal = FALSE;
	self->priv->_match = NULL;
	self->priv->_target = NULL;
}

static void
slingshot_backend_app_finalize (GObject * obj)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desktop_id);
	_g_free0 (self->priv->_exec);
	self->priv->_keywords = (_vala_array_free (self->priv->_keywords, self->priv->_keywords_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_desktop_path);
	_g_free0 (self->priv->_categories);
	_g_free0 (self->priv->_generic_name);
	_g_object_unref0 (self->priv->_match);
	_g_object_unref0 (self->priv->_target);
	_g_object_unref0 (self->priv->switcheroo_control);
	G_OBJECT_CLASS (slingshot_backend_app_parent_class)->finalize (obj);
}

GType
slingshot_backend_app_get_type (void)
{
	return slingshot_backend_app_type_id;
}

GType
slingshot_backend_app_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendApp), 0, (GInstanceInitFunc) slingshot_backend_app_instance_init, NULL };
	slingshot_backend_app_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SlingshotBackendApp", &g_define_type_info, 0);
	SlingshotBackendApp_private_offset = sizeof (SlingshotBackendAppPrivate);
	return slingshot_backend_app_type_id;
}

static void
_vala_slingshot_backend_app_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_NAME_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_name (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_description (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_desktop_id (self));
		break;
		case SLINGSHOT_BACKEND_APP_EXEC_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_exec (self));
		break;
		case SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, slingshot_backend_app_get_keywords (self, &length));
		}
		break;
		case SLINGSHOT_BACKEND_APP_ICON_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_icon (self));
		break;
		case SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY:
		g_value_set_double (value, slingshot_backend_app_get_popularity (self));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_desktop_path (self));
		break;
		case SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_categories (self));
		break;
		case SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY:
		g_value_set_string (value, slingshot_backend_app_get_generic_name (self));
		break;
		case SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_app_get_prefers_default_gpu (self));
		break;
		case SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY:
		g_value_set_enum (value, slingshot_backend_app_get_app_type (self));
		break;
		case SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_app_get_terminal (self));
		break;
		case SLINGSHOT_BACKEND_APP_MATCH_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_match (self));
		break;
		case SLINGSHOT_BACKEND_APP_TARGET_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_get_target (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_app_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SlingshotBackendApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP, SlingshotBackendApp);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_NAME_PROPERTY:
		slingshot_backend_app_set_name (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESCRIPTION_PROPERTY:
		slingshot_backend_app_set_description (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_ID_PROPERTY:
		slingshot_backend_app_set_desktop_id (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_EXEC_PROPERTY:
		slingshot_backend_app_set_exec (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_KEYWORDS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			slingshot_backend_app_set_keywords (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case SLINGSHOT_BACKEND_APP_ICON_PROPERTY:
		slingshot_backend_app_set_icon (self, g_value_get_object (value));
		break;
		case SLINGSHOT_BACKEND_APP_POPULARITY_PROPERTY:
		slingshot_backend_app_set_popularity (self, g_value_get_double (value));
		break;
		case SLINGSHOT_BACKEND_APP_DESKTOP_PATH_PROPERTY:
		slingshot_backend_app_set_desktop_path (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_CATEGORIES_PROPERTY:
		slingshot_backend_app_set_categories (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_GENERIC_NAME_PROPERTY:
		slingshot_backend_app_set_generic_name (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_APP_PREFERS_DEFAULT_GPU_PROPERTY:
		slingshot_backend_app_set_prefers_default_gpu (self, g_value_get_boolean (value));
		break;
		case SLINGSHOT_BACKEND_APP_APP_TYPE_PROPERTY:
		slingshot_backend_app_set_app_type (self, g_value_get_enum (value));
		break;
		case SLINGSHOT_BACKEND_APP_TERMINAL_PROPERTY:
		slingshot_backend_app_set_terminal (self, g_value_get_boolean (value));
		break;
		case SLINGSHOT_BACKEND_APP_MATCH_PROPERTY:
		slingshot_backend_app_set_match (self, g_value_get_object (value));
		break;
		case SLINGSHOT_BACKEND_APP_TARGET_PROPERTY:
		slingshot_backend_app_set_target (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

