/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM HashChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "HashChangeEvent.h"
#include "HashChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/HashChangeEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


HashChangeEvent::HashChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

HashChangeEvent::~HashChangeEvent()
{
}

HashChangeEvent*
HashChangeEvent::AsHashChangeEvent()
{
  return this;
}

JSObject*
HashChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return HashChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<HashChangeEvent>
HashChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const HashChangeEventInit& aEventInitDict)
{
  RefPtr<HashChangeEvent> e = new HashChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mOldURL = aEventInitDict.mOldURL;
  e->mNewURL = aEventInitDict.mNewURL;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<HashChangeEvent>
HashChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const HashChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
HashChangeEvent::GetOldURL(nsString& aRetVal) const
{
  aRetVal = mOldURL;
}

void
HashChangeEvent::GetNewURL(nsString& aRetVal) const
{
  aRetVal = mNewURL;
}


} // namespace mozilla::dom
