//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PClientHandleChild.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"

#include "mozilla/dom/PClientManagerChild.h"
#include "mozilla/dom/PClientHandleOpChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PClientHandleChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PClientHandleChild::PClientHandleChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PClientHandleChild);
}

PClientHandleChild::~PClientHandleChild()
{
    MOZ_COUNT_DTOR(PClientHandleChild);
}

auto PClientHandleChild::ActorAlloc() -> void
{
    AddRef();
}

auto PClientHandleChild::ActorDealloc() -> void
{
    Release();
}

auto PClientHandleChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PClientHandleChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PClientHandleChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PClientHandleChild::Manager() const -> PClientManagerChild*
{
    return static_cast<PClientManagerChild*>(IProtocol::Manager());
}

auto PClientHandleChild::ManagedPClientHandleOpChild(nsTArray<PClientHandleOpChild*>& aArr) const -> void
{
    mManagedPClientHandleOpChild.ToArray(aArr);
}

auto PClientHandleChild::ManagedPClientHandleOpChild() const -> const ManagedContainer<PClientHandleOpChild>&
{
    return mManagedPClientHandleOpChild;
}

auto PClientHandleChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PClientHandleOpMsgStart
    };
    return sIds;
}

auto PClientHandleChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PClientHandleOpMsgStart:
        return (&(mManagedPClientHandleOpChild));
    default:
        return nullptr;
    }
}

auto PClientHandleChild::OpenPClientHandleOpEndpoint(PClientHandleOpChild* aActor) -> ManagedEndpoint<PClientHandleOpParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientHandleOpChild actor");
        return ManagedEndpoint<PClientHandleOpParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleOpChild actor");
        return ManagedEndpoint<PClientHandleOpParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientHandleOpParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientHandleChild::BindPClientHandleOpEndpoint(
        ManagedEndpoint<PClientHandleOpChild> aEndpoint,
        PClientHandleOpChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientHandleChild::SendTeardown() -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientHandle::Msg_Teardown(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientHandleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientHandle::Msg_Teardown", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientHandleChild::SendPClientHandleOpConstructor(const ClientOpConstructorArgs& aArgs) -> PClientHandleOpChild*
{
    PClientHandleOpChild* actor = (this)->AllocPClientHandleOpChild(aArgs);
    return SendPClientHandleOpConstructor(std::move(actor), std::move(aArgs));
}

auto PClientHandleChild::SendPClientHandleOpConstructor(
        PClientHandleOpChild* actor,
        const ClientOpConstructorArgs& aArgs) -> PClientHandleOpChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientHandleOpChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleOpChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientHandle::Msg_PClientHandleOpConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientHandleChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientHandle::Msg_PClientHandleOpConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientHandleOpChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientHandleChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PClientHandleOpMsgStart:
        this->DeallocPClientHandleOpChild(static_cast<PClientHandleOpChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PClientHandleChild::OnMessageReceived(const Message& msg__) -> PClientHandleChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PClientHandle::Reply_PClientHandleOpConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientHandle::Msg_ExecutionReady__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientHandleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientHandle::Msg_ExecutionReady", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__aClientInfo = IPC::ReadParam<IPCClientInfo>((&(reader__)));
            if (!maybe__aClientInfo) {
                FatalError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;

            }
            auto& aClientInfo = *maybe__aClientInfo;
            // Sentinel = 'aClientInfo'
            if ((!(((&(reader__)))->ReadSentinel(422315085)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'IPCClientInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvExecutionReady(std::move(aClientInfo));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientHandle::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientHandle", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientHandleChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientHandle::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PClientHandleChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PClientHandleChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PClientHandleChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PClientHandle'
    (aWriter)->WriteSentinel(568198396);
}

auto ParamTraits<::mozilla::dom::PClientHandleChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PClientHandle actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PClientHandle'
    if ((!((aReader)->ReadSentinel(568198396)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PClientHandle actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PClientHandleMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PClientHandle)");

        return {};
    }
    return static_cast<::mozilla::dom::PClientHandleChild*>(actor);
}

} // namespace IPC
