/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_mmse_fir_interpolator_cc = R"doc(Compute intermediate samples between signal samples x(k*Ts)

This implements a Minimum Mean Squared Error interpolator with 8 taps. It is suitable for signals where the bandwidth of interest B = 1/(4*Ts) Where Ts is the time between samples.


Although mu, the fractional delay, is specified as a float, it is actually quantized. 0.0 <= mu <= 1.0. That is, mu is quantized in the interpolate method to 32nd's of a sample.


For more information, in the GNU Radio source code, see:)doc";


static const char* __doc_gr_filter_mmse_fir_interpolator_cc_mmse_fir_interpolator_cc_0 =
    R"doc()doc";


static const char* __doc_gr_filter_mmse_fir_interpolator_cc_mmse_fir_interpolator_cc_1 =
    R"doc()doc";


static const char* __doc_gr_filter_mmse_fir_interpolator_cc_ntaps = R"doc()doc";


static const char* __doc_gr_filter_mmse_fir_interpolator_cc_nsteps = R"doc()doc";


static const char* __doc_gr_filter_mmse_fir_interpolator_cc_interpolate = R"doc(compute a single interpolated output value.

must have ntaps() valid entries and be 8-byte aligned. input[0] .. input[ntaps() - 1] are referenced to compute the output value. 
 must be in the range [0, 1] and specifies the fractional delay.)doc";
