{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GdkTexture@ representing a DMA buffer.
-- 
-- To create a @GdkDmabufTexture@, use the auxiliary
-- t'GI.Gdk.Objects.DmabufTextureBuilder.DmabufTextureBuilder' object.
-- 
-- Dma-buf textures can only be created on Linux.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DmabufTexture
    ( 

-- * Exported types
    DmabufTexture(..)                       ,
    IsDmabufTexture                         ,
    toDmabufTexture                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [computeConcreteSize]("GI.Gdk.Interfaces.Paintable#g:method:computeConcreteSize"), [download]("GI.Gdk.Objects.Texture#g:method:download"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [invalidateContents]("GI.Gdk.Interfaces.Paintable#g:method:invalidateContents"), [invalidateSize]("GI.Gdk.Interfaces.Paintable#g:method:invalidateSize"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [load]("GI.Gio.Interfaces.LoadableIcon#g:method:load"), [loadAsync]("GI.Gio.Interfaces.LoadableIcon#g:method:loadAsync"), [loadFinish]("GI.Gio.Interfaces.LoadableIcon#g:method:loadFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [saveToPng]("GI.Gdk.Objects.Texture#g:method:saveToPng"), [saveToPngBytes]("GI.Gdk.Objects.Texture#g:method:saveToPngBytes"), [saveToTiff]("GI.Gdk.Objects.Texture#g:method:saveToTiff"), [saveToTiffBytes]("GI.Gdk.Objects.Texture#g:method:saveToTiffBytes"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [snapshot]("GI.Gdk.Interfaces.Paintable#g:method:snapshot"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getColorState]("GI.Gdk.Objects.Texture#g:method:getColorState"), [getCurrentImage]("GI.Gdk.Interfaces.Paintable#g:method:getCurrentImage"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFlags]("GI.Gdk.Interfaces.Paintable#g:method:getFlags"), [getFormat]("GI.Gdk.Objects.Texture#g:method:getFormat"), [getHeight]("GI.Gdk.Objects.Texture#g:method:getHeight"), [getIntrinsicAspectRatio]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicAspectRatio"), [getIntrinsicHeight]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicHeight"), [getIntrinsicWidth]("GI.Gdk.Interfaces.Paintable#g:method:getIntrinsicWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidth]("GI.Gdk.Objects.Texture#g:method:getWidth").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDmabufTextureMethod              ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon

#endif

-- | Memory-managed wrapper type.
newtype DmabufTexture = DmabufTexture (SP.ManagedPtr DmabufTexture)
    deriving (Eq)

instance SP.ManagedPtrNewtype DmabufTexture where
    toManagedPtr (DmabufTexture p) = p

foreign import ccall "gdk_dmabuf_texture_get_type"
    c_gdk_dmabuf_texture_get_type :: IO B.Types.GType

instance B.Types.TypedObject DmabufTexture where
    glibType = c_gdk_dmabuf_texture_get_type

instance B.Types.GObject DmabufTexture

-- | Type class for types which can be safely cast to t'DmabufTexture', for instance with `toDmabufTexture`.
class (SP.GObject o, O.IsDescendantOf DmabufTexture o) => IsDmabufTexture o
instance (SP.GObject o, O.IsDescendantOf DmabufTexture o) => IsDmabufTexture o

instance O.HasParentTypes DmabufTexture
type instance O.ParentTypes DmabufTexture = '[Gdk.Texture.Texture, GObject.Object.Object, Gdk.Paintable.Paintable, Gio.Icon.Icon, Gio.LoadableIcon.LoadableIcon]

-- | Cast to t'DmabufTexture', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDmabufTexture :: (MIO.MonadIO m, IsDmabufTexture o) => o -> m DmabufTexture
toDmabufTexture = MIO.liftIO . B.ManagedPtr.unsafeCastTo DmabufTexture

-- | Convert t'DmabufTexture' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DmabufTexture) where
    gvalueGType_ = c_gdk_dmabuf_texture_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DmabufTexture)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DmabufTexture)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DmabufTexture ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDmabufTextureMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDmabufTextureMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDmabufTextureMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDmabufTextureMethod "computeConcreteSize" o = Gdk.Paintable.PaintableComputeConcreteSizeMethodInfo
    ResolveDmabufTextureMethod "download" o = Gdk.Texture.TextureDownloadMethodInfo
    ResolveDmabufTextureMethod "equal" o = Gio.Icon.IconEqualMethodInfo
    ResolveDmabufTextureMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDmabufTextureMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDmabufTextureMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDmabufTextureMethod "hash" o = Gio.Icon.IconHashMethodInfo
    ResolveDmabufTextureMethod "invalidateContents" o = Gdk.Paintable.PaintableInvalidateContentsMethodInfo
    ResolveDmabufTextureMethod "invalidateSize" o = Gdk.Paintable.PaintableInvalidateSizeMethodInfo
    ResolveDmabufTextureMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDmabufTextureMethod "load" o = Gio.LoadableIcon.LoadableIconLoadMethodInfo
    ResolveDmabufTextureMethod "loadAsync" o = Gio.LoadableIcon.LoadableIconLoadAsyncMethodInfo
    ResolveDmabufTextureMethod "loadFinish" o = Gio.LoadableIcon.LoadableIconLoadFinishMethodInfo
    ResolveDmabufTextureMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDmabufTextureMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDmabufTextureMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDmabufTextureMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDmabufTextureMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDmabufTextureMethod "saveToPng" o = Gdk.Texture.TextureSaveToPngMethodInfo
    ResolveDmabufTextureMethod "saveToPngBytes" o = Gdk.Texture.TextureSaveToPngBytesMethodInfo
    ResolveDmabufTextureMethod "saveToTiff" o = Gdk.Texture.TextureSaveToTiffMethodInfo
    ResolveDmabufTextureMethod "saveToTiffBytes" o = Gdk.Texture.TextureSaveToTiffBytesMethodInfo
    ResolveDmabufTextureMethod "serialize" o = Gio.Icon.IconSerializeMethodInfo
    ResolveDmabufTextureMethod "snapshot" o = Gdk.Paintable.PaintableSnapshotMethodInfo
    ResolveDmabufTextureMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDmabufTextureMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDmabufTextureMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDmabufTextureMethod "toString" o = Gio.Icon.IconToStringMethodInfo
    ResolveDmabufTextureMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDmabufTextureMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDmabufTextureMethod "getColorState" o = Gdk.Texture.TextureGetColorStateMethodInfo
    ResolveDmabufTextureMethod "getCurrentImage" o = Gdk.Paintable.PaintableGetCurrentImageMethodInfo
    ResolveDmabufTextureMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDmabufTextureMethod "getFlags" o = Gdk.Paintable.PaintableGetFlagsMethodInfo
    ResolveDmabufTextureMethod "getFormat" o = Gdk.Texture.TextureGetFormatMethodInfo
    ResolveDmabufTextureMethod "getHeight" o = Gdk.Texture.TextureGetHeightMethodInfo
    ResolveDmabufTextureMethod "getIntrinsicAspectRatio" o = Gdk.Paintable.PaintableGetIntrinsicAspectRatioMethodInfo
    ResolveDmabufTextureMethod "getIntrinsicHeight" o = Gdk.Paintable.PaintableGetIntrinsicHeightMethodInfo
    ResolveDmabufTextureMethod "getIntrinsicWidth" o = Gdk.Paintable.PaintableGetIntrinsicWidthMethodInfo
    ResolveDmabufTextureMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDmabufTextureMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDmabufTextureMethod "getWidth" o = Gdk.Texture.TextureGetWidthMethodInfo
    ResolveDmabufTextureMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDmabufTextureMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDmabufTextureMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDmabufTextureMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDmabufTextureMethod t DmabufTexture, O.OverloadedMethod info DmabufTexture p) => OL.IsLabel t (DmabufTexture -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDmabufTextureMethod t DmabufTexture, O.OverloadedMethod info DmabufTexture p, R.HasField t DmabufTexture p) => R.HasField t DmabufTexture p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDmabufTextureMethod t DmabufTexture, O.OverloadedMethodInfo info DmabufTexture) => OL.IsLabel t (O.MethodProxy info DmabufTexture) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DmabufTexture
type instance O.AttributeList DmabufTexture = DmabufTextureAttributeList
type DmabufTextureAttributeList = ('[ '("colorState", Gdk.Texture.TextureColorStatePropertyInfo), '("height", Gdk.Texture.TextureHeightPropertyInfo), '("width", Gdk.Texture.TextureWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DmabufTexture = DmabufTextureSignalList
type DmabufTextureSignalList = ('[ '("invalidateContents", Gdk.Paintable.PaintableInvalidateContentsSignalInfo), '("invalidateSize", Gdk.Paintable.PaintableInvalidateSizeSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


