{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Sorts items by comparing strings.
-- 
-- To obtain the strings to compare, this sorter evaluates a
-- t'GI.Gtk.Objects.Expression.Expression'.
-- 
-- It does the comparison in a linguistically correct way using the
-- current locale by normalizing Unicode strings and possibly case-folding
-- them before performing the comparison.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.StringSorter
    ( 

-- * Exported types
    StringSorter(..)                        ,
    IsStringSorter                          ,
    toStringSorter                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCollation]("GI.Gtk.Objects.StringSorter#g:method:getCollation"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getExpression]("GI.Gtk.Objects.StringSorter#g:method:getExpression"), [getIgnoreCase]("GI.Gtk.Objects.StringSorter#g:method:getIgnoreCase"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setCollation]("GI.Gtk.Objects.StringSorter#g:method:setCollation"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setExpression]("GI.Gtk.Objects.StringSorter#g:method:setExpression"), [setIgnoreCase]("GI.Gtk.Objects.StringSorter#g:method:setIgnoreCase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveStringSorterMethod               ,
#endif

-- ** getCollation #method:getCollation#

#if defined(ENABLE_OVERLOADING)
    StringSorterGetCollationMethodInfo      ,
#endif
    stringSorterGetCollation                ,


-- ** getExpression #method:getExpression#

#if defined(ENABLE_OVERLOADING)
    StringSorterGetExpressionMethodInfo     ,
#endif
    stringSorterGetExpression               ,


-- ** getIgnoreCase #method:getIgnoreCase#

#if defined(ENABLE_OVERLOADING)
    StringSorterGetIgnoreCaseMethodInfo     ,
#endif
    stringSorterGetIgnoreCase               ,


-- ** new #method:new#

    stringSorterNew                         ,


-- ** setCollation #method:setCollation#

#if defined(ENABLE_OVERLOADING)
    StringSorterSetCollationMethodInfo      ,
#endif
    stringSorterSetCollation                ,


-- ** setExpression #method:setExpression#

#if defined(ENABLE_OVERLOADING)
    StringSorterSetExpressionMethodInfo     ,
#endif
    stringSorterSetExpression               ,


-- ** setIgnoreCase #method:setIgnoreCase#

#if defined(ENABLE_OVERLOADING)
    StringSorterSetIgnoreCaseMethodInfo     ,
#endif
    stringSorterSetIgnoreCase               ,




 -- * Properties


-- ** collation #attr:collation#
-- | The collation method to use for sorting.
-- 
-- The @GTK_COLLATION_NONE@ value is useful when the expression already
-- returns collation keys, or strings that need to be compared byte-by-byte.
-- 
-- The default value, @GTK_COLLATION_UNICODE@, compares strings according
-- to the <https://www.unicode.org/reports/tr10/ Unicode collation algorithm>.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    StringSorterCollationPropertyInfo       ,
#endif
    constructStringSorterCollation          ,
    getStringSorterCollation                ,
    setStringSorterCollation                ,
#if defined(ENABLE_OVERLOADING)
    stringSorterCollation                   ,
#endif


-- ** expression #attr:expression#
-- | The expression to evaluate on item to get a string to compare with.

#if defined(ENABLE_OVERLOADING)
    StringSorterExpressionPropertyInfo      ,
#endif
    clearStringSorterExpression             ,
    constructStringSorterExpression         ,
    getStringSorterExpression               ,
    setStringSorterExpression               ,
#if defined(ENABLE_OVERLOADING)
    stringSorterExpression                  ,
#endif


-- ** ignoreCase #attr:ignoreCase#
-- | If sorting is case sensitive.

#if defined(ENABLE_OVERLOADING)
    StringSorterIgnoreCasePropertyInfo      ,
#endif
    constructStringSorterIgnoreCase         ,
    getStringSorterIgnoreCase               ,
    setStringSorterIgnoreCase               ,
#if defined(ENABLE_OVERLOADING)
    stringSorterIgnoreCase                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype StringSorter = StringSorter (SP.ManagedPtr StringSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype StringSorter where
    toManagedPtr (StringSorter p) = p

foreign import ccall "gtk_string_sorter_get_type"
    c_gtk_string_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject StringSorter where
    glibType = c_gtk_string_sorter_get_type

instance B.Types.GObject StringSorter

-- | Type class for types which can be safely cast to t'StringSorter', for instance with `toStringSorter`.
class (SP.GObject o, O.IsDescendantOf StringSorter o) => IsStringSorter o
instance (SP.GObject o, O.IsDescendantOf StringSorter o) => IsStringSorter o

instance O.HasParentTypes StringSorter
type instance O.ParentTypes StringSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object]

-- | Cast to t'StringSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toStringSorter :: (MIO.MonadIO m, IsStringSorter o) => o -> m StringSorter
toStringSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo StringSorter

-- | Convert t'StringSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe StringSorter) where
    gvalueGType_ = c_gtk_string_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr StringSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr StringSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject StringSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStringSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStringSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStringSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStringSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveStringSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveStringSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStringSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStringSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStringSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStringSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStringSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStringSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStringSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStringSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStringSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStringSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStringSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStringSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStringSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStringSorterMethod "getCollation" o = StringSorterGetCollationMethodInfo
    ResolveStringSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStringSorterMethod "getExpression" o = StringSorterGetExpressionMethodInfo
    ResolveStringSorterMethod "getIgnoreCase" o = StringSorterGetIgnoreCaseMethodInfo
    ResolveStringSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveStringSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStringSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStringSorterMethod "setCollation" o = StringSorterSetCollationMethodInfo
    ResolveStringSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStringSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStringSorterMethod "setExpression" o = StringSorterSetExpressionMethodInfo
    ResolveStringSorterMethod "setIgnoreCase" o = StringSorterSetIgnoreCaseMethodInfo
    ResolveStringSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStringSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStringSorterMethod t StringSorter, O.OverloadedMethod info StringSorter p) => OL.IsLabel t (StringSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStringSorterMethod t StringSorter, O.OverloadedMethod info StringSorter p, R.HasField t StringSorter p) => R.HasField t StringSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStringSorterMethod t StringSorter, O.OverloadedMethodInfo info StringSorter) => OL.IsLabel t (O.MethodProxy info StringSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "collation"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Collation"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@collation@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringSorter #collation
-- @
getStringSorterCollation :: (MonadIO m, IsStringSorter o) => o -> m Gtk.Enums.Collation
getStringSorterCollation obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "collation"

-- | Set the value of the “@collation@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringSorter [ #collation 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringSorterCollation :: (MonadIO m, IsStringSorter o) => o -> Gtk.Enums.Collation -> m ()
setStringSorterCollation obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "collation" val

-- | Construct a t'GValueConstruct' with valid value for the “@collation@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringSorterCollation :: (IsStringSorter o, MIO.MonadIO m) => Gtk.Enums.Collation -> m (GValueConstruct o)
constructStringSorterCollation val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "collation" val

#if defined(ENABLE_OVERLOADING)
data StringSorterCollationPropertyInfo
instance AttrInfo StringSorterCollationPropertyInfo where
    type AttrAllowedOps StringSorterCollationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StringSorterCollationPropertyInfo = IsStringSorter
    type AttrSetTypeConstraint StringSorterCollationPropertyInfo = (~) Gtk.Enums.Collation
    type AttrTransferTypeConstraint StringSorterCollationPropertyInfo = (~) Gtk.Enums.Collation
    type AttrTransferType StringSorterCollationPropertyInfo = Gtk.Enums.Collation
    type AttrGetType StringSorterCollationPropertyInfo = Gtk.Enums.Collation
    type AttrLabel StringSorterCollationPropertyInfo = "collation"
    type AttrOrigin StringSorterCollationPropertyInfo = StringSorter
    attrGet = getStringSorterCollation
    attrSet = setStringSorterCollation
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringSorterCollation
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.collation"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#g:attr:collation"
        })
#endif

-- VVV Prop "expression"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Expression"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringSorter #expression
-- @
getStringSorterExpression :: (MonadIO m, IsStringSorter o) => o -> m (Maybe Gtk.Expression.Expression)
getStringSorterExpression obj = MIO.liftIO $ B.Properties.getObjectPropertyIsGValueInstance obj "expression"

-- | Set the value of the “@expression@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringSorter [ #expression 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringSorterExpression :: (MonadIO m, IsStringSorter o, Gtk.Expression.IsExpression a) => o -> a -> m ()
setStringSorterExpression obj val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Just val')

-- | Construct a t'GValueConstruct' with valid value for the “@expression@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringSorterExpression :: (IsStringSorter o, MIO.MonadIO m, Gtk.Expression.IsExpression a) => a -> m (GValueConstruct o)
constructStringSorterExpression val = MIO.liftIO $ do
    val' <- Gtk.Expression.toExpression val
    MIO.liftIO $ B.Properties.constructObjectPropertyIsGValueInstance "expression" (P.Just val')

-- | Set the value of the “@expression@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #expression
-- @
clearStringSorterExpression :: (MonadIO m, IsStringSorter o) => o -> m ()
clearStringSorterExpression obj = liftIO $ B.Properties.setObjectPropertyIsGValueInstance obj "expression" (Nothing :: Maybe Gtk.Expression.Expression)

#if defined(ENABLE_OVERLOADING)
data StringSorterExpressionPropertyInfo
instance AttrInfo StringSorterExpressionPropertyInfo where
    type AttrAllowedOps StringSorterExpressionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StringSorterExpressionPropertyInfo = IsStringSorter
    type AttrSetTypeConstraint StringSorterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferTypeConstraint StringSorterExpressionPropertyInfo = (~) Gtk.Expression.Expression
    type AttrTransferType StringSorterExpressionPropertyInfo = Gtk.Expression.Expression
    type AttrGetType StringSorterExpressionPropertyInfo = (Maybe Gtk.Expression.Expression)
    type AttrLabel StringSorterExpressionPropertyInfo = "expression"
    type AttrOrigin StringSorterExpressionPropertyInfo = StringSorter
    attrGet = getStringSorterExpression
    attrSet = setStringSorterExpression
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringSorterExpression
    attrClear = clearStringSorterExpression
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.expression"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#g:attr:expression"
        })
#endif

-- VVV Prop "ignore-case"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@ignore-case@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stringSorter #ignoreCase
-- @
getStringSorterIgnoreCase :: (MonadIO m, IsStringSorter o) => o -> m Bool
getStringSorterIgnoreCase obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "ignore-case"

-- | Set the value of the “@ignore-case@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stringSorter [ #ignoreCase 'Data.GI.Base.Attributes.:=' value ]
-- @
setStringSorterIgnoreCase :: (MonadIO m, IsStringSorter o) => o -> Bool -> m ()
setStringSorterIgnoreCase obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "ignore-case" val

-- | Construct a t'GValueConstruct' with valid value for the “@ignore-case@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStringSorterIgnoreCase :: (IsStringSorter o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStringSorterIgnoreCase val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "ignore-case" val

#if defined(ENABLE_OVERLOADING)
data StringSorterIgnoreCasePropertyInfo
instance AttrInfo StringSorterIgnoreCasePropertyInfo where
    type AttrAllowedOps StringSorterIgnoreCasePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StringSorterIgnoreCasePropertyInfo = IsStringSorter
    type AttrSetTypeConstraint StringSorterIgnoreCasePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StringSorterIgnoreCasePropertyInfo = (~) Bool
    type AttrTransferType StringSorterIgnoreCasePropertyInfo = Bool
    type AttrGetType StringSorterIgnoreCasePropertyInfo = Bool
    type AttrLabel StringSorterIgnoreCasePropertyInfo = "ignore-case"
    type AttrOrigin StringSorterIgnoreCasePropertyInfo = StringSorter
    attrGet = getStringSorterIgnoreCase
    attrSet = setStringSorterIgnoreCase
    attrTransfer _ v = do
        return v
    attrConstruct = constructStringSorterIgnoreCase
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.ignoreCase"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#g:attr:ignoreCase"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList StringSorter
type instance O.AttributeList StringSorter = StringSorterAttributeList
type StringSorterAttributeList = ('[ '("collation", StringSorterCollationPropertyInfo), '("expression", StringSorterExpressionPropertyInfo), '("ignoreCase", StringSorterIgnoreCasePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stringSorterCollation :: AttrLabelProxy "collation"
stringSorterCollation = AttrLabelProxy

stringSorterExpression :: AttrLabelProxy "expression"
stringSorterExpression = AttrLabelProxy

stringSorterIgnoreCase :: AttrLabelProxy "ignoreCase"
stringSorterIgnoreCase = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList StringSorter = StringSorterSignalList
type StringSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method StringSorter::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The expression to evaluate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "StringSorter" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_new" gtk_string_sorter_new :: 
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO (Ptr StringSorter)

-- | Creates a new string sorter that compares items using the given
-- /@expression@/.
-- 
-- Unless an expression is set on it, this sorter will always
-- compare items as invalid.
stringSorterNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Expression.IsExpression a) =>
    Maybe (a)
    -- ^ /@expression@/: The expression to evaluate
    -> m StringSorter
    -- ^ __Returns:__ a new @GtkStringSorter@
stringSorterNew expression = liftIO $ do
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- B.ManagedPtr.disownManagedPtr jExpression
            return jExpression'
    result <- gtk_string_sorter_new maybeExpression
    checkUnexpectedReturnNULL "stringSorterNew" result
    result' <- (wrapObject StringSorter) result
    whenJust expression touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method StringSorter::get_collation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Collation" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_get_collation" gtk_string_sorter_get_collation :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    IO CUInt

-- | Gets which collation method the sorter uses.
-- 
-- /Since: 4.10/
stringSorterGetCollation ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> m Gtk.Enums.Collation
    -- ^ __Returns:__ The collation method
stringSorterGetCollation self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_sorter_get_collation self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StringSorterGetCollationMethodInfo
instance (signature ~ (m Gtk.Enums.Collation), MonadIO m, IsStringSorter a) => O.OverloadedMethod StringSorterGetCollationMethodInfo a signature where
    overloadedMethod = stringSorterGetCollation

instance O.OverloadedMethodInfo StringSorterGetCollationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterGetCollation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterGetCollation"
        })


#endif

-- method StringSorter::get_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Expression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_get_expression" gtk_string_sorter_get_expression :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    IO (Ptr Gtk.Expression.Expression)

-- | Gets the expression that is evaluated to obtain strings from items.
stringSorterGetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> m (Maybe Gtk.Expression.Expression)
    -- ^ __Returns:__ a @GtkExpression@
stringSorterGetExpression self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_sorter_get_expression self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gtk.Expression.Expression) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StringSorterGetExpressionMethodInfo
instance (signature ~ (m (Maybe Gtk.Expression.Expression)), MonadIO m, IsStringSorter a) => O.OverloadedMethod StringSorterGetExpressionMethodInfo a signature where
    overloadedMethod = stringSorterGetExpression

instance O.OverloadedMethodInfo StringSorterGetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterGetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterGetExpression"
        })


#endif

-- method StringSorter::get_ignore_case
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_get_ignore_case" gtk_string_sorter_get_ignore_case :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    IO CInt

-- | Gets whether the sorter ignores case differences.
stringSorterGetIgnoreCase ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@self@/ is ignoring case differences
stringSorterGetIgnoreCase self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_string_sorter_get_ignore_case self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data StringSorterGetIgnoreCaseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStringSorter a) => O.OverloadedMethod StringSorterGetIgnoreCaseMethodInfo a signature where
    overloadedMethod = stringSorterGetIgnoreCase

instance O.OverloadedMethodInfo StringSorterGetIgnoreCaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterGetIgnoreCase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterGetIgnoreCase"
        })


#endif

-- method StringSorter::set_collation
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "collation"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Collation" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the collation method"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_set_collation" gtk_string_sorter_set_collation :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    CUInt ->                                -- collation : TInterface (Name {namespace = "Gtk", name = "Collation"})
    IO ()

-- | Sets the collation method to use for sorting.
-- 
-- /Since: 4.10/
stringSorterSetCollation ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> Gtk.Enums.Collation
    -- ^ /@collation@/: the collation method
    -> m ()
stringSorterSetCollation self collation = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let collation' = (fromIntegral . fromEnum) collation
    gtk_string_sorter_set_collation self' collation'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringSorterSetCollationMethodInfo
instance (signature ~ (Gtk.Enums.Collation -> m ()), MonadIO m, IsStringSorter a) => O.OverloadedMethod StringSorterSetCollationMethodInfo a signature where
    overloadedMethod = stringSorterSetCollation

instance O.OverloadedMethodInfo StringSorterSetCollationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterSetCollation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterSetCollation"
        })


#endif

-- method StringSorter::set_expression
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Expression" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkExpression`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_set_expression" gtk_string_sorter_set_expression :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    Ptr Gtk.Expression.Expression ->        -- expression : TInterface (Name {namespace = "Gtk", name = "Expression"})
    IO ()

-- | Sets the expression that is evaluated to obtain strings from items.
-- 
-- The expression must have the type @/G_TYPE_STRING/@.
stringSorterSetExpression ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a, Gtk.Expression.IsExpression b) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> Maybe (b)
    -- ^ /@expression@/: a @GtkExpression@
    -> m ()
stringSorterSetExpression self expression = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeExpression <- case expression of
        Nothing -> return FP.nullPtr
        Just jExpression -> do
            jExpression' <- unsafeManagedPtrCastPtr jExpression
            return jExpression'
    gtk_string_sorter_set_expression self' maybeExpression
    touchManagedPtr self
    whenJust expression touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data StringSorterSetExpressionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsStringSorter a, Gtk.Expression.IsExpression b) => O.OverloadedMethod StringSorterSetExpressionMethodInfo a signature where
    overloadedMethod = stringSorterSetExpression

instance O.OverloadedMethodInfo StringSorterSetExpressionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterSetExpression",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterSetExpression"
        })


#endif

-- method StringSorter::set_ignore_case
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "StringSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStringSorter`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ignore_case"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to ignore case differences"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_string_sorter_set_ignore_case" gtk_string_sorter_set_ignore_case :: 
    Ptr StringSorter ->                     -- self : TInterface (Name {namespace = "Gtk", name = "StringSorter"})
    CInt ->                                 -- ignore_case : TBasicType TBoolean
    IO ()

-- | Sets whether the sorter will ignore case differences.
stringSorterSetIgnoreCase ::
    (B.CallStack.HasCallStack, MonadIO m, IsStringSorter a) =>
    a
    -- ^ /@self@/: a @GtkStringSorter@
    -> Bool
    -- ^ /@ignoreCase@/: 'P.True' to ignore case differences
    -> m ()
stringSorterSetIgnoreCase self ignoreCase = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let ignoreCase' = (P.fromIntegral . P.fromEnum) ignoreCase
    gtk_string_sorter_set_ignore_case self' ignoreCase'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data StringSorterSetIgnoreCaseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStringSorter a) => O.OverloadedMethod StringSorterSetIgnoreCaseMethodInfo a signature where
    overloadedMethod = stringSorterSetIgnoreCase

instance O.OverloadedMethodInfo StringSorterSetIgnoreCaseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.StringSorter.stringSorterSetIgnoreCase",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-StringSorter.html#v:stringSorterSetIgnoreCase"
        })


#endif


