
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kshareddatacache_wrapper.h"

// Argument includes
#include <QString>
#include <kshareddatacache.h>
#include <qbytearray.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KSharedDataCache_Type = nullptr;
static PyTypeObject *Sbk_KSharedDataCache_TypeF(void)
{
    return _Sbk_KSharedDataCache_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KSharedDataCache_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KSharedDataCache >()))
        return -1;

    ::KSharedDataCache *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:KSharedDataCache", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KSharedDataCache::KSharedDataCache(QString,uint,uint=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // KSharedDataCache(QString,uint,uint)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
            overloadId = 0; // KSharedDataCache(QString,uint,uint)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"expectedItemSize", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2 = 0;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KSharedDataCache(QString,uint,uint)
            cptr = new ::KSharedDataCache(cppArg0, cppArg1, cppArg2);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KSharedDataCache >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KSharedDataCacheFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        cppSelf->clear();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSharedDataCacheFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSharedDataCache::contains(QString)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "contains", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // contains(QString)const
            bool cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_deleteCache(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KSharedDataCache::deleteCache(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // deleteCache(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "deleteCache", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // deleteCache(QString)
            ::KSharedDataCache::deleteCache(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSharedDataCacheFunc_evictionPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // evictionPolicy()const
        KSharedDataCache::EvictionPolicy cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->evictionPolicy();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_EvictionPolicy_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_find(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "find", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSharedDataCache::find(QString,QByteArray*)const->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[1])))) {
        overloadId = 0; // find(QString,QByteArray*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "find", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // find(QString,QByteArray*)const
            bool cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->find(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_freeSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // freeSize()const
        unsigned int cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->freeSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "insert", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KSharedDataCache::insert(QString,QByteArray)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insert(QString,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insert", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // insert(QString,QByteArray)
            bool cppResult = cppSelf->insert(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSharedDataCache::remove(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // remove(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "remove", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // remove(QString)
            bool cppResult = cppSelf->remove(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_setEvictionPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSharedDataCache::setEvictionPolicy(KSharedDataCache::EvictionPolicy)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_EvictionPolicy_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setEvictionPolicy(KSharedDataCache::EvictionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEvictionPolicy", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        ::KSharedDataCache::EvictionPolicy cppArg0{KSharedDataCache::NoEvictionPreference};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEvictionPolicy(KSharedDataCache::EvictionPolicy)
            cppSelf->setEvictionPolicy(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSharedDataCacheFunc_setTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSharedDataCache::setTimestamp(uint)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // setTimestamp(uint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTimestamp", errInfo, SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]);

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTimestamp(uint)
            cppSelf->setTimestamp(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KSharedDataCacheFunc_timestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // timestamp()const
        unsigned int cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->timestamp();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KSharedDataCacheFunc_totalSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KSharedDataCache *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // totalSize()const
        unsigned int cppResult = const_cast<const ::KSharedDataCache *>(cppSelf)->totalSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KSharedDataCache_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KSharedDataCache_EnumFlagInfo[] = {
    "EvictionPolicy:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KSharedDataCache_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_clear), METH_NOARGS, nullptr},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_contains), METH_O, nullptr},
    {"deleteCache", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_deleteCache), METH_O|METH_STATIC, nullptr},
    {"evictionPolicy", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_evictionPolicy), METH_NOARGS, nullptr},
    {"find", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_find), METH_VARARGS, nullptr},
    {"freeSize", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_freeSize), METH_NOARGS, nullptr},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_insert), METH_VARARGS, nullptr},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_remove), METH_O, nullptr},
    {"setEvictionPolicy", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_setEvictionPolicy), METH_O, nullptr},
    {"setTimestamp", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_setTimestamp), METH_O, nullptr},
    {"timestamp", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_timestamp), METH_NOARGS, nullptr},
    {"totalSize", reinterpret_cast<PyCFunction>(Sbk_KSharedDataCacheFunc_totalSize), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KSharedDataCache_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KSharedDataCache_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KSharedDataCache_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KSharedDataCache_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KSharedDataCache_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KSharedDataCache_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KSharedDataCache_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KSharedDataCache_spec = {
    "1:KCoreAddons.KSharedDataCache",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KSharedDataCache_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KSharedDataCache_EvictionPolicy(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KSharedDataCache::EvictionPolicy>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KSharedDataCache::EvictionPolicy *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KSharedDataCache_EvictionPolicy_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_EvictionPolicy_IDX])))
        return Enum_PythonToCpp_KSharedDataCache_EvictionPolicy;
    return {};
}

static PyObject *KSharedDataCache_EvictionPolicy_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KSharedDataCache::EvictionPolicy>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KSharedDataCache::EvictionPolicy *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KSharedDataCache_PythonToCpp_KSharedDataCache_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KSharedDataCache_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KSharedDataCache_PythonToCpp_KSharedDataCache_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KSharedDataCache_TypeF()))
        return KSharedDataCache_PythonToCpp_KSharedDataCache_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KSharedDataCache_PTR_CppToPython_KSharedDataCache(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KSharedDataCache_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KSharedDataCache_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KSharedDataCache_SignatureStrings[] = {
    "KCoreAddons.KSharedDataCache(self,cacheName:QString,defaultCacheSize:unsigned int,expectedItemSize:unsigned int=0)",
    "KCoreAddons.KSharedDataCache.clear(self)",
    "KCoreAddons.KSharedDataCache.contains(self,key:QString)->bool",
    "KCoreAddons.KSharedDataCache.deleteCache(cacheName:QString)",
    "KCoreAddons.KSharedDataCache.evictionPolicy(self)->KCoreAddons.KSharedDataCache.EvictionPolicy",
    "KCoreAddons.KSharedDataCache.find(self,key:QString,destination:typing.Union[PySide6.QtCore.QByteArray, char*])->bool",
    "KCoreAddons.KSharedDataCache.freeSize(self)->unsigned int",
    "KCoreAddons.KSharedDataCache.insert(self,key:QString,data:typing.Union[PySide6.QtCore.QByteArray, char*])->bool",
    "KCoreAddons.KSharedDataCache.remove(self,key:QString)->bool",
    "KCoreAddons.KSharedDataCache.setEvictionPolicy(self,newPolicy:KCoreAddons.KSharedDataCache.EvictionPolicy)",
    "KCoreAddons.KSharedDataCache.setTimestamp(self,newTimestamp:unsigned int)",
    "KCoreAddons.KSharedDataCache.timestamp(self)->unsigned int",
    "KCoreAddons.KSharedDataCache.totalSize(self)->unsigned int",
    nullptr}; // Sentinel
#else
static constexpr size_t KSharedDataCache_SignatureByteSize = 294;
static constexpr uint8_t KSharedDataCache_SignatureBytes[294] = {
    0x78, 0xda, 0xb5, 0x93, 0xcd, 0x4e, 0xc3, 0x30, 0x10, 0x84, 0xef, 0x3c, 0x45, 0x8f, 0x04, 0xa5,
    0x11, 0x27, 0x0e, 0x91, 0xa8, 0x54, 0x4a, 0x0f, 0x28, 0x12, 0x6a, 0x14, 0x38, 0x21, 0x0e, 0xc6,
    0x9e, 0xb4, 0x16, 0x8e, 0x1d, 0xd9, 0xdb, 0x82, 0x79, 0x7a, 0x9c, 0x46, 0xad, 0x88, 0x02, 0x09,
    0x45, 0xe2, 0xe6, 0x9f, 0xdd, 0x99, 0x59, 0x7f, 0x72, 0xb6, 0x30, 0x16, 0x73, 0x21, 0x8c, 0x76,
    0x49, 0x56, 0x6c, 0x98, 0x85, 0xb8, 0x65, 0xc4, 0x16, 0x8c, 0x6f, 0x70, 0xee, 0xa0, 0xca, 0x98,
    0x37, 0xcb, 0x7b, 0x56, 0x21, 0xcd, 0x0b, 0xb2, 0x52, 0xaf, 0x63, 0x81, 0x92, 0x6d, 0x15, 0xed,
    0x6b, 0x0a, 0xf9, 0x81, 0x74, 0xab, 0x9d, 0x5c, 0x6b, 0x88, 0x89, 0xd4, 0x14, 0xe3, 0xbd, 0x06,
    0x27, 0x88, 0x3b, 0x42, 0xd5, 0xbb, 0xbd, 0xbe, 0x8c, 0xce, 0xb2, 0x01, 0xcb, 0x84, 0x2b, 0x30,
    0xbb, 0x37, 0x1e, 0x2b, 0x34, 0x9a, 0x98, 0xd4, 0xae, 0x0d, 0xf9, 0x0a, 0x7f, 0x88, 0x17, 0x4d,
    0x67, 0x2f, 0xc6, 0xa8, 0xe1, 0x6e, 0x01, 0x05, 0x42, 0x3b, 0x65, 0x6f, 0xc0, 0x11, 0x67, 0xec,
    0x24, 0x27, 0x69, 0xf4, 0xca, 0x28, 0xc9, 0x7d, 0x9b, 0x75, 0x3a, 0x1b, 0x6c, 0x59, 0x76, 0x5a,
    0x86, 0xe5, 0x4b, 0xa9, 0x45, 0x6f, 0xa8, 0xf0, 0xe6, 0x8e, 0xa4, 0x66, 0x8d, 0x48, 0x4a, 0xbe,
    0x0e, 0x47, 0xc9, 0xa3, 0x0e, 0x9b, 0xa7, 0x95, 0x2f, 0xa4, 0xc0, 0x55, 0x92, 0x53, 0x23, 0x9a,
    0xe4, 0x37, 0x9e, 0x30, 0xb7, 0x96, 0xf9, 0x78, 0xc2, 0x83, 0xf2, 0xc5, 0xf3, 0xaf, 0xde, 0xa3,
    0xb4, 0xd8, 0xa3, 0x3c, 0x4c, 0xf3, 0x95, 0xd9, 0x70, 0x67, 0x40, 0x00, 0x4b, 0xdf, 0x04, 0x0e,
    0x15, 0xff, 0x91, 0xd4, 0xa2, 0x32, 0x3b, 0xfc, 0x8d, 0xba, 0x03, 0x2d, 0xfb, 0xf0, 0x62, 0x8d,
    0xb7, 0x76, 0x9b, 0x9e, 0x00, 0x31, 0x1a, 0xb5, 0x7a, 0x90, 0x55, 0x80, 0xc6, 0xaa, 0xfa, 0xe8,
    0x72, 0x3c, 0xe9, 0xfc, 0x89, 0x11, 0x25, 0xea, 0xc8, 0x9c, 0xc4, 0x86, 0x0c, 0x31, 0xf5, 0x23,
    0xd6, 0x4f, 0xf8, 0x72, 0x73, 0xa4
};
#endif

PyTypeObject *init_KSharedDataCache(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX].type;

    Shiboken::AutoDecRef Sbk_KSharedDataCache_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KSharedDataCache_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KSharedDataCache",
        "KSharedDataCache*",
        &Sbk_KSharedDataCache_spec,
        &Shiboken::callCppDestructor< ::KSharedDataCache >,
        Sbk_KSharedDataCache_Type_bases.object(),
        0);
    auto *pyType = Sbk_KSharedDataCache_TypeF(); // references _Sbk_KSharedDataCache_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KSharedDataCache_SignatureStrings);
#else
    InitSignatureBytes(pyType, KSharedDataCache_SignatureBytes, KSharedDataCache_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KSharedDataCache_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KSharedDataCache_PythonToCpp_KSharedDataCache_PTR,
        is_KSharedDataCache_PythonToCpp_KSharedDataCache_PTR_Convertible,
        KSharedDataCache_PTR_CppToPython_KSharedDataCache);

    Shiboken::Conversions::registerConverterName(converter, "KSharedDataCache");
    Shiboken::Conversions::registerConverterName(converter, "KSharedDataCache*");
    Shiboken::Conversions::registerConverterName(converter, "KSharedDataCache&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KSharedDataCache).name());

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KSharedDataCache_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'EvictionPolicy'.
    const char *EvictionPolicy_Initializer[] = {
        "NoEvictionPreference",
        "EvictLeastRecentlyUsed",
        "EvictLeastOftenUsed",
        "EvictOldest",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t EvictionPolicy_InitializerValues[] = {
        uint8_t(KSharedDataCache::EvictionPolicy::NoEvictionPreference),   //  0x00  0
        uint8_t(KSharedDataCache::EvictionPolicy::EvictLeastRecentlyUsed), //  0x01  1
        uint8_t(KSharedDataCache::EvictionPolicy::EvictLeastOftenUsed),    //  0x02  2
        uint8_t(KSharedDataCache::EvictionPolicy::EvictOldest)             //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KSharedDataCache_TypeF(),
        "1:KCoreAddons.KSharedDataCache.EvictionPolicy",
        EvictionPolicy_Initializer, EvictionPolicy_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KSharedDataCache_EvictionPolicy_IDX].type = EType;
    // Register converter for enum 'KSharedDataCache::EvictionPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KSharedDataCache_EvictionPolicy_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KSharedDataCache_EvictionPolicy,
            is_Enum_PythonToCpp_KSharedDataCache_EvictionPolicy_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KSharedDataCache::EvictionPolicy");
        Shiboken::Conversions::registerConverterAlias(converter, "EvictionPolicy");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'EvictionPolicy' enum.

    qRegisterMetaType< ::KSharedDataCache *>();
    qRegisterMetaType< ::KSharedDataCache::EvictionPolicy >("KSharedDataCache::EvictionPolicy");

    return pyType;
}
