// Copyright (c) 2005-2023 Code Synthesis.
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis gives permission
// to link this program with the Xerces-C++ library (or with modified
// versions of Xerces-C++ that use the same license as Xerces-C++), and
// distribute linked combinations including the two. You must obey the GNU
// General Public License version 2 in all respects for all of the code
// used other than Xerces-C++. If you modify this copy of the program, you
// may extend this exception to your version of the program, but you are
// not obligated to do so. If you do not wish to do so, delete this
// exception statement from your version.
//
// Furthermore, Code Synthesis makes a special exception for the Free/Libre
// and Open Source Software (FLOSS) which is described in the accompanying
// FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "xCard.hxx"

namespace vcard_4_0
{
  // DateType
  //


  // DateTimeType
  //


  // TimeStampType
  //


  // BaseParameterType
  //


  // ArrayOfParameters
  //

  const ArrayOfParameters::baseParameter_sequence& ArrayOfParameters::
  baseParameter () const
  {
    return this->baseParameter_;
  }

  ArrayOfParameters::baseParameter_sequence& ArrayOfParameters::
  baseParameter ()
  {
    return this->baseParameter_;
  }

  void ArrayOfParameters::
  baseParameter (const baseParameter_sequence& s)
  {
    this->baseParameter_ = s;
  }


  // TextParameterType
  //

  const TextParameterType::text_type& TextParameterType::
  text () const
  {
    return this->text_.get ();
  }

  TextParameterType::text_type& TextParameterType::
  text ()
  {
    return this->text_.get ();
  }

  void TextParameterType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void TextParameterType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // UriParameterType
  //

  const UriParameterType::uri_type& UriParameterType::
  uri () const
  {
    return this->uri_.get ();
  }

  UriParameterType::uri_type& UriParameterType::
  uri ()
  {
    return this->uri_.get ();
  }

  void UriParameterType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void UriParameterType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }


  // TypeValueType
  //

  TypeValueType::
  TypeValueType (value v)
  : ::xml_schema::token (_xsd_TypeValueType_literals_[v])
  {
  }

  TypeValueType::
  TypeValueType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  TypeValueType::
  TypeValueType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  TypeValueType::
  TypeValueType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  TypeValueType::
  TypeValueType (const TypeValueType& v,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  TypeValueType& TypeValueType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_TypeValueType_literals_[v]);

    return *this;
  }


  // typeParamType
  //

  const typeParamType::text_sequence& typeParamType::
  text () const
  {
    return this->text_;
  }

  typeParamType::text_sequence& typeParamType::
  text ()
  {
    return this->text_;
  }

  void typeParamType::
  text (const text_sequence& s)
  {
    this->text_ = s;
  }


  // labelParamType
  //


  // prefParamType
  //

  const prefParamType::integer_type& prefParamType::
  integer () const
  {
    return this->integer_.get ();
  }

  prefParamType::integer_type& prefParamType::
  integer ()
  {
    return this->integer_.get ();
  }

  void prefParamType::
  integer (const integer_type& x)
  {
    this->integer_.set (x);
  }

  void prefParamType::
  integer (::std::unique_ptr< integer_type > x)
  {
    this->integer_.set (std::move (x));
  }

  const prefParamType::integer_type& prefParamType::
  integer_default_value ()
  {
    return integer_default_value_;
  }


  // xuidParamType
  //


  // BasePropertyType
  //

  const BasePropertyType::parameters_optional& BasePropertyType::
  parameters () const
  {
    return this->parameters_;
  }

  BasePropertyType::parameters_optional& BasePropertyType::
  parameters ()
  {
    return this->parameters_;
  }

  void BasePropertyType::
  parameters (const parameters_type& x)
  {
    this->parameters_.set (x);
  }

  void BasePropertyType::
  parameters (const parameters_optional& x)
  {
    this->parameters_ = x;
  }

  void BasePropertyType::
  parameters (::std::unique_ptr< parameters_type > x)
  {
    this->parameters_.set (std::move (x));
  }


  // TextPropertyType
  //

  const TextPropertyType::text_type& TextPropertyType::
  text () const
  {
    return this->text_.get ();
  }

  TextPropertyType::text_type& TextPropertyType::
  text ()
  {
    return this->text_.get ();
  }

  void TextPropertyType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void TextPropertyType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }


  // TextListPropertyType
  //

  const TextListPropertyType::text_sequence& TextListPropertyType::
  text () const
  {
    return this->text_;
  }

  TextListPropertyType::text_sequence& TextListPropertyType::
  text ()
  {
    return this->text_;
  }

  void TextListPropertyType::
  text (const text_sequence& s)
  {
    this->text_ = s;
  }


  // NonEmptyTextListPropertyType
  //

  const NonEmptyTextListPropertyType::text_sequence& NonEmptyTextListPropertyType::
  text () const
  {
    return this->text_;
  }

  NonEmptyTextListPropertyType::text_sequence& NonEmptyTextListPropertyType::
  text ()
  {
    return this->text_;
  }

  void NonEmptyTextListPropertyType::
  text (const text_sequence& s)
  {
    this->text_ = s;
  }


  // UriPropertyType
  //

  const UriPropertyType::uri_type& UriPropertyType::
  uri () const
  {
    return this->uri_.get ();
  }

  UriPropertyType::uri_type& UriPropertyType::
  uri ()
  {
    return this->uri_.get ();
  }

  void UriPropertyType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void UriPropertyType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }


  // TextOrUriPropertyType
  //

  const TextOrUriPropertyType::text_optional& TextOrUriPropertyType::
  text () const
  {
    return this->text_;
  }

  TextOrUriPropertyType::text_optional& TextOrUriPropertyType::
  text ()
  {
    return this->text_;
  }

  void TextOrUriPropertyType::
  text (const text_type& x)
  {
    this->text_.set (x);
  }

  void TextOrUriPropertyType::
  text (const text_optional& x)
  {
    this->text_ = x;
  }

  void TextOrUriPropertyType::
  text (::std::unique_ptr< text_type > x)
  {
    this->text_.set (std::move (x));
  }

  const TextOrUriPropertyType::uri_optional& TextOrUriPropertyType::
  uri () const
  {
    return this->uri_;
  }

  TextOrUriPropertyType::uri_optional& TextOrUriPropertyType::
  uri ()
  {
    return this->uri_;
  }

  void TextOrUriPropertyType::
  uri (const uri_type& x)
  {
    this->uri_.set (x);
  }

  void TextOrUriPropertyType::
  uri (const uri_optional& x)
  {
    this->uri_ = x;
  }

  void TextOrUriPropertyType::
  uri (::std::unique_ptr< uri_type > x)
  {
    this->uri_.set (std::move (x));
  }


  // DateDatetimePropertyType
  //

  const DateDatetimePropertyType::date_time_optional& DateDatetimePropertyType::
  date_time () const
  {
    return this->date_time_;
  }

  DateDatetimePropertyType::date_time_optional& DateDatetimePropertyType::
  date_time ()
  {
    return this->date_time_;
  }

  void DateDatetimePropertyType::
  date_time (const date_time_type& x)
  {
    this->date_time_.set (x);
  }

  void DateDatetimePropertyType::
  date_time (const date_time_optional& x)
  {
    this->date_time_ = x;
  }

  void DateDatetimePropertyType::
  date_time (::std::unique_ptr< date_time_type > x)
  {
    this->date_time_.set (std::move (x));
  }

  const DateDatetimePropertyType::date_optional& DateDatetimePropertyType::
  date () const
  {
    return this->date_;
  }

  DateDatetimePropertyType::date_optional& DateDatetimePropertyType::
  date ()
  {
    return this->date_;
  }

  void DateDatetimePropertyType::
  date (const date_type& x)
  {
    this->date_.set (x);
  }

  void DateDatetimePropertyType::
  date (const date_optional& x)
  {
    this->date_ = x;
  }

  void DateDatetimePropertyType::
  date (::std::unique_ptr< date_type > x)
  {
    this->date_.set (std::move (x));
  }


  // kindPropType
  //


  // revPropType
  //

  const revPropType::timestamp_type& revPropType::
  timestamp () const
  {
    return this->timestamp_.get ();
  }

  revPropType::timestamp_type& revPropType::
  timestamp ()
  {
    return this->timestamp_.get ();
  }

  void revPropType::
  timestamp (const timestamp_type& x)
  {
    this->timestamp_.set (x);
  }

  void revPropType::
  timestamp (::std::unique_ptr< timestamp_type > x)
  {
    this->timestamp_.set (std::move (x));
  }


  // prodidPropType
  //


  // categoriesPropType
  //


  // fnPropType
  //


  // uidPropType
  //


  // nPropType
  //

  const nPropType::surname_sequence& nPropType::
  surname () const
  {
    return this->surname_;
  }

  nPropType::surname_sequence& nPropType::
  surname ()
  {
    return this->surname_;
  }

  void nPropType::
  surname (const surname_sequence& s)
  {
    this->surname_ = s;
  }

  const nPropType::given_sequence& nPropType::
  given () const
  {
    return this->given_;
  }

  nPropType::given_sequence& nPropType::
  given ()
  {
    return this->given_;
  }

  void nPropType::
  given (const given_sequence& s)
  {
    this->given_ = s;
  }

  const nPropType::additional_sequence& nPropType::
  additional () const
  {
    return this->additional_;
  }

  nPropType::additional_sequence& nPropType::
  additional ()
  {
    return this->additional_;
  }

  void nPropType::
  additional (const additional_sequence& s)
  {
    this->additional_ = s;
  }

  const nPropType::prefix_sequence& nPropType::
  prefix () const
  {
    return this->prefix_;
  }

  nPropType::prefix_sequence& nPropType::
  prefix ()
  {
    return this->prefix_;
  }

  void nPropType::
  prefix (const prefix_sequence& s)
  {
    this->prefix_ = s;
  }

  const nPropType::suffix_sequence& nPropType::
  suffix () const
  {
    return this->suffix_;
  }

  nPropType::suffix_sequence& nPropType::
  suffix ()
  {
    return this->suffix_;
  }

  void nPropType::
  suffix (const suffix_sequence& s)
  {
    this->suffix_ = s;
  }


  // notePropType
  //


  // fburlPropType
  //


  // titlePropType
  //


  // affiliationPropType
  //

  const affiliationPropType::org_type& affiliationPropType::
  org () const
  {
    return this->org_.get ();
  }

  affiliationPropType::org_type& affiliationPropType::
  org ()
  {
    return this->org_.get ();
  }

  void affiliationPropType::
  org (const org_type& x)
  {
    this->org_.set (x);
  }

  void affiliationPropType::
  org (::std::unique_ptr< org_type > x)
  {
    this->org_.set (std::move (x));
  }

  const affiliationPropType::logo_optional& affiliationPropType::
  logo () const
  {
    return this->logo_;
  }

  affiliationPropType::logo_optional& affiliationPropType::
  logo ()
  {
    return this->logo_;
  }

  void affiliationPropType::
  logo (const logo_type& x)
  {
    this->logo_.set (x);
  }

  void affiliationPropType::
  logo (const logo_optional& x)
  {
    this->logo_ = x;
  }

  void affiliationPropType::
  logo (::std::unique_ptr< logo_type > x)
  {
    this->logo_.set (std::move (x));
  }

  const affiliationPropType::role_sequence& affiliationPropType::
  role () const
  {
    return this->role_;
  }

  affiliationPropType::role_sequence& affiliationPropType::
  role ()
  {
    return this->role_;
  }

  void affiliationPropType::
  role (const role_sequence& s)
  {
    this->role_ = s;
  }

  const affiliationPropType::related_sequence& affiliationPropType::
  related () const
  {
    return this->related_;
  }

  affiliationPropType::related_sequence& affiliationPropType::
  related ()
  {
    return this->related_;
  }

  void affiliationPropType::
  related (const related_sequence& s)
  {
    this->related_ = s;
  }

  const affiliationPropType::adr_sequence& affiliationPropType::
  adr () const
  {
    return this->adr_;
  }

  affiliationPropType::adr_sequence& affiliationPropType::
  adr ()
  {
    return this->adr_;
  }

  void affiliationPropType::
  adr (const adr_sequence& s)
  {
    this->adr_ = s;
  }

  const affiliationPropType::name_type& affiliationPropType::
  name () const
  {
    return this->name_.get ();
  }

  const affiliationPropType::name_type& affiliationPropType::
  name_default_value ()
  {
    return name_default_value_;
  }


  // urlPropType
  //


  // adrPropType
  //

  const adrPropType::pobox_type& adrPropType::
  pobox () const
  {
    return this->pobox_.get ();
  }

  adrPropType::pobox_type& adrPropType::
  pobox ()
  {
    return this->pobox_.get ();
  }

  void adrPropType::
  pobox (const pobox_type& x)
  {
    this->pobox_.set (x);
  }

  void adrPropType::
  pobox (::std::unique_ptr< pobox_type > x)
  {
    this->pobox_.set (std::move (x));
  }

  const adrPropType::ext_type& adrPropType::
  ext () const
  {
    return this->ext_.get ();
  }

  adrPropType::ext_type& adrPropType::
  ext ()
  {
    return this->ext_.get ();
  }

  void adrPropType::
  ext (const ext_type& x)
  {
    this->ext_.set (x);
  }

  void adrPropType::
  ext (::std::unique_ptr< ext_type > x)
  {
    this->ext_.set (std::move (x));
  }

  const adrPropType::street_type& adrPropType::
  street () const
  {
    return this->street_.get ();
  }

  adrPropType::street_type& adrPropType::
  street ()
  {
    return this->street_.get ();
  }

  void adrPropType::
  street (const street_type& x)
  {
    this->street_.set (x);
  }

  void adrPropType::
  street (::std::unique_ptr< street_type > x)
  {
    this->street_.set (std::move (x));
  }

  const adrPropType::locality_type& adrPropType::
  locality () const
  {
    return this->locality_.get ();
  }

  adrPropType::locality_type& adrPropType::
  locality ()
  {
    return this->locality_.get ();
  }

  void adrPropType::
  locality (const locality_type& x)
  {
    this->locality_.set (x);
  }

  void adrPropType::
  locality (::std::unique_ptr< locality_type > x)
  {
    this->locality_.set (std::move (x));
  }

  const adrPropType::region_type& adrPropType::
  region () const
  {
    return this->region_.get ();
  }

  adrPropType::region_type& adrPropType::
  region ()
  {
    return this->region_.get ();
  }

  void adrPropType::
  region (const region_type& x)
  {
    this->region_.set (x);
  }

  void adrPropType::
  region (::std::unique_ptr< region_type > x)
  {
    this->region_.set (std::move (x));
  }

  const adrPropType::code_type& adrPropType::
  code () const
  {
    return this->code_.get ();
  }

  adrPropType::code_type& adrPropType::
  code ()
  {
    return this->code_.get ();
  }

  void adrPropType::
  code (const code_type& x)
  {
    this->code_.set (x);
  }

  void adrPropType::
  code (::std::unique_ptr< code_type > x)
  {
    this->code_.set (std::move (x));
  }

  const adrPropType::country_type& adrPropType::
  country () const
  {
    return this->country_.get ();
  }

  adrPropType::country_type& adrPropType::
  country ()
  {
    return this->country_.get ();
  }

  void adrPropType::
  country (const country_type& x)
  {
    this->country_.set (x);
  }

  void adrPropType::
  country (::std::unique_ptr< country_type > x)
  {
    this->country_.set (std::move (x));
  }


  // nicknamePropType
  //


  // relatedPropType
  //


  // bdayPropType
  //


  // anniversaryPropType
  //


  // photoPropType
  //


  // SexType
  //

  SexType::
  SexType (value v)
  : ::xml_schema::token (_xsd_SexType_literals_[v])
  {
  }

  SexType::
  SexType (const char* v)
  : ::xml_schema::token (v)
  {
  }

  SexType::
  SexType (const ::std::string& v)
  : ::xml_schema::token (v)
  {
  }

  SexType::
  SexType (const ::xml_schema::token& v)
  : ::xml_schema::token (v)
  {
  }

  SexType::
  SexType (const SexType& v,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::token (v, f, c)
  {
  }

  SexType& SexType::
  operator= (value v)
  {
    static_cast< ::xml_schema::token& > (*this) = 
    ::xml_schema::token (_xsd_SexType_literals_[v]);

    return *this;
  }


  // genderPropType
  //

  const genderPropType::sex_type& genderPropType::
  sex () const
  {
    return this->sex_.get ();
  }

  genderPropType::sex_type& genderPropType::
  sex ()
  {
    return this->sex_.get ();
  }

  void genderPropType::
  sex (const sex_type& x)
  {
    this->sex_.set (x);
  }

  void genderPropType::
  sex (::std::unique_ptr< sex_type > x)
  {
    this->sex_.set (std::move (x));
  }


  // langPropType
  //

  const langPropType::language_tag_type& langPropType::
  language_tag () const
  {
    return this->language_tag_.get ();
  }

  langPropType::language_tag_type& langPropType::
  language_tag ()
  {
    return this->language_tag_.get ();
  }

  void langPropType::
  language_tag (const language_tag_type& x)
  {
    this->language_tag_.set (x);
  }

  void langPropType::
  language_tag (::std::unique_ptr< language_tag_type > x)
  {
    this->language_tag_.set (std::move (x));
  }


  // telPropType
  //


  // imppPropType
  //


  // emailPropType
  //


  // keyPropType
  //


  // geoPropType
  //


  // memberPropType
  //
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

#include <xsd/cxx/tree/type-factory-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_factory_plate< 0, char >
  type_factory_plate_init;
}

namespace vcard_4_0
{
  // DateType
  //

  DateType::
  DateType ()
  : ::xml_schema::string ()
  {
  }

  DateType::
  DateType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateType::
  DateType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateType::
  DateType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateType::
  DateType (const DateType& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  DateType::
  DateType (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  DateType::
  DateType (const ::xercesc::DOMAttr& a,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  DateType::
  DateType (const ::std::string& s,
            const ::xercesc::DOMElement* e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  DateType* DateType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateType (*this, f, c);
  }

  DateType::
  ~DateType ()
  {
  }

  // DateTimeType
  //

  DateTimeType::
  DateTimeType ()
  : ::xml_schema::string ()
  {
  }

  DateTimeType::
  DateTimeType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateTimeType::
  DateTimeType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateTimeType::
  DateTimeType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  DateTimeType::
  DateTimeType (const DateTimeType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::xercesc::DOMAttr& a,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  DateTimeType::
  DateTimeType (const ::std::string& s,
                const ::xercesc::DOMElement* e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  DateTimeType* DateTimeType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateTimeType (*this, f, c);
  }

  DateTimeType::
  ~DateTimeType ()
  {
  }

  // TimeStampType
  //

  TimeStampType::
  TimeStampType ()
  : ::xml_schema::string ()
  {
  }

  TimeStampType::
  TimeStampType (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  TimeStampType::
  TimeStampType (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  TimeStampType::
  TimeStampType (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  TimeStampType::
  TimeStampType (const TimeStampType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  TimeStampType::
  TimeStampType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  TimeStampType::
  TimeStampType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  TimeStampType::
  TimeStampType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  TimeStampType* TimeStampType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TimeStampType (*this, f, c);
  }

  TimeStampType::
  ~TimeStampType ()
  {
  }

  // BaseParameterType
  //

  BaseParameterType::
  BaseParameterType ()
  : ::xml_schema::type ()
  {
  }

  BaseParameterType::
  BaseParameterType (const BaseParameterType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (a, f, c)
  {
  }

  BaseParameterType::
  BaseParameterType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (s, e, f, c)
  {
  }

  BaseParameterType::
  ~BaseParameterType ()
  {
  }

  // ArrayOfParameters
  //

  ArrayOfParameters::
  ArrayOfParameters ()
  : ::xml_schema::type (),
    baseParameter_ (this)
  {
  }

  ArrayOfParameters::
  ArrayOfParameters (const ArrayOfParameters& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    baseParameter_ (x.baseParameter_, f, this)
  {
  }

  ArrayOfParameters::
  ArrayOfParameters (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    baseParameter_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ArrayOfParameters::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // baseParameter
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "baseParameter",
            "urn:ietf:params:xml:ns:vcard-4.0",
            0,
            true, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< baseParameter_type > r (
            dynamic_cast< baseParameter_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->baseParameter_.push_back (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  ArrayOfParameters* ArrayOfParameters::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ArrayOfParameters (*this, f, c);
  }

  ArrayOfParameters& ArrayOfParameters::
  operator= (const ArrayOfParameters& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->baseParameter_ = x.baseParameter_;
    }

    return *this;
  }

  ArrayOfParameters::
  ~ArrayOfParameters ()
  {
  }

  // TextParameterType
  //

  TextParameterType::
  TextParameterType (const text_type& text)
  : ::vcard_4_0::BaseParameterType (),
    text_ (text, this)
  {
  }

  TextParameterType::
  TextParameterType (const TextParameterType& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextParameterType::
  TextParameterType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextParameterType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  TextParameterType* TextParameterType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextParameterType (*this, f, c);
  }

  TextParameterType& TextParameterType::
  operator= (const TextParameterType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BaseParameterType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextParameterType::
  ~TextParameterType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextParameterType >
  _xsd_TextParameterType_type_factory_init (
    "TextParameterType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // UriParameterType
  //

  UriParameterType::
  UriParameterType (const uri_type& uri)
  : ::vcard_4_0::BaseParameterType (),
    uri_ (uri, this)
  {
  }

  UriParameterType::
  UriParameterType (const UriParameterType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (x, f, c),
    uri_ (x.uri_, f, this)
  {
  }

  UriParameterType::
  UriParameterType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    uri_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UriParameterType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!uri_.present ())
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uri_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uri",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  UriParameterType* UriParameterType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UriParameterType (*this, f, c);
  }

  UriParameterType& UriParameterType::
  operator= (const UriParameterType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BaseParameterType& > (*this) = x;
      this->uri_ = x.uri_;
    }

    return *this;
  }

  UriParameterType::
  ~UriParameterType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UriParameterType >
  _xsd_UriParameterType_type_factory_init (
    "UriParameterType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // TypeValueType
  //

  TypeValueType::
  TypeValueType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_TypeValueType_convert ();
  }

  TypeValueType::
  TypeValueType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_TypeValueType_convert ();
  }

  TypeValueType::
  TypeValueType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_TypeValueType_convert ();
  }

  TypeValueType* TypeValueType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TypeValueType (*this, f, c);
  }

  TypeValueType::value TypeValueType::
  _xsd_TypeValueType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_TypeValueType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_TypeValueType_indexes_,
                      _xsd_TypeValueType_indexes_ + 15,
                      *this,
                      c));

    if (i == _xsd_TypeValueType_indexes_ + 15 || _xsd_TypeValueType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const TypeValueType::
  _xsd_TypeValueType_literals_[15] =
  {
    "work",
    "home",
    "text",
    "voice",
    "fax",
    "cell",
    "video",
    "pager",
    "textphone",
    "x-car",
    "spouse",
    "child",
    "x-assistant",
    "x-manager",
    "x-blog"
  };

  const TypeValueType::value TypeValueType::
  _xsd_TypeValueType_indexes_[15] =
  {
    ::vcard_4_0::TypeValueType::cell,
    ::vcard_4_0::TypeValueType::child,
    ::vcard_4_0::TypeValueType::fax,
    ::vcard_4_0::TypeValueType::home,
    ::vcard_4_0::TypeValueType::pager,
    ::vcard_4_0::TypeValueType::spouse,
    ::vcard_4_0::TypeValueType::text,
    ::vcard_4_0::TypeValueType::textphone,
    ::vcard_4_0::TypeValueType::video,
    ::vcard_4_0::TypeValueType::voice,
    ::vcard_4_0::TypeValueType::work,
    ::vcard_4_0::TypeValueType::x_assistant,
    ::vcard_4_0::TypeValueType::x_blog,
    ::vcard_4_0::TypeValueType::x_car,
    ::vcard_4_0::TypeValueType::x_manager
  };

  // typeParamType
  //

  typeParamType::
  typeParamType ()
  : ::vcard_4_0::BaseParameterType (),
    text_ (this)
  {
  }

  typeParamType::
  typeParamType (const typeParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  typeParamType::
  typeParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void typeParamType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        this->text_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  typeParamType* typeParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class typeParamType (*this, f, c);
  }

  typeParamType& typeParamType::
  operator= (const typeParamType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BaseParameterType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  typeParamType::
  ~typeParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, typeParamType >
  _xsd_typeParamType_type_factory_init (
    "typeParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // labelParamType
  //

  labelParamType::
  labelParamType (const text_type& text)
  : ::vcard_4_0::TextParameterType (text)
  {
  }

  labelParamType::
  labelParamType (const labelParamType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::TextParameterType (x, f, c)
  {
  }

  labelParamType::
  labelParamType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::TextParameterType (e, f, c)
  {
  }

  labelParamType* labelParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class labelParamType (*this, f, c);
  }

  labelParamType::
  ~labelParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, labelParamType >
  _xsd_labelParamType_type_factory_init (
    "labelParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // prefParamType
  //

  const prefParamType::integer_type prefParamType::integer_default_value_ (
    "1");

  prefParamType::
  prefParamType (const integer_type& integer)
  : ::vcard_4_0::BaseParameterType (),
    integer_ (integer, this)
  {
  }

  prefParamType::
  prefParamType (const prefParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (x, f, c),
    integer_ (x.integer_, f, this)
  {
  }

  prefParamType::
  prefParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::BaseParameterType (e, f | ::xml_schema::flags::base, c),
    integer_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void prefParamType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // integer
      //
      if (n.name () == "integer" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< integer_type > r (
          integer_traits::create (i, f, this));

        if (!integer_.present ())
        {
          this->integer_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!integer_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "integer",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  prefParamType* prefParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class prefParamType (*this, f, c);
  }

  prefParamType& prefParamType::
  operator= (const prefParamType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BaseParameterType& > (*this) = x;
      this->integer_ = x.integer_;
    }

    return *this;
  }

  prefParamType::
  ~prefParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, prefParamType >
  _xsd_prefParamType_type_factory_init (
    "prefParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // xuidParamType
  //

  xuidParamType::
  xuidParamType (const uri_type& uri)
  : ::vcard_4_0::UriParameterType (uri)
  {
  }

  xuidParamType::
  xuidParamType (const xuidParamType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriParameterType (x, f, c)
  {
  }

  xuidParamType::
  xuidParamType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriParameterType (e, f, c)
  {
  }

  xuidParamType* xuidParamType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class xuidParamType (*this, f, c);
  }

  xuidParamType::
  ~xuidParamType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, xuidParamType >
  _xsd_xuidParamType_type_factory_init (
    "xuidParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_type_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "type",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::typeParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_label_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "label",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::labelParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_pref_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "pref",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::prefParamType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_x_uid_element_factory_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-uid",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::xuidParamType >);


  // BasePropertyType
  //

  BasePropertyType::
  BasePropertyType ()
  : ::xml_schema::type (),
    parameters_ (this)
  {
  }

  BasePropertyType::
  BasePropertyType (const BasePropertyType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    parameters_ (x.parameters_, f, this)
  {
  }

  BasePropertyType::
  BasePropertyType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    parameters_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void BasePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // parameters
      //
      if (n.name () == "parameters" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< parameters_type > r (
          parameters_traits::create (i, f, this));

        if (!this->parameters_)
        {
          this->parameters_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  BasePropertyType& BasePropertyType::
  operator= (const BasePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->parameters_ = x.parameters_;
    }

    return *this;
  }

  BasePropertyType::
  ~BasePropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_fn_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "fn",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::fnPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_n_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "n",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::nPropType >);


  static
  const ::xsd::cxx::tree::element_factory_initializer< 0, char >
  _xsd_bday_element_factory_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "bday",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::factory_impl< ::vcard_4_0::bdayPropType >);


  // TextPropertyType
  //

  TextPropertyType::
  TextPropertyType (const text_type& text)
  : ::vcard_4_0::BasePropertyType (),
    text_ (text, this)
  {
  }

  TextPropertyType::
  TextPropertyType (const TextPropertyType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextPropertyType::
  TextPropertyType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!text_.present ())
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!text_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "text",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  TextPropertyType* TextPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextPropertyType (*this, f, c);
  }

  TextPropertyType& TextPropertyType::
  operator= (const TextPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextPropertyType::
  ~TextPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextPropertyType >
  _xsd_TextPropertyType_type_factory_init (
    "TextPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // TextListPropertyType
  //

  TextListPropertyType::
  TextListPropertyType ()
  : ::vcard_4_0::BasePropertyType (),
    text_ (this)
  {
  }

  TextListPropertyType::
  TextListPropertyType (const TextListPropertyType& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  TextListPropertyType::
  TextListPropertyType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextListPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        this->text_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  TextListPropertyType* TextListPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextListPropertyType (*this, f, c);
  }

  TextListPropertyType& TextListPropertyType::
  operator= (const TextListPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  TextListPropertyType::
  ~TextListPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextListPropertyType >
  _xsd_TextListPropertyType_type_factory_init (
    "TextListPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // NonEmptyTextListPropertyType
  //

  NonEmptyTextListPropertyType::
  NonEmptyTextListPropertyType ()
  : ::vcard_4_0::BasePropertyType (),
    text_ (this)
  {
  }

  NonEmptyTextListPropertyType::
  NonEmptyTextListPropertyType (const NonEmptyTextListPropertyType& x,
                                ::xml_schema::flags f,
                                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this)
  {
  }

  NonEmptyTextListPropertyType::
  NonEmptyTextListPropertyType (const ::xercesc::DOMElement& e,
                                ::xml_schema::flags f,
                                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void NonEmptyTextListPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        this->text_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  NonEmptyTextListPropertyType* NonEmptyTextListPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class NonEmptyTextListPropertyType (*this, f, c);
  }

  NonEmptyTextListPropertyType& NonEmptyTextListPropertyType::
  operator= (const NonEmptyTextListPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
    }

    return *this;
  }

  NonEmptyTextListPropertyType::
  ~NonEmptyTextListPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, NonEmptyTextListPropertyType >
  _xsd_NonEmptyTextListPropertyType_type_factory_init (
    "NonEmptyTextListPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // UriPropertyType
  //

  UriPropertyType::
  UriPropertyType (const uri_type& uri)
  : ::vcard_4_0::BasePropertyType (),
    uri_ (uri, this)
  {
  }

  UriPropertyType::
  UriPropertyType (const UriPropertyType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    uri_ (x.uri_, f, this)
  {
  }

  UriPropertyType::
  UriPropertyType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    uri_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void UriPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!uri_.present ())
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!uri_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "uri",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  UriPropertyType* UriPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class UriPropertyType (*this, f, c);
  }

  UriPropertyType& UriPropertyType::
  operator= (const UriPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->uri_ = x.uri_;
    }

    return *this;
  }

  UriPropertyType::
  ~UriPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, UriPropertyType >
  _xsd_UriPropertyType_type_factory_init (
    "UriPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // TextOrUriPropertyType
  //

  TextOrUriPropertyType::
  TextOrUriPropertyType ()
  : ::vcard_4_0::BasePropertyType (),
    text_ (this),
    uri_ (this)
  {
  }

  TextOrUriPropertyType::
  TextOrUriPropertyType (const TextOrUriPropertyType& x,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    text_ (x.text_, f, this),
    uri_ (x.uri_, f, this)
  {
  }

  TextOrUriPropertyType::
  TextOrUriPropertyType (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f,
                         ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    text_ (this),
    uri_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TextOrUriPropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // text
      //
      if (n.name () == "text" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< text_type > r (
          text_traits::create (i, f, this));

        if (!this->text_)
        {
          this->text_.set (::std::move (r));
          continue;
        }
      }

      // uri
      //
      if (n.name () == "uri" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< uri_type > r (
          uri_traits::create (i, f, this));

        if (!this->uri_)
        {
          this->uri_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  TextOrUriPropertyType* TextOrUriPropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TextOrUriPropertyType (*this, f, c);
  }

  TextOrUriPropertyType& TextOrUriPropertyType::
  operator= (const TextOrUriPropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->text_ = x.text_;
      this->uri_ = x.uri_;
    }

    return *this;
  }

  TextOrUriPropertyType::
  ~TextOrUriPropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, TextOrUriPropertyType >
  _xsd_TextOrUriPropertyType_type_factory_init (
    "TextOrUriPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // DateDatetimePropertyType
  //

  DateDatetimePropertyType::
  DateDatetimePropertyType ()
  : ::vcard_4_0::BasePropertyType (),
    date_time_ (this),
    date_ (this)
  {
  }

  DateDatetimePropertyType::
  DateDatetimePropertyType (const DateDatetimePropertyType& x,
                            ::xml_schema::flags f,
                            ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    date_time_ (x.date_time_, f, this),
    date_ (x.date_, f, this)
  {
  }

  DateDatetimePropertyType::
  DateDatetimePropertyType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f,
                            ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    date_time_ (this),
    date_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DateDatetimePropertyType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // date-time
      //
      if (n.name () == "date-time" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< date_time_type > r (
          date_time_traits::create (i, f, this));

        if (!this->date_time_)
        {
          this->date_time_.set (::std::move (r));
          continue;
        }
      }

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        if (!this->date_)
        {
          this->date_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  DateDatetimePropertyType* DateDatetimePropertyType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateDatetimePropertyType (*this, f, c);
  }

  DateDatetimePropertyType& DateDatetimePropertyType::
  operator= (const DateDatetimePropertyType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->date_time_ = x.date_time_;
      this->date_ = x.date_;
    }

    return *this;
  }

  DateDatetimePropertyType::
  ~DateDatetimePropertyType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, DateDatetimePropertyType >
  _xsd_DateDatetimePropertyType_type_factory_init (
    "DateDatetimePropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // kindPropType
  //

  kindPropType::
  kindPropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  kindPropType::
  kindPropType (const kindPropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  kindPropType::
  kindPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  kindPropType* kindPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class kindPropType (*this, f, c);
  }

  kindPropType::
  ~kindPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, kindPropType >
  _xsd_kindPropType_type_factory_init (
    "kindPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // revPropType
  //

  revPropType::
  revPropType (const timestamp_type& timestamp)
  : ::vcard_4_0::BasePropertyType (),
    timestamp_ (timestamp, this)
  {
  }

  revPropType::
  revPropType (const revPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    timestamp_ (x.timestamp_, f, this)
  {
  }

  revPropType::
  revPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    timestamp_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void revPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // timestamp
      //
      if (n.name () == "timestamp" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< timestamp_type > r (
          timestamp_traits::create (i, f, this));

        if (!timestamp_.present ())
        {
          this->timestamp_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!timestamp_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "timestamp",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  revPropType* revPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class revPropType (*this, f, c);
  }

  revPropType& revPropType::
  operator= (const revPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->timestamp_ = x.timestamp_;
    }

    return *this;
  }

  revPropType::
  ~revPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, revPropType >
  _xsd_revPropType_type_factory_init (
    "revPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // prodidPropType
  //

  prodidPropType::
  prodidPropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  prodidPropType::
  prodidPropType (const prodidPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  prodidPropType::
  prodidPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  prodidPropType* prodidPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class prodidPropType (*this, f, c);
  }

  prodidPropType::
  ~prodidPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, prodidPropType >
  _xsd_prodidPropType_type_factory_init (
    "prodidPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // categoriesPropType
  //

  categoriesPropType::
  categoriesPropType ()
  : ::vcard_4_0::TextListPropertyType ()
  {
  }

  categoriesPropType::
  categoriesPropType (const categoriesPropType& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::vcard_4_0::TextListPropertyType (x, f, c)
  {
  }

  categoriesPropType::
  categoriesPropType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::vcard_4_0::TextListPropertyType (e, f, c)
  {
  }

  categoriesPropType* categoriesPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class categoriesPropType (*this, f, c);
  }

  categoriesPropType::
  ~categoriesPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, categoriesPropType >
  _xsd_categoriesPropType_type_factory_init (
    "categoriesPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // fnPropType
  //

  fnPropType::
  fnPropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  fnPropType::
  fnPropType (const fnPropType& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  fnPropType::
  fnPropType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  fnPropType* fnPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class fnPropType (*this, f, c);
  }

  fnPropType::
  ~fnPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, fnPropType >
  _xsd_fnPropType_type_factory_init (
    "fnPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // uidPropType
  //

  uidPropType::
  uidPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  uidPropType::
  uidPropType (const uidPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  uidPropType::
  uidPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  uidPropType* uidPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class uidPropType (*this, f, c);
  }

  uidPropType::
  ~uidPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, uidPropType >
  _xsd_uidPropType_type_factory_init (
    "uidPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // nPropType
  //

  nPropType::
  nPropType ()
  : ::vcard_4_0::BasePropertyType (),
    surname_ (this),
    given_ (this),
    additional_ (this),
    prefix_ (this),
    suffix_ (this)
  {
  }

  nPropType::
  nPropType (const nPropType& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    surname_ (x.surname_, f, this),
    given_ (x.given_, f, this),
    additional_ (x.additional_, f, this),
    prefix_ (x.prefix_, f, this),
    suffix_ (x.suffix_, f, this)
  {
  }

  nPropType::
  nPropType (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    surname_ (this),
    given_ (this),
    additional_ (this),
    prefix_ (this),
    suffix_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void nPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // surname
      //
      if (n.name () == "surname" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< surname_type > r (
          surname_traits::create (i, f, this));

        this->surname_.push_back (::std::move (r));
        continue;
      }

      // given
      //
      if (n.name () == "given" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< given_type > r (
          given_traits::create (i, f, this));

        this->given_.push_back (::std::move (r));
        continue;
      }

      // additional
      //
      if (n.name () == "additional" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< additional_type > r (
          additional_traits::create (i, f, this));

        this->additional_.push_back (::std::move (r));
        continue;
      }

      // prefix
      //
      if (n.name () == "prefix" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< prefix_type > r (
          prefix_traits::create (i, f, this));

        this->prefix_.push_back (::std::move (r));
        continue;
      }

      // suffix
      //
      if (n.name () == "suffix" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< suffix_type > r (
          suffix_traits::create (i, f, this));

        this->suffix_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  nPropType* nPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class nPropType (*this, f, c);
  }

  nPropType& nPropType::
  operator= (const nPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->surname_ = x.surname_;
      this->given_ = x.given_;
      this->additional_ = x.additional_;
      this->prefix_ = x.prefix_;
      this->suffix_ = x.suffix_;
    }

    return *this;
  }

  nPropType::
  ~nPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, nPropType >
  _xsd_nPropType_type_factory_init (
    "nPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // notePropType
  //

  notePropType::
  notePropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  notePropType::
  notePropType (const notePropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  notePropType::
  notePropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  notePropType* notePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class notePropType (*this, f, c);
  }

  notePropType::
  ~notePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, notePropType >
  _xsd_notePropType_type_factory_init (
    "notePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // fburlPropType
  //

  fburlPropType::
  fburlPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  fburlPropType::
  fburlPropType (const fburlPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  fburlPropType::
  fburlPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  fburlPropType* fburlPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class fburlPropType (*this, f, c);
  }

  fburlPropType::
  ~fburlPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, fburlPropType >
  _xsd_fburlPropType_type_factory_init (
    "fburlPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // titlePropType
  //

  titlePropType::
  titlePropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  titlePropType::
  titlePropType (const titlePropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  titlePropType::
  titlePropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  titlePropType* titlePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class titlePropType (*this, f, c);
  }

  titlePropType::
  ~titlePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, titlePropType >
  _xsd_titlePropType_type_factory_init (
    "titlePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // affiliationPropType
  //

  const affiliationPropType::name_type affiliationPropType::name_default_value_ (
    "Affiliation");

  affiliationPropType::
  affiliationPropType (const org_type& org)
  : ::vcard_4_0::BasePropertyType (),
    org_ (org, this),
    logo_ (this),
    role_ (this),
    related_ (this),
    adr_ (this),
    name_ (name_default_value (), this)
  {
  }

  affiliationPropType::
  affiliationPropType (::std::unique_ptr< org_type > org)
  : ::vcard_4_0::BasePropertyType (),
    org_ (std::move (org), this),
    logo_ (this),
    role_ (this),
    related_ (this),
    adr_ (this),
    name_ (name_default_value (), this)
  {
  }

  affiliationPropType::
  affiliationPropType (const affiliationPropType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    org_ (x.org_, f, this),
    logo_ (x.logo_, f, this),
    role_ (x.role_, f, this),
    related_ (x.related_, f, this),
    adr_ (x.adr_, f, this),
    name_ (x.name_, f, this)
  {
  }

  affiliationPropType::
  affiliationPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    org_ (this),
    logo_ (this),
    role_ (this),
    related_ (this),
    adr_ (this),
    name_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, true);
      this->parse (p, f);
    }
  }

  void affiliationPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // org
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "org",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< org_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!org_.present ())
          {
            ::std::unique_ptr< org_type > r (
              dynamic_cast< org_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->org_.set (::std::move (r));
            continue;
          }
        }
      }

      // logo
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "logo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< logo_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          if (!this->logo_)
          {
            ::std::unique_ptr< logo_type > r (
              dynamic_cast< logo_type* > (tmp.get ()));

            if (r.get ())
              tmp.release ();
            else
              throw ::xsd::cxx::tree::not_derived< char > ();

            this->logo_.set (::std::move (r));
            continue;
          }
        }
      }

      // role
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "role",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< role_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< role_type > r (
            dynamic_cast< role_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->role_.push_back (::std::move (r));
          continue;
        }
      }

      // related
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "related",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< related_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< related_type > r (
            dynamic_cast< related_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->related_.push_back (::std::move (r));
          continue;
        }
      }

      // adr
      //
      {
        ::std::unique_ptr< ::xsd::cxx::tree::type > tmp (
          ::xsd::cxx::tree::type_factory_map_instance< 0, char > ().create (
            "adr",
            "urn:ietf:params:xml:ns:vcard-4.0",
            &::xsd::cxx::tree::factory_impl< adr_type >,
            false, true, i, n, f, this));

        if (tmp.get () != 0)
        {
          ::std::unique_ptr< adr_type > r (
            dynamic_cast< adr_type* > (tmp.get ()));

          if (r.get ())
            tmp.release ();
          else
            throw ::xsd::cxx::tree::not_derived< char > ();

          this->adr_.push_back (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!org_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "org",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "name" && n.namespace_ ().empty ())
      {
        this->name_.set (name_traits::create (i, f, this));
        continue;
      }
    }

    if (!name_.present ())
    {
      this->name_.set (name_default_value ());
    }
  }

  affiliationPropType* affiliationPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class affiliationPropType (*this, f, c);
  }

  affiliationPropType& affiliationPropType::
  operator= (const affiliationPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->org_ = x.org_;
      this->logo_ = x.logo_;
      this->role_ = x.role_;
      this->related_ = x.related_;
      this->adr_ = x.adr_;
      this->name_ = x.name_;
    }

    return *this;
  }

  affiliationPropType::
  ~affiliationPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, affiliationPropType >
  _xsd_affiliationPropType_type_factory_init (
    "affiliationPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // urlPropType
  //

  urlPropType::
  urlPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  urlPropType::
  urlPropType (const urlPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  urlPropType::
  urlPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  urlPropType* urlPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class urlPropType (*this, f, c);
  }

  urlPropType::
  ~urlPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, urlPropType >
  _xsd_urlPropType_type_factory_init (
    "urlPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // adrPropType
  //

  adrPropType::
  adrPropType (const pobox_type& pobox,
               const ext_type& ext,
               const street_type& street,
               const locality_type& locality,
               const region_type& region,
               const code_type& code,
               const country_type& country)
  : ::vcard_4_0::BasePropertyType (),
    pobox_ (pobox, this),
    ext_ (ext, this),
    street_ (street, this),
    locality_ (locality, this),
    region_ (region, this),
    code_ (code, this),
    country_ (country, this)
  {
  }

  adrPropType::
  adrPropType (const adrPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    pobox_ (x.pobox_, f, this),
    ext_ (x.ext_, f, this),
    street_ (x.street_, f, this),
    locality_ (x.locality_, f, this),
    region_ (x.region_, f, this),
    code_ (x.code_, f, this),
    country_ (x.country_, f, this)
  {
  }

  adrPropType::
  adrPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    pobox_ (this),
    ext_ (this),
    street_ (this),
    locality_ (this),
    region_ (this),
    code_ (this),
    country_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void adrPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // pobox
      //
      if (n.name () == "pobox" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< pobox_type > r (
          pobox_traits::create (i, f, this));

        if (!pobox_.present ())
        {
          this->pobox_.set (::std::move (r));
          continue;
        }
      }

      // ext
      //
      if (n.name () == "ext" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< ext_type > r (
          ext_traits::create (i, f, this));

        if (!ext_.present ())
        {
          this->ext_.set (::std::move (r));
          continue;
        }
      }

      // street
      //
      if (n.name () == "street" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< street_type > r (
          street_traits::create (i, f, this));

        if (!street_.present ())
        {
          this->street_.set (::std::move (r));
          continue;
        }
      }

      // locality
      //
      if (n.name () == "locality" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< locality_type > r (
          locality_traits::create (i, f, this));

        if (!locality_.present ())
        {
          this->locality_.set (::std::move (r));
          continue;
        }
      }

      // region
      //
      if (n.name () == "region" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< region_type > r (
          region_traits::create (i, f, this));

        if (!region_.present ())
        {
          this->region_.set (::std::move (r));
          continue;
        }
      }

      // code
      //
      if (n.name () == "code" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< code_type > r (
          code_traits::create (i, f, this));

        if (!code_.present ())
        {
          this->code_.set (::std::move (r));
          continue;
        }
      }

      // country
      //
      if (n.name () == "country" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< country_type > r (
          country_traits::create (i, f, this));

        if (!country_.present ())
        {
          this->country_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!pobox_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "pobox",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!ext_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "ext",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!street_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "street",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!locality_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "locality",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!region_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "region",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!code_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "code",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }

    if (!country_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "country",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  adrPropType* adrPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class adrPropType (*this, f, c);
  }

  adrPropType& adrPropType::
  operator= (const adrPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->pobox_ = x.pobox_;
      this->ext_ = x.ext_;
      this->street_ = x.street_;
      this->locality_ = x.locality_;
      this->region_ = x.region_;
      this->code_ = x.code_;
      this->country_ = x.country_;
    }

    return *this;
  }

  adrPropType::
  ~adrPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, adrPropType >
  _xsd_adrPropType_type_factory_init (
    "adrPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // nicknamePropType
  //

  nicknamePropType::
  nicknamePropType ()
  : ::vcard_4_0::TextListPropertyType ()
  {
  }

  nicknamePropType::
  nicknamePropType (const nicknamePropType& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::TextListPropertyType (x, f, c)
  {
  }

  nicknamePropType::
  nicknamePropType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::vcard_4_0::TextListPropertyType (e, f, c)
  {
  }

  nicknamePropType* nicknamePropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class nicknamePropType (*this, f, c);
  }

  nicknamePropType::
  ~nicknamePropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, nicknamePropType >
  _xsd_nicknamePropType_type_factory_init (
    "nicknamePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // relatedPropType
  //

  relatedPropType::
  relatedPropType ()
  : ::vcard_4_0::TextOrUriPropertyType ()
  {
  }

  relatedPropType::
  relatedPropType (const relatedPropType& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::vcard_4_0::TextOrUriPropertyType (x, f, c)
  {
  }

  relatedPropType::
  relatedPropType (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::vcard_4_0::TextOrUriPropertyType (e, f, c)
  {
  }

  relatedPropType* relatedPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class relatedPropType (*this, f, c);
  }

  relatedPropType::
  ~relatedPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, relatedPropType >
  _xsd_relatedPropType_type_factory_init (
    "relatedPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // bdayPropType
  //

  bdayPropType::
  bdayPropType ()
  : ::vcard_4_0::DateDatetimePropertyType ()
  {
  }

  bdayPropType::
  bdayPropType (const bdayPropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::DateDatetimePropertyType (x, f, c)
  {
  }

  bdayPropType::
  bdayPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::DateDatetimePropertyType (e, f, c)
  {
  }

  bdayPropType* bdayPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class bdayPropType (*this, f, c);
  }

  bdayPropType::
  ~bdayPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, bdayPropType >
  _xsd_bdayPropType_type_factory_init (
    "bdayPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // anniversaryPropType
  //

  anniversaryPropType::
  anniversaryPropType ()
  : ::vcard_4_0::DateDatetimePropertyType ()
  {
  }

  anniversaryPropType::
  anniversaryPropType (const anniversaryPropType& x,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::vcard_4_0::DateDatetimePropertyType (x, f, c)
  {
  }

  anniversaryPropType::
  anniversaryPropType (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f,
                       ::xml_schema::container* c)
  : ::vcard_4_0::DateDatetimePropertyType (e, f, c)
  {
  }

  anniversaryPropType* anniversaryPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class anniversaryPropType (*this, f, c);
  }

  anniversaryPropType::
  ~anniversaryPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, anniversaryPropType >
  _xsd_anniversaryPropType_type_factory_init (
    "anniversaryPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // photoPropType
  //

  photoPropType::
  photoPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  photoPropType::
  photoPropType (const photoPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  photoPropType::
  photoPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  photoPropType* photoPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class photoPropType (*this, f, c);
  }

  photoPropType::
  ~photoPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, photoPropType >
  _xsd_photoPropType_type_factory_init (
    "photoPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // SexType
  //

  SexType::
  SexType (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::token (e, f, c)
  {
    _xsd_SexType_convert ();
  }

  SexType::
  SexType (const ::xercesc::DOMAttr& a,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::token (a, f, c)
  {
    _xsd_SexType_convert ();
  }

  SexType::
  SexType (const ::std::string& s,
           const ::xercesc::DOMElement* e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::token (s, e, f, c)
  {
    _xsd_SexType_convert ();
  }

  SexType* SexType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SexType (*this, f, c);
  }

  SexType::value SexType::
  _xsd_SexType_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_SexType_literals_);
    const value* i (::std::lower_bound (
                      _xsd_SexType_indexes_,
                      _xsd_SexType_indexes_ + 3,
                      *this,
                      c));

    if (i == _xsd_SexType_indexes_ + 3 || _xsd_SexType_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const SexType::
  _xsd_SexType_literals_[3] =
  {
    "",
    "M",
    "F"
  };

  const SexType::value SexType::
  _xsd_SexType_indexes_[3] =
  {
    ::vcard_4_0::SexType::empty,
    ::vcard_4_0::SexType::F,
    ::vcard_4_0::SexType::M
  };

  // genderPropType
  //

  genderPropType::
  genderPropType (const sex_type& sex)
  : ::xml_schema::type (),
    sex_ (sex, this)
  {
  }

  genderPropType::
  genderPropType (const genderPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    sex_ (x.sex_, f, this)
  {
  }

  genderPropType::
  genderPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    sex_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void genderPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // sex
      //
      if (n.name () == "sex" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< sex_type > r (
          sex_traits::create (i, f, this));

        if (!sex_.present ())
        {
          this->sex_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!sex_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "sex",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  genderPropType* genderPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class genderPropType (*this, f, c);
  }

  genderPropType& genderPropType::
  operator= (const genderPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->sex_ = x.sex_;
    }

    return *this;
  }

  genderPropType::
  ~genderPropType ()
  {
  }

  // langPropType
  //

  langPropType::
  langPropType (const language_tag_type& language_tag)
  : ::vcard_4_0::BasePropertyType (),
    language_tag_ (language_tag, this)
  {
  }

  langPropType::
  langPropType (const langPropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (x, f, c),
    language_tag_ (x.language_tag_, f, this)
  {
  }

  langPropType::
  langPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::BasePropertyType (e, f | ::xml_schema::flags::base, c),
    language_tag_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void langPropType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::vcard_4_0::BasePropertyType::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // language-tag
      //
      if (n.name () == "language-tag" && n.namespace_ () == "urn:ietf:params:xml:ns:vcard-4.0")
      {
        ::std::unique_ptr< language_tag_type > r (
          language_tag_traits::create (i, f, this));

        if (!language_tag_.present ())
        {
          this->language_tag_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!language_tag_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "language-tag",
        "urn:ietf:params:xml:ns:vcard-4.0");
    }
  }

  langPropType* langPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class langPropType (*this, f, c);
  }

  langPropType& langPropType::
  operator= (const langPropType& x)
  {
    if (this != &x)
    {
      static_cast< ::vcard_4_0::BasePropertyType& > (*this) = x;
      this->language_tag_ = x.language_tag_;
    }

    return *this;
  }

  langPropType::
  ~langPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, langPropType >
  _xsd_langPropType_type_factory_init (
    "langPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // telPropType
  //

  telPropType::
  telPropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  telPropType::
  telPropType (const telPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  telPropType::
  telPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  telPropType* telPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class telPropType (*this, f, c);
  }

  telPropType::
  ~telPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, telPropType >
  _xsd_telPropType_type_factory_init (
    "telPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // imppPropType
  //

  imppPropType::
  imppPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  imppPropType::
  imppPropType (const imppPropType& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  imppPropType::
  imppPropType (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  imppPropType* imppPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class imppPropType (*this, f, c);
  }

  imppPropType::
  ~imppPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, imppPropType >
  _xsd_imppPropType_type_factory_init (
    "imppPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // emailPropType
  //

  emailPropType::
  emailPropType (const text_type& text)
  : ::vcard_4_0::TextPropertyType (text)
  {
  }

  emailPropType::
  emailPropType (const emailPropType& x,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (x, f, c)
  {
  }

  emailPropType::
  emailPropType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f,
                 ::xml_schema::container* c)
  : ::vcard_4_0::TextPropertyType (e, f, c)
  {
  }

  emailPropType* emailPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class emailPropType (*this, f, c);
  }

  emailPropType::
  ~emailPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, emailPropType >
  _xsd_emailPropType_type_factory_init (
    "emailPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // keyPropType
  //

  keyPropType::
  keyPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  keyPropType::
  keyPropType (const keyPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  keyPropType::
  keyPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  keyPropType* keyPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class keyPropType (*this, f, c);
  }

  keyPropType::
  ~keyPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, keyPropType >
  _xsd_keyPropType_type_factory_init (
    "keyPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // geoPropType
  //

  geoPropType::
  geoPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  geoPropType::
  geoPropType (const geoPropType& x,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  geoPropType::
  geoPropType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f,
               ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  geoPropType* geoPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class geoPropType (*this, f, c);
  }

  geoPropType::
  ~geoPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, geoPropType >
  _xsd_geoPropType_type_factory_init (
    "geoPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");

  // memberPropType
  //

  memberPropType::
  memberPropType (const uri_type& uri)
  : ::vcard_4_0::UriPropertyType (uri)
  {
  }

  memberPropType::
  memberPropType (const memberPropType& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (x, f, c)
  {
  }

  memberPropType::
  memberPropType (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::vcard_4_0::UriPropertyType (e, f, c)
  {
  }

  memberPropType* memberPropType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class memberPropType (*this, f, c);
  }

  memberPropType::
  ~memberPropType ()
  {
  }

  static
  const ::xsd::cxx::tree::type_factory_initializer< 0, char, memberPropType >
  _xsd_memberPropType_type_factory_init (
    "memberPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace vcard_4_0
{
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

#include <xsd/cxx/tree/type-serializer-map.hxx>

namespace _xsd
{
  static
  const ::xsd::cxx::tree::type_serializer_plate< 0, char >
  type_serializer_plate_init;
}

namespace vcard_4_0
{
  void
  operator<< (::xercesc::DOMElement& e, const DateType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const DateType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const DateType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const DateTimeType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const DateTimeType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const DateTimeType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const TimeStampType& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const TimeStampType& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const TimeStampType& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const BaseParameterType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr&, const BaseParameterType&)
  {
  }

  void
  operator<< (::xml_schema::list_stream&,
              const BaseParameterType&)
  {
  }

  void
  operator<< (::xercesc::DOMElement& e, const ArrayOfParameters& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // baseParameter
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (ArrayOfParameters::baseParameter_const_iterator
           b (i.baseParameter ().begin ()), n (i.baseParameter ().end ());
           b != n; ++b)
      {
        const ArrayOfParameters::baseParameter_type& x (*b);

        if (typeid (ArrayOfParameters::baseParameter_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "baseParameter",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "baseParameter",
            "urn:ietf:params:xml:ns:vcard-4.0",
            true, true, e, x);
      }
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const TextParameterType& i)
  {
    e << static_cast< const ::vcard_4_0::BaseParameterType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextParameterType >
  _xsd_TextParameterType_type_serializer_init (
    "TextParameterType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const UriParameterType& i)
  {
    e << static_cast< const ::vcard_4_0::BaseParameterType& > (i);

    // uri
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.uri ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UriParameterType >
  _xsd_UriParameterType_type_serializer_init (
    "UriParameterType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const TypeValueType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const TypeValueType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const TypeValueType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const typeParamType& i)
  {
    e << static_cast< const ::vcard_4_0::BaseParameterType& > (i);

    // text
    //
    for (typeParamType::text_const_iterator
         b (i.text ().begin ()), n (i.text ().end ());
         b != n; ++b)
    {
      const typeParamType::text_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, typeParamType >
  _xsd_typeParamType_type_serializer_init (
    "typeParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const labelParamType& i)
  {
    e << static_cast< const ::vcard_4_0::TextParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, labelParamType >
  _xsd_labelParamType_type_serializer_init (
    "labelParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const prefParamType& i)
  {
    e << static_cast< const ::vcard_4_0::BaseParameterType& > (i);

    // integer
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "integer",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.integer ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, prefParamType >
  _xsd_prefParamType_type_serializer_init (
    "prefParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const xuidParamType& i)
  {
    e << static_cast< const ::vcard_4_0::UriParameterType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, xuidParamType >
  _xsd_xuidParamType_type_serializer_init (
    "xuidParamType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::typeParamType >
  _xsd_type_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "type",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::typeParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::labelParamType >
  _xsd_label_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "label",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::labelParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::prefParamType >
  _xsd_pref_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "pref",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::prefParamType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::xuidParamType >
  _xsd_x_uid_element_serializer_init (
    "baseParameter",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "x-uid",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::xuidParamType >);


  void
  operator<< (::xercesc::DOMElement& e, const BasePropertyType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // parameters
    //
    if (i.parameters ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "parameters",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.parameters ();
    }
  }

  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::fnPropType >
  _xsd_fn_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "fn",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::fnPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::nPropType >
  _xsd_n_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "n",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::nPropType >);


  static
  const ::xsd::cxx::tree::element_serializer_initializer< 0, char, ::vcard_4_0::bdayPropType >
  _xsd_bday_element_serializer_init (
    "baseProperty",
    "urn:ietf:params:xml:ns:vcard-4.0",
    "bday",
    "urn:ietf:params:xml:ns:vcard-4.0",
    &::xsd::cxx::tree::serializer_impl< ::vcard_4_0::bdayPropType >);


  void
  operator<< (::xercesc::DOMElement& e, const TextPropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // text
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.text ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextPropertyType >
  _xsd_TextPropertyType_type_serializer_init (
    "TextPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const TextListPropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // text
    //
    for (TextListPropertyType::text_const_iterator
         b (i.text ().begin ()), n (i.text ().end ());
         b != n; ++b)
    {
      const TextListPropertyType::text_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextListPropertyType >
  _xsd_TextListPropertyType_type_serializer_init (
    "TextListPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const NonEmptyTextListPropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // text
    //
    for (NonEmptyTextListPropertyType::text_const_iterator
         b (i.text ().begin ()), n (i.text ().end ());
         b != n; ++b)
    {
      const NonEmptyTextListPropertyType::text_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, NonEmptyTextListPropertyType >
  _xsd_NonEmptyTextListPropertyType_type_serializer_init (
    "NonEmptyTextListPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const UriPropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // uri
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.uri ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, UriPropertyType >
  _xsd_UriPropertyType_type_serializer_init (
    "UriPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const TextOrUriPropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // text
    //
    if (i.text ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "text",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.text ();
    }

    // uri
    //
    if (i.uri ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "uri",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.uri ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, TextOrUriPropertyType >
  _xsd_TextOrUriPropertyType_type_serializer_init (
    "TextOrUriPropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const DateDatetimePropertyType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // date-time
    //
    if (i.date_time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date-time",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.date_time ();
    }

    // date
    //
    if (i.date ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << *i.date ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, DateDatetimePropertyType >
  _xsd_DateDatetimePropertyType_type_serializer_init (
    "DateDatetimePropertyType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const kindPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, kindPropType >
  _xsd_kindPropType_type_serializer_init (
    "kindPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const revPropType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // timestamp
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "timestamp",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.timestamp ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, revPropType >
  _xsd_revPropType_type_serializer_init (
    "revPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const prodidPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, prodidPropType >
  _xsd_prodidPropType_type_serializer_init (
    "prodidPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const categoriesPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextListPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, categoriesPropType >
  _xsd_categoriesPropType_type_serializer_init (
    "categoriesPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const fnPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, fnPropType >
  _xsd_fnPropType_type_serializer_init (
    "fnPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const uidPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, uidPropType >
  _xsd_uidPropType_type_serializer_init (
    "uidPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const nPropType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // surname
    //
    for (nPropType::surname_const_iterator
         b (i.surname ().begin ()), n (i.surname ().end ());
         b != n; ++b)
    {
      const nPropType::surname_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "surname",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }

    // given
    //
    for (nPropType::given_const_iterator
         b (i.given ().begin ()), n (i.given ().end ());
         b != n; ++b)
    {
      const nPropType::given_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "given",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }

    // additional
    //
    for (nPropType::additional_const_iterator
         b (i.additional ().begin ()), n (i.additional ().end ());
         b != n; ++b)
    {
      const nPropType::additional_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "additional",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }

    // prefix
    //
    for (nPropType::prefix_const_iterator
         b (i.prefix ().begin ()), n (i.prefix ().end ());
         b != n; ++b)
    {
      const nPropType::prefix_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "prefix",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }

    // suffix
    //
    for (nPropType::suffix_const_iterator
         b (i.suffix ().begin ()), n (i.suffix ().end ());
         b != n; ++b)
    {
      const nPropType::suffix_type& x (*b);

      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "suffix",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << x;
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, nPropType >
  _xsd_nPropType_type_serializer_init (
    "nPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const notePropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, notePropType >
  _xsd_notePropType_type_serializer_init (
    "notePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const fburlPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, fburlPropType >
  _xsd_fburlPropType_type_serializer_init (
    "fburlPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const titlePropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, titlePropType >
  _xsd_titlePropType_type_serializer_init (
    "titlePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const affiliationPropType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // org
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      const affiliationPropType::org_type& x (i.org ());
      if (typeid (affiliationPropType::org_type) == typeid (x))
      {
        ::xercesc::DOMElement& s (
          ::xsd::cxx::xml::dom::create_element (
            "org",
            "urn:ietf:params:xml:ns:vcard-4.0",
            e));

        s << x;
      }
      else
        tsm.serialize (
          "org",
          "urn:ietf:params:xml:ns:vcard-4.0",
          false, true, e, x);
    }

    // logo
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      if (i.logo ())
      {
        const affiliationPropType::logo_type& x (*i.logo ());
        if (typeid (affiliationPropType::logo_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "logo",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "logo",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // role
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (affiliationPropType::role_const_iterator
           b (i.role ().begin ()), n (i.role ().end ());
           b != n; ++b)
      {
        const affiliationPropType::role_type& x (*b);

        if (typeid (affiliationPropType::role_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "role",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "role",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // related
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (affiliationPropType::related_const_iterator
           b (i.related ().begin ()), n (i.related ().end ());
           b != n; ++b)
      {
        const affiliationPropType::related_type& x (*b);

        if (typeid (affiliationPropType::related_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "related",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "related",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // adr
    //
    {
      ::xsd::cxx::tree::type_serializer_map< char >& tsm (
        ::xsd::cxx::tree::type_serializer_map_instance< 0, char > ());

      for (affiliationPropType::adr_const_iterator
           b (i.adr ().begin ()), n (i.adr ().end ());
           b != n; ++b)
      {
        const affiliationPropType::adr_type& x (*b);

        if (typeid (affiliationPropType::adr_type) == typeid (x))
        {
          ::xercesc::DOMElement& s (
            ::xsd::cxx::xml::dom::create_element (
              "adr",
              "urn:ietf:params:xml:ns:vcard-4.0",
              e));

          s << x;
        }
        else
          tsm.serialize (
            "adr",
            "urn:ietf:params:xml:ns:vcard-4.0",
            false, true, e, x);
      }
    }

    // name
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "name",
          e));

      a << i.name ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, affiliationPropType >
  _xsd_affiliationPropType_type_serializer_init (
    "affiliationPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const urlPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, urlPropType >
  _xsd_urlPropType_type_serializer_init (
    "urlPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const adrPropType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // pobox
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "pobox",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.pobox ();
    }

    // ext
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "ext",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.ext ();
    }

    // street
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "street",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.street ();
    }

    // locality
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "locality",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.locality ();
    }

    // region
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "region",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.region ();
    }

    // code
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "code",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.code ();
    }

    // country
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "country",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.country ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, adrPropType >
  _xsd_adrPropType_type_serializer_init (
    "adrPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const nicknamePropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextListPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, nicknamePropType >
  _xsd_nicknamePropType_type_serializer_init (
    "nicknamePropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const relatedPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextOrUriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, relatedPropType >
  _xsd_relatedPropType_type_serializer_init (
    "relatedPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const bdayPropType& i)
  {
    e << static_cast< const ::vcard_4_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, bdayPropType >
  _xsd_bdayPropType_type_serializer_init (
    "bdayPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const anniversaryPropType& i)
  {
    e << static_cast< const ::vcard_4_0::DateDatetimePropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, anniversaryPropType >
  _xsd_anniversaryPropType_type_serializer_init (
    "anniversaryPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const photoPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, photoPropType >
  _xsd_photoPropType_type_serializer_init (
    "photoPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const SexType& i)
  {
    e << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const SexType& i)
  {
    a << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const SexType& i)
  {
    l << static_cast< const ::xml_schema::token& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const genderPropType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // sex
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "sex",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.sex ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const langPropType& i)
  {
    e << static_cast< const ::vcard_4_0::BasePropertyType& > (i);

    // language-tag
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "language-tag",
          "urn:ietf:params:xml:ns:vcard-4.0",
          e));

      s << i.language_tag ();
    }
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, langPropType >
  _xsd_langPropType_type_serializer_init (
    "langPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const telPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, telPropType >
  _xsd_telPropType_type_serializer_init (
    "telPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const imppPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, imppPropType >
  _xsd_imppPropType_type_serializer_init (
    "imppPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const emailPropType& i)
  {
    e << static_cast< const ::vcard_4_0::TextPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, emailPropType >
  _xsd_emailPropType_type_serializer_init (
    "emailPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const keyPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, keyPropType >
  _xsd_keyPropType_type_serializer_init (
    "keyPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const geoPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, geoPropType >
  _xsd_geoPropType_type_serializer_init (
    "geoPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");


  void
  operator<< (::xercesc::DOMElement& e, const memberPropType& i)
  {
    e << static_cast< const ::vcard_4_0::UriPropertyType& > (i);
  }

  static
  const ::xsd::cxx::tree::type_serializer_initializer< 0, char, memberPropType >
  _xsd_memberPropType_type_serializer_init (
    "memberPropType",
    "urn:ietf:params:xml:ns:vcard-4.0");
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

