// python wrapper for vtkMaterialInterfaceFilter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkMaterialInterfaceFilter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfaceFilter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfaceFilter_ClassNew(); }


static PyObject *
PyvtkMaterialInterfaceFilter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkMaterialInterfaceFilter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkMaterialInterfaceFilter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkMaterialInterfaceFilter *tempr = vtkMaterialInterfaceFilter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMaterialInterfaceFilter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkMaterialInterfaceFilter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkMaterialInterfaceFilter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkMaterialInterfaceFilter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectMaterialArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectMaterialArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectMaterialArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SelectMaterialArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectMaterialArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectMaterialArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnselectMaterialArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectMaterialArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectAllMaterialArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectAllMaterialArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnselectAllMaterialArrays();
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectAllMaterialArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetMaterialArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaterialArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMaterialArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetMaterialArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaterialArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMaterialArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaterialArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMaterialArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_Methods[] = {
  {"GetMaterialArrayStatus", PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_s1, METH_VARARGS,
   "@z"},
  {"GetMaterialArrayStatus", PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetMaterialArrayStatus");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfMaterialArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfMaterialArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfMaterialArrays() :
      op->vtkMaterialInterfaceFilter::GetNumberOfMaterialArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMaterialArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetMaterialArrayName(temp0) :
      op->vtkMaterialInterfaceFilter::GetMaterialArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectMassArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectMassArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectMassArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SelectMassArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectMassArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectMassArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnselectMassArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectMassArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectAllMassArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectAllMassArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnselectAllMassArrays();
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectAllMassArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetMassArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMassArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMassArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetMassArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMassArrayStatus_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMassArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceFilter_GetMassArrayStatus_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMassArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_GetMassArrayStatus_Methods[] = {
  {"GetMassArrayStatus", PyvtkMaterialInterfaceFilter_GetMassArrayStatus_s1, METH_VARARGS,
   "@z"},
  {"GetMassArrayStatus", PyvtkMaterialInterfaceFilter_GetMassArrayStatus_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceFilter_GetMassArrayStatus(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceFilter_GetMassArrayStatus_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetMassArrayStatus");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfMassArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfMassArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfMassArrays() :
      op->vtkMaterialInterfaceFilter::GetNumberOfMassArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMassArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetMassArrayName(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectVolumeWtdAvgArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectVolumeWtdAvgArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectVolumeWtdAvgArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SelectVolumeWtdAvgArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectVolumeWtdAvgArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectVolumeWtdAvgArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnselectVolumeWtdAvgArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectVolumeWtdAvgArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectAllVolumeWtdAvgArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectAllVolumeWtdAvgArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnselectAllVolumeWtdAvgArrays();
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectAllVolumeWtdAvgArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetVolumeWtdAvgArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVolumeWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetVolumeWtdAvgArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetVolumeWtdAvgArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVolumeWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetVolumeWtdAvgArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetVolumeWtdAvgArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVolumeWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetVolumeWtdAvgArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetVolumeWtdAvgArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_Methods[] = {
  {"GetVolumeWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_s1, METH_VARARGS,
   "@z"},
  {"GetVolumeWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetVolumeWtdAvgArrayStatus");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfVolumeWtdAvgArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfVolumeWtdAvgArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfVolumeWtdAvgArrays() :
      op->vtkMaterialInterfaceFilter::GetNumberOfVolumeWtdAvgArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVolumeWtdAvgArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetVolumeWtdAvgArrayName(temp0) :
      op->vtkMaterialInterfaceFilter::GetVolumeWtdAvgArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectMassWtdAvgArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectMassWtdAvgArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectMassWtdAvgArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SelectMassWtdAvgArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectMassWtdAvgArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectMassWtdAvgArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnselectMassWtdAvgArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectMassWtdAvgArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectAllMassWtdAvgArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectAllMassWtdAvgArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnselectAllMassWtdAvgArrays();
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectAllMassWtdAvgArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetMassWtdAvgArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMassWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetMassWtdAvgArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetMassWtdAvgArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMassWtdAvgArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassWtdAvgArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassWtdAvgArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMassWtdAvgArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassWtdAvgArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_Methods[] = {
  {"GetMassWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_s1, METH_VARARGS,
   "@z"},
  {"GetMassWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetMassWtdAvgArrayStatus");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfMassWtdAvgArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfMassWtdAvgArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfMassWtdAvgArrays() :
      op->vtkMaterialInterfaceFilter::GetNumberOfMassWtdAvgArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMassWtdAvgArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetMassWtdAvgArrayName(temp0) :
      op->vtkMaterialInterfaceFilter::GetMassWtdAvgArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectSummationArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectSummationArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SelectSummationArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SelectSummationArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectSummationArray(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectSummationArray");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnselectSummationArray(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectSummationArray(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_UnselectAllSummationArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnselectAllSummationArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnselectAllSummationArrays();
    }
    else
    {
      op->vtkMaterialInterfaceFilter::UnselectAllSummationArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetSummationArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSummationArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSummationArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetSummationArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSummationArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSummationArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetSummationArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSummationArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSummationArrayStatus(temp0) :
      op->vtkMaterialInterfaceFilter::GetSummationArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_Methods[] = {
  {"GetSummationArrayStatus", PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_s1, METH_VARARGS,
   "@z"},
  {"GetSummationArrayStatus", PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfaceFilter_GetSummationArrayStatus(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkMaterialInterfaceFilter_GetSummationArrayStatus_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetSummationArrayStatus");
  return nullptr;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetNumberOfSummationArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfSummationArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfSummationArrays() :
      op->vtkMaterialInterfaceFilter::GetNumberOfSummationArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetSummationArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSummationArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetSummationArrayName(temp0) :
      op->vtkMaterialInterfaceFilter::GetSummationArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetMaterialFractionThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaterialFractionThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaterialFractionThreshold(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetMaterialFractionThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMaterialFractionThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaterialFractionThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaterialFractionThreshold() :
      op->vtkMaterialInterfaceFilter::GetMaterialFractionThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetComputeOBB(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeOBB");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeOBB(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetComputeOBB(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetComputeOBB(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeOBB");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeOBB() :
      op->vtkMaterialInterfaceFilter::GetComputeOBB());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetUpperLoadingBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUpperLoadingBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUpperLoadingBound(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetUpperLoadingBound(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetUpperLoadingBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpperLoadingBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetUpperLoadingBound() :
      op->vtkMaterialInterfaceFilter::GetUpperLoadingBound());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetOutputBaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputBaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputBaseName(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetOutputBaseName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetOutputBaseName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputBaseName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetOutputBaseName() :
      op->vtkMaterialInterfaceFilter::GetOutputBaseName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetWriteGeometryOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteGeometryOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteGeometryOutput(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetWriteGeometryOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetWriteGeometryOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteGeometryOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteGeometryOutput() :
      op->vtkMaterialInterfaceFilter::GetWriteGeometryOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetWriteStatisticsOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteStatisticsOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteStatisticsOutput(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetWriteStatisticsOutput(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetWriteStatisticsOutput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteStatisticsOutput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteStatisticsOutput() :
      op->vtkMaterialInterfaceFilter::GetWriteStatisticsOutput());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetBlockGhostLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBlockGhostLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  unsigned char temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBlockGhostLevel(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetBlockGhostLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetBlockGhostLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBlockGhostLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned char tempr = (ap.IsBound() ?
      op->GetBlockGhostLevel() :
      op->vtkMaterialInterfaceFilter::GetBlockGhostLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SelectionModifiedCallback(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SelectionModifiedCallback");

  vtkObject *temp0 = nullptr;
  unsigned long temp1;
  void  *temp2 = nullptr;
  Py_buffer pbuf2 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  void  *temp3 = nullptr;
  Py_buffer pbuf3 = { nullptr, nullptr, 0, 0, 0, 0, nullptr, nullptr, nullptr, nullptr, nullptr };
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkObject") &&
      ap.GetValue(temp1) &&
      ap.GetBuffer(temp2, &pbuf2) &&
      ap.GetBuffer(temp3, &pbuf3))
  {
    vtkMaterialInterfaceFilter::SelectionModifiedCallback(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  if (pbuf2.obj != nullptr)
  {
    PyBuffer_Release(&pbuf2);
  }
  if (pbuf3.obj != nullptr)
  {
    PyBuffer_Release(&pbuf3);
  }
  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetClipFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClipFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetClipFunction(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetClipFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetClipFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClipFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImplicitFunction *tempr = (ap.IsBound() ?
      op->GetClipFunction() :
      op->vtkMaterialInterfaceFilter::GetClipFunction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_SetInvertVolumeFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInvertVolumeFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetInvertVolumeFraction(temp0);
    }
    else
    {
      op->vtkMaterialInterfaceFilter::SetInvertVolumeFraction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetInvertVolumeFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInvertVolumeFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetInvertVolumeFraction() :
      op->vtkMaterialInterfaceFilter::GetInvertVolumeFraction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfaceFilter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMaterialInterfaceFilter *op = static_cast<vtkMaterialInterfaceFilter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkMaterialInterfaceFilter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfaceFilter_Methods[] = {
  {"IsTypeOf", PyvtkMaterialInterfaceFilter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkMaterialInterfaceFilter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkMaterialInterfaceFilter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkMaterialInterfaceFilter\nC++: static vtkMaterialInterfaceFilter *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkMaterialInterfaceFilter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkMaterialInterfaceFilter\nC++: vtkMaterialInterfaceFilter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkMaterialInterfaceFilter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkMaterialInterfaceFilter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SelectMaterialArray", PyvtkMaterialInterfaceFilter_SelectMaterialArray, METH_VARARGS,
   "SelectMaterialArray(self, name:str) -> None\nC++: void SelectMaterialArray(const char *name)\n\nMaterial sellection\n\nAdd a single array\n"},
  {"UnselectMaterialArray", PyvtkMaterialInterfaceFilter_UnselectMaterialArray, METH_VARARGS,
   "UnselectMaterialArray(self, name:str) -> None\nC++: void UnselectMaterialArray(const char *name)\n\nremove a single array\n"},
  {"UnselectAllMaterialArrays", PyvtkMaterialInterfaceFilter_UnselectAllMaterialArrays, METH_VARARGS,
   "UnselectAllMaterialArrays(self) -> None\nC++: void UnselectAllMaterialArrays()\n\nremove all arrays\n"},
  {"SetMaterialArrayStatus", PyvtkMaterialInterfaceFilter_SetMaterialArrayStatus, METH_VARARGS,
   "SetMaterialArrayStatus(self, name:str, status:int) -> None\nC++: void SetMaterialArrayStatus(const char *name, int status)\n\nEnable/disable processing on an array\n"},
  {"GetMaterialArrayStatus", PyvtkMaterialInterfaceFilter_GetMaterialArrayStatus, METH_VARARGS,
   "GetMaterialArrayStatus(self, name:str) -> int\nC++: int GetMaterialArrayStatus(const char *name)\nGetMaterialArrayStatus(self, index:int) -> int\nC++: int GetMaterialArrayStatus(int index)\n\nGet enable./disable status for a given array\n"},
  {"GetNumberOfMaterialArrays", PyvtkMaterialInterfaceFilter_GetNumberOfMaterialArrays, METH_VARARGS,
   "GetNumberOfMaterialArrays(self) -> int\nC++: int GetNumberOfMaterialArrays()\n\nQuery the number of available arrays\n"},
  {"GetMaterialArrayName", PyvtkMaterialInterfaceFilter_GetMaterialArrayName, METH_VARARGS,
   "GetMaterialArrayName(self, index:int) -> str\nC++: const char *GetMaterialArrayName(int index)\n\nGet the name of a specific array\n"},
  {"SelectMassArray", PyvtkMaterialInterfaceFilter_SelectMassArray, METH_VARARGS,
   "SelectMassArray(self, name:str) -> None\nC++: void SelectMassArray(const char *name)\n\nMass sellection\n\nAdd a single array\n"},
  {"UnselectMassArray", PyvtkMaterialInterfaceFilter_UnselectMassArray, METH_VARARGS,
   "UnselectMassArray(self, name:str) -> None\nC++: void UnselectMassArray(const char *name)\n\nremove a single array\n"},
  {"UnselectAllMassArrays", PyvtkMaterialInterfaceFilter_UnselectAllMassArrays, METH_VARARGS,
   "UnselectAllMassArrays(self) -> None\nC++: void UnselectAllMassArrays()\n\nremove all arrays\n"},
  {"SetMassArrayStatus", PyvtkMaterialInterfaceFilter_SetMassArrayStatus, METH_VARARGS,
   "SetMassArrayStatus(self, name:str, status:int) -> None\nC++: void SetMassArrayStatus(const char *name, int status)\n\nEnable/disable processing on an array\n"},
  {"GetMassArrayStatus", PyvtkMaterialInterfaceFilter_GetMassArrayStatus, METH_VARARGS,
   "GetMassArrayStatus(self, name:str) -> int\nC++: int GetMassArrayStatus(const char *name)\nGetMassArrayStatus(self, index:int) -> int\nC++: int GetMassArrayStatus(int index)\n\nGet enable./disable status for a given array\n"},
  {"GetNumberOfMassArrays", PyvtkMaterialInterfaceFilter_GetNumberOfMassArrays, METH_VARARGS,
   "GetNumberOfMassArrays(self) -> int\nC++: int GetNumberOfMassArrays()\n\nQuery the number of available arrays\n"},
  {"GetMassArrayName", PyvtkMaterialInterfaceFilter_GetMassArrayName, METH_VARARGS,
   "GetMassArrayName(self, index:int) -> str\nC++: const char *GetMassArrayName(int index)\n\nGet the name of a specific array\n"},
  {"SelectVolumeWtdAvgArray", PyvtkMaterialInterfaceFilter_SelectVolumeWtdAvgArray, METH_VARARGS,
   "SelectVolumeWtdAvgArray(self, name:str) -> None\nC++: void SelectVolumeWtdAvgArray(const char *name)\n\nVolume weighted average attribute sellection\n\nAdd a single array\n"},
  {"UnselectVolumeWtdAvgArray", PyvtkMaterialInterfaceFilter_UnselectVolumeWtdAvgArray, METH_VARARGS,
   "UnselectVolumeWtdAvgArray(self, name:str) -> None\nC++: void UnselectVolumeWtdAvgArray(const char *name)\n\nremove a single array\n"},
  {"UnselectAllVolumeWtdAvgArrays", PyvtkMaterialInterfaceFilter_UnselectAllVolumeWtdAvgArrays, METH_VARARGS,
   "UnselectAllVolumeWtdAvgArrays(self) -> None\nC++: void UnselectAllVolumeWtdAvgArrays()\n\nremove all arrays\n"},
  {"SetVolumeWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_SetVolumeWtdAvgArrayStatus, METH_VARARGS,
   "SetVolumeWtdAvgArrayStatus(self, name:str, status:int) -> None\nC++: void SetVolumeWtdAvgArrayStatus(const char *name, int status)\n\nEnable/disable processing on an array\n"},
  {"GetVolumeWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayStatus, METH_VARARGS,
   "GetVolumeWtdAvgArrayStatus(self, name:str) -> int\nC++: int GetVolumeWtdAvgArrayStatus(const char *name)\nGetVolumeWtdAvgArrayStatus(self, index:int) -> int\nC++: int GetVolumeWtdAvgArrayStatus(int index)\n\nGet enable./disable status for a given array\n"},
  {"GetNumberOfVolumeWtdAvgArrays", PyvtkMaterialInterfaceFilter_GetNumberOfVolumeWtdAvgArrays, METH_VARARGS,
   "GetNumberOfVolumeWtdAvgArrays(self) -> int\nC++: int GetNumberOfVolumeWtdAvgArrays()\n\nQuery the number of available arrays\n"},
  {"GetVolumeWtdAvgArrayName", PyvtkMaterialInterfaceFilter_GetVolumeWtdAvgArrayName, METH_VARARGS,
   "GetVolumeWtdAvgArrayName(self, index:int) -> str\nC++: const char *GetVolumeWtdAvgArrayName(int index)\n\nGet the name of a specific array\n"},
  {"SelectMassWtdAvgArray", PyvtkMaterialInterfaceFilter_SelectMassWtdAvgArray, METH_VARARGS,
   "SelectMassWtdAvgArray(self, name:str) -> None\nC++: void SelectMassWtdAvgArray(const char *name)\n\nMass weighted average attribute sellection\n\nAdd a single array\n"},
  {"UnselectMassWtdAvgArray", PyvtkMaterialInterfaceFilter_UnselectMassWtdAvgArray, METH_VARARGS,
   "UnselectMassWtdAvgArray(self, name:str) -> None\nC++: void UnselectMassWtdAvgArray(const char *name)\n\nremove a single array\n"},
  {"UnselectAllMassWtdAvgArrays", PyvtkMaterialInterfaceFilter_UnselectAllMassWtdAvgArrays, METH_VARARGS,
   "UnselectAllMassWtdAvgArrays(self) -> None\nC++: void UnselectAllMassWtdAvgArrays()\n\nremove all arrays\n"},
  {"SetMassWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_SetMassWtdAvgArrayStatus, METH_VARARGS,
   "SetMassWtdAvgArrayStatus(self, name:str, status:int) -> None\nC++: void SetMassWtdAvgArrayStatus(const char *name, int status)\n\nEnable/disable processing on an array\n"},
  {"GetMassWtdAvgArrayStatus", PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayStatus, METH_VARARGS,
   "GetMassWtdAvgArrayStatus(self, name:str) -> int\nC++: int GetMassWtdAvgArrayStatus(const char *name)\nGetMassWtdAvgArrayStatus(self, index:int) -> int\nC++: int GetMassWtdAvgArrayStatus(int index)\n\nGet enable./disable status for a given array\n"},
  {"GetNumberOfMassWtdAvgArrays", PyvtkMaterialInterfaceFilter_GetNumberOfMassWtdAvgArrays, METH_VARARGS,
   "GetNumberOfMassWtdAvgArrays(self) -> int\nC++: int GetNumberOfMassWtdAvgArrays()\n\nQuery the number of available arrays\n"},
  {"GetMassWtdAvgArrayName", PyvtkMaterialInterfaceFilter_GetMassWtdAvgArrayName, METH_VARARGS,
   "GetMassWtdAvgArrayName(self, index:int) -> str\nC++: const char *GetMassWtdAvgArrayName(int index)\n\nGet the name of a specific array\n"},
  {"SelectSummationArray", PyvtkMaterialInterfaceFilter_SelectSummationArray, METH_VARARGS,
   "SelectSummationArray(self, name:str) -> None\nC++: void SelectSummationArray(const char *name)\n\nSummation attribute sellection\n\nAdd a single array\n"},
  {"UnselectSummationArray", PyvtkMaterialInterfaceFilter_UnselectSummationArray, METH_VARARGS,
   "UnselectSummationArray(self, name:str) -> None\nC++: void UnselectSummationArray(const char *name)\n\nremove a single array\n"},
  {"UnselectAllSummationArrays", PyvtkMaterialInterfaceFilter_UnselectAllSummationArrays, METH_VARARGS,
   "UnselectAllSummationArrays(self) -> None\nC++: void UnselectAllSummationArrays()\n\nremove all arrays\n"},
  {"SetSummationArrayStatus", PyvtkMaterialInterfaceFilter_SetSummationArrayStatus, METH_VARARGS,
   "SetSummationArrayStatus(self, name:str, status:int) -> None\nC++: void SetSummationArrayStatus(const char *name, int status)\n\nEnable/disable processing on an array\n"},
  {"GetSummationArrayStatus", PyvtkMaterialInterfaceFilter_GetSummationArrayStatus, METH_VARARGS,
   "GetSummationArrayStatus(self, name:str) -> int\nC++: int GetSummationArrayStatus(const char *name)\nGetSummationArrayStatus(self, index:int) -> int\nC++: int GetSummationArrayStatus(int index)\n\nGet enable./disable status for a given array\n"},
  {"GetNumberOfSummationArrays", PyvtkMaterialInterfaceFilter_GetNumberOfSummationArrays, METH_VARARGS,
   "GetNumberOfSummationArrays(self) -> int\nC++: int GetNumberOfSummationArrays()\n\nQuery the number of available arrays\n"},
  {"GetSummationArrayName", PyvtkMaterialInterfaceFilter_GetSummationArrayName, METH_VARARGS,
   "GetSummationArrayName(self, index:int) -> str\nC++: const char *GetSummationArrayName(int index)\n\nGet the name of a specific array\n"},
  {"SetMaterialFractionThreshold", PyvtkMaterialInterfaceFilter_SetMaterialFractionThreshold, METH_VARARGS,
   "SetMaterialFractionThreshold(self, fraction:float) -> None\nC++: void SetMaterialFractionThreshold(double fraction)\n\nVolume fraction which volxels are included in a frgament.\n"},
  {"GetMaterialFractionThreshold", PyvtkMaterialInterfaceFilter_GetMaterialFractionThreshold, METH_VARARGS,
   "GetMaterialFractionThreshold(self) -> float\nC++: virtual double GetMaterialFractionThreshold()\n\n"},
  {"SetComputeOBB", PyvtkMaterialInterfaceFilter_SetComputeOBB, METH_VARARGS,
   "SetComputeOBB(self, _arg:bool) -> None\nC++: virtual void SetComputeOBB(bool _arg)\n\nTurn on/off OBB calculations\n"},
  {"GetComputeOBB", PyvtkMaterialInterfaceFilter_GetComputeOBB, METH_VARARGS,
   "GetComputeOBB(self) -> bool\nC++: virtual bool GetComputeOBB()\n\n"},
  {"SetUpperLoadingBound", PyvtkMaterialInterfaceFilter_SetUpperLoadingBound, METH_VARARGS,
   "SetUpperLoadingBound(self, nPolys:int) -> None\nC++: void SetUpperLoadingBound(int nPolys)\n\nSet the upper bound(in number of polygons) that will be used to\nexclude processes from work sharing during memory intensive\nportions of the algorithm. acceptable values are [1 INF), however\nthe default is 1,000,000 polys. Increasing increases parallelism\nwhile decreasing reduces parallelism. Setting too low can cause\nproblems. For instance if it's set so low that all processes are\nexcluded.\n"},
  {"GetUpperLoadingBound", PyvtkMaterialInterfaceFilter_GetUpperLoadingBound, METH_VARARGS,
   "GetUpperLoadingBound(self) -> int\nC++: virtual int GetUpperLoadingBound()\n\n"},
  {"SetOutputBaseName", PyvtkMaterialInterfaceFilter_SetOutputBaseName, METH_VARARGS,
   "SetOutputBaseName(self, _arg:str) -> None\nC++: virtual void SetOutputBaseName(const char *_arg)\n\nName the file to save a table of fragment attributes to.\n"},
  {"GetOutputBaseName", PyvtkMaterialInterfaceFilter_GetOutputBaseName, METH_VARARGS,
   "GetOutputBaseName(self) -> str\nC++: virtual char *GetOutputBaseName()\n\n"},
  {"SetWriteGeometryOutput", PyvtkMaterialInterfaceFilter_SetWriteGeometryOutput, METH_VARARGS,
   "SetWriteGeometryOutput(self, _arg:bool) -> None\nC++: virtual void SetWriteGeometryOutput(bool _arg)\n\nIf true, save the results of the filter in a text file\n"},
  {"GetWriteGeometryOutput", PyvtkMaterialInterfaceFilter_GetWriteGeometryOutput, METH_VARARGS,
   "GetWriteGeometryOutput(self) -> bool\nC++: virtual bool GetWriteGeometryOutput()\n\n"},
  {"SetWriteStatisticsOutput", PyvtkMaterialInterfaceFilter_SetWriteStatisticsOutput, METH_VARARGS,
   "SetWriteStatisticsOutput(self, _arg:bool) -> None\nC++: virtual void SetWriteStatisticsOutput(bool _arg)\n\n"},
  {"GetWriteStatisticsOutput", PyvtkMaterialInterfaceFilter_GetWriteStatisticsOutput, METH_VARARGS,
   "GetWriteStatisticsOutput(self) -> bool\nC++: virtual bool GetWriteStatisticsOutput()\n\n"},
  {"SetBlockGhostLevel", PyvtkMaterialInterfaceFilter_SetBlockGhostLevel, METH_VARARGS,
   "SetBlockGhostLevel(self, _arg:int) -> None\nC++: virtual void SetBlockGhostLevel(unsigned char _arg)\n\nVariable used to specify the number of ghost level is available\nin each block. By Default set to 1 which is what the scth reader\nprovides\n"},
  {"GetBlockGhostLevel", PyvtkMaterialInterfaceFilter_GetBlockGhostLevel, METH_VARARGS,
   "GetBlockGhostLevel(self) -> int\nC++: virtual unsigned char GetBlockGhostLevel()\n\n"},
  {"SelectionModifiedCallback", PyvtkMaterialInterfaceFilter_SelectionModifiedCallback, METH_VARARGS,
   "SelectionModifiedCallback(__a:vtkObject, __b:int,\n    clientdata:Pointer, __d:Pointer) -> None\nC++: static void SelectionModifiedCallback(vtkObject *,\n    unsigned long, void *clientdata, void *)\n\nSets modified if array selection changes.\n"},
  {"SetClipFunction", PyvtkMaterialInterfaceFilter_SetClipFunction, METH_VARARGS,
   "SetClipFunction(self, clipFunction:vtkImplicitFunction) -> None\nC++: void SetClipFunction(vtkImplicitFunction *clipFunction)\n\nSet the clip function which can be a plane or a sphere\n"},
  {"GetClipFunction", PyvtkMaterialInterfaceFilter_GetClipFunction, METH_VARARGS,
   "GetClipFunction(self) -> vtkImplicitFunction\nC++: virtual vtkImplicitFunction *GetClipFunction()\n\n"},
  {"SetInvertVolumeFraction", PyvtkMaterialInterfaceFilter_SetInvertVolumeFraction, METH_VARARGS,
   "SetInvertVolumeFraction(self, _arg:int) -> None\nC++: virtual void SetInvertVolumeFraction(int _arg)\n\nInvert the volume fraction to extract the negative space. This is\nuseful for extracting a crater.\n"},
  {"GetInvertVolumeFraction", PyvtkMaterialInterfaceFilter_GetInvertVolumeFraction, METH_VARARGS,
   "GetInvertVolumeFraction(self) -> int\nC++: virtual int GetInvertVolumeFraction()\n\n"},
  {"GetMTime", PyvtkMaterialInterfaceFilter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nReturn the mtime also considering the locator and clip function.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfaceFilter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("material_fraction_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetMaterialFractionThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetMaterialFractionThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetMaterialFractionThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaterialFractionThreshold/SetMaterialFractionThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_obb"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetComputeOBB(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetComputeOBB(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetComputeOBB(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeOBB/SetComputeOBB\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("upper_loading_bound"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetUpperLoadingBound(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetUpperLoadingBound(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetUpperLoadingBound(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUpperLoadingBound/SetUpperLoadingBound\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_base_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetOutputBaseName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetOutputBaseName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetOutputBaseName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputBaseName/SetOutputBaseName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_geometry_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetWriteGeometryOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetWriteGeometryOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetWriteGeometryOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteGeometryOutput/SetWriteGeometryOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_statistics_output"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetWriteStatisticsOutput(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetWriteStatisticsOutput(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetWriteStatisticsOutput(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteStatisticsOutput/SetWriteStatisticsOutput\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("block_ghost_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetBlockGhostLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetBlockGhostLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetBlockGhostLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBlockGhostLevel/SetBlockGhostLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clip_function"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetClipFunction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetClipFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetClipFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClipFunction/SetClipFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("invert_volume_fraction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetInvertVolumeFraction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMaterialInterfaceFilter_SetInvertVolumeFraction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMaterialInterfaceFilter_SetInvertVolumeFraction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetInvertVolumeFraction/SetInvertVolumeFraction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_material_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetNumberOfMaterialArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfMaterialArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_mass_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetNumberOfMassArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfMassArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_volume_wtd_avg_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetNumberOfVolumeWtdAvgArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfVolumeWtdAvgArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_mass_wtd_avg_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetNumberOfMassWtdAvgArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfMassWtdAvgArrays\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_summation_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMaterialInterfaceFilter_GetNumberOfSummationArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfSummationArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkMaterialInterfaceFilter_Doc =
  "vtkMaterialInterfaceFilter - Extract particles and analyse them.\n\n"
  "Superclass: vtkMultiBlockDataSetAlgorithm\n\n"
  "This filter takes a cell data volume fraction and generates a\n"
  "polydata surface.  It also performs connectivity on the particles and\n"
  "generates a particle index as part of the cell data of the output. \n"
  "It computes the volume of each particle from the volume fraction.\n\n"
  "This will turn on validation and debug i/o of the filter.{.cpp}\n"
  "#define vtkMaterialInterfaceFilterDEBUG\n\n"
  "This will turn on profiling of how long each part of the filter\n"
  "takes{.cpp}\n"
  "#define vtkMaterialInterfaceFilterPROFILE\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfaceFilter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfaceFilter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkMaterialInterfaceFilter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkMaterialInterfaceFilter_StaticNew()
{
  return vtkMaterialInterfaceFilter::New();
}

PyObject *PyvtkMaterialInterfaceFilter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkMaterialInterfaceFilter_Type, PyvtkMaterialInterfaceFilter_Methods,
    "vtkMaterialInterfaceFilter",
 &PyvtkMaterialInterfaceFilter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkMultiBlockDataSetAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkMaterialInterfaceFilter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfaceFilter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfaceFilter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfaceFilter", o) != 0)
  {
    Py_DECREF(o);
  }

}

