// python wrapper for vtkMPIMoveData
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkMPIMoveData.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMPIMoveData(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMPIMoveData_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMPIMoveData_MoveModes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkMPIMoveData.MoveModes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkMPIMoveData_MoveModes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkMPIMoveData_MoveModes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkMPIMoveData_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkMPIMoveData::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkMPIMoveData::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkMPIMoveData *tempr = vtkMPIMoveData::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMPIMoveData *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkMPIMoveData::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkMPIMoveData::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkMPIMoveData::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_InitializeForCommunicationForParaView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InitializeForCommunicationForParaView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InitializeForCommunicationForParaView();
    }
    else
    {
      op->vtkMPIMoveData::InitializeForCommunicationForParaView();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetMPIMToNSocketConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMPIMToNSocketConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  vtkMPIMToNSocketConnection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMPIMToNSocketConnection"))
  {
    if (ap.IsBound())
    {
      op->SetMPIMToNSocketConnection(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetMPIMToNSocketConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetClientDataServerSocketController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClientDataServerSocketController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetClientDataServerSocketController(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetClientDataServerSocketController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetClientDataServerSocketController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClientDataServerSocketController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetClientDataServerSocketController() :
      op->vtkMPIMoveData::GetClientDataServerSocketController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetServerToClient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerToClient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetServerToClient();
    }
    else
    {
      op->vtkMPIMoveData::SetServerToClient();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetServerToDataServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerToDataServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetServerToDataServer();
    }
    else
    {
      op->vtkMPIMoveData::SetServerToDataServer();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetServerToRenderServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServerToRenderServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetServerToRenderServer();
    }
    else
    {
      op->vtkMPIMoveData::SetServerToRenderServer();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetServer(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetServer(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetServerMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerMinValue() :
      op->vtkMPIMoveData::GetServerMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetServerMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServerMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServerMaxValue() :
      op->vtkMPIMoveData::GetServerMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetServer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetServer() :
      op->vtkMPIMoveData::GetServer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetMoveModeToPassThrough(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMoveModeToPassThrough");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMoveModeToPassThrough();
    }
    else
    {
      op->vtkMPIMoveData::SetMoveModeToPassThrough();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetMoveModeToCollect(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMoveModeToCollect");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMoveModeToCollect();
    }
    else
    {
      op->vtkMPIMoveData::SetMoveModeToCollect();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetMoveModeToClone(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMoveModeToClone");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetMoveModeToClone();
    }
    else
    {
      op->vtkMPIMoveData::SetMoveModeToClone();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetMoveMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMoveMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMoveMode(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetMoveMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetMoveModeMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMoveModeMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMoveModeMinValue() :
      op->vtkMPIMoveData::GetMoveModeMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetMoveModeMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMoveModeMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMoveModeMaxValue() :
      op->vtkMPIMoveData::GetMoveModeMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetOutputDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputDataType(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetOutputDataType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetOutputDataType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputDataType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetOutputDataType() :
      op->vtkMPIMoveData::GetOutputDataType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetUseZLibCompression(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetUseZLibCompression");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkMPIMoveData::SetUseZLibCompression(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetUseZLibCompression(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUseZLibCompression");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkMPIMoveData::GetUseZLibCompression();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetOutputGeneratedOnProcess(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputGeneratedOnProcess");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOutputGeneratedOnProcess() :
      op->vtkMPIMoveData::GetOutputGeneratedOnProcess());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_SetSkipDataServerGatherToZero(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSkipDataServerGatherToZero");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSkipDataServerGatherToZero(temp0);
    }
    else
    {
      op->vtkMPIMoveData::SetSkipDataServerGatherToZero(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMPIMoveData_GetSkipDataServerGatherToZero(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSkipDataServerGatherToZero");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkMPIMoveData *op = static_cast<vtkMPIMoveData *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSkipDataServerGatherToZero() :
      op->vtkMPIMoveData::GetSkipDataServerGatherToZero());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMPIMoveData_Methods[] = {
  {"IsTypeOf", PyvtkMPIMoveData_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkMPIMoveData_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkMPIMoveData_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkMPIMoveData\nC++: static vtkMPIMoveData *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkMPIMoveData_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkMPIMoveData\nC++: vtkMPIMoveData *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkMPIMoveData_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkMPIMoveData_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"InitializeForCommunicationForParaView", PyvtkMPIMoveData_InitializeForCommunicationForParaView, METH_VARARGS,
   "InitializeForCommunicationForParaView(self) -> None\nC++: virtual void InitializeForCommunicationForParaView()\n\nUse this method to initialize all communicators/sockets using\nParaView defaults.\n"},
  {"SetController", PyvtkMPIMoveData_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *controller)\n\nObjects for communication. The controller is an MPI controller\nused to communicate between processes within one server (render\nor data). The client-data server socket controller is set on the\nclient and data server and is used to communicate between the\ntwo. MPIMToNSocetConnection is set on the data server and render\nserver when we are running with a render server.  It has multiple\nsockets which are used to send data from the data server to the\nrender server. ClientDataServerController==0  => One MPI program.\nMPIMToNSocketConnection==0 => Client-DataServer.\nMPIMToNSocketConnection==1 => Client-DataServer-RenderServer.\n"},
  {"SetMPIMToNSocketConnection", PyvtkMPIMoveData_SetMPIMToNSocketConnection, METH_VARARGS,
   "SetMPIMToNSocketConnection(self, sc:vtkMPIMToNSocketConnection)\n    -> None\nC++: void SetMPIMToNSocketConnection(\n    vtkMPIMToNSocketConnection *sc)\n\n"},
  {"SetClientDataServerSocketController", PyvtkMPIMoveData_SetClientDataServerSocketController, METH_VARARGS,
   "SetClientDataServerSocketController(self,\n    __a:vtkMultiProcessController) -> None\nC++: void SetClientDataServerSocketController(\n    vtkMultiProcessController *)\n\n"},
  {"GetClientDataServerSocketController", PyvtkMPIMoveData_GetClientDataServerSocketController, METH_VARARGS,
   "GetClientDataServerSocketController(self)\n    -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetClientDataServerSocketController(\n    )\n\n"},
  {"SetServerToClient", PyvtkMPIMoveData_SetServerToClient, METH_VARARGS,
   "SetServerToClient(self) -> None\nC++: void SetServerToClient()\n\nTell the object on which client/server it resides. Whether the\nsockets are set helps determine which servers are running.\n"},
  {"SetServerToDataServer", PyvtkMPIMoveData_SetServerToDataServer, METH_VARARGS,
   "SetServerToDataServer(self) -> None\nC++: void SetServerToDataServer()\n\n"},
  {"SetServerToRenderServer", PyvtkMPIMoveData_SetServerToRenderServer, METH_VARARGS,
   "SetServerToRenderServer(self) -> None\nC++: void SetServerToRenderServer()\n\n"},
  {"SetServer", PyvtkMPIMoveData_SetServer, METH_VARARGS,
   "SetServer(self, _arg:int) -> None\nC++: virtual void SetServer(int _arg)\n\n"},
  {"GetServerMinValue", PyvtkMPIMoveData_GetServerMinValue, METH_VARARGS,
   "GetServerMinValue(self) -> int\nC++: virtual int GetServerMinValue()\n\n"},
  {"GetServerMaxValue", PyvtkMPIMoveData_GetServerMaxValue, METH_VARARGS,
   "GetServerMaxValue(self) -> int\nC++: virtual int GetServerMaxValue()\n\n"},
  {"GetServer", PyvtkMPIMoveData_GetServer, METH_VARARGS,
   "GetServer(self) -> int\nC++: virtual int GetServer()\n\n"},
  {"SetMoveModeToPassThrough", PyvtkMPIMoveData_SetMoveModeToPassThrough, METH_VARARGS,
   "SetMoveModeToPassThrough(self) -> None\nC++: void SetMoveModeToPassThrough()\n\nSpecify how the data is to be redistributed.\n"},
  {"SetMoveModeToCollect", PyvtkMPIMoveData_SetMoveModeToCollect, METH_VARARGS,
   "SetMoveModeToCollect(self) -> None\nC++: void SetMoveModeToCollect()\n\n"},
  {"SetMoveModeToClone", PyvtkMPIMoveData_SetMoveModeToClone, METH_VARARGS,
   "SetMoveModeToClone(self) -> None\nC++: void SetMoveModeToClone()\n\n"},
  {"SetMoveMode", PyvtkMPIMoveData_SetMoveMode, METH_VARARGS,
   "SetMoveMode(self, _arg:int) -> None\nC++: virtual void SetMoveMode(int _arg)\n\n"},
  {"GetMoveModeMinValue", PyvtkMPIMoveData_GetMoveModeMinValue, METH_VARARGS,
   "GetMoveModeMinValue(self) -> int\nC++: virtual int GetMoveModeMinValue()\n\n"},
  {"GetMoveModeMaxValue", PyvtkMPIMoveData_GetMoveModeMaxValue, METH_VARARGS,
   "GetMoveModeMaxValue(self) -> int\nC++: virtual int GetMoveModeMaxValue()\n\n"},
  {"SetOutputDataType", PyvtkMPIMoveData_SetOutputDataType, METH_VARARGS,
   "SetOutputDataType(self, _arg:int) -> None\nC++: virtual void SetOutputDataType(int _arg)\n\nControls the output type. This is required because processes\nreceiving data cannot know their output type in RequestDataObject\nwithout communicating with other processes. Since communicating\nwith other processes in RequestDataObject is dangerous (can cause\ndeadlock because it may happen out-of-sync), the application has\nto set the output type. The default is VTK_POLY_DATA.\n"},
  {"GetOutputDataType", PyvtkMPIMoveData_GetOutputDataType, METH_VARARGS,
   "GetOutputDataType(self) -> int\nC++: virtual int GetOutputDataType()\n\n"},
  {"SetUseZLibCompression", PyvtkMPIMoveData_SetUseZLibCompression, METH_VARARGS,
   "SetUseZLibCompression(b:bool) -> None\nC++: static void SetUseZLibCompression(bool b)\n\nWhen set to true, zlib compression is used. False by default.\nThis value has any effect only on the data-sender processes. The\nreceiver always checks the received data to see if zlib\ndecompression is required.\n"},
  {"GetUseZLibCompression", PyvtkMPIMoveData_GetUseZLibCompression, METH_VARARGS,
   "GetUseZLibCompression() -> bool\nC++: static bool GetUseZLibCompression()\n\n"},
  {"GetOutputGeneratedOnProcess", PyvtkMPIMoveData_GetOutputGeneratedOnProcess, METH_VARARGS,
   "GetOutputGeneratedOnProcess(self) -> bool\nC++: bool GetOutputGeneratedOnProcess()\n\nvtkMPIMoveData doesn't necessarily generate a valid output data\non all the involved processes (depending on the MoveMode and\nServer ivars). This returns true if valid data is available on\nthe current processes after successful Update() given the current\nivars).\n"},
  {"SetSkipDataServerGatherToZero", PyvtkMPIMoveData_SetSkipDataServerGatherToZero, METH_VARARGS,
   "SetSkipDataServerGatherToZero(self, _arg:bool) -> None\nC++: virtual void SetSkipDataServerGatherToZero(bool _arg)\n\nWhen set, vtkMPIMoveData will skip the gather-to-root-node\nprocess altogether. This is useful when the data is already\ncloned on the server-nodes or we are interested in the root-node\nresult alone.\n"},
  {"GetSkipDataServerGatherToZero", PyvtkMPIMoveData_GetSkipDataServerGatherToZero, METH_VARARGS,
   "GetSkipDataServerGatherToZero(self) -> bool\nC++: virtual bool GetSkipDataServerGatherToZero()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMPIMoveData_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mpim_to_n_socket_connection"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetMPIMToNSocketConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetMPIMToNSocketConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMPIMToNSocketConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("client_data_server_socket_controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetClientDataServerSocketController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetClientDataServerSocketController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetClientDataServerSocketController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClientDataServerSocketController/SetClientDataServerSocketController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("server"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetServer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetServer(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetServer(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetServer/SetServer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("move_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetMoveMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetMoveMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMoveMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_data_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetOutputDataType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetOutputDataType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetOutputDataType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOutputDataType/SetOutputDataType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_z_lib_compression"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetUseZLibCompression(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetUseZLibCompression(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetUseZLibCompression(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseZLibCompression/SetUseZLibCompression\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("skip_data_server_gather_to_zero"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetSkipDataServerGatherToZero(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkMPIMoveData_SetSkipDataServerGatherToZero(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkMPIMoveData_SetSkipDataServerGatherToZero(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSkipDataServerGatherToZero/SetSkipDataServerGatherToZero\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_generated_on_process"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkMPIMoveData_GetOutputGeneratedOnProcess(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutputGeneratedOnProcess\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkMPIMoveData_Doc =
  "vtkMPIMoveData - Moves/redistributes data between processes.\n\n"
  "Superclass: vtkPassInputTypeAlgorithm\n\n"
  "This class combines all the duplicate and collection requirements\n"
  "into one filter. It can move polydata and unstructured grid between\n"
  "processes. It can redistributed polydata from M to N processors.\n"
  "Update: This filter can now support delivering vtkUniformGridAMR\n"
  "datasets in PASS_THROUGH and/or COLLECT modes.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMPIMoveData_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkMPIMoveData", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkMPIMoveData_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkMPIMoveData_StaticNew()
{
  return vtkMPIMoveData::New();
}

PyObject *PyvtkMPIMoveData_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkMPIMoveData_Type, PyvtkMPIMoveData_Methods,
    "vtkMPIMoveData",
 &PyvtkMPIMoveData_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPassInputTypeAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkMPIMoveData_MoveModes_Type);
  PyVTKEnum_Add(&PyvtkMPIMoveData_MoveModes_Type, "vtkMPIMoveData.MoveModes");

  o = (PyObject *)&PyvtkMPIMoveData_MoveModes_Type;
  if (PyDict_SetItemString(d, "MoveModes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 5; c++)
  {
    typedef vtkMPIMoveData::MoveModes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[5] = {
        { "PASS_THROUGH", vtkMPIMoveData::PASS_THROUGH },
        { "COLLECT", vtkMPIMoveData::COLLECT },
        { "CLONE", vtkMPIMoveData::CLONE },
        { "COLLECT_AND_PASS_THROUGH", vtkMPIMoveData::COLLECT_AND_PASS_THROUGH },
        { "INVALID", vtkMPIMoveData::INVALID },
      };

    o = PyvtkMPIMoveData_MoveModes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkMPIMoveData_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMPIMoveData(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMPIMoveData_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkMPIMoveData", o) != 0)
  {
    Py_DECREF(o);
  }

}

