// python wrapper for vtkSMDomain
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMDomain.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMDomain(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMDomain_ClassNew(); }

#ifndef DECLARED_PyvtkSMSessionObject_ClassNew
extern "C" { PyObject *PyvtkSMSessionObject_ClassNew(); }
#define DECLARED_PyvtkSMSessionObject_ClassNew
#endif
#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMDomain_IsInDomainReturnCodes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMDomain.IsInDomainReturnCodes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMDomain_IsInDomainReturnCodes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMDomain_IsInDomainReturnCodes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMDomain_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMDomain::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMDomain::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMDomain *tempr = vtkSMDomain::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMDomain *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMDomain::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMDomain::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMDomain::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_IsInDomain(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    int tempr = (ap.IsBound() ?
      op->IsInDomain(temp0) :
      op->vtkSMDomain::IsInDomain(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    if (ap.IsBound())
    {
      op->Update(temp0);
    }
    else
    {
      op->vtkSMDomain::Update(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_SetAnimationValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAnimationValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkSMProperty") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAnimationValue(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSMDomain::SetAnimationValue(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_SetDefaultValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDefaultValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMProperty") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SetDefaultValues(temp0, temp1) :
      op->vtkSMDomain::SetDefaultValues(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetXMLName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXMLName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetXMLName() :
      op->vtkSMDomain::GetXMLName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetIsOptional(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsOptional");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsOptional() :
      op->vtkSMDomain::GetIsOptional());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetProperty() :
      op->vtkSMDomain::GetProperty());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetInputDataInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  unsigned int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetInputDataInformation(temp0, temp1) :
      op->vtkSMDomain::GetInputDataInformation(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetInputSubsetDataInformation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputSubsetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  unsigned int temp0;
  const char *temp1 = nullptr;
  unsigned int temp2 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetInputSubsetDataInformation(temp0, temp1, temp2) :
      op->vtkSMDomain::GetInputSubsetDataInformation(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMDomain_GetInputSubsetDataInformation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInputSubsetDataInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  const char *temp2 = nullptr;
  unsigned int temp3 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3, 4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    vtkPVDataInformation *tempr = (ap.IsBound() ?
      op->GetInputSubsetDataInformation(temp0, temp1, temp2, temp3) :
      op->vtkSMDomain::GetInputSubsetDataInformation(temp0, temp1, temp2, temp3));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMDomain_GetInputSubsetDataInformation_Methods[] = {
  {"GetInputSubsetDataInformation", PyvtkSMDomain_GetInputSubsetDataInformation_s1, METH_VARARGS,
   "@Iz|I"},
  {"GetInputSubsetDataInformation", PyvtkSMDomain_GetInputSubsetDataInformation_s2, METH_VARARGS,
   "@zzz|I"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMDomain_GetInputSubsetDataInformation(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMDomain_GetInputSubsetDataInformation_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMDomain_GetInputSubsetDataInformation_s1(self, args);
    case 4:
      return PyvtkSMDomain_GetInputSubsetDataInformation_s2(self, args);
    case 3:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "GetInputSubsetDataInformation");
  return nullptr;
}


static PyObject *
PyvtkSMDomain_GetNumberOfInputConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfInputConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNumberOfInputConnections(temp0) :
      op->vtkSMDomain::GetNumberOfInputConnections(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDomain_GetRequiredProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDomain *op = static_cast<vtkSMDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMProperty *tempr = (ap.IsBound() ?
      op->GetRequiredProperty(temp0) :
      op->vtkSMDomain::GetRequiredProperty(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMDomain_Methods[] = {
  {"IsTypeOf", PyvtkSMDomain_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMDomain_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMDomain_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMDomain\nC++: static vtkSMDomain *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMDomain_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMDomain\nC++: vtkSMDomain *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMDomain_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMDomain_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsInDomain", PyvtkSMDomain_IsInDomain, METH_VARARGS,
   "IsInDomain(self, property:vtkSMProperty) -> int\nC++: virtual int IsInDomain(vtkSMProperty *property)\n\nIs the (unchecked) value of the property in the domain?\nOverwritten by sub-classes.\n\nReturned values as defined in `IsInDomainReturnCodes`.\n`NOT_APPLICABLE` is returned if the domain is not applicable for\nthe property values. `NOT_IN_DOMAIN` implies that the value is\nnot in domain while `IN_DOMAIN` implies that the value is\nacceptable.\n"},
  {"Update", PyvtkSMDomain_Update, METH_VARARGS,
   "Update(self, requestingProperty:vtkSMProperty) -> None\nC++: virtual void Update(vtkSMProperty *requestingProperty)\n\nUpdate self based on the \"unchecked\" values of all required\nproperties. Subclasses must override this method to update the\ndomain based on the requestingProperty (and/or other required\nproperties).\n"},
  {"SetAnimationValue", PyvtkSMDomain_SetAnimationValue, METH_VARARGS,
   "SetAnimationValue(self, __a:vtkSMProperty, index:int, value:float)\n     -> None\nC++: virtual void SetAnimationValue(vtkSMProperty *, int index,\n    double value)\n\nSet the value of an element of a property from the animation\neditor.\n"},
  {"SetDefaultValues", PyvtkSMDomain_SetDefaultValues, METH_VARARGS,
   "SetDefaultValues(self, __a:vtkSMProperty,\n    use_unchecked_values:bool) -> int\nC++: virtual int SetDefaultValues(vtkSMProperty *,\n    bool use_unchecked_values)\n\nA vtkSMProperty is often defined with a default value in the XML\nitself. However, many times, the default value must be determined\nat run time. To facilitate this, domains can override this method\nto compute and set the default value for the property. Note that\nunlike the compile-time default values, the application must\nexplicitly call this method to initialize the property. If\nuse_unchecked_values is true, the property's unchecked values\nwill be changed by this method. Returns 1 if the domain updated\nthe property. Default implementation does nothing.\n"},
  {"GetXMLName", PyvtkSMDomain_GetXMLName, METH_VARARGS,
   "GetXMLName(self) -> str\nC++: virtual char *GetXMLName()\n\nAssigned by the XML parser. The name assigned in the XML\nconfiguration. Can be used to figure out the origin of the\ndomain.\n"},
  {"GetIsOptional", PyvtkSMDomain_GetIsOptional, METH_VARARGS,
   "GetIsOptional(self) -> bool\nC++: virtual bool GetIsOptional()\n\nWhen the IsOptional flag is set, IsInDomain() always returns\ntrue. This is used by properties that use domains to provide\ninformation (a suggestion to the gui for example) as opposed to\nrestrict their values.\n"},
  {"GetProperty", PyvtkSMDomain_GetProperty, METH_VARARGS,
   "GetProperty(self) -> vtkSMProperty\nC++: vtkSMProperty *GetProperty()\n\nProvides access to the vtkSMProperty on which this domain is\nhooked up.\n"},
  {"GetInputDataInformation", PyvtkSMDomain_GetInputDataInformation, METH_VARARGS,
   "GetInputDataInformation(self, function:str, index:int=0)\n    -> vtkPVDataInformation\nC++: virtual vtkPVDataInformation *GetInputDataInformation(\n    const char *function, unsigned int index=0)\n\nHelper methods to get vtkPVDataInformation from input proxy\nconnected to the required property with the given function and\nprovided input index.\n"},
  {"GetInputSubsetDataInformation", PyvtkSMDomain_GetInputSubsetDataInformation, METH_VARARGS,
   "GetInputSubsetDataInformation(self, compositeIndex:int,\n    function:str, index:int=0) -> vtkPVDataInformation\nC++: virtual vtkPVDataInformation *GetInputSubsetDataInformation(\n    unsigned int compositeIndex, const char *function,\n    unsigned int index=0)\nGetInputSubsetDataInformation(self, selector:str,\n    assemblyName:str, function:str, index:int=0)\n    -> vtkPVDataInformation\nC++: virtual vtkPVDataInformation *GetInputSubsetDataInformation(\n    const char *selector, const char *assemblyName,\n    const char *function, unsigned int index=0)\n\n"},
  {"GetNumberOfInputConnections", PyvtkSMDomain_GetNumberOfInputConnections, METH_VARARGS,
   "GetNumberOfInputConnections(self, function:str) -> int\nC++: virtual unsigned int GetNumberOfInputConnections(\n    const char *function)\n\nHelper method to get the number of input connections hence the\nnumber of available vtkPVDataInformation from input proxy\nconnected to the required property with the given function.\n"},
  {"GetRequiredProperty", PyvtkSMDomain_GetRequiredProperty, METH_VARARGS,
   "GetRequiredProperty(self, function:str) -> vtkSMProperty\nC++: vtkSMProperty *GetRequiredProperty(const char *function)\n\nReturns a given required property of the given function. Function\nis a string associated with the require property in the XML file.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMDomain_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("is_optional"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDomain_GetIsOptional(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIsOptional\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("xml_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDomain_GetXMLName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetXMLName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("property"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDomain_GetProperty(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProperty\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMDomain_Doc =
  "vtkSMDomain - represents the possible values a property can have\n\n"
  "Superclass: vtkSMSessionObject\n\n"
  "vtkSMDomain is an abstract class that describes the \"domain\" of a a\n"
  "widget. A domain is a collection of possible values a property can\n"
  "have.\n\n"
  "Each domain can depend on one or more properties to compute it's\n"
  "values. This are called \"required\" properties and can be set in the\n"
  "XML configuration file.\n\n"
  "Every time a domain changes it must fire a\n"
  "vtkCommand::DomainModifiedEvent. Applications may decide to update\n"
  "the UI every-time the domain changes. As a result, domains ideally\n"
  "should only fire that event when their values change for real not\n"
  "just potentially changed.\n"
  "@sa vtkSMDomain::DeferDomainModifiedEvents.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMDomain_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMDomain", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMDomain_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMDomain_StaticNew()
{
  return vtkSMDomain::New();
}

PyObject *PyvtkSMDomain_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMDomain_Type, PyvtkSMDomain_Methods,
    "vtkSMDomain",
 &PyvtkSMDomain_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMSessionObject_ClassNew();

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMDomain_IsInDomainReturnCodes_Type);
  PyVTKEnum_Add(&PyvtkSMDomain_IsInDomainReturnCodes_Type, "vtkSMDomain.IsInDomainReturnCodes");

  o = (PyObject *)&PyvtkSMDomain_IsInDomainReturnCodes_Type;
  if (PyDict_SetItemString(d, "IsInDomainReturnCodes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkSMDomain::IsInDomainReturnCodes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "NOT_APPLICABLE", vtkSMDomain::NOT_APPLICABLE },
        { "NOT_IN_DOMAIN", vtkSMDomain::NOT_IN_DOMAIN },
        { "IN_DOMAIN", vtkSMDomain::IN_DOMAIN },
      };

    o = PyvtkSMDomain_IsInDomainReturnCodes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMDomain_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMDomain(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMDomain_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMDomain", o) != 0)
  {
    Py_DECREF(o);
  }

}

