// components/services/storage/public/mojom/service_worker_storage_control.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/service_worker_storage_control.mojom-shared-internal.h"
#include "components/services/storage/public/mojom/local_storage_control.mojom-shared.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace storage {
namespace mojom {
class ServiceWorkerFindRegistrationResultDataView;

class ServiceWorkerUserDataDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerFindRegistrationResultDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerUserDataDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerUserData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class ServiceWorkerStorageOriginState : int32_t {
  
  kKeep = 0,
  
  kDelete = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerStorageOriginState value);
inline bool IsKnownEnumValue(ServiceWorkerStorageOriginState value) {
  return internal::ServiceWorkerStorageOriginState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ServiceWorkerLiveVersionRefInterfaceBase {};

using ServiceWorkerLiveVersionRefPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
using ServiceWorkerLiveVersionRefAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerLiveVersionRefInterfaceBase>;
class ServiceWorkerDataPipeStateNotifierInterfaceBase {};

using ServiceWorkerDataPipeStateNotifierPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerDataPipeStateNotifierInterfaceBase>;
using ServiceWorkerDataPipeStateNotifierRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerDataPipeStateNotifierInterfaceBase>;
using ServiceWorkerDataPipeStateNotifierAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerDataPipeStateNotifierInterfaceBase>;
using ServiceWorkerDataPipeStateNotifierAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerDataPipeStateNotifierInterfaceBase>;
class ServiceWorkerResourceReaderInterfaceBase {};

using ServiceWorkerResourceReaderPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceReaderInterfaceBase>;
using ServiceWorkerResourceReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceReaderInterfaceBase>;
class ServiceWorkerResourceWriterInterfaceBase {};

using ServiceWorkerResourceWriterPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceWriterInterfaceBase>;
using ServiceWorkerResourceWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceWriterInterfaceBase>;
class ServiceWorkerResourceMetadataWriterInterfaceBase {};

using ServiceWorkerResourceMetadataWriterPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
using ServiceWorkerResourceMetadataWriterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerResourceMetadataWriterInterfaceBase>;
class ServiceWorkerStorageControlInterfaceBase {};

using ServiceWorkerStorageControlPtrDataView =
    mojo::InterfacePtrDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlRequestDataView =
    mojo::InterfaceRequestDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ServiceWorkerStorageControlInterfaceBase>;
using ServiceWorkerStorageControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ServiceWorkerStorageControlInterfaceBase>;


class ServiceWorkerFindRegistrationResultDataView {
 public:
  ServiceWorkerFindRegistrationResultDataView() {}

  ServiceWorkerFindRegistrationResultDataView(
      internal::ServiceWorkerFindRegistrationResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeVersionReference() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
            &data_->version_reference, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetRegistrationDataView(
      ::storage::mojom::ServiceWorkerRegistrationDataDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRegistration(UserType* output) {
    
    auto* pointer = data_->registration.Get();
    return mojo::internal::Deserialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
        pointer, output, context_);
  }
  inline void GetResourcesDataView(
      mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResources(UserType* output) {
    
    auto* pointer = data_->resources.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ServiceWorkerFindRegistrationResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ServiceWorkerUserDataDataView {
 public:
  ServiceWorkerUserDataDataView() {}

  ServiceWorkerUserDataDataView(
      internal::ServiceWorkerUserData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int64_t registration_id() const {
    return data_->registration_id;
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::ServiceWorkerUserData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::ServiceWorkerStorageOriginState>
    : public mojo::internal::EnumHashImpl<::storage::mojom::ServiceWorkerStorageOriginState> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::ServiceWorkerStorageOriginState, ::storage::mojom::ServiceWorkerStorageOriginState> {
  static ::storage::mojom::ServiceWorkerStorageOriginState ToMojom(::storage::mojom::ServiceWorkerStorageOriginState input) { return input; }
  static bool FromMojom(::storage::mojom::ServiceWorkerStorageOriginState input, ::storage::mojom::ServiceWorkerStorageOriginState* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerStorageOriginState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::ServiceWorkerStorageOriginState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::ServiceWorkerStorageOriginState>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerFindRegistrationResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerFindRegistrationResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::version_reference(input)) in_version_reference = Traits::version_reference(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::ServiceWorkerLiveVersionRefInterfaceBase>>(
        in_version_reference, &(*output)->version_reference, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->version_reference),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid version_reference in ServiceWorkerFindRegistrationResult struct");
    decltype(Traits::registration(input)) in_registration = Traits::registration(input);
    typename decltype((*output)->registration)::BaseType::BufferWriter
        registration_writer;
    mojo::internal::Serialize<::storage::mojom::ServiceWorkerRegistrationDataDataView>(
        in_registration, buffer, &registration_writer, context);
    (*output)->registration.Set(
        registration_writer.is_null() ? nullptr : registration_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->registration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null registration in ServiceWorkerFindRegistrationResult struct");
    decltype(Traits::resources(input)) in_resources = Traits::resources(input);
    typename decltype((*output)->resources)::BaseType::BufferWriter
        resources_writer;
    const mojo::internal::ContainerValidateParams resources_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>>(
        in_resources, buffer, &resources_writer, &resources_validate_params,
        context);
    (*output)->resources.Set(
        resources_writer.is_null() ? nullptr : resources_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->resources.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resources in ServiceWorkerFindRegistrationResult struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerFindRegistrationResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerFindRegistrationResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerUserDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerUserDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::ServiceWorkerUserData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->registration_id = Traits::registration_id(input);
    decltype(Traits::key(input)) in_key = Traits::key(input);
    typename decltype((*output)->key)::BaseType::BufferWriter
        key_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_key, buffer, &key_writer, context);
    (*output)->key.Set(
        key_writer.is_null() ? nullptr : key_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in ServiceWorkerUserData struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    typename decltype((*output)->value)::BaseType::BufferWriter
        value_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, buffer, &value_writer, context);
    (*output)->value.Set(
        value_writer.is_null() ? nullptr : value_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in ServiceWorkerUserData struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerUserData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerUserDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void ServiceWorkerFindRegistrationResultDataView::GetRegistrationDataView(
    ::storage::mojom::ServiceWorkerRegistrationDataDataView* output) {
  auto pointer = data_->registration.Get();
  *output = ::storage::mojom::ServiceWorkerRegistrationDataDataView(pointer, context_);
}
inline void ServiceWorkerFindRegistrationResultDataView::GetResourcesDataView(
    mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>* output) {
  auto pointer = data_->resources.Get();
  *output = mojo::ArrayDataView<::storage::mojom::ServiceWorkerResourceRecordDataView>(pointer, context_);
}


inline void ServiceWorkerUserDataDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ServiceWorkerUserDataDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_STORAGE_CONTROL_MOJOM_SHARED_H_