// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_
#define FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_

#include "flatbuffers/flatbuffers.h"

#include "components/url_pattern_index/flat/url_pattern_index_generated.h"

namespace extensions {
namespace declarative_net_request {
namespace flat {

struct QueryKeyValue;

struct UrlTransform;

struct UrlRuleMetadata;

struct ModifyHeaderInfo;

struct RegexRule;

struct ExtensionIndexedRuleset;

/// The type of an action. Corresponds to
/// extensions::api::declarative_net_request::RuleActionType.
enum ActionType {
  ActionType_block = 0,
  ActionType_allow = 1,
  ActionType_redirect = 2,
  ActionType_upgrade_scheme = 3,
  ActionType_modify_headers = 4,
  ActionType_allow_all_requests = 5,
  /// Number of actions. Must be the last entry.
  ActionType_count = 6,
  ActionType_MIN = ActionType_block,
  ActionType_MAX = ActionType_count
};

inline const ActionType (&EnumValuesActionType())[7] {
  static const ActionType values[] = {
    ActionType_block,
    ActionType_allow,
    ActionType_redirect,
    ActionType_upgrade_scheme,
    ActionType_modify_headers,
    ActionType_allow_all_requests,
    ActionType_count
  };
  return values;
}

inline const char * const *EnumNamesActionType() {
  static const char * const names[8] = {
    "block",
    "allow",
    "redirect",
    "upgrade_scheme",
    "modify_headers",
    "allow_all_requests",
    "count",
    nullptr
  };
  return names;
}

inline const char *EnumNameActionType(ActionType e) {
  if (e < ActionType_block || e > ActionType_count) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesActionType()[index];
}

/// This provides a mapping from an index type to its index within
/// the |index_list| vector.
enum IndexType {
  /// Index for rules that are evaluated during the onBeforeRequest stage of a
  /// request, excluding allowAllRequests rules.
  IndexType_before_request_except_allow_all_requests = 0,
  /// Index for allowAllRequests rule. We have a separate index for these rules
  /// since they need to be evaluated separately when a navigation commits.
  IndexType_allow_all_requests = 1,
  IndexType_modify_headers = 2,
  /// Number of indices. Must be the last entry.
  IndexType_count = 3,
  IndexType_MIN = IndexType_before_request_except_allow_all_requests,
  IndexType_MAX = IndexType_count
};

inline const IndexType (&EnumValuesIndexType())[4] {
  static const IndexType values[] = {
    IndexType_before_request_except_allow_all_requests,
    IndexType_allow_all_requests,
    IndexType_modify_headers,
    IndexType_count
  };
  return values;
}

inline const char * const *EnumNamesIndexType() {
  static const char * const names[5] = {
    "before_request_except_allow_all_requests",
    "allow_all_requests",
    "modify_headers",
    "count",
    nullptr
  };
  return names;
}

inline const char *EnumNameIndexType(IndexType e) {
  if (e < IndexType_before_request_except_allow_all_requests || e > IndexType_count) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesIndexType()[index];
}

/// The type of header operation for modifyHeaders rules. Corresponds to
/// extensions::api::declarative_net_request::HeaderOperation.
enum HeaderOperation {
  HeaderOperation_append = 0,
  HeaderOperation_set = 1,
  HeaderOperation_remove = 2,
  HeaderOperation_MIN = HeaderOperation_append,
  HeaderOperation_MAX = HeaderOperation_remove
};

inline const HeaderOperation (&EnumValuesHeaderOperation())[3] {
  static const HeaderOperation values[] = {
    HeaderOperation_append,
    HeaderOperation_set,
    HeaderOperation_remove
  };
  return values;
}

inline const char * const *EnumNamesHeaderOperation() {
  static const char * const names[4] = {
    "append",
    "set",
    "remove",
    nullptr
  };
  return names;
}

inline const char *EnumNameHeaderOperation(HeaderOperation e) {
  if (e < HeaderOperation_append || e > HeaderOperation_remove) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesHeaderOperation()[index];
}

struct QueryKeyValue FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_KEY = 4,
    VT_VALUE = 6
  };
  const flatbuffers::String *key() const {
    return GetPointer<const flatbuffers::String *>(VT_KEY);
  }
  const flatbuffers::String *value() const {
    return GetPointer<const flatbuffers::String *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffsetRequired(verifier, VT_KEY) &&
           verifier.VerifyString(key()) &&
           VerifyOffsetRequired(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           verifier.EndTable();
  }
};

struct QueryKeyValueBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_key(flatbuffers::Offset<flatbuffers::String> key) {
    fbb_.AddOffset(QueryKeyValue::VT_KEY, key);
  }
  void add_value(flatbuffers::Offset<flatbuffers::String> value) {
    fbb_.AddOffset(QueryKeyValue::VT_VALUE, value);
  }
  explicit QueryKeyValueBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  QueryKeyValueBuilder &operator=(const QueryKeyValueBuilder &);
  flatbuffers::Offset<QueryKeyValue> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<QueryKeyValue>(end);
    fbb_.Required(o, QueryKeyValue::VT_KEY);
    fbb_.Required(o, QueryKeyValue::VT_VALUE);
    return o;
  }
};

inline flatbuffers::Offset<QueryKeyValue> CreateQueryKeyValue(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> key = 0,
    flatbuffers::Offset<flatbuffers::String> value = 0) {
  QueryKeyValueBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_key(key);
  return builder_.Finish();
}

inline flatbuffers::Offset<QueryKeyValue> CreateQueryKeyValueDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *key = nullptr,
    const char *value = nullptr) {
  auto key__ = key ? _fbb.CreateString(key) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return extensions::declarative_net_request::flat::CreateQueryKeyValue(
      _fbb,
      key__,
      value__);
}

struct UrlTransform FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_SCHEME = 4,
    VT_HOST = 6,
    VT_CLEAR_PORT = 8,
    VT_PORT = 10,
    VT_CLEAR_PATH = 12,
    VT_PATH = 14,
    VT_CLEAR_QUERY = 16,
    VT_QUERY = 18,
    VT_REMOVE_QUERY_PARAMS = 20,
    VT_ADD_OR_REPLACE_QUERY_PARAMS = 22,
    VT_CLEAR_FRAGMENT = 24,
    VT_FRAGMENT = 26,
    VT_USERNAME = 28,
    VT_PASSWORD = 30
  };
  const flatbuffers::String *scheme() const {
    return GetPointer<const flatbuffers::String *>(VT_SCHEME);
  }
  const flatbuffers::String *host() const {
    return GetPointer<const flatbuffers::String *>(VT_HOST);
  }
  bool clear_port() const {
    return GetField<uint8_t>(VT_CLEAR_PORT, 0) != 0;
  }
  const flatbuffers::String *port() const {
    return GetPointer<const flatbuffers::String *>(VT_PORT);
  }
  bool clear_path() const {
    return GetField<uint8_t>(VT_CLEAR_PATH, 0) != 0;
  }
  const flatbuffers::String *path() const {
    return GetPointer<const flatbuffers::String *>(VT_PATH);
  }
  bool clear_query() const {
    return GetField<uint8_t>(VT_CLEAR_QUERY, 0) != 0;
  }
  /// If valid, doesn't include the '?' separator.
  const flatbuffers::String *query() const {
    return GetPointer<const flatbuffers::String *>(VT_QUERY);
  }
  /// Query params to be removed. These are already sorted and escaped using
  /// net::EscapeQueryParamValue.
  const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *remove_query_params() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>> *>(VT_REMOVE_QUERY_PARAMS);
  }
  /// Query params to be added/replaced. These are already escaped using
  /// net::EscapeQueryParamValue.
  const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *add_or_replace_query_params() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *>(VT_ADD_OR_REPLACE_QUERY_PARAMS);
  }
  bool clear_fragment() const {
    return GetField<uint8_t>(VT_CLEAR_FRAGMENT, 0) != 0;
  }
  /// If valid, doesn't include the '#' separator.
  const flatbuffers::String *fragment() const {
    return GetPointer<const flatbuffers::String *>(VT_FRAGMENT);
  }
  const flatbuffers::String *username() const {
    return GetPointer<const flatbuffers::String *>(VT_USERNAME);
  }
  const flatbuffers::String *password() const {
    return GetPointer<const flatbuffers::String *>(VT_PASSWORD);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_SCHEME) &&
           verifier.VerifyString(scheme()) &&
           VerifyOffset(verifier, VT_HOST) &&
           verifier.VerifyString(host()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_PORT) &&
           VerifyOffset(verifier, VT_PORT) &&
           verifier.VerifyString(port()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_PATH) &&
           VerifyOffset(verifier, VT_PATH) &&
           verifier.VerifyString(path()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_QUERY) &&
           VerifyOffset(verifier, VT_QUERY) &&
           verifier.VerifyString(query()) &&
           VerifyOffset(verifier, VT_REMOVE_QUERY_PARAMS) &&
           verifier.VerifyVector(remove_query_params()) &&
           verifier.VerifyVectorOfStrings(remove_query_params()) &&
           VerifyOffset(verifier, VT_ADD_OR_REPLACE_QUERY_PARAMS) &&
           verifier.VerifyVector(add_or_replace_query_params()) &&
           verifier.VerifyVectorOfTables(add_or_replace_query_params()) &&
           VerifyField<uint8_t>(verifier, VT_CLEAR_FRAGMENT) &&
           VerifyOffset(verifier, VT_FRAGMENT) &&
           verifier.VerifyString(fragment()) &&
           VerifyOffset(verifier, VT_USERNAME) &&
           verifier.VerifyString(username()) &&
           VerifyOffset(verifier, VT_PASSWORD) &&
           verifier.VerifyString(password()) &&
           verifier.EndTable();
  }
};

struct UrlTransformBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_scheme(flatbuffers::Offset<flatbuffers::String> scheme) {
    fbb_.AddOffset(UrlTransform::VT_SCHEME, scheme);
  }
  void add_host(flatbuffers::Offset<flatbuffers::String> host) {
    fbb_.AddOffset(UrlTransform::VT_HOST, host);
  }
  void add_clear_port(bool clear_port) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_PORT, static_cast<uint8_t>(clear_port), 0);
  }
  void add_port(flatbuffers::Offset<flatbuffers::String> port) {
    fbb_.AddOffset(UrlTransform::VT_PORT, port);
  }
  void add_clear_path(bool clear_path) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_PATH, static_cast<uint8_t>(clear_path), 0);
  }
  void add_path(flatbuffers::Offset<flatbuffers::String> path) {
    fbb_.AddOffset(UrlTransform::VT_PATH, path);
  }
  void add_clear_query(bool clear_query) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_QUERY, static_cast<uint8_t>(clear_query), 0);
  }
  void add_query(flatbuffers::Offset<flatbuffers::String> query) {
    fbb_.AddOffset(UrlTransform::VT_QUERY, query);
  }
  void add_remove_query_params(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> remove_query_params) {
    fbb_.AddOffset(UrlTransform::VT_REMOVE_QUERY_PARAMS, remove_query_params);
  }
  void add_add_or_replace_query_params(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>> add_or_replace_query_params) {
    fbb_.AddOffset(UrlTransform::VT_ADD_OR_REPLACE_QUERY_PARAMS, add_or_replace_query_params);
  }
  void add_clear_fragment(bool clear_fragment) {
    fbb_.AddElement<uint8_t>(UrlTransform::VT_CLEAR_FRAGMENT, static_cast<uint8_t>(clear_fragment), 0);
  }
  void add_fragment(flatbuffers::Offset<flatbuffers::String> fragment) {
    fbb_.AddOffset(UrlTransform::VT_FRAGMENT, fragment);
  }
  void add_username(flatbuffers::Offset<flatbuffers::String> username) {
    fbb_.AddOffset(UrlTransform::VT_USERNAME, username);
  }
  void add_password(flatbuffers::Offset<flatbuffers::String> password) {
    fbb_.AddOffset(UrlTransform::VT_PASSWORD, password);
  }
  explicit UrlTransformBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  UrlTransformBuilder &operator=(const UrlTransformBuilder &);
  flatbuffers::Offset<UrlTransform> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<UrlTransform>(end);
    return o;
  }
};

inline flatbuffers::Offset<UrlTransform> CreateUrlTransform(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::String> scheme = 0,
    flatbuffers::Offset<flatbuffers::String> host = 0,
    bool clear_port = false,
    flatbuffers::Offset<flatbuffers::String> port = 0,
    bool clear_path = false,
    flatbuffers::Offset<flatbuffers::String> path = 0,
    bool clear_query = false,
    flatbuffers::Offset<flatbuffers::String> query = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<flatbuffers::String>>> remove_query_params = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>> add_or_replace_query_params = 0,
    bool clear_fragment = false,
    flatbuffers::Offset<flatbuffers::String> fragment = 0,
    flatbuffers::Offset<flatbuffers::String> username = 0,
    flatbuffers::Offset<flatbuffers::String> password = 0) {
  UrlTransformBuilder builder_(_fbb);
  builder_.add_password(password);
  builder_.add_username(username);
  builder_.add_fragment(fragment);
  builder_.add_add_or_replace_query_params(add_or_replace_query_params);
  builder_.add_remove_query_params(remove_query_params);
  builder_.add_query(query);
  builder_.add_path(path);
  builder_.add_port(port);
  builder_.add_host(host);
  builder_.add_scheme(scheme);
  builder_.add_clear_fragment(clear_fragment);
  builder_.add_clear_query(clear_query);
  builder_.add_clear_path(clear_path);
  builder_.add_clear_port(clear_port);
  return builder_.Finish();
}

inline flatbuffers::Offset<UrlTransform> CreateUrlTransformDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const char *scheme = nullptr,
    const char *host = nullptr,
    bool clear_port = false,
    const char *port = nullptr,
    bool clear_path = false,
    const char *path = nullptr,
    bool clear_query = false,
    const char *query = nullptr,
    const std::vector<flatbuffers::Offset<flatbuffers::String>> *remove_query_params = nullptr,
    const std::vector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>> *add_or_replace_query_params = nullptr,
    bool clear_fragment = false,
    const char *fragment = nullptr,
    const char *username = nullptr,
    const char *password = nullptr) {
  auto scheme__ = scheme ? _fbb.CreateString(scheme) : 0;
  auto host__ = host ? _fbb.CreateString(host) : 0;
  auto port__ = port ? _fbb.CreateString(port) : 0;
  auto path__ = path ? _fbb.CreateString(path) : 0;
  auto query__ = query ? _fbb.CreateString(query) : 0;
  auto remove_query_params__ = remove_query_params ? _fbb.CreateVector<flatbuffers::Offset<flatbuffers::String>>(*remove_query_params) : 0;
  auto add_or_replace_query_params__ = add_or_replace_query_params ? _fbb.CreateVector<flatbuffers::Offset<extensions::declarative_net_request::flat::QueryKeyValue>>(*add_or_replace_query_params) : 0;
  auto fragment__ = fragment ? _fbb.CreateString(fragment) : 0;
  auto username__ = username ? _fbb.CreateString(username) : 0;
  auto password__ = password ? _fbb.CreateString(password) : 0;
  return extensions::declarative_net_request::flat::CreateUrlTransform(
      _fbb,
      scheme__,
      host__,
      clear_port,
      port__,
      clear_path,
      path__,
      clear_query,
      query__,
      remove_query_params__,
      add_or_replace_query_params__,
      clear_fragment,
      fragment__,
      username__,
      password__);
}

/// Additional extension related metadata for a url_pattern_index UrlRule.
struct UrlRuleMetadata FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_ID = 4,
    VT_ACTION = 6,
    VT_REDIRECT_URL = 8,
    VT_TRANSFORM = 10,
    VT_REQUEST_HEADERS = 12,
    VT_RESPONSE_HEADERS = 14
  };
  /// ID of the UrlRule for which this metadata is stored.
  uint32_t id() const {
    return GetField<uint32_t>(VT_ID, 0);
  }
  bool KeyCompareLessThan(const UrlRuleMetadata *o) const {
    return id() < o->id();
  }
  int KeyCompareWithValue(uint32_t val) const {
    return static_cast<int>(id() > val) - static_cast<int>(id() < val);
  }
  /// Action type for this rule.
  extensions::declarative_net_request::flat::ActionType action() const {
    return static_cast<extensions::declarative_net_request::flat::ActionType>(GetField<uint8_t>(VT_ACTION, 0));
  }
  /// Redirect url for this rule. Should represent a valid GURL. At most one of
  /// |redirect_url| and |transform| should be specified for redirect rules.
  const flatbuffers::String *redirect_url() const {
    return GetPointer<const flatbuffers::String *>(VT_REDIRECT_URL);
  }
  /// UrlTransform for this rule.
  const extensions::declarative_net_request::flat::UrlTransform *transform() const {
    return GetPointer<const extensions::declarative_net_request::flat::UrlTransform *>(VT_TRANSFORM);
  }
  /// A list of ModifyHeaderInfo, for both request and response headers. Valid
  /// for "modifyHeaders" rules.
  const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *request_headers() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *>(VT_REQUEST_HEADERS);
  }
  const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *response_headers() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *>(VT_RESPONSE_HEADERS);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint32_t>(verifier, VT_ID) &&
           VerifyField<uint8_t>(verifier, VT_ACTION) &&
           VerifyOffset(verifier, VT_REDIRECT_URL) &&
           verifier.VerifyString(redirect_url()) &&
           VerifyOffset(verifier, VT_TRANSFORM) &&
           verifier.VerifyTable(transform()) &&
           VerifyOffset(verifier, VT_REQUEST_HEADERS) &&
           verifier.VerifyVector(request_headers()) &&
           verifier.VerifyVectorOfTables(request_headers()) &&
           VerifyOffset(verifier, VT_RESPONSE_HEADERS) &&
           verifier.VerifyVector(response_headers()) &&
           verifier.VerifyVectorOfTables(response_headers()) &&
           verifier.EndTable();
  }
};

struct UrlRuleMetadataBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_id(uint32_t id) {
    fbb_.AddElement<uint32_t>(UrlRuleMetadata::VT_ID, id, 0);
  }
  void add_action(extensions::declarative_net_request::flat::ActionType action) {
    fbb_.AddElement<uint8_t>(UrlRuleMetadata::VT_ACTION, static_cast<uint8_t>(action), 0);
  }
  void add_redirect_url(flatbuffers::Offset<flatbuffers::String> redirect_url) {
    fbb_.AddOffset(UrlRuleMetadata::VT_REDIRECT_URL, redirect_url);
  }
  void add_transform(flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform) {
    fbb_.AddOffset(UrlRuleMetadata::VT_TRANSFORM, transform);
  }
  void add_request_headers(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> request_headers) {
    fbb_.AddOffset(UrlRuleMetadata::VT_REQUEST_HEADERS, request_headers);
  }
  void add_response_headers(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> response_headers) {
    fbb_.AddOffset(UrlRuleMetadata::VT_RESPONSE_HEADERS, response_headers);
  }
  explicit UrlRuleMetadataBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  UrlRuleMetadataBuilder &operator=(const UrlRuleMetadataBuilder &);
  flatbuffers::Offset<UrlRuleMetadata> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<UrlRuleMetadata>(end);
    return o;
  }
};

inline flatbuffers::Offset<UrlRuleMetadata> CreateUrlRuleMetadata(
    flatbuffers::FlatBufferBuilder &_fbb,
    uint32_t id = 0,
    extensions::declarative_net_request::flat::ActionType action = extensions::declarative_net_request::flat::ActionType_block,
    flatbuffers::Offset<flatbuffers::String> redirect_url = 0,
    flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> request_headers = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>> response_headers = 0) {
  UrlRuleMetadataBuilder builder_(_fbb);
  builder_.add_response_headers(response_headers);
  builder_.add_request_headers(request_headers);
  builder_.add_transform(transform);
  builder_.add_redirect_url(redirect_url);
  builder_.add_id(id);
  builder_.add_action(action);
  return builder_.Finish();
}

inline flatbuffers::Offset<UrlRuleMetadata> CreateUrlRuleMetadataDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    uint32_t id = 0,
    extensions::declarative_net_request::flat::ActionType action = extensions::declarative_net_request::flat::ActionType_block,
    const char *redirect_url = nullptr,
    flatbuffers::Offset<extensions::declarative_net_request::flat::UrlTransform> transform = 0,
    const std::vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *request_headers = nullptr,
    const std::vector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>> *response_headers = nullptr) {
  auto redirect_url__ = redirect_url ? _fbb.CreateString(redirect_url) : 0;
  auto request_headers__ = request_headers ? _fbb.CreateVector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>(*request_headers) : 0;
  auto response_headers__ = response_headers ? _fbb.CreateVector<flatbuffers::Offset<extensions::declarative_net_request::flat::ModifyHeaderInfo>>(*response_headers) : 0;
  return extensions::declarative_net_request::flat::CreateUrlRuleMetadata(
      _fbb,
      id,
      action,
      redirect_url__,
      transform,
      request_headers__,
      response_headers__);
}

/// Describes the header to be modified and operation to be performed on it.
/// Corresponds to extensions::api::declarative_net_request::ModifyHeaderInfo.
struct ModifyHeaderInfo FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_OPERATION = 4,
    VT_HEADER = 6,
    VT_VALUE = 8
  };
  extensions::declarative_net_request::flat::HeaderOperation operation() const {
    return static_cast<extensions::declarative_net_request::flat::HeaderOperation>(GetField<uint8_t>(VT_OPERATION, 0));
  }
  /// The name the header to be modified. Since header names are
  /// case-insensitive, the header name is normalized by converting it to
  /// lowercase.
  const flatbuffers::String *header() const {
    return GetPointer<const flatbuffers::String *>(VT_HEADER);
  }
  /// The value of the header to be set/appended. Should be specified only if
  /// |operation| is append or set.
  const flatbuffers::String *value() const {
    return GetPointer<const flatbuffers::String *>(VT_VALUE);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyField<uint8_t>(verifier, VT_OPERATION) &&
           VerifyOffset(verifier, VT_HEADER) &&
           verifier.VerifyString(header()) &&
           VerifyOffset(verifier, VT_VALUE) &&
           verifier.VerifyString(value()) &&
           verifier.EndTable();
  }
};

struct ModifyHeaderInfoBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_operation(extensions::declarative_net_request::flat::HeaderOperation operation) {
    fbb_.AddElement<uint8_t>(ModifyHeaderInfo::VT_OPERATION, static_cast<uint8_t>(operation), 0);
  }
  void add_header(flatbuffers::Offset<flatbuffers::String> header) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_HEADER, header);
  }
  void add_value(flatbuffers::Offset<flatbuffers::String> value) {
    fbb_.AddOffset(ModifyHeaderInfo::VT_VALUE, value);
  }
  explicit ModifyHeaderInfoBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ModifyHeaderInfoBuilder &operator=(const ModifyHeaderInfoBuilder &);
  flatbuffers::Offset<ModifyHeaderInfo> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ModifyHeaderInfo>(end);
    return o;
  }
};

inline flatbuffers::Offset<ModifyHeaderInfo> CreateModifyHeaderInfo(
    flatbuffers::FlatBufferBuilder &_fbb,
    extensions::declarative_net_request::flat::HeaderOperation operation = extensions::declarative_net_request::flat::HeaderOperation_append,
    flatbuffers::Offset<flatbuffers::String> header = 0,
    flatbuffers::Offset<flatbuffers::String> value = 0) {
  ModifyHeaderInfoBuilder builder_(_fbb);
  builder_.add_value(value);
  builder_.add_header(header);
  builder_.add_operation(operation);
  return builder_.Finish();
}

inline flatbuffers::Offset<ModifyHeaderInfo> CreateModifyHeaderInfoDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    extensions::declarative_net_request::flat::HeaderOperation operation = extensions::declarative_net_request::flat::HeaderOperation_append,
    const char *header = nullptr,
    const char *value = nullptr) {
  auto header__ = header ? _fbb.CreateString(header) : 0;
  auto value__ = value ? _fbb.CreateString(value) : 0;
  return extensions::declarative_net_request::flat::CreateModifyHeaderInfo(
      _fbb,
      operation,
      header__,
      value__);
}

/// Completely represents a rule with a regex filter.
struct RegexRule FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_URL_RULE = 4,
    VT_ACTION_TYPE = 6,
    VT_REGEX_SUBSTITUTION = 8
  };
  /// The underlying UrlRule.
  const url_pattern_index::flat::UrlRule *url_rule() const {
    return GetPointer<const url_pattern_index::flat::UrlRule *>(VT_URL_RULE);
  }
  /// The action to take.
  extensions::declarative_net_request::flat::ActionType action_type() const {
    return static_cast<extensions::declarative_net_request::flat::ActionType>(GetField<uint8_t>(VT_ACTION_TYPE, 0));
  }
  /// The regex substitution pattern for this rule if specified.
  const flatbuffers::String *regex_substitution() const {
    return GetPointer<const flatbuffers::String *>(VT_REGEX_SUBSTITUTION);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_URL_RULE) &&
           verifier.VerifyTable(url_rule()) &&
           VerifyField<uint8_t>(verifier, VT_ACTION_TYPE) &&
           VerifyOffset(verifier, VT_REGEX_SUBSTITUTION) &&
           verifier.VerifyString(regex_substitution()) &&
           verifier.EndTable();
  }
};

struct RegexRuleBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_url_rule(flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule) {
    fbb_.AddOffset(RegexRule::VT_URL_RULE, url_rule);
  }
  void add_action_type(extensions::declarative_net_request::flat::ActionType action_type) {
    fbb_.AddElement<uint8_t>(RegexRule::VT_ACTION_TYPE, static_cast<uint8_t>(action_type), 0);
  }
  void add_regex_substitution(flatbuffers::Offset<flatbuffers::String> regex_substitution) {
    fbb_.AddOffset(RegexRule::VT_REGEX_SUBSTITUTION, regex_substitution);
  }
  explicit RegexRuleBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  RegexRuleBuilder &operator=(const RegexRuleBuilder &);
  flatbuffers::Offset<RegexRule> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<RegexRule>(end);
    return o;
  }
};

inline flatbuffers::Offset<RegexRule> CreateRegexRule(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule = 0,
    extensions::declarative_net_request::flat::ActionType action_type = extensions::declarative_net_request::flat::ActionType_block,
    flatbuffers::Offset<flatbuffers::String> regex_substitution = 0) {
  RegexRuleBuilder builder_(_fbb);
  builder_.add_regex_substitution(regex_substitution);
  builder_.add_url_rule(url_rule);
  builder_.add_action_type(action_type);
  return builder_.Finish();
}

inline flatbuffers::Offset<RegexRule> CreateRegexRuleDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<url_pattern_index::flat::UrlRule> url_rule = 0,
    extensions::declarative_net_request::flat::ActionType action_type = extensions::declarative_net_request::flat::ActionType_block,
    const char *regex_substitution = nullptr) {
  auto regex_substitution__ = regex_substitution ? _fbb.CreateString(regex_substitution) : 0;
  return extensions::declarative_net_request::flat::CreateRegexRule(
      _fbb,
      url_rule,
      action_type,
      regex_substitution__);
}

/// The top-level data structure used to store extensions URL rules for the
/// Declarative Net Request API.
struct ExtensionIndexedRuleset FLATBUFFERS_FINAL_CLASS : private flatbuffers::Table {
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_INDEX_LIST = 4,
    VT_REGEX_RULES = 6,
    VT_EXTENSION_METADATA = 8
  };
  /// Vector of UrlPatternIndex. This will consist of IndexType_count
  /// indices.
  const flatbuffers::Vector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *index_list() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *>(VT_INDEX_LIST);
  }
  const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *regex_rules() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *>(VT_REGEX_RULES);
  }
  /// Extension related metadata. Sorted by id, to support fast lookup.
  const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *extension_metadata() const {
    return GetPointer<const flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *>(VT_EXTENSION_METADATA);
  }
  bool Verify(flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_INDEX_LIST) &&
           verifier.VerifyVector(index_list()) &&
           verifier.VerifyVectorOfTables(index_list()) &&
           VerifyOffset(verifier, VT_REGEX_RULES) &&
           verifier.VerifyVector(regex_rules()) &&
           verifier.VerifyVectorOfTables(regex_rules()) &&
           VerifyOffset(verifier, VT_EXTENSION_METADATA) &&
           verifier.VerifyVector(extension_metadata()) &&
           verifier.VerifyVectorOfTables(extension_metadata()) &&
           verifier.EndTable();
  }
};

struct ExtensionIndexedRulesetBuilder {
  flatbuffers::FlatBufferBuilder &fbb_;
  flatbuffers::uoffset_t start_;
  void add_index_list(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> index_list) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_INDEX_LIST, index_list);
  }
  void add_regex_rules(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> regex_rules) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_REGEX_RULES, regex_rules);
  }
  void add_extension_metadata(flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>>> extension_metadata) {
    fbb_.AddOffset(ExtensionIndexedRuleset::VT_EXTENSION_METADATA, extension_metadata);
  }
  explicit ExtensionIndexedRulesetBuilder(flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ExtensionIndexedRulesetBuilder &operator=(const ExtensionIndexedRulesetBuilder &);
  flatbuffers::Offset<ExtensionIndexedRuleset> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = flatbuffers::Offset<ExtensionIndexedRuleset>(end);
    return o;
  }
};

inline flatbuffers::Offset<ExtensionIndexedRuleset> CreateExtensionIndexedRuleset(
    flatbuffers::FlatBufferBuilder &_fbb,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>> index_list = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>> regex_rules = 0,
    flatbuffers::Offset<flatbuffers::Vector<flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>>> extension_metadata = 0) {
  ExtensionIndexedRulesetBuilder builder_(_fbb);
  builder_.add_extension_metadata(extension_metadata);
  builder_.add_regex_rules(regex_rules);
  builder_.add_index_list(index_list);
  return builder_.Finish();
}

inline flatbuffers::Offset<ExtensionIndexedRuleset> CreateExtensionIndexedRulesetDirect(
    flatbuffers::FlatBufferBuilder &_fbb,
    const std::vector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>> *index_list = nullptr,
    const std::vector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>> *regex_rules = nullptr,
    std::vector<flatbuffers::Offset<extensions::declarative_net_request::flat::UrlRuleMetadata>> *extension_metadata = nullptr) {
  auto index_list__ = index_list ? _fbb.CreateVector<flatbuffers::Offset<url_pattern_index::flat::UrlPatternIndex>>(*index_list) : 0;
  auto regex_rules__ = regex_rules ? _fbb.CreateVector<flatbuffers::Offset<extensions::declarative_net_request::flat::RegexRule>>(*regex_rules) : 0;
  auto extension_metadata__ = extension_metadata ? _fbb.CreateVectorOfSortedTables<extensions::declarative_net_request::flat::UrlRuleMetadata>(extension_metadata) : 0;
  return extensions::declarative_net_request::flat::CreateExtensionIndexedRuleset(
      _fbb,
      index_list__,
      regex_rules__,
      extension_metadata__);
}

inline const extensions::declarative_net_request::flat::ExtensionIndexedRuleset *GetExtensionIndexedRuleset(const void *buf) {
  return flatbuffers::GetRoot<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(buf);
}

inline const extensions::declarative_net_request::flat::ExtensionIndexedRuleset *GetSizePrefixedExtensionIndexedRuleset(const void *buf) {
  return flatbuffers::GetSizePrefixedRoot<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(buf);
}

inline const char *ExtensionIndexedRulesetIdentifier() {
  return "EXTR";
}

inline bool ExtensionIndexedRulesetBufferHasIdentifier(const void *buf) {
  return flatbuffers::BufferHasIdentifier(
      buf, ExtensionIndexedRulesetIdentifier());
}

inline bool VerifyExtensionIndexedRulesetBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(ExtensionIndexedRulesetIdentifier());
}

inline bool VerifySizePrefixedExtensionIndexedRulesetBuffer(
    flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<extensions::declarative_net_request::flat::ExtensionIndexedRuleset>(ExtensionIndexedRulesetIdentifier());
}

inline void FinishExtensionIndexedRulesetBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<extensions::declarative_net_request::flat::ExtensionIndexedRuleset> root) {
  fbb.Finish(root, ExtensionIndexedRulesetIdentifier());
}

inline void FinishSizePrefixedExtensionIndexedRulesetBuffer(
    flatbuffers::FlatBufferBuilder &fbb,
    flatbuffers::Offset<extensions::declarative_net_request::flat::ExtensionIndexedRuleset> root) {
  fbb.FinishSizePrefixed(root, ExtensionIndexedRulesetIdentifier());
}

}  // namespace flat
}  // namespace declarative_net_request
}  // namespace extensions

#endif  // FLATBUFFERS_GENERATED_EXTENSIONRULESET_EXTENSIONS_DECLARATIVE_NET_REQUEST_FLAT_H_
