// gpu/ipc/common/gpu_preferences.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_H_
#define GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "gpu/ipc/common/gpu_preferences.mojom-shared.h"
#include "gpu/ipc/common/gpu_preferences.mojom-forward.h"
#include "mojo/public/mojom/base/message_pump_type.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include <string>
#include <vector>




#include "gpu/ipc/common/gpu_preferences_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace gpu {
namespace mojom {








class  GpuPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GpuPreferences, T>::value>;
  using DataView = GpuPreferencesDataView;
  using Data_ = internal::GpuPreferences_Data;

  template <typename... Args>
  static GpuPreferencesPtr New(Args&&... args) {
    return GpuPreferencesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GpuPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<GpuPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GpuPreferences>::Convert(*this);
  }


  GpuPreferences();

  GpuPreferences(
      bool disable_accelerated_video_decode,
      bool disable_accelerated_video_encode,
      bool gpu_startup_dialog,
      bool disable_gpu_watchdog,
      bool gpu_sandbox_start_early,
      bool enable_low_latency_dxva,
      bool enable_zero_copy_dxgi_video,
      bool enable_nv12_dxgi_video,
      bool enable_media_foundation_vea_on_windows7,
      bool disable_software_rasterizer,
      bool log_gpu_control_list_decisions,
      bool compile_shader_always_succeeds,
      bool disable_gl_error_limit,
      bool disable_glsl_translator,
      bool disable_shader_name_hashing,
      bool enable_gpu_command_logging,
      bool enable_gpu_debugging,
      bool enable_gpu_service_logging_gpu,
      bool enable_gpu_driver_debug_logging,
      bool disable_gpu_program_cache,
      bool enforce_gl_minimums,
      uint32_t force_gpu_mem_available_bytes,
      uint32_t force_gpu_mem_discardable_limit_bytes,
      uint32_t force_max_texture_size,
      uint32_t gpu_program_cache_size,
      bool disable_gpu_shader_disk_cache,
      bool enable_threaded_texture_mailboxes,
      bool gl_shader_interm_output,
      bool emulate_shader_precision,
      bool enable_android_surface_control,
      bool enable_gpu_service_logging,
      bool enable_gpu_service_tracing,
      bool use_passthrough_cmd_decoder,
      bool disable_biplanar_gpu_memory_buffers_for_video_frames,
      std::vector<::gfx::BufferUsageAndFormat> texture_target_exception_list,
      bool ignore_gpu_blocklist,
      bool enable_oop_rasterization,
      bool disable_oop_rasterization,
      bool enable_oop_rasterization_ddl,
      bool watchdog_starts_backgrounded,
      GrContextType gr_context_type,
      VulkanImplementationName use_vulkan,
      bool enforce_vulkan_protected_memory,
      bool disable_vulkan_surface,
      bool disable_vulkan_fallback_to_gl_for_testing,
      bool enable_metal,
      bool enable_gpu_benchmarking_extension,
      bool enable_webgpu,
      bool enable_dawn_backend_validation,
      bool enable_gpu_blocked_time_metric,
      bool enable_perf_data_collection,
      ::base::MessagePumpType message_pump_type,
      bool enable_native_gpu_memory_buffers);

  ~GpuPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GpuPreferencesPtr>
  GpuPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GpuPreferences::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GpuPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GpuPreferences_UnserializedMessageContext<
            UserType, GpuPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<GpuPreferences::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return GpuPreferences::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GpuPreferences_UnserializedMessageContext<
            UserType, GpuPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GpuPreferences::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool disable_accelerated_video_decode;
  
  bool disable_accelerated_video_encode;
  
  bool gpu_startup_dialog;
  
  bool disable_gpu_watchdog;
  
  bool gpu_sandbox_start_early;
  
  bool enable_low_latency_dxva;
  
  bool enable_zero_copy_dxgi_video;
  
  bool enable_nv12_dxgi_video;
  
  bool enable_media_foundation_vea_on_windows7;
  
  bool disable_software_rasterizer;
  
  bool log_gpu_control_list_decisions;
  
  bool compile_shader_always_succeeds;
  
  bool disable_gl_error_limit;
  
  bool disable_glsl_translator;
  
  bool disable_shader_name_hashing;
  
  bool enable_gpu_command_logging;
  
  bool enable_gpu_debugging;
  
  bool enable_gpu_service_logging_gpu;
  
  bool enable_gpu_driver_debug_logging;
  
  bool disable_gpu_program_cache;
  
  bool enforce_gl_minimums;
  
  uint32_t force_gpu_mem_available_bytes;
  
  uint32_t force_gpu_mem_discardable_limit_bytes;
  
  uint32_t force_max_texture_size;
  
  uint32_t gpu_program_cache_size;
  
  bool disable_gpu_shader_disk_cache;
  
  bool enable_threaded_texture_mailboxes;
  
  bool gl_shader_interm_output;
  
  bool emulate_shader_precision;
  
  bool enable_android_surface_control;
  
  bool enable_gpu_service_logging;
  
  bool enable_gpu_service_tracing;
  
  bool use_passthrough_cmd_decoder;
  
  bool disable_biplanar_gpu_memory_buffers_for_video_frames;
  
  std::vector<::gfx::BufferUsageAndFormat> texture_target_exception_list;
  
  bool ignore_gpu_blocklist;
  
  bool enable_oop_rasterization;
  
  bool disable_oop_rasterization;
  
  bool enable_oop_rasterization_ddl;
  
  bool watchdog_starts_backgrounded;
  
  GrContextType gr_context_type;
  
  VulkanImplementationName use_vulkan;
  
  bool enforce_vulkan_protected_memory;
  
  bool disable_vulkan_surface;
  
  bool disable_vulkan_fallback_to_gl_for_testing;
  
  bool enable_metal;
  
  bool enable_gpu_benchmarking_extension;
  
  bool enable_webgpu;
  
  bool enable_dawn_backend_validation;
  
  bool enable_gpu_blocked_time_metric;
  
  bool enable_perf_data_collection;
  
  ::base::MessagePumpType message_pump_type;
  
  bool enable_native_gpu_memory_buffers;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GpuPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GpuPreferencesPtr GpuPreferences::Clone() const {
  return New(
      mojo::Clone(disable_accelerated_video_decode),
      mojo::Clone(disable_accelerated_video_encode),
      mojo::Clone(gpu_startup_dialog),
      mojo::Clone(disable_gpu_watchdog),
      mojo::Clone(gpu_sandbox_start_early),
      mojo::Clone(enable_low_latency_dxva),
      mojo::Clone(enable_zero_copy_dxgi_video),
      mojo::Clone(enable_nv12_dxgi_video),
      mojo::Clone(enable_media_foundation_vea_on_windows7),
      mojo::Clone(disable_software_rasterizer),
      mojo::Clone(log_gpu_control_list_decisions),
      mojo::Clone(compile_shader_always_succeeds),
      mojo::Clone(disable_gl_error_limit),
      mojo::Clone(disable_glsl_translator),
      mojo::Clone(disable_shader_name_hashing),
      mojo::Clone(enable_gpu_command_logging),
      mojo::Clone(enable_gpu_debugging),
      mojo::Clone(enable_gpu_service_logging_gpu),
      mojo::Clone(enable_gpu_driver_debug_logging),
      mojo::Clone(disable_gpu_program_cache),
      mojo::Clone(enforce_gl_minimums),
      mojo::Clone(force_gpu_mem_available_bytes),
      mojo::Clone(force_gpu_mem_discardable_limit_bytes),
      mojo::Clone(force_max_texture_size),
      mojo::Clone(gpu_program_cache_size),
      mojo::Clone(disable_gpu_shader_disk_cache),
      mojo::Clone(enable_threaded_texture_mailboxes),
      mojo::Clone(gl_shader_interm_output),
      mojo::Clone(emulate_shader_precision),
      mojo::Clone(enable_android_surface_control),
      mojo::Clone(enable_gpu_service_logging),
      mojo::Clone(enable_gpu_service_tracing),
      mojo::Clone(use_passthrough_cmd_decoder),
      mojo::Clone(disable_biplanar_gpu_memory_buffers_for_video_frames),
      mojo::Clone(texture_target_exception_list),
      mojo::Clone(ignore_gpu_blocklist),
      mojo::Clone(enable_oop_rasterization),
      mojo::Clone(disable_oop_rasterization),
      mojo::Clone(enable_oop_rasterization_ddl),
      mojo::Clone(watchdog_starts_backgrounded),
      mojo::Clone(gr_context_type),
      mojo::Clone(use_vulkan),
      mojo::Clone(enforce_vulkan_protected_memory),
      mojo::Clone(disable_vulkan_surface),
      mojo::Clone(disable_vulkan_fallback_to_gl_for_testing),
      mojo::Clone(enable_metal),
      mojo::Clone(enable_gpu_benchmarking_extension),
      mojo::Clone(enable_webgpu),
      mojo::Clone(enable_dawn_backend_validation),
      mojo::Clone(enable_gpu_blocked_time_metric),
      mojo::Clone(enable_perf_data_collection),
      mojo::Clone(message_pump_type),
      mojo::Clone(enable_native_gpu_memory_buffers)
  );
}

template <typename T, GpuPreferences::EnableIfSame<T>*>
bool GpuPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->disable_accelerated_video_decode, other_struct.disable_accelerated_video_decode))
    return false;
  if (!mojo::Equals(this->disable_accelerated_video_encode, other_struct.disable_accelerated_video_encode))
    return false;
  if (!mojo::Equals(this->gpu_startup_dialog, other_struct.gpu_startup_dialog))
    return false;
  if (!mojo::Equals(this->disable_gpu_watchdog, other_struct.disable_gpu_watchdog))
    return false;
  if (!mojo::Equals(this->gpu_sandbox_start_early, other_struct.gpu_sandbox_start_early))
    return false;
  if (!mojo::Equals(this->enable_low_latency_dxva, other_struct.enable_low_latency_dxva))
    return false;
  if (!mojo::Equals(this->enable_zero_copy_dxgi_video, other_struct.enable_zero_copy_dxgi_video))
    return false;
  if (!mojo::Equals(this->enable_nv12_dxgi_video, other_struct.enable_nv12_dxgi_video))
    return false;
  if (!mojo::Equals(this->enable_media_foundation_vea_on_windows7, other_struct.enable_media_foundation_vea_on_windows7))
    return false;
  if (!mojo::Equals(this->disable_software_rasterizer, other_struct.disable_software_rasterizer))
    return false;
  if (!mojo::Equals(this->log_gpu_control_list_decisions, other_struct.log_gpu_control_list_decisions))
    return false;
  if (!mojo::Equals(this->compile_shader_always_succeeds, other_struct.compile_shader_always_succeeds))
    return false;
  if (!mojo::Equals(this->disable_gl_error_limit, other_struct.disable_gl_error_limit))
    return false;
  if (!mojo::Equals(this->disable_glsl_translator, other_struct.disable_glsl_translator))
    return false;
  if (!mojo::Equals(this->disable_shader_name_hashing, other_struct.disable_shader_name_hashing))
    return false;
  if (!mojo::Equals(this->enable_gpu_command_logging, other_struct.enable_gpu_command_logging))
    return false;
  if (!mojo::Equals(this->enable_gpu_debugging, other_struct.enable_gpu_debugging))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_logging_gpu, other_struct.enable_gpu_service_logging_gpu))
    return false;
  if (!mojo::Equals(this->enable_gpu_driver_debug_logging, other_struct.enable_gpu_driver_debug_logging))
    return false;
  if (!mojo::Equals(this->disable_gpu_program_cache, other_struct.disable_gpu_program_cache))
    return false;
  if (!mojo::Equals(this->enforce_gl_minimums, other_struct.enforce_gl_minimums))
    return false;
  if (!mojo::Equals(this->force_gpu_mem_available_bytes, other_struct.force_gpu_mem_available_bytes))
    return false;
  if (!mojo::Equals(this->force_gpu_mem_discardable_limit_bytes, other_struct.force_gpu_mem_discardable_limit_bytes))
    return false;
  if (!mojo::Equals(this->force_max_texture_size, other_struct.force_max_texture_size))
    return false;
  if (!mojo::Equals(this->gpu_program_cache_size, other_struct.gpu_program_cache_size))
    return false;
  if (!mojo::Equals(this->disable_gpu_shader_disk_cache, other_struct.disable_gpu_shader_disk_cache))
    return false;
  if (!mojo::Equals(this->enable_threaded_texture_mailboxes, other_struct.enable_threaded_texture_mailboxes))
    return false;
  if (!mojo::Equals(this->gl_shader_interm_output, other_struct.gl_shader_interm_output))
    return false;
  if (!mojo::Equals(this->emulate_shader_precision, other_struct.emulate_shader_precision))
    return false;
  if (!mojo::Equals(this->enable_android_surface_control, other_struct.enable_android_surface_control))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_logging, other_struct.enable_gpu_service_logging))
    return false;
  if (!mojo::Equals(this->enable_gpu_service_tracing, other_struct.enable_gpu_service_tracing))
    return false;
  if (!mojo::Equals(this->use_passthrough_cmd_decoder, other_struct.use_passthrough_cmd_decoder))
    return false;
  if (!mojo::Equals(this->disable_biplanar_gpu_memory_buffers_for_video_frames, other_struct.disable_biplanar_gpu_memory_buffers_for_video_frames))
    return false;
  if (!mojo::Equals(this->texture_target_exception_list, other_struct.texture_target_exception_list))
    return false;
  if (!mojo::Equals(this->ignore_gpu_blocklist, other_struct.ignore_gpu_blocklist))
    return false;
  if (!mojo::Equals(this->enable_oop_rasterization, other_struct.enable_oop_rasterization))
    return false;
  if (!mojo::Equals(this->disable_oop_rasterization, other_struct.disable_oop_rasterization))
    return false;
  if (!mojo::Equals(this->enable_oop_rasterization_ddl, other_struct.enable_oop_rasterization_ddl))
    return false;
  if (!mojo::Equals(this->watchdog_starts_backgrounded, other_struct.watchdog_starts_backgrounded))
    return false;
  if (!mojo::Equals(this->gr_context_type, other_struct.gr_context_type))
    return false;
  if (!mojo::Equals(this->use_vulkan, other_struct.use_vulkan))
    return false;
  if (!mojo::Equals(this->enforce_vulkan_protected_memory, other_struct.enforce_vulkan_protected_memory))
    return false;
  if (!mojo::Equals(this->disable_vulkan_surface, other_struct.disable_vulkan_surface))
    return false;
  if (!mojo::Equals(this->disable_vulkan_fallback_to_gl_for_testing, other_struct.disable_vulkan_fallback_to_gl_for_testing))
    return false;
  if (!mojo::Equals(this->enable_metal, other_struct.enable_metal))
    return false;
  if (!mojo::Equals(this->enable_gpu_benchmarking_extension, other_struct.enable_gpu_benchmarking_extension))
    return false;
  if (!mojo::Equals(this->enable_webgpu, other_struct.enable_webgpu))
    return false;
  if (!mojo::Equals(this->enable_dawn_backend_validation, other_struct.enable_dawn_backend_validation))
    return false;
  if (!mojo::Equals(this->enable_gpu_blocked_time_metric, other_struct.enable_gpu_blocked_time_metric))
    return false;
  if (!mojo::Equals(this->enable_perf_data_collection, other_struct.enable_perf_data_collection))
    return false;
  if (!mojo::Equals(this->message_pump_type, other_struct.message_pump_type))
    return false;
  if (!mojo::Equals(this->enable_native_gpu_memory_buffers, other_struct.enable_native_gpu_memory_buffers))
    return false;
  return true;
}

template <typename T, GpuPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.disable_accelerated_video_decode, rhs.disable_accelerated_video_decode))
    return true;
  if (std::less<>{}(rhs.disable_accelerated_video_decode, lhs.disable_accelerated_video_decode))
    return false;
  if (std::less<>{}(lhs.disable_accelerated_video_encode, rhs.disable_accelerated_video_encode))
    return true;
  if (std::less<>{}(rhs.disable_accelerated_video_encode, lhs.disable_accelerated_video_encode))
    return false;
  if (std::less<>{}(lhs.gpu_startup_dialog, rhs.gpu_startup_dialog))
    return true;
  if (std::less<>{}(rhs.gpu_startup_dialog, lhs.gpu_startup_dialog))
    return false;
  if (std::less<>{}(lhs.disable_gpu_watchdog, rhs.disable_gpu_watchdog))
    return true;
  if (std::less<>{}(rhs.disable_gpu_watchdog, lhs.disable_gpu_watchdog))
    return false;
  if (std::less<>{}(lhs.gpu_sandbox_start_early, rhs.gpu_sandbox_start_early))
    return true;
  if (std::less<>{}(rhs.gpu_sandbox_start_early, lhs.gpu_sandbox_start_early))
    return false;
  if (std::less<>{}(lhs.enable_low_latency_dxva, rhs.enable_low_latency_dxva))
    return true;
  if (std::less<>{}(rhs.enable_low_latency_dxva, lhs.enable_low_latency_dxva))
    return false;
  if (std::less<>{}(lhs.enable_zero_copy_dxgi_video, rhs.enable_zero_copy_dxgi_video))
    return true;
  if (std::less<>{}(rhs.enable_zero_copy_dxgi_video, lhs.enable_zero_copy_dxgi_video))
    return false;
  if (std::less<>{}(lhs.enable_nv12_dxgi_video, rhs.enable_nv12_dxgi_video))
    return true;
  if (std::less<>{}(rhs.enable_nv12_dxgi_video, lhs.enable_nv12_dxgi_video))
    return false;
  if (std::less<>{}(lhs.enable_media_foundation_vea_on_windows7, rhs.enable_media_foundation_vea_on_windows7))
    return true;
  if (std::less<>{}(rhs.enable_media_foundation_vea_on_windows7, lhs.enable_media_foundation_vea_on_windows7))
    return false;
  if (std::less<>{}(lhs.disable_software_rasterizer, rhs.disable_software_rasterizer))
    return true;
  if (std::less<>{}(rhs.disable_software_rasterizer, lhs.disable_software_rasterizer))
    return false;
  if (std::less<>{}(lhs.log_gpu_control_list_decisions, rhs.log_gpu_control_list_decisions))
    return true;
  if (std::less<>{}(rhs.log_gpu_control_list_decisions, lhs.log_gpu_control_list_decisions))
    return false;
  if (std::less<>{}(lhs.compile_shader_always_succeeds, rhs.compile_shader_always_succeeds))
    return true;
  if (std::less<>{}(rhs.compile_shader_always_succeeds, lhs.compile_shader_always_succeeds))
    return false;
  if (std::less<>{}(lhs.disable_gl_error_limit, rhs.disable_gl_error_limit))
    return true;
  if (std::less<>{}(rhs.disable_gl_error_limit, lhs.disable_gl_error_limit))
    return false;
  if (std::less<>{}(lhs.disable_glsl_translator, rhs.disable_glsl_translator))
    return true;
  if (std::less<>{}(rhs.disable_glsl_translator, lhs.disable_glsl_translator))
    return false;
  if (std::less<>{}(lhs.disable_shader_name_hashing, rhs.disable_shader_name_hashing))
    return true;
  if (std::less<>{}(rhs.disable_shader_name_hashing, lhs.disable_shader_name_hashing))
    return false;
  if (std::less<>{}(lhs.enable_gpu_command_logging, rhs.enable_gpu_command_logging))
    return true;
  if (std::less<>{}(rhs.enable_gpu_command_logging, lhs.enable_gpu_command_logging))
    return false;
  if (std::less<>{}(lhs.enable_gpu_debugging, rhs.enable_gpu_debugging))
    return true;
  if (std::less<>{}(rhs.enable_gpu_debugging, lhs.enable_gpu_debugging))
    return false;
  if (std::less<>{}(lhs.enable_gpu_service_logging_gpu, rhs.enable_gpu_service_logging_gpu))
    return true;
  if (std::less<>{}(rhs.enable_gpu_service_logging_gpu, lhs.enable_gpu_service_logging_gpu))
    return false;
  if (std::less<>{}(lhs.enable_gpu_driver_debug_logging, rhs.enable_gpu_driver_debug_logging))
    return true;
  if (std::less<>{}(rhs.enable_gpu_driver_debug_logging, lhs.enable_gpu_driver_debug_logging))
    return false;
  if (std::less<>{}(lhs.disable_gpu_program_cache, rhs.disable_gpu_program_cache))
    return true;
  if (std::less<>{}(rhs.disable_gpu_program_cache, lhs.disable_gpu_program_cache))
    return false;
  if (std::less<>{}(lhs.enforce_gl_minimums, rhs.enforce_gl_minimums))
    return true;
  if (std::less<>{}(rhs.enforce_gl_minimums, lhs.enforce_gl_minimums))
    return false;
  if (std::less<>{}(lhs.force_gpu_mem_available_bytes, rhs.force_gpu_mem_available_bytes))
    return true;
  if (std::less<>{}(rhs.force_gpu_mem_available_bytes, lhs.force_gpu_mem_available_bytes))
    return false;
  if (std::less<>{}(lhs.force_gpu_mem_discardable_limit_bytes, rhs.force_gpu_mem_discardable_limit_bytes))
    return true;
  if (std::less<>{}(rhs.force_gpu_mem_discardable_limit_bytes, lhs.force_gpu_mem_discardable_limit_bytes))
    return false;
  if (std::less<>{}(lhs.force_max_texture_size, rhs.force_max_texture_size))
    return true;
  if (std::less<>{}(rhs.force_max_texture_size, lhs.force_max_texture_size))
    return false;
  if (std::less<>{}(lhs.gpu_program_cache_size, rhs.gpu_program_cache_size))
    return true;
  if (std::less<>{}(rhs.gpu_program_cache_size, lhs.gpu_program_cache_size))
    return false;
  if (std::less<>{}(lhs.disable_gpu_shader_disk_cache, rhs.disable_gpu_shader_disk_cache))
    return true;
  if (std::less<>{}(rhs.disable_gpu_shader_disk_cache, lhs.disable_gpu_shader_disk_cache))
    return false;
  if (std::less<>{}(lhs.enable_threaded_texture_mailboxes, rhs.enable_threaded_texture_mailboxes))
    return true;
  if (std::less<>{}(rhs.enable_threaded_texture_mailboxes, lhs.enable_threaded_texture_mailboxes))
    return false;
  if (std::less<>{}(lhs.gl_shader_interm_output, rhs.gl_shader_interm_output))
    return true;
  if (std::less<>{}(rhs.gl_shader_interm_output, lhs.gl_shader_interm_output))
    return false;
  if (std::less<>{}(lhs.emulate_shader_precision, rhs.emulate_shader_precision))
    return true;
  if (std::less<>{}(rhs.emulate_shader_precision, lhs.emulate_shader_precision))
    return false;
  if (std::less<>{}(lhs.enable_android_surface_control, rhs.enable_android_surface_control))
    return true;
  if (std::less<>{}(rhs.enable_android_surface_control, lhs.enable_android_surface_control))
    return false;
  if (std::less<>{}(lhs.enable_gpu_service_logging, rhs.enable_gpu_service_logging))
    return true;
  if (std::less<>{}(rhs.enable_gpu_service_logging, lhs.enable_gpu_service_logging))
    return false;
  if (std::less<>{}(lhs.enable_gpu_service_tracing, rhs.enable_gpu_service_tracing))
    return true;
  if (std::less<>{}(rhs.enable_gpu_service_tracing, lhs.enable_gpu_service_tracing))
    return false;
  if (std::less<>{}(lhs.use_passthrough_cmd_decoder, rhs.use_passthrough_cmd_decoder))
    return true;
  if (std::less<>{}(rhs.use_passthrough_cmd_decoder, lhs.use_passthrough_cmd_decoder))
    return false;
  if (std::less<>{}(lhs.disable_biplanar_gpu_memory_buffers_for_video_frames, rhs.disable_biplanar_gpu_memory_buffers_for_video_frames))
    return true;
  if (std::less<>{}(rhs.disable_biplanar_gpu_memory_buffers_for_video_frames, lhs.disable_biplanar_gpu_memory_buffers_for_video_frames))
    return false;
  if (std::less<>{}(lhs.texture_target_exception_list, rhs.texture_target_exception_list))
    return true;
  if (std::less<>{}(rhs.texture_target_exception_list, lhs.texture_target_exception_list))
    return false;
  if (std::less<>{}(lhs.ignore_gpu_blocklist, rhs.ignore_gpu_blocklist))
    return true;
  if (std::less<>{}(rhs.ignore_gpu_blocklist, lhs.ignore_gpu_blocklist))
    return false;
  if (std::less<>{}(lhs.enable_oop_rasterization, rhs.enable_oop_rasterization))
    return true;
  if (std::less<>{}(rhs.enable_oop_rasterization, lhs.enable_oop_rasterization))
    return false;
  if (std::less<>{}(lhs.disable_oop_rasterization, rhs.disable_oop_rasterization))
    return true;
  if (std::less<>{}(rhs.disable_oop_rasterization, lhs.disable_oop_rasterization))
    return false;
  if (std::less<>{}(lhs.enable_oop_rasterization_ddl, rhs.enable_oop_rasterization_ddl))
    return true;
  if (std::less<>{}(rhs.enable_oop_rasterization_ddl, lhs.enable_oop_rasterization_ddl))
    return false;
  if (std::less<>{}(lhs.watchdog_starts_backgrounded, rhs.watchdog_starts_backgrounded))
    return true;
  if (std::less<>{}(rhs.watchdog_starts_backgrounded, lhs.watchdog_starts_backgrounded))
    return false;
  if (std::less<>{}(lhs.gr_context_type, rhs.gr_context_type))
    return true;
  if (std::less<>{}(rhs.gr_context_type, lhs.gr_context_type))
    return false;
  if (std::less<>{}(lhs.use_vulkan, rhs.use_vulkan))
    return true;
  if (std::less<>{}(rhs.use_vulkan, lhs.use_vulkan))
    return false;
  if (std::less<>{}(lhs.enforce_vulkan_protected_memory, rhs.enforce_vulkan_protected_memory))
    return true;
  if (std::less<>{}(rhs.enforce_vulkan_protected_memory, lhs.enforce_vulkan_protected_memory))
    return false;
  if (std::less<>{}(lhs.disable_vulkan_surface, rhs.disable_vulkan_surface))
    return true;
  if (std::less<>{}(rhs.disable_vulkan_surface, lhs.disable_vulkan_surface))
    return false;
  if (std::less<>{}(lhs.disable_vulkan_fallback_to_gl_for_testing, rhs.disable_vulkan_fallback_to_gl_for_testing))
    return true;
  if (std::less<>{}(rhs.disable_vulkan_fallback_to_gl_for_testing, lhs.disable_vulkan_fallback_to_gl_for_testing))
    return false;
  if (std::less<>{}(lhs.enable_metal, rhs.enable_metal))
    return true;
  if (std::less<>{}(rhs.enable_metal, lhs.enable_metal))
    return false;
  if (std::less<>{}(lhs.enable_gpu_benchmarking_extension, rhs.enable_gpu_benchmarking_extension))
    return true;
  if (std::less<>{}(rhs.enable_gpu_benchmarking_extension, lhs.enable_gpu_benchmarking_extension))
    return false;
  if (std::less<>{}(lhs.enable_webgpu, rhs.enable_webgpu))
    return true;
  if (std::less<>{}(rhs.enable_webgpu, lhs.enable_webgpu))
    return false;
  if (std::less<>{}(lhs.enable_dawn_backend_validation, rhs.enable_dawn_backend_validation))
    return true;
  if (std::less<>{}(rhs.enable_dawn_backend_validation, lhs.enable_dawn_backend_validation))
    return false;
  if (std::less<>{}(lhs.enable_gpu_blocked_time_metric, rhs.enable_gpu_blocked_time_metric))
    return true;
  if (std::less<>{}(rhs.enable_gpu_blocked_time_metric, lhs.enable_gpu_blocked_time_metric))
    return false;
  if (std::less<>{}(lhs.enable_perf_data_collection, rhs.enable_perf_data_collection))
    return true;
  if (std::less<>{}(rhs.enable_perf_data_collection, lhs.enable_perf_data_collection))
    return false;
  if (std::less<>{}(lhs.message_pump_type, rhs.message_pump_type))
    return true;
  if (std::less<>{}(rhs.message_pump_type, lhs.message_pump_type))
    return false;
  if (std::less<>{}(lhs.enable_native_gpu_memory_buffers, rhs.enable_native_gpu_memory_buffers))
    return true;
  if (std::less<>{}(rhs.enable_native_gpu_memory_buffers, lhs.enable_native_gpu_memory_buffers))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace gpu

namespace mojo {


template <>
struct  StructTraits<::gpu::mojom::GpuPreferences::DataView,
                                         ::gpu::mojom::GpuPreferencesPtr> {
  static bool IsNull(const ::gpu::mojom::GpuPreferencesPtr& input) { return !input; }
  static void SetToNull(::gpu::mojom::GpuPreferencesPtr* output) { output->reset(); }

  static decltype(::gpu::mojom::GpuPreferences::disable_accelerated_video_decode) disable_accelerated_video_decode(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_accelerated_video_decode;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_accelerated_video_encode) disable_accelerated_video_encode(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_accelerated_video_encode;
  }

  static decltype(::gpu::mojom::GpuPreferences::gpu_startup_dialog) gpu_startup_dialog(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->gpu_startup_dialog;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_gpu_watchdog) disable_gpu_watchdog(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_gpu_watchdog;
  }

  static decltype(::gpu::mojom::GpuPreferences::gpu_sandbox_start_early) gpu_sandbox_start_early(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->gpu_sandbox_start_early;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_low_latency_dxva) enable_low_latency_dxva(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_low_latency_dxva;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_zero_copy_dxgi_video) enable_zero_copy_dxgi_video(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_zero_copy_dxgi_video;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_nv12_dxgi_video) enable_nv12_dxgi_video(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_nv12_dxgi_video;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_media_foundation_vea_on_windows7) enable_media_foundation_vea_on_windows7(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_media_foundation_vea_on_windows7;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_software_rasterizer) disable_software_rasterizer(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_software_rasterizer;
  }

  static decltype(::gpu::mojom::GpuPreferences::log_gpu_control_list_decisions) log_gpu_control_list_decisions(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->log_gpu_control_list_decisions;
  }

  static decltype(::gpu::mojom::GpuPreferences::compile_shader_always_succeeds) compile_shader_always_succeeds(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->compile_shader_always_succeeds;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_gl_error_limit) disable_gl_error_limit(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_gl_error_limit;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_glsl_translator) disable_glsl_translator(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_glsl_translator;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_shader_name_hashing) disable_shader_name_hashing(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_shader_name_hashing;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_command_logging) enable_gpu_command_logging(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_command_logging;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_debugging) enable_gpu_debugging(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_debugging;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_service_logging_gpu) enable_gpu_service_logging_gpu(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_logging_gpu;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_driver_debug_logging) enable_gpu_driver_debug_logging(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_driver_debug_logging;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_gpu_program_cache) disable_gpu_program_cache(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_gpu_program_cache;
  }

  static decltype(::gpu::mojom::GpuPreferences::enforce_gl_minimums) enforce_gl_minimums(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enforce_gl_minimums;
  }

  static decltype(::gpu::mojom::GpuPreferences::force_gpu_mem_available_bytes) force_gpu_mem_available_bytes(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->force_gpu_mem_available_bytes;
  }

  static decltype(::gpu::mojom::GpuPreferences::force_gpu_mem_discardable_limit_bytes) force_gpu_mem_discardable_limit_bytes(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->force_gpu_mem_discardable_limit_bytes;
  }

  static decltype(::gpu::mojom::GpuPreferences::force_max_texture_size) force_max_texture_size(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->force_max_texture_size;
  }

  static decltype(::gpu::mojom::GpuPreferences::gpu_program_cache_size) gpu_program_cache_size(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->gpu_program_cache_size;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_gpu_shader_disk_cache) disable_gpu_shader_disk_cache(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_gpu_shader_disk_cache;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_threaded_texture_mailboxes) enable_threaded_texture_mailboxes(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_threaded_texture_mailboxes;
  }

  static decltype(::gpu::mojom::GpuPreferences::gl_shader_interm_output) gl_shader_interm_output(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->gl_shader_interm_output;
  }

  static decltype(::gpu::mojom::GpuPreferences::emulate_shader_precision) emulate_shader_precision(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->emulate_shader_precision;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_android_surface_control) enable_android_surface_control(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_android_surface_control;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_service_logging) enable_gpu_service_logging(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_logging;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_service_tracing) enable_gpu_service_tracing(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_service_tracing;
  }

  static decltype(::gpu::mojom::GpuPreferences::use_passthrough_cmd_decoder) use_passthrough_cmd_decoder(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->use_passthrough_cmd_decoder;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_biplanar_gpu_memory_buffers_for_video_frames) disable_biplanar_gpu_memory_buffers_for_video_frames(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_biplanar_gpu_memory_buffers_for_video_frames;
  }

  static const decltype(::gpu::mojom::GpuPreferences::texture_target_exception_list)& texture_target_exception_list(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->texture_target_exception_list;
  }

  static decltype(::gpu::mojom::GpuPreferences::ignore_gpu_blocklist) ignore_gpu_blocklist(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->ignore_gpu_blocklist;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_oop_rasterization) enable_oop_rasterization(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_oop_rasterization;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_oop_rasterization) disable_oop_rasterization(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_oop_rasterization;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_oop_rasterization_ddl) enable_oop_rasterization_ddl(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_oop_rasterization_ddl;
  }

  static decltype(::gpu::mojom::GpuPreferences::watchdog_starts_backgrounded) watchdog_starts_backgrounded(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->watchdog_starts_backgrounded;
  }

  static decltype(::gpu::mojom::GpuPreferences::gr_context_type) gr_context_type(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->gr_context_type;
  }

  static decltype(::gpu::mojom::GpuPreferences::use_vulkan) use_vulkan(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->use_vulkan;
  }

  static decltype(::gpu::mojom::GpuPreferences::enforce_vulkan_protected_memory) enforce_vulkan_protected_memory(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enforce_vulkan_protected_memory;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_vulkan_surface) disable_vulkan_surface(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_vulkan_surface;
  }

  static decltype(::gpu::mojom::GpuPreferences::disable_vulkan_fallback_to_gl_for_testing) disable_vulkan_fallback_to_gl_for_testing(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->disable_vulkan_fallback_to_gl_for_testing;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_metal) enable_metal(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_metal;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_benchmarking_extension) enable_gpu_benchmarking_extension(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_benchmarking_extension;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_webgpu) enable_webgpu(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_webgpu;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_dawn_backend_validation) enable_dawn_backend_validation(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_dawn_backend_validation;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_gpu_blocked_time_metric) enable_gpu_blocked_time_metric(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_gpu_blocked_time_metric;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_perf_data_collection) enable_perf_data_collection(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_perf_data_collection;
  }

  static decltype(::gpu::mojom::GpuPreferences::message_pump_type) message_pump_type(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->message_pump_type;
  }

  static decltype(::gpu::mojom::GpuPreferences::enable_native_gpu_memory_buffers) enable_native_gpu_memory_buffers(
      const ::gpu::mojom::GpuPreferencesPtr& input) {
    return input->enable_native_gpu_memory_buffers;
  }

  static bool Read(::gpu::mojom::GpuPreferences::DataView input, ::gpu::mojom::GpuPreferencesPtr* output);
};

}  // namespace mojo

#endif  // GPU_IPC_COMMON_GPU_PREFERENCES_MOJOM_H_