// services/data_decoder/public/mojom/data_decoder_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-shared.h"
#include "services/data_decoder/public/mojom/data_decoder_service.mojom-forward.h"
#include "components/web_package/mojom/web_bundle_parser.mojom.h"
#include "services/data_decoder/public/mojom/image_decoder.mojom.h"
#include "services/data_decoder/public/mojom/json_parser.mojom.h"
#include "services/data_decoder/public/mojom/web_bundler.mojom.h"
#include "services/data_decoder/public/mojom/xml_parser.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace data_decoder {
namespace mojom {

class DataDecoderServiceProxy;

template <typename ImplRefTraits>
class DataDecoderServiceStub;

class DataDecoderServiceRequestValidator;


class  DataDecoderService
    : public DataDecoderServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DataDecoderServiceInterfaceBase;
  using Proxy_ = DataDecoderServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DataDecoderServiceStub<ImplRefTraits>;

  using RequestValidator_ = DataDecoderServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindImageDecoderMinVersion = 0,
    kBindJsonParserMinVersion = 0,
    kBindXmlParserMinVersion = 0,
    kBindWebBundleParserFactoryMinVersion = 0,
    kBindWebBundlerMinVersion = 0,
  };
  virtual ~DataDecoderService() {}

  
  virtual void BindImageDecoder(::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> receiver) = 0;

  
  virtual void BindJsonParser(::mojo::PendingReceiver<::data_decoder::mojom::JsonParser> receiver) = 0;

  
  virtual void BindXmlParser(::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> reciever) = 0;

  
  virtual void BindWebBundleParserFactory(::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> receiver) = 0;

  
  virtual void BindWebBundler(::mojo::PendingReceiver<::data_decoder::mojom::WebBundler> receiver) = 0;
};



class  DataDecoderServiceProxy
    : public DataDecoderService {
 public:
  using InterfaceType = DataDecoderService;

  explicit DataDecoderServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindImageDecoder(::mojo::PendingReceiver<::data_decoder::mojom::ImageDecoder> receiver) final;
  
  void BindJsonParser(::mojo::PendingReceiver<::data_decoder::mojom::JsonParser> receiver) final;
  
  void BindXmlParser(::mojo::PendingReceiver<::data_decoder::mojom::XmlParser> reciever) final;
  
  void BindWebBundleParserFactory(::mojo::PendingReceiver<::web_package::mojom::WebBundleParserFactory> receiver) final;
  
  void BindWebBundler(::mojo::PendingReceiver<::data_decoder::mojom::WebBundler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DataDecoderServiceStubDispatch {
 public:
  static bool Accept(DataDecoderService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DataDecoderService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DataDecoderService>>
class DataDecoderServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DataDecoderServiceStub() {}
  ~DataDecoderServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataDecoderServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DataDecoderServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DataDecoderServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace data_decoder

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_DATA_DECODER_SERVICE_MOJOM_H_