// third_party/blink/public/mojom/devtools/devtools_frontend.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_FRONTEND_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_FRONTEND_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_frontend.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class DevToolsFrontendProxy;

template <typename ImplRefTraits>
class DevToolsFrontendStub;

class DevToolsFrontendRequestValidator;


class BLINK_COMMON_EXPORT DevToolsFrontend
    : public DevToolsFrontendInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DevToolsFrontendInterfaceBase;
  using Proxy_ = DevToolsFrontendProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsFrontendStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsFrontendRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetupDevToolsFrontendMinVersion = 0,
    kSetupDevToolsExtensionAPIMinVersion = 0,
  };
  virtual ~DevToolsFrontend() {}

  
  virtual void SetupDevToolsFrontend(const std::string& api_script, ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> host) = 0;

  
  virtual void SetupDevToolsExtensionAPI(const std::string& extension_api) = 0;
};

class DevToolsFrontendHostProxy;

template <typename ImplRefTraits>
class DevToolsFrontendHostStub;

class DevToolsFrontendHostRequestValidator;


class BLINK_COMMON_EXPORT DevToolsFrontendHost
    : public DevToolsFrontendHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DevToolsFrontendHostInterfaceBase;
  using Proxy_ = DevToolsFrontendHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevToolsFrontendHostStub<ImplRefTraits>;

  using RequestValidator_ = DevToolsFrontendHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchEmbedderMessageMinVersion = 0,
  };
  virtual ~DevToolsFrontendHost() {}

  
  virtual void DispatchEmbedderMessage(const std::string& message) = 0;
};



class BLINK_COMMON_EXPORT DevToolsFrontendProxy
    : public DevToolsFrontend {
 public:
  using InterfaceType = DevToolsFrontend;

  explicit DevToolsFrontendProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetupDevToolsFrontend(const std::string& api_script, ::mojo::PendingAssociatedRemote<DevToolsFrontendHost> host) final;
  
  void SetupDevToolsExtensionAPI(const std::string& extension_api) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT DevToolsFrontendHostProxy
    : public DevToolsFrontendHost {
 public:
  using InterfaceType = DevToolsFrontendHost;

  explicit DevToolsFrontendHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchEmbedderMessage(const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DevToolsFrontendStubDispatch {
 public:
  static bool Accept(DevToolsFrontend* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsFrontend* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsFrontend>>
class DevToolsFrontendStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsFrontendStub() {}
  ~DevToolsFrontendStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsFrontendStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsFrontendStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsFrontendHostStubDispatch {
 public:
  static bool Accept(DevToolsFrontendHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevToolsFrontendHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevToolsFrontendHost>>
class DevToolsFrontendHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevToolsFrontendHostStub() {}
  ~DevToolsFrontendHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsFrontendHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevToolsFrontendHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DevToolsFrontendRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DevToolsFrontendHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_DEVTOOLS_FRONTEND_MOJOM_H_