// third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_handle.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_HANDLE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_HANDLE_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char NativeFileSystemFileHandle::Name_[] = "blink.mojom.NativeFileSystemFileHandle";

class NativeFileSystemFileHandle_GetPermissionStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileHandle_GetPermissionStatus_ForwardToCallback(
      NativeFileSystemFileHandle::GetPermissionStatusCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileHandle::GetPermissionStatusCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_GetPermissionStatus_ForwardToCallback);
};

class NativeFileSystemFileHandle_RequestPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileHandle_RequestPermission_ForwardToCallback(
      NativeFileSystemFileHandle::RequestPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileHandle::RequestPermissionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_RequestPermission_ForwardToCallback);
};

class NativeFileSystemFileHandle_AsBlob_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileHandle_AsBlob_ForwardToCallback(
      NativeFileSystemFileHandle::AsBlobCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileHandle::AsBlobCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_AsBlob_ForwardToCallback);
};

class NativeFileSystemFileHandle_CreateFileWriter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileHandle_CreateFileWriter_ForwardToCallback(
      NativeFileSystemFileHandle::CreateFileWriterCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileHandle::CreateFileWriterCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_CreateFileWriter_ForwardToCallback);
};

class NativeFileSystemFileHandle_IsSameEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileHandle_IsSameEntry_ForwardToCallback(
      NativeFileSystemFileHandle::IsSameEntryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileHandle::IsSameEntryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_IsSameEntry_ForwardToCallback);
};

NativeFileSystemFileHandleProxy::NativeFileSystemFileHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemFileHandleProxy::GetPermissionStatus(
    bool in_writable, GetPermissionStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileHandle::GetPermissionStatus", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("writable", in_writable);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_GetPermissionStatus_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->writable = in_writable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileHandle_GetPermissionStatus_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileHandleProxy::RequestPermission(
    bool in_writable, RequestPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileHandle::RequestPermission", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("writable", in_writable);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_RequestPermission_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->writable = in_writable;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileHandle_RequestPermission_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileHandleProxy::AsBlob(
    AsBlobCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeFileSystemFileHandle::AsBlob");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_AsBlob_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_AsBlob_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileHandle_AsBlob_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileHandleProxy::CreateFileWriter(
    bool in_keep_existing_data, CreateFileWriterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileHandle::CreateFileWriter", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("keep_existing_data", in_keep_existing_data);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_CreateFileWriter_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_CreateFileWriter_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->keep_existing_data = in_keep_existing_data;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileHandle_CreateFileWriter_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileHandleProxy::IsSameEntry(
    ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemTransferToken> in_other, IsSameEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileHandle::IsSameEntry", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("other", in_other.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_IsSameEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_IsSameEntry_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_other, &params->other, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->other),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid other in NativeFileSystemFileHandle.IsSameEntry request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileHandle_IsSameEntry_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileHandleProxy::Transfer(
    ::mojo::PendingReceiver<::blink::mojom::blink::NativeFileSystemTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileHandle::Transfer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("token", in_token.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_Transfer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_Transfer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeFileSystemTransferTokenInterfaceBase>>(
      in_token, &params->token, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in NativeFileSystemFileHandle.Transfer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("Transfer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder {
 public:
  static NativeFileSystemFileHandle::GetPermissionStatusCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder> proxy(
        new NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileHandle::GetPermissionStatusCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder);
};

bool NativeFileSystemFileHandle_GetPermissionStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileHandle::GetPermissionStatusCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileHandle_GetPermissionStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileHandle_GetPermissionStatus_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::PermissionStatus p_status{};
  NativeFileSystemFileHandle_GetPermissionStatus_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileHandle::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder::Run(
    ::blink::mojom::blink::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::GetPermissionStatusCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_GetPermissionStatus_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_GetPermissionStatus_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::GetPermissionStatusCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("GetPermissionStatus");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileHandle_RequestPermission_ProxyToResponder {
 public:
  static NativeFileSystemFileHandle::RequestPermissionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileHandle_RequestPermission_ProxyToResponder> proxy(
        new NativeFileSystemFileHandle_RequestPermission_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileHandle_RequestPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileHandle_RequestPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileHandle_RequestPermission_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileHandle::RequestPermissionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, ::blink::mojom::blink::PermissionStatus in_status);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_RequestPermission_ProxyToResponder);
};

bool NativeFileSystemFileHandle_RequestPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileHandle::RequestPermissionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileHandle_RequestPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileHandle_RequestPermission_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  ::blink::mojom::blink::PermissionStatus p_status{};
  NativeFileSystemFileHandle_RequestPermission_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileHandle::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_status));
  return true;
}

void NativeFileSystemFileHandle_RequestPermission_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, ::blink::mojom::blink::PermissionStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::RequestPermissionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("status", base::trace_event::ValueToString(in_status));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_RequestPermission_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_RequestPermission_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<::blink::mojom::PermissionStatus>(
      in_status, &params->status);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::RequestPermissionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("RequestPermission");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileHandle_AsBlob_ProxyToResponder {
 public:
  static NativeFileSystemFileHandle::AsBlobCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileHandle_AsBlob_ProxyToResponder> proxy(
        new NativeFileSystemFileHandle_AsBlob_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileHandle_AsBlob_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileHandle_AsBlob_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileHandle_AsBlob_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileHandle::AsBlobCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, const ::base::File::Info& in_info, const ::scoped_refptr<::blink::BlobDataHandle>& in_blob);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_AsBlob_ProxyToResponder);
};

bool NativeFileSystemFileHandle_AsBlob_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileHandle::AsBlobCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileHandle_AsBlob_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileHandle_AsBlob_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  ::base::File::Info p_info{};
  ::scoped_refptr<::blink::BlobDataHandle> p_blob{};
  NativeFileSystemFileHandle_AsBlob_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (success && !input_data_view.ReadBlob(&p_blob))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileHandle::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_info), 
std::move(p_blob));
  return true;
}

void NativeFileSystemFileHandle_AsBlob_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, const ::base::File::Info& in_info, const ::scoped_refptr<::blink::BlobDataHandle>& in_blob) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::AsBlobCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("info", base::trace_event::ValueToString(in_info, "<value of type const ::base::File::Info&>"));
      raw_value->SetString("blob", base::trace_event::ValueToString(in_blob, "<value of type const ::scoped_refptr<::blink::BlobDataHandle>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_AsBlob_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_AsBlob_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  typename decltype(params->info)::BaseType::BufferWriter
      info_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
      in_info, buffer, &info_writer, &serialization_context);
  params->info.Set(
      info_writer.is_null() ? nullptr : info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in ");
  typename decltype(params->blob)::BaseType::BufferWriter
      blob_writer;
  mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
      in_blob, buffer, &blob_writer, &serialization_context);
  params->blob.Set(
      blob_writer.is_null() ? nullptr : blob_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::AsBlobCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("AsBlob");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder {
 public:
  static NativeFileSystemFileHandle::CreateFileWriterCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder> proxy(
        new NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileHandle::CreateFileWriterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemFileWriter> in_writer);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder);
};

bool NativeFileSystemFileHandle_CreateFileWriter_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileHandle::CreateFileWriterCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileHandle_CreateFileWriter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileHandle_CreateFileWriter_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemFileWriter> p_writer{};
  NativeFileSystemFileHandle_CreateFileWriter_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_writer =
        input_data_view.TakeWriter<decltype(p_writer)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileHandle::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_writer));
  return true;
}

void NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemFileWriter> in_writer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::CreateFileWriterCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("writer", in_writer.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_CreateFileWriter_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_CreateFileWriter_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NativeFileSystemFileWriterInterfaceBase>>(
      in_writer, &params->writer, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::CreateFileWriterCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("CreateFileWriter");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder {
 public:
  static NativeFileSystemFileHandle::IsSameEntryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder> proxy(
        new NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileHandle::IsSameEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, bool in_is_same);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder);
};

bool NativeFileSystemFileHandle_IsSameEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileHandle::IsSameEntryCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileHandle_IsSameEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileHandle_IsSameEntry_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  bool p_is_same{};
  NativeFileSystemFileHandle_IsSameEntry_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_is_same = input_data_view.is_same();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileHandle::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_is_same));
  return true;
}

void NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, bool in_is_same) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::IsSameEntryCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("is_same", in_is_same);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileHandle_IsSameEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileHandle_IsSameEntry_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->is_same = in_is_same;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileHandle::IsSameEntryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileHandle::Name_);
  message.set_method_name("IsSameEntry");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemFileHandleStubDispatch::Accept(
    NativeFileSystemFileHandle* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemFileHandle_GetPermissionStatus_Name: {
      break;
    }
    case internal::kNativeFileSystemFileHandle_RequestPermission_Name: {
      break;
    }
    case internal::kNativeFileSystemFileHandle_AsBlob_Name: {
      break;
    }
    case internal::kNativeFileSystemFileHandle_CreateFileWriter_Name: {
      break;
    }
    case internal::kNativeFileSystemFileHandle_IsSameEntry_Name: {
      break;
    }
    case internal::kNativeFileSystemFileHandle_Transfer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::Transfer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::Transfer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NativeFileSystemFileHandle_Transfer_Params_Data* params =
          reinterpret_cast<internal::NativeFileSystemFileHandle_Transfer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::blink::NativeFileSystemTransferToken> p_token{};
      NativeFileSystemFileHandle_Transfer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Transfer(
std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool NativeFileSystemFileHandleStubDispatch::AcceptWithResponder(
    NativeFileSystemFileHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemFileHandle_GetPermissionStatus_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::GetPermissionStatus",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::GetPermissionStatus");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileHandle_GetPermissionStatus_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileHandle_GetPermissionStatus_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      NativeFileSystemFileHandle_GetPermissionStatus_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 0, false);
        return false;
      }
      NativeFileSystemFileHandle::GetPermissionStatusCallback callback =
          NativeFileSystemFileHandle_GetPermissionStatus_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPermissionStatus(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileHandle_RequestPermission_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::RequestPermission",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::RequestPermission");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileHandle_RequestPermission_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileHandle_RequestPermission_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_writable{};
      NativeFileSystemFileHandle_RequestPermission_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_writable = input_data_view.writable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 1, false);
        return false;
      }
      NativeFileSystemFileHandle::RequestPermissionCallback callback =
          NativeFileSystemFileHandle_RequestPermission_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPermission(
std::move(p_writable), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileHandle_AsBlob_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::AsBlob",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::AsBlob");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileHandle_AsBlob_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileHandle_AsBlob_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeFileSystemFileHandle_AsBlob_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 2, false);
        return false;
      }
      NativeFileSystemFileHandle::AsBlobCallback callback =
          NativeFileSystemFileHandle_AsBlob_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AsBlob(std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileHandle_CreateFileWriter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::CreateFileWriter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::CreateFileWriter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileHandle_CreateFileWriter_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileHandle_CreateFileWriter_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      bool p_keep_existing_data{};
      NativeFileSystemFileHandle_CreateFileWriter_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_keep_existing_data = input_data_view.keep_existing_data();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 3, false);
        return false;
      }
      NativeFileSystemFileHandle::CreateFileWriterCallback callback =
          NativeFileSystemFileHandle_CreateFileWriter_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFileWriter(
std::move(p_keep_existing_data), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileHandle_IsSameEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileHandle::IsSameEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileHandle::IsSameEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileHandle_IsSameEntry_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileHandle_IsSameEntry_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::NativeFileSystemTransferToken> p_other{};
      NativeFileSystemFileHandle_IsSameEntry_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_other =
            input_data_view.TakeOther<decltype(p_other)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileHandle::Name_, 4, false);
        return false;
      }
      NativeFileSystemFileHandle::IsSameEntryCallback callback =
          NativeFileSystemFileHandle_IsSameEntry_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsSameEntry(
std::move(p_other), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileHandle_Transfer_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemFileHandleValidationInfo[] = {
    {&internal::NativeFileSystemFileHandle_GetPermissionStatus_Params_Data::Validate,
     &internal::NativeFileSystemFileHandle_GetPermissionStatus_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileHandle_RequestPermission_Params_Data::Validate,
     &internal::NativeFileSystemFileHandle_RequestPermission_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileHandle_AsBlob_Params_Data::Validate,
     &internal::NativeFileSystemFileHandle_AsBlob_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileHandle_CreateFileWriter_Params_Data::Validate,
     &internal::NativeFileSystemFileHandle_CreateFileWriter_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileHandle_IsSameEntry_Params_Data::Validate,
     &internal::NativeFileSystemFileHandle_IsSameEntry_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileHandle_Transfer_Params_Data::Validate,
     nullptr /* no response */},
};

bool NativeFileSystemFileHandleRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemFileHandle::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemFileHandleValidationInfo);
}

bool NativeFileSystemFileHandleResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemFileHandle::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeFileSystemFileHandleValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif