// components/spellcheck/common/spellcheck.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace spellcheck::mojom {
namespace internal {
class  SpellChecker_Initialize_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SpellCheckBDictLanguage_Data>>> dictionaries;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> custom_words;
  uint8_t enable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SpellChecker_Initialize_Params_Data>;

  SpellChecker_Initialize_Params_Data();
  ~SpellChecker_Initialize_Params_Data() = delete;
};
static_assert(sizeof(SpellChecker_Initialize_Params_Data) == 32,
              "Bad sizeof(SpellChecker_Initialize_Params_Data)");
class  SpellChecker_CustomDictionaryChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> words_added;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> words_removed;

 private:
  friend class mojo::internal::MessageFragment<SpellChecker_CustomDictionaryChanged_Params_Data>;

  SpellChecker_CustomDictionaryChanged_Params_Data();
  ~SpellChecker_CustomDictionaryChanged_Params_Data() = delete;
};
static_assert(sizeof(SpellChecker_CustomDictionaryChanged_Params_Data) == 24,
              "Bad sizeof(SpellChecker_CustomDictionaryChanged_Params_Data)");
class  SpellCheckInitializationHost_RequestDictionary_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<SpellCheckInitializationHost_RequestDictionary_Params_Data>;

  SpellCheckInitializationHost_RequestDictionary_Params_Data();
  ~SpellCheckInitializationHost_RequestDictionary_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckInitializationHost_RequestDictionary_Params_Data) == 8,
              "Bad sizeof(SpellCheckInitializationHost_RequestDictionary_Params_Data)");
class  SpellCheckHost_NotifyChecked_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> word;
  uint8_t misspelled : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<SpellCheckHost_NotifyChecked_Params_Data>;

  SpellCheckHost_NotifyChecked_Params_Data();
  ~SpellCheckHost_NotifyChecked_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_NotifyChecked_Params_Data) == 24,
              "Bad sizeof(SpellCheckHost_NotifyChecked_Params_Data)");
class  SpellCheckHost_CallSpellingService_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> text;

 private:
  friend class mojo::internal::MessageFragment<SpellCheckHost_CallSpellingService_Params_Data>;

  SpellCheckHost_CallSpellingService_Params_Data();
  ~SpellCheckHost_CallSpellingService_Params_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_CallSpellingService_Params_Data) == 16,
              "Bad sizeof(SpellCheckHost_CallSpellingService_Params_Data)");
class  SpellCheckHost_CallSpellingService_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SpellCheckResult_Data>>> results;

 private:
  friend class mojo::internal::MessageFragment<SpellCheckHost_CallSpellingService_ResponseParams_Data>;

  SpellCheckHost_CallSpellingService_ResponseParams_Data();
  ~SpellCheckHost_CallSpellingService_ResponseParams_Data() = delete;
};
static_assert(sizeof(SpellCheckHost_CallSpellingService_ResponseParams_Data) == 24,
              "Bad sizeof(SpellCheckHost_CallSpellingService_ResponseParams_Data)");

}  // namespace internal


class SpellChecker_Initialize_ParamsDataView {
 public:
  SpellChecker_Initialize_ParamsDataView() = default;

  SpellChecker_Initialize_ParamsDataView(
      internal::SpellChecker_Initialize_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDictionariesDataView(
      mojo::ArrayDataView<SpellCheckBDictLanguageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionaries(UserType* output) {
    
    auto* pointer = data_->dictionaries.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckBDictLanguageDataView>>(
        pointer, output, message_);
  }
  inline void GetCustomWordsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCustomWords(UserType* output) {
    
    auto* pointer = data_->custom_words.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::SpellChecker_Initialize_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellChecker_CustomDictionaryChanged_ParamsDataView {
 public:
  SpellChecker_CustomDictionaryChanged_ParamsDataView() = default;

  SpellChecker_CustomDictionaryChanged_ParamsDataView(
      internal::SpellChecker_CustomDictionaryChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordsAddedDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWordsAdded(UserType* output) {
    
    auto* pointer = data_->words_added.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetWordsRemovedDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWordsRemoved(UserType* output) {
    
    auto* pointer = data_->words_removed.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SpellChecker_CustomDictionaryChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellCheckInitializationHost_RequestDictionary_ParamsDataView {
 public:
  SpellCheckInitializationHost_RequestDictionary_ParamsDataView() = default;

  SpellCheckInitializationHost_RequestDictionary_ParamsDataView(
      internal::SpellCheckInitializationHost_RequestDictionary_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SpellCheckInitializationHost_RequestDictionary_Params_Data* data_ = nullptr;
};


class SpellCheckHost_NotifyChecked_ParamsDataView {
 public:
  SpellCheckHost_NotifyChecked_ParamsDataView() = default;

  SpellCheckHost_NotifyChecked_ParamsDataView(
      internal::SpellCheckHost_NotifyChecked_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWordDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWord(UserType* output) {
    
    auto* pointer = data_->word.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool misspelled() const {
    return data_->misspelled;
  }
 private:
  internal::SpellCheckHost_NotifyChecked_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellCheckHost_CallSpellingService_ParamsDataView {
 public:
  SpellCheckHost_CallSpellingService_ParamsDataView() = default;

  SpellCheckHost_CallSpellingService_ParamsDataView(
      internal::SpellCheckHost_CallSpellingService_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTextDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadText(UserType* output) {
    
    auto* pointer = data_->text.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SpellCheckHost_CallSpellingService_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellCheckHost_CallSpellingService_ResponseParamsDataView {
 public:
  SpellCheckHost_CallSpellingService_ResponseParamsDataView() = default;

  SpellCheckHost_CallSpellingService_ResponseParamsDataView(
      internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetResultsDataView(
      mojo::ArrayDataView<SpellCheckResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::spellcheck::mojom::SpellCheckResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SpellCheckHost_CallSpellingService_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void SpellChecker_Initialize_ParamsDataView::GetDictionariesDataView(
    mojo::ArrayDataView<SpellCheckBDictLanguageDataView>* output) {
  auto pointer = data_->dictionaries.Get();
  *output = mojo::ArrayDataView<SpellCheckBDictLanguageDataView>(pointer, message_);
}
inline void SpellChecker_Initialize_ParamsDataView::GetCustomWordsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->custom_words.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void SpellChecker_CustomDictionaryChanged_ParamsDataView::GetWordsAddedDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->words_added.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void SpellChecker_CustomDictionaryChanged_ParamsDataView::GetWordsRemovedDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->words_removed.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}




inline void SpellCheckHost_NotifyChecked_ParamsDataView::GetWordDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->word.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SpellCheckHost_CallSpellingService_ParamsDataView::GetTextDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->text.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SpellCheckHost_CallSpellingService_ResponseParamsDataView::GetResultsDataView(
    mojo::ArrayDataView<SpellCheckResultDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<SpellCheckResultDataView>(pointer, message_);
}



}  // spellcheck::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_PARAMS_DATA_H_