// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Preload_h
#define content_protocol_Preload_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Preload {
using SpeculationAction = String;
using SpeculationTargetHint = String;
class PreloadingAttemptKey;
using PreloadPipelineId = String;
using PrerenderFinalStatus = String;
using PreloadingStatus = String;
using PrefetchStatus = String;
class PrerenderMismatchedHeaders;

// ------------- Forward and enum declarations.

namespace SpeculationActionEnum {
CONTENT_EXPORT extern const char Prefetch[];
CONTENT_EXPORT extern const char Prerender[];
} // namespace SpeculationActionEnum

namespace SpeculationTargetHintEnum {
CONTENT_EXPORT extern const char Blank[];
CONTENT_EXPORT extern const char Self[];
} // namespace SpeculationTargetHintEnum

namespace PrerenderFinalStatusEnum {
CONTENT_EXPORT extern const char Activated[];
CONTENT_EXPORT extern const char Destroyed[];
CONTENT_EXPORT extern const char LowEndDevice[];
CONTENT_EXPORT extern const char InvalidSchemeRedirect[];
CONTENT_EXPORT extern const char InvalidSchemeNavigation[];
CONTENT_EXPORT extern const char NavigationRequestBlockedByCsp[];
CONTENT_EXPORT extern const char MainFrameNavigation[];
CONTENT_EXPORT extern const char MojoBinderPolicy[];
CONTENT_EXPORT extern const char RendererProcessCrashed[];
CONTENT_EXPORT extern const char RendererProcessKilled[];
CONTENT_EXPORT extern const char Download[];
CONTENT_EXPORT extern const char TriggerDestroyed[];
CONTENT_EXPORT extern const char NavigationNotCommitted[];
CONTENT_EXPORT extern const char NavigationBadHttpStatus[];
CONTENT_EXPORT extern const char ClientCertRequested[];
CONTENT_EXPORT extern const char NavigationRequestNetworkError[];
CONTENT_EXPORT extern const char CancelAllHostsForTesting[];
CONTENT_EXPORT extern const char DidFailLoad[];
CONTENT_EXPORT extern const char Stop[];
CONTENT_EXPORT extern const char SslCertificateError[];
CONTENT_EXPORT extern const char LoginAuthRequested[];
CONTENT_EXPORT extern const char UaChangeRequiresReload[];
CONTENT_EXPORT extern const char BlockedByClient[];
CONTENT_EXPORT extern const char AudioOutputDeviceRequested[];
CONTENT_EXPORT extern const char MixedContent[];
CONTENT_EXPORT extern const char TriggerBackgrounded[];
CONTENT_EXPORT extern const char MemoryLimitExceeded[];
CONTENT_EXPORT extern const char DataSaverEnabled[];
CONTENT_EXPORT extern const char TriggerUrlHasEffectiveUrl[];
CONTENT_EXPORT extern const char ActivatedBeforeStarted[];
CONTENT_EXPORT extern const char InactivePageRestriction[];
CONTENT_EXPORT extern const char StartFailed[];
CONTENT_EXPORT extern const char TimeoutBackgrounded[];
CONTENT_EXPORT extern const char CrossSiteRedirectInInitialNavigation[];
CONTENT_EXPORT extern const char CrossSiteNavigationInInitialNavigation[];
CONTENT_EXPORT extern const char SameSiteCrossOriginRedirectNotOptInInInitialNavigation[];
CONTENT_EXPORT extern const char SameSiteCrossOriginNavigationNotOptInInInitialNavigation[];
CONTENT_EXPORT extern const char ActivationNavigationParameterMismatch[];
CONTENT_EXPORT extern const char ActivatedInBackground[];
CONTENT_EXPORT extern const char EmbedderHostDisallowed[];
CONTENT_EXPORT extern const char ActivationNavigationDestroyedBeforeSuccess[];
CONTENT_EXPORT extern const char TabClosedByUserGesture[];
CONTENT_EXPORT extern const char TabClosedWithoutUserGesture[];
CONTENT_EXPORT extern const char PrimaryMainFrameRendererProcessCrashed[];
CONTENT_EXPORT extern const char PrimaryMainFrameRendererProcessKilled[];
CONTENT_EXPORT extern const char ActivationFramePolicyNotCompatible[];
CONTENT_EXPORT extern const char PreloadingDisabled[];
CONTENT_EXPORT extern const char BatterySaverEnabled[];
CONTENT_EXPORT extern const char ActivatedDuringMainFrameNavigation[];
CONTENT_EXPORT extern const char PreloadingUnsupportedByWebContents[];
CONTENT_EXPORT extern const char CrossSiteRedirectInMainFrameNavigation[];
CONTENT_EXPORT extern const char CrossSiteNavigationInMainFrameNavigation[];
CONTENT_EXPORT extern const char SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation[];
CONTENT_EXPORT extern const char SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation[];
CONTENT_EXPORT extern const char MemoryPressureOnTrigger[];
CONTENT_EXPORT extern const char MemoryPressureAfterTriggered[];
CONTENT_EXPORT extern const char PrerenderingDisabledByDevTools[];
CONTENT_EXPORT extern const char SpeculationRuleRemoved[];
CONTENT_EXPORT extern const char ActivatedWithAuxiliaryBrowsingContexts[];
CONTENT_EXPORT extern const char MaxNumOfRunningEagerPrerendersExceeded[];
CONTENT_EXPORT extern const char MaxNumOfRunningNonEagerPrerendersExceeded[];
CONTENT_EXPORT extern const char MaxNumOfRunningEmbedderPrerendersExceeded[];
CONTENT_EXPORT extern const char PrerenderingUrlHasEffectiveUrl[];
CONTENT_EXPORT extern const char RedirectedPrerenderingUrlHasEffectiveUrl[];
CONTENT_EXPORT extern const char ActivationUrlHasEffectiveUrl[];
CONTENT_EXPORT extern const char JavaScriptInterfaceAdded[];
CONTENT_EXPORT extern const char JavaScriptInterfaceRemoved[];
CONTENT_EXPORT extern const char AllPrerenderingCanceled[];
CONTENT_EXPORT extern const char WindowClosed[];
CONTENT_EXPORT extern const char SlowNetwork[];
CONTENT_EXPORT extern const char OtherPrerenderedPageActivated[];
CONTENT_EXPORT extern const char V8OptimizerDisabled[];
CONTENT_EXPORT extern const char PrerenderFailedDuringPrefetch[];
} // namespace PrerenderFinalStatusEnum

namespace PreloadingStatusEnum {
CONTENT_EXPORT extern const char Pending[];
CONTENT_EXPORT extern const char Running[];
CONTENT_EXPORT extern const char Ready[];
CONTENT_EXPORT extern const char Success[];
CONTENT_EXPORT extern const char Failure[];
CONTENT_EXPORT extern const char NotSupported[];
} // namespace PreloadingStatusEnum

namespace PrefetchStatusEnum {
CONTENT_EXPORT extern const char PrefetchAllowed[];
CONTENT_EXPORT extern const char PrefetchFailedIneligibleRedirect[];
CONTENT_EXPORT extern const char PrefetchFailedInvalidRedirect[];
CONTENT_EXPORT extern const char PrefetchFailedMIMENotSupported[];
CONTENT_EXPORT extern const char PrefetchFailedNetError[];
CONTENT_EXPORT extern const char PrefetchFailedNon2XX[];
CONTENT_EXPORT extern const char PrefetchEvictedAfterCandidateRemoved[];
CONTENT_EXPORT extern const char PrefetchEvictedForNewerPrefetch[];
CONTENT_EXPORT extern const char PrefetchHeldback[];
CONTENT_EXPORT extern const char PrefetchIneligibleRetryAfter[];
CONTENT_EXPORT extern const char PrefetchIsPrivacyDecoy[];
CONTENT_EXPORT extern const char PrefetchIsStale[];
CONTENT_EXPORT extern const char PrefetchNotEligibleBrowserContextOffTheRecord[];
CONTENT_EXPORT extern const char PrefetchNotEligibleDataSaverEnabled[];
CONTENT_EXPORT extern const char PrefetchNotEligibleExistingProxy[];
CONTENT_EXPORT extern const char PrefetchNotEligibleHostIsNonUnique[];
CONTENT_EXPORT extern const char PrefetchNotEligibleNonDefaultStoragePartition[];
CONTENT_EXPORT extern const char PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy[];
CONTENT_EXPORT extern const char PrefetchNotEligibleSchemeIsNotHttps[];
CONTENT_EXPORT extern const char PrefetchNotEligibleUserHasCookies[];
CONTENT_EXPORT extern const char PrefetchNotEligibleUserHasServiceWorker[];
CONTENT_EXPORT extern const char PrefetchNotEligibleBatterySaverEnabled[];
CONTENT_EXPORT extern const char PrefetchNotEligiblePreloadingDisabled[];
CONTENT_EXPORT extern const char PrefetchNotFinishedInTime[];
CONTENT_EXPORT extern const char PrefetchNotStarted[];
CONTENT_EXPORT extern const char PrefetchNotUsedCookiesChanged[];
CONTENT_EXPORT extern const char PrefetchProxyNotAvailable[];
CONTENT_EXPORT extern const char PrefetchResponseUsed[];
CONTENT_EXPORT extern const char PrefetchSuccessfulButNotUsed[];
CONTENT_EXPORT extern const char PrefetchNotUsedProbeFailed[];
} // namespace PrefetchStatusEnum

// ------------- Type and builder declarations.

class CONTENT_EXPORT PreloadingAttemptKey : public ::crdtp::ProtocolObject<PreloadingAttemptKey> {
public:
    ~PreloadingAttemptKey() override { }

    String GetLoaderId() { return m_loaderId; }
    void SetLoaderId(const String& value) { m_loaderId = value; }

    String GetAction() { return m_action; }
    void SetAction(const String& value) { m_action = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    bool HasTargetHint() { return !!m_targetHint; }
    String GetTargetHint(const String& defaultValue) const {
       return m_targetHint.value_or(defaultValue);
    }
    const std::optional<String>& GetTargetHint() const {
       return m_targetHint;
    }
    void SetTargetHint(const String& value) { m_targetHint = value; }

    template<int STATE>
    class PreloadingAttemptKeyBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LoaderIdSet = 1 << 1,
            ActionSet = 1 << 2,
            UrlSet = 1 << 3,
            AllFieldsSet = (LoaderIdSet | ActionSet | UrlSet | 0)};


        PreloadingAttemptKeyBuilder<STATE | LoaderIdSet>& SetLoaderId(const String& value)
        {
            static_assert(!(STATE & LoaderIdSet), "property loaderId should not be set yet");
            m_result->SetLoaderId(value);
            return castState<LoaderIdSet>();
        }

        PreloadingAttemptKeyBuilder<STATE | ActionSet>& SetAction(const String& value)
        {
            static_assert(!(STATE & ActionSet), "property action should not be set yet");
            m_result->SetAction(value);
            return castState<ActionSet>();
        }

        PreloadingAttemptKeyBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        PreloadingAttemptKeyBuilder<STATE>& SetTargetHint(const String& value)
        {
            m_result->SetTargetHint(value);
            return *this;
        }

        std::unique_ptr<PreloadingAttemptKey> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PreloadingAttemptKey;
        PreloadingAttemptKeyBuilder() : m_result(new PreloadingAttemptKey()) { }

        template<int STEP> PreloadingAttemptKeyBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PreloadingAttemptKeyBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::PreloadingAttemptKey> m_result;
    };

    static PreloadingAttemptKeyBuilder<0> Create()
    {
        return PreloadingAttemptKeyBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PreloadingAttemptKey()
    {
    }

    String m_loaderId;
    String m_action;
    String m_url;
    std::optional<String> m_targetHint;
};


class CONTENT_EXPORT PrerenderMismatchedHeaders : public ::crdtp::ProtocolObject<PrerenderMismatchedHeaders> {
public:
    ~PrerenderMismatchedHeaders() override { }

    String GetHeaderName() { return m_headerName; }
    void SetHeaderName(const String& value) { m_headerName = value; }

    bool HasInitialValue() { return !!m_initialValue; }
    String GetInitialValue(const String& defaultValue) const {
       return m_initialValue.value_or(defaultValue);
    }
    const std::optional<String>& GetInitialValue() const {
       return m_initialValue;
    }
    void SetInitialValue(const String& value) { m_initialValue = value; }

    bool HasActivationValue() { return !!m_activationValue; }
    String GetActivationValue(const String& defaultValue) const {
       return m_activationValue.value_or(defaultValue);
    }
    const std::optional<String>& GetActivationValue() const {
       return m_activationValue;
    }
    void SetActivationValue(const String& value) { m_activationValue = value; }

    template<int STATE>
    class PrerenderMismatchedHeadersBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HeaderNameSet = 1 << 1,
            AllFieldsSet = (HeaderNameSet | 0)};


        PrerenderMismatchedHeadersBuilder<STATE | HeaderNameSet>& SetHeaderName(const String& value)
        {
            static_assert(!(STATE & HeaderNameSet), "property headerName should not be set yet");
            m_result->SetHeaderName(value);
            return castState<HeaderNameSet>();
        }

        PrerenderMismatchedHeadersBuilder<STATE>& SetInitialValue(const String& value)
        {
            m_result->SetInitialValue(value);
            return *this;
        }

        PrerenderMismatchedHeadersBuilder<STATE>& SetActivationValue(const String& value)
        {
            m_result->SetActivationValue(value);
            return *this;
        }

        std::unique_ptr<PrerenderMismatchedHeaders> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PrerenderMismatchedHeaders;
        PrerenderMismatchedHeadersBuilder() : m_result(new PrerenderMismatchedHeaders()) { }

        template<int STEP> PrerenderMismatchedHeadersBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PrerenderMismatchedHeadersBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Preload::PrerenderMismatchedHeaders> m_result;
    };

    static PrerenderMismatchedHeadersBuilder<0> Create()
    {
        return PrerenderMismatchedHeadersBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PrerenderMismatchedHeaders()
    {
    }

    String m_headerName;
    std::optional<String> m_initialValue;
    std::optional<String> m_activationValue;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse Enable() = 0;
    virtual DispatchResponse Disable() = 0;

};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void PreloadEnabledStateUpdated(bool disabledByPreference, bool disabledByDataSaver, bool disabledByBatterySaver, bool disabledByHoldbackPrefetchSpeculationRules, bool disabledByHoldbackPrerenderSpeculationRules);
    void PrefetchStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& initiatingFrameId, const String& prefetchUrl, const String& status, const String& prefetchStatus, const String& requestId);
    void PrerenderStatusUpdated(std::unique_ptr<protocol::Preload::PreloadingAttemptKey> key, const String& pipelineId, const String& status, std::optional<String> prerenderStatus = {}, std::optional<String> disallowedMojoInterface = {}, std::unique_ptr<protocol::Array<protocol::Preload::PrerenderMismatchedHeaders>> mismatchedHeaders = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Preload
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Preload_h)
