// device/vr/public/mojom/xr_device.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/xr_device.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "device/vr/public/mojom/xr_device.mojom-params-data.h"
namespace device {
namespace mojom {

NOINLINE static const char* XRDeviceIdToStringHelper(XRDeviceId value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case XRDeviceId::WEB_TEST_DEVICE_ID:
      return "WEB_TEST_DEVICE_ID";
    case XRDeviceId::FAKE_DEVICE_ID:
      return "FAKE_DEVICE_ID";
    case XRDeviceId::ORIENTATION_DEVICE_ID:
      return "ORIENTATION_DEVICE_ID";
    default:
      return nullptr;
  }
}

std::string XRDeviceIdToString(XRDeviceId value) {
  const char *str = XRDeviceIdToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown XRDeviceId value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, XRDeviceId value) {
  return os << XRDeviceIdToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace device

namespace perfetto {

// static
void TraceFormatTraits<::device::mojom::XRDeviceId>::WriteIntoTrace(
   perfetto::TracedValue context, ::device::mojom::XRDeviceId value) {
  return std::move(context).WriteString(::device::mojom::XRDeviceIdToString(value));
}

} // namespace perfetto