// extensions/common/mojom/renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/mojom/renderer.mojom-shared-internal.h"
#include "extensions/common/mojom/api_permission_id.mojom-shared.h"
#include "extensions/common/mojom/channel.mojom-shared.h"
#include "extensions/common/mojom/feature_session_type.mojom-shared.h"
#include "extensions/common/mojom/host_id.mojom-shared.h"
#include "extensions/common/mojom/manifest.mojom-shared.h"
#include "extensions/common/mojom/permission_set.mojom-shared.h"
#include "extensions/common/mojom/url_pattern_set.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace extensions::mojom {
class ExtensionLoadedParamsDataView;

class UserScriptWorldInfoDataView;



}  // extensions::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mojom::ExtensionLoadedParamsDataView> {
  using Data = ::extensions::mojom::internal::ExtensionLoadedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mojom::UserScriptWorldInfoDataView> {
  using Data = ::extensions::mojom::internal::UserScriptWorldInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mojom {
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;


class ExtensionLoadedParamsDataView {
 public:
  ExtensionLoadedParamsDataView() = default;

  ExtensionLoadedParamsDataView(
      internal::ExtensionLoadedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetManifestDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManifest(UserType* output) {
    
    auto* pointer = data_->manifest.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) const {
    auto data_value = data_->location;
    return mojo::internal::Deserialize<::extensions::mojom::ManifestLocation>(
        data_value, output);
  }
  ::extensions::mojom::ManifestLocation location() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::extensions::mojom::ManifestLocation>(data_->location));
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetActivePermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActivePermissions(UserType* output) {
    
    auto* pointer = data_->active_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetWithheldPermissionsDataView(
      ::extensions::mojom::PermissionSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWithheldPermissions(UserType* output) {
    
    auto* pointer = data_->withheld_permissions.Get();
    return mojo::internal::Deserialize<::extensions::mojom::PermissionSetDataView>(
        pointer, output, message_);
  }
  inline void GetTabSpecificPermissionsDataView(
      mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabSpecificPermissions(UserType* output) {
    
    auto* pointer = data_->tab_specific_permissions.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>>(
        pointer, output, message_);
  }
  inline void GetPolicyBlockedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyBlockedHosts(UserType* output) {
    
    auto* pointer = data_->policy_blocked_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  inline void GetPolicyAllowedHostsDataView(
      ::extensions::mojom::URLPatternSetDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPolicyAllowedHosts(UserType* output) {
    
    auto* pointer = data_->policy_allowed_hosts.Get();
    return mojo::internal::Deserialize<::extensions::mojom::URLPatternSetDataView>(
        pointer, output, message_);
  }
  bool uses_default_policy_blocked_allowed_hosts() const {
    return data_->uses_default_policy_blocked_allowed_hosts;
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetWorkerActivationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorkerActivationToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `worker_activation_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorkerActivationToken` instead "
    "of `ReadWorkerActivationToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->worker_activation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t creation_flags() const {
    return data_->creation_flags;
  }
  inline void GetGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ExtensionLoadedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UserScriptWorldInfoDataView {
 public:
  UserScriptWorldInfoDataView() = default;

  UserScriptWorldInfoDataView(
      internal::UserScriptWorldInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionId(UserType* output) {
    
    auto* pointer = data_->extension_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetWorldIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWorldId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `world_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWorldId` instead "
    "of `ReadWorldId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->world_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCspDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCsp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `csp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCsp` instead "
    "of `ReadCsp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->csp.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enable_messaging() const {
    return data_->enable_messaging;
  }
 private:
  internal::UserScriptWorldInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // extensions::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::ExtensionLoadedParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::ExtensionLoadedParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::ExtensionLoadedParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::manifest(input)) in_manifest = Traits::manifest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manifest)::BaseType> manifest_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
        in_manifest, manifest_fragment);
    fragment->manifest.Set(
        manifest_fragment.is_null() ? nullptr : manifest_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->manifest.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null manifest in ExtensionLoadedParams struct");
    mojo::internal::Serialize<::extensions::mojom::ManifestLocation>(
        Traits::location(input), &fragment->location);
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in ExtensionLoadedParams struct");
    decltype(Traits::active_permissions(input)) in_active_permissions = Traits::active_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->active_permissions)::BaseType> active_permissions_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
        in_active_permissions, active_permissions_fragment);
    fragment->active_permissions.Set(
        active_permissions_fragment.is_null() ? nullptr : active_permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->active_permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null active_permissions in ExtensionLoadedParams struct");
    decltype(Traits::withheld_permissions(input)) in_withheld_permissions = Traits::withheld_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->withheld_permissions)::BaseType> withheld_permissions_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::PermissionSetDataView>(
        in_withheld_permissions, withheld_permissions_fragment);
    fragment->withheld_permissions.Set(
        withheld_permissions_fragment.is_null() ? nullptr : withheld_permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->withheld_permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null withheld_permissions in ExtensionLoadedParams struct");
    decltype(Traits::tab_specific_permissions(input)) in_tab_specific_permissions = Traits::tab_specific_permissions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_specific_permissions)::BaseType>
        tab_specific_permissions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tab_specific_permissions_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>>(
        in_tab_specific_permissions, tab_specific_permissions_fragment, &tab_specific_permissions_validate_params);
    fragment->tab_specific_permissions.Set(
        tab_specific_permissions_fragment.is_null() ? nullptr : tab_specific_permissions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tab_specific_permissions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tab_specific_permissions in ExtensionLoadedParams struct");
    decltype(Traits::policy_blocked_hosts(input)) in_policy_blocked_hosts = Traits::policy_blocked_hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_blocked_hosts)::BaseType> policy_blocked_hosts_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
        in_policy_blocked_hosts, policy_blocked_hosts_fragment);
    fragment->policy_blocked_hosts.Set(
        policy_blocked_hosts_fragment.is_null() ? nullptr : policy_blocked_hosts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->policy_blocked_hosts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null policy_blocked_hosts in ExtensionLoadedParams struct");
    decltype(Traits::policy_allowed_hosts(input)) in_policy_allowed_hosts = Traits::policy_allowed_hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->policy_allowed_hosts)::BaseType> policy_allowed_hosts_fragment(
            fragment.message());
    mojo::internal::Serialize<::extensions::mojom::URLPatternSetDataView>(
        in_policy_allowed_hosts, policy_allowed_hosts_fragment);
    fragment->policy_allowed_hosts.Set(
        policy_allowed_hosts_fragment.is_null() ? nullptr : policy_allowed_hosts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->policy_allowed_hosts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null policy_allowed_hosts in ExtensionLoadedParams struct");
    fragment->uses_default_policy_blocked_allowed_hosts = Traits::uses_default_policy_blocked_allowed_hosts(input);
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ExtensionLoadedParams struct");
    decltype(Traits::worker_activation_token(input)) in_worker_activation_token = Traits::worker_activation_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->worker_activation_token)::BaseType> worker_activation_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_worker_activation_token, worker_activation_token_fragment);
    fragment->worker_activation_token.Set(
        worker_activation_token_fragment.is_null() ? nullptr : worker_activation_token_fragment.data());
    fragment->creation_flags = Traits::creation_flags(input);
    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_guid, guid_fragment);
    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->guid.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in ExtensionLoadedParams struct");
  }

  static bool Deserialize(::extensions::mojom::internal::ExtensionLoadedParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::ExtensionLoadedParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mojom::UserScriptWorldInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mojom::UserScriptWorldInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mojom::internal::UserScriptWorldInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::extension_id(input)) in_extension_id = Traits::extension_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extension_id)::BaseType> extension_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extension_id, extension_id_fragment);
    fragment->extension_id.Set(
        extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extension_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extension_id in UserScriptWorldInfo struct");
    decltype(Traits::world_id(input)) in_world_id = Traits::world_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->world_id)::BaseType> world_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_world_id, world_id_fragment);
    fragment->world_id.Set(
        world_id_fragment.is_null() ? nullptr : world_id_fragment.data());
    decltype(Traits::csp(input)) in_csp = Traits::csp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->csp)::BaseType> csp_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_csp, csp_fragment);
    fragment->csp.Set(
        csp_fragment.is_null() ? nullptr : csp_fragment.data());
    fragment->enable_messaging = Traits::enable_messaging(input);
  }

  static bool Deserialize(::extensions::mojom::internal::UserScriptWorldInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mojom::UserScriptWorldInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mojom {

inline void ExtensionLoadedParamsDataView::GetManifestDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->manifest.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetActivePermissionsDataView(
    ::extensions::mojom::PermissionSetDataView* output) {
  auto pointer = data_->active_permissions.Get();
  *output = ::extensions::mojom::PermissionSetDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetWithheldPermissionsDataView(
    ::extensions::mojom::PermissionSetDataView* output) {
  auto pointer = data_->withheld_permissions.Get();
  *output = ::extensions::mojom::PermissionSetDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetTabSpecificPermissionsDataView(
    mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>* output) {
  auto pointer = data_->tab_specific_permissions.Get();
  *output = mojo::MapDataView<int32_t, ::extensions::mojom::PermissionSetDataView>(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetPolicyBlockedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->policy_blocked_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetPolicyAllowedHostsDataView(
    ::extensions::mojom::URLPatternSetDataView* output) {
  auto pointer = data_->policy_allowed_hosts.Get();
  *output = ::extensions::mojom::URLPatternSetDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetWorkerActivationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->worker_activation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void ExtensionLoadedParamsDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void UserScriptWorldInfoDataView::GetExtensionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extension_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserScriptWorldInfoDataView::GetWorldIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->world_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UserScriptWorldInfoDataView::GetCspDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->csp.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // extensions::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_MOJOM_RENDERER_MOJOM_SHARED_H_