// gpu/ipc/common/vulkan_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_
#define GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "gpu/ipc/common/vulkan_types.mojom-shared-internal.h"



#include "base/component_export.h"




namespace gpu::mojom {
class VkExtensionPropertiesDataView;

class VkLayerPropertiesDataView;

class VkPhysicalDeviceLimitsDataView;

class VkPhysicalDeviceSparsePropertiesDataView;

class VkPhysicalDevicePropertiesDataView;

class VkPhysicalDeviceFeaturesDataView;

class VkExtent3DDataView;

class VkQueueFamilyPropertiesDataView;



}  // gpu::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtensionPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkExtensionProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkLayerPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkLayerProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceLimits_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView> {
  using Data = ::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkExtent3DDataView> {
  using Data = ::gpu::mojom::internal::VkExtent3D_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView> {
  using Data = ::gpu::mojom::internal::VkQueueFamilyProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gpu::mojom {


enum class VkPhysicalDeviceType : int32_t {
  
  OTHER = 0,
  
  INTEGRATED_GPU = 1,
  
  DISCRETE_GPU = 2,
  
  VIRTUAL_GPU = 3,
  
  CPU = 4,
  
  INVALID_VALUE = -1,
  kMinValue = -1,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) std::ostream& operator<<(std::ostream& os, VkPhysicalDeviceType value);
inline bool IsKnownEnumValue(VkPhysicalDeviceType value) {
  return internal::VkPhysicalDeviceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class VkExtensionPropertiesDataView {
 public:
  VkExtensionPropertiesDataView() = default;

  VkExtensionPropertiesDataView(
      internal::VkExtensionProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExtensionNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtensionName(UserType* output) {
    
    auto* pointer = data_->extensionName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
 private:
  internal::VkExtensionProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkLayerPropertiesDataView {
 public:
  VkLayerPropertiesDataView() = default;

  VkLayerPropertiesDataView(
      internal::VkLayerProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLayerNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayerName(UserType* output) {
    
    auto* pointer = data_->layerName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t specVersion() const {
    return data_->specVersion;
  }
  uint32_t implementationVersion() const {
    return data_->implementationVersion;
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkLayerProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceLimitsDataView {
 public:
  VkPhysicalDeviceLimitsDataView() = default;

  VkPhysicalDeviceLimitsDataView(
      internal::VkPhysicalDeviceLimits_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t maxImageDimension1D() const {
    return data_->maxImageDimension1D;
  }
  uint32_t maxImageDimension2D() const {
    return data_->maxImageDimension2D;
  }
  uint32_t maxImageDimension3D() const {
    return data_->maxImageDimension3D;
  }
  uint32_t maxImageDimensionCube() const {
    return data_->maxImageDimensionCube;
  }
  uint32_t maxImageArrayLayers() const {
    return data_->maxImageArrayLayers;
  }
  uint32_t maxTexelBufferElements() const {
    return data_->maxTexelBufferElements;
  }
  uint32_t maxUniformBufferRange() const {
    return data_->maxUniformBufferRange;
  }
  uint32_t maxStorageBufferRange() const {
    return data_->maxStorageBufferRange;
  }
  uint32_t maxPushConstantsSize() const {
    return data_->maxPushConstantsSize;
  }
  uint32_t maxMemoryAllocationCount() const {
    return data_->maxMemoryAllocationCount;
  }
  uint32_t maxSamplerAllocationCount() const {
    return data_->maxSamplerAllocationCount;
  }
  uint64_t bufferImageGranularity() const {
    return data_->bufferImageGranularity;
  }
  uint64_t sparseAddressSpaceSize() const {
    return data_->sparseAddressSpaceSize;
  }
  uint32_t maxBoundDescriptorSets() const {
    return data_->maxBoundDescriptorSets;
  }
  uint32_t maxPerStageDescriptorSamplers() const {
    return data_->maxPerStageDescriptorSamplers;
  }
  uint32_t maxPerStageDescriptorUniformBuffers() const {
    return data_->maxPerStageDescriptorUniformBuffers;
  }
  uint32_t maxPerStageDescriptorStorageBuffers() const {
    return data_->maxPerStageDescriptorStorageBuffers;
  }
  uint32_t maxPerStageDescriptorSampledImages() const {
    return data_->maxPerStageDescriptorSampledImages;
  }
  uint32_t maxPerStageDescriptorStorageImages() const {
    return data_->maxPerStageDescriptorStorageImages;
  }
  uint32_t maxPerStageDescriptorInputAttachments() const {
    return data_->maxPerStageDescriptorInputAttachments;
  }
  uint32_t maxPerStageResources() const {
    return data_->maxPerStageResources;
  }
  uint32_t maxDescriptorSetSamplers() const {
    return data_->maxDescriptorSetSamplers;
  }
  uint32_t maxDescriptorSetUniformBuffers() const {
    return data_->maxDescriptorSetUniformBuffers;
  }
  uint32_t maxDescriptorSetUniformBuffersDynamic() const {
    return data_->maxDescriptorSetUniformBuffersDynamic;
  }
  uint32_t maxDescriptorSetStorageBuffers() const {
    return data_->maxDescriptorSetStorageBuffers;
  }
  uint32_t maxDescriptorSetStorageBuffersDynamic() const {
    return data_->maxDescriptorSetStorageBuffersDynamic;
  }
  uint32_t maxDescriptorSetSampledImages() const {
    return data_->maxDescriptorSetSampledImages;
  }
  uint32_t maxDescriptorSetStorageImages() const {
    return data_->maxDescriptorSetStorageImages;
  }
  uint32_t maxDescriptorSetInputAttachments() const {
    return data_->maxDescriptorSetInputAttachments;
  }
  uint32_t maxVertexInputAttributes() const {
    return data_->maxVertexInputAttributes;
  }
  uint32_t maxVertexInputBindings() const {
    return data_->maxVertexInputBindings;
  }
  uint32_t maxVertexInputAttributeOffset() const {
    return data_->maxVertexInputAttributeOffset;
  }
  uint32_t maxVertexInputBindingStride() const {
    return data_->maxVertexInputBindingStride;
  }
  uint32_t maxVertexOutputComponents() const {
    return data_->maxVertexOutputComponents;
  }
  uint32_t maxTessellationGenerationLevel() const {
    return data_->maxTessellationGenerationLevel;
  }
  uint32_t maxTessellationPatchSize() const {
    return data_->maxTessellationPatchSize;
  }
  uint32_t maxTessellationControlPerVertexInputComponents() const {
    return data_->maxTessellationControlPerVertexInputComponents;
  }
  uint32_t maxTessellationControlPerVertexOutputComponents() const {
    return data_->maxTessellationControlPerVertexOutputComponents;
  }
  uint32_t maxTessellationControlPerPatchOutputComponents() const {
    return data_->maxTessellationControlPerPatchOutputComponents;
  }
  uint32_t maxTessellationControlTotalOutputComponents() const {
    return data_->maxTessellationControlTotalOutputComponents;
  }
  uint32_t maxTessellationEvaluationInputComponents() const {
    return data_->maxTessellationEvaluationInputComponents;
  }
  uint32_t maxTessellationEvaluationOutputComponents() const {
    return data_->maxTessellationEvaluationOutputComponents;
  }
  uint32_t maxGeometryShaderInvocations() const {
    return data_->maxGeometryShaderInvocations;
  }
  uint32_t maxGeometryInputComponents() const {
    return data_->maxGeometryInputComponents;
  }
  uint32_t maxGeometryOutputComponents() const {
    return data_->maxGeometryOutputComponents;
  }
  uint32_t maxGeometryOutputVertices() const {
    return data_->maxGeometryOutputVertices;
  }
  uint32_t maxGeometryTotalOutputComponents() const {
    return data_->maxGeometryTotalOutputComponents;
  }
  uint32_t maxFragmentInputComponents() const {
    return data_->maxFragmentInputComponents;
  }
  uint32_t maxFragmentOutputAttachments() const {
    return data_->maxFragmentOutputAttachments;
  }
  uint32_t maxFragmentDualSrcAttachments() const {
    return data_->maxFragmentDualSrcAttachments;
  }
  uint32_t maxFragmentCombinedOutputResources() const {
    return data_->maxFragmentCombinedOutputResources;
  }
  uint32_t maxComputeSharedMemorySize() const {
    return data_->maxComputeSharedMemorySize;
  }
  inline void GetMaxComputeWorkGroupCountDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxComputeWorkGroupCount(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupCount.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t maxComputeWorkGroupInvocations() const {
    return data_->maxComputeWorkGroupInvocations;
  }
  inline void GetMaxComputeWorkGroupSizeDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxComputeWorkGroupSize(UserType* output) {
    
    auto* pointer = data_->maxComputeWorkGroupSize.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t subPixelPrecisionBits() const {
    return data_->subPixelPrecisionBits;
  }
  uint32_t subTexelPrecisionBits() const {
    return data_->subTexelPrecisionBits;
  }
  uint32_t mipmapPrecisionBits() const {
    return data_->mipmapPrecisionBits;
  }
  uint32_t maxDrawIndexedIndexValue() const {
    return data_->maxDrawIndexedIndexValue;
  }
  uint32_t maxDrawIndirectCount() const {
    return data_->maxDrawIndirectCount;
  }
  float maxSamplerLodBias() const {
    return data_->maxSamplerLodBias;
  }
  float maxSamplerAnisotropy() const {
    return data_->maxSamplerAnisotropy;
  }
  uint32_t maxViewports() const {
    return data_->maxViewports;
  }
  inline void GetMaxViewportDimensionsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxViewportDimensions(UserType* output) {
    
    auto* pointer = data_->maxViewportDimensions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  inline void GetViewportBoundsRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportBoundsRange(UserType* output) {
    
    auto* pointer = data_->viewportBoundsRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  uint32_t viewportSubPixelBits() const {
    return data_->viewportSubPixelBits;
  }
  uint64_t minMemoryMapAlignment() const {
    return data_->minMemoryMapAlignment;
  }
  uint64_t minTexelBufferOffsetAlignment() const {
    return data_->minTexelBufferOffsetAlignment;
  }
  uint64_t minUniformBufferOffsetAlignment() const {
    return data_->minUniformBufferOffsetAlignment;
  }
  uint64_t minStorageBufferOffsetAlignment() const {
    return data_->minStorageBufferOffsetAlignment;
  }
  int32_t minTexelOffset() const {
    return data_->minTexelOffset;
  }
  uint32_t maxTexelOffset() const {
    return data_->maxTexelOffset;
  }
  int32_t minTexelGatherOffset() const {
    return data_->minTexelGatherOffset;
  }
  uint32_t maxTexelGatherOffset() const {
    return data_->maxTexelGatherOffset;
  }
  float minInterpolationOffset() const {
    return data_->minInterpolationOffset;
  }
  float maxInterpolationOffset() const {
    return data_->maxInterpolationOffset;
  }
  uint32_t subPixelInterpolationOffsetBits() const {
    return data_->subPixelInterpolationOffsetBits;
  }
  uint32_t maxFramebufferWidth() const {
    return data_->maxFramebufferWidth;
  }
  uint32_t maxFramebufferHeight() const {
    return data_->maxFramebufferHeight;
  }
  uint32_t maxFramebufferLayers() const {
    return data_->maxFramebufferLayers;
  }
  uint32_t framebufferColorSampleCounts() const {
    return data_->framebufferColorSampleCounts;
  }
  uint32_t framebufferDepthSampleCounts() const {
    return data_->framebufferDepthSampleCounts;
  }
  uint32_t framebufferStencilSampleCounts() const {
    return data_->framebufferStencilSampleCounts;
  }
  uint32_t framebufferNoAttachmentsSampleCounts() const {
    return data_->framebufferNoAttachmentsSampleCounts;
  }
  uint32_t maxColorAttachments() const {
    return data_->maxColorAttachments;
  }
  uint32_t sampledImageColorSampleCounts() const {
    return data_->sampledImageColorSampleCounts;
  }
  uint32_t sampledImageIntegerSampleCounts() const {
    return data_->sampledImageIntegerSampleCounts;
  }
  uint32_t sampledImageDepthSampleCounts() const {
    return data_->sampledImageDepthSampleCounts;
  }
  uint32_t sampledImageStencilSampleCounts() const {
    return data_->sampledImageStencilSampleCounts;
  }
  uint32_t storageImageSampleCounts() const {
    return data_->storageImageSampleCounts;
  }
  uint32_t maxSampleMaskWords() const {
    return data_->maxSampleMaskWords;
  }
  bool timestampComputeAndGraphics() const {
    return data_->timestampComputeAndGraphics;
  }
  float timestampPeriod() const {
    return data_->timestampPeriod;
  }
  uint32_t maxClipDistances() const {
    return data_->maxClipDistances;
  }
  uint32_t maxCullDistances() const {
    return data_->maxCullDistances;
  }
  uint32_t maxCombinedClipAndCullDistances() const {
    return data_->maxCombinedClipAndCullDistances;
  }
  uint32_t discreteQueuePriorities() const {
    return data_->discreteQueuePriorities;
  }
  inline void GetPointSizeRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointSizeRange(UserType* output) {
    
    auto* pointer = data_->pointSizeRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  inline void GetLineWidthRangeDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLineWidthRange(UserType* output) {
    
    auto* pointer = data_->lineWidthRange.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
  float pointSizeGranularity() const {
    return data_->pointSizeGranularity;
  }
  float lineWidthGranularity() const {
    return data_->lineWidthGranularity;
  }
  bool strictLines() const {
    return data_->strictLines;
  }
  bool standardSampleLocations() const {
    return data_->standardSampleLocations;
  }
  uint64_t optimalBufferCopyOffsetAlignment() const {
    return data_->optimalBufferCopyOffsetAlignment;
  }
  uint64_t optimalBufferCopyRowPitchAlignment() const {
    return data_->optimalBufferCopyRowPitchAlignment;
  }
  uint64_t nonCoherentAtomSize() const {
    return data_->nonCoherentAtomSize;
  }
 private:
  internal::VkPhysicalDeviceLimits_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceSparsePropertiesDataView {
 public:
  VkPhysicalDeviceSparsePropertiesDataView() = default;

  VkPhysicalDeviceSparsePropertiesDataView(
      internal::VkPhysicalDeviceSparseProperties_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool residencyStandard2DBlockShape() const {
    return data_->residencyStandard2DBlockShape;
  }
  bool residencyStandard2DMultisampleBlockShape() const {
    return data_->residencyStandard2DMultisampleBlockShape;
  }
  bool residencyStandard3DBlockShape() const {
    return data_->residencyStandard3DBlockShape;
  }
  bool residencyAlignedMipSize() const {
    return data_->residencyAlignedMipSize;
  }
  bool residencyNonResidentStrict() const {
    return data_->residencyNonResidentStrict;
  }
 private:
  internal::VkPhysicalDeviceSparseProperties_Data* data_ = nullptr;
};


class VkPhysicalDevicePropertiesDataView {
 public:
  VkPhysicalDevicePropertiesDataView() = default;

  VkPhysicalDevicePropertiesDataView(
      internal::VkPhysicalDeviceProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t apiVersion() const {
    return data_->apiVersion;
  }
  uint32_t driverVersion() const {
    return data_->driverVersion;
  }
  uint32_t vendorID() const {
    return data_->vendorID;
  }
  uint32_t deviceID() const {
    return data_->deviceID;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDeviceType(UserType* output) const {
    auto data_value = data_->deviceType;
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceType>(
        data_value, output);
  }
  VkPhysicalDeviceType deviceType() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gpu::mojom::VkPhysicalDeviceType>(data_->deviceType));
  }
  inline void GetDeviceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceName(UserType* output) {
    
    auto* pointer = data_->deviceName.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPipelineCacheUuidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPipelineCacheUuid(UserType* output) {
    
    auto* pointer = data_->pipelineCacheUUID.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetLimitsDataView(
      VkPhysicalDeviceLimitsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLimits(UserType* output) {
    
    auto* pointer = data_->limits.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
        pointer, output, message_);
  }
  inline void GetSparsePropertiesDataView(
      VkPhysicalDeviceSparsePropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSparseProperties(UserType* output) {
    
    auto* pointer = data_->sparseProperties.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkPhysicalDeviceProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VkPhysicalDeviceFeaturesDataView {
 public:
  VkPhysicalDeviceFeaturesDataView() = default;

  VkPhysicalDeviceFeaturesDataView(
      internal::VkPhysicalDeviceFeatures_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool robustBufferAccess() const {
    return data_->robustBufferAccess;
  }
  bool fullDrawIndexUint32() const {
    return data_->fullDrawIndexUint32;
  }
  bool imageCubeArray() const {
    return data_->imageCubeArray;
  }
  bool independentBlend() const {
    return data_->independentBlend;
  }
  bool geometryShader() const {
    return data_->geometryShader;
  }
  bool tessellationShader() const {
    return data_->tessellationShader;
  }
  bool sampleRateShading() const {
    return data_->sampleRateShading;
  }
  bool dualSrcBlend() const {
    return data_->dualSrcBlend;
  }
  bool logicOp() const {
    return data_->logicOp;
  }
  bool multiDrawIndirect() const {
    return data_->multiDrawIndirect;
  }
  bool drawIndirectFirstInstance() const {
    return data_->drawIndirectFirstInstance;
  }
  bool depthClamp() const {
    return data_->depthClamp;
  }
  bool depthBiasClamp() const {
    return data_->depthBiasClamp;
  }
  bool fillModeNonSolid() const {
    return data_->fillModeNonSolid;
  }
  bool depthBounds() const {
    return data_->depthBounds;
  }
  bool wideLines() const {
    return data_->wideLines;
  }
  bool largePoints() const {
    return data_->largePoints;
  }
  bool alphaToOne() const {
    return data_->alphaToOne;
  }
  bool multiViewport() const {
    return data_->multiViewport;
  }
  bool samplerAnisotropy() const {
    return data_->samplerAnisotropy;
  }
  bool textureCompressionETC2() const {
    return data_->textureCompressionETC2;
  }
  bool textureCompressionASTC_LDR() const {
    return data_->textureCompressionASTC_LDR;
  }
  bool textureCompressionBC() const {
    return data_->textureCompressionBC;
  }
  bool occlusionQueryPrecise() const {
    return data_->occlusionQueryPrecise;
  }
  bool pipelineStatisticsQuery() const {
    return data_->pipelineStatisticsQuery;
  }
  bool vertexPipelineStoresAndAtomics() const {
    return data_->vertexPipelineStoresAndAtomics;
  }
  bool fragmentStoresAndAtomics() const {
    return data_->fragmentStoresAndAtomics;
  }
  bool shaderTessellationAndGeometryPointSize() const {
    return data_->shaderTessellationAndGeometryPointSize;
  }
  bool shaderImageGatherExtended() const {
    return data_->shaderImageGatherExtended;
  }
  bool shaderStorageImageExtendedFormats() const {
    return data_->shaderStorageImageExtendedFormats;
  }
  bool shaderStorageImageMultisample() const {
    return data_->shaderStorageImageMultisample;
  }
  bool shaderStorageImageReadWithoutFormat() const {
    return data_->shaderStorageImageReadWithoutFormat;
  }
  bool shaderStorageImageWriteWithoutFormat() const {
    return data_->shaderStorageImageWriteWithoutFormat;
  }
  bool shaderUniformBufferArrayDynamicIndexing() const {
    return data_->shaderUniformBufferArrayDynamicIndexing;
  }
  bool shaderSampledImageArrayDynamicIndexing() const {
    return data_->shaderSampledImageArrayDynamicIndexing;
  }
  bool shaderStorageBufferArrayDynamicIndexing() const {
    return data_->shaderStorageBufferArrayDynamicIndexing;
  }
  bool shaderStorageImageArrayDynamicIndexing() const {
    return data_->shaderStorageImageArrayDynamicIndexing;
  }
  bool shaderClipDistance() const {
    return data_->shaderClipDistance;
  }
  bool shaderCullDistance() const {
    return data_->shaderCullDistance;
  }
  bool shaderFloat64() const {
    return data_->shaderFloat64;
  }
  bool shaderInt64() const {
    return data_->shaderInt64;
  }
  bool shaderInt16() const {
    return data_->shaderInt16;
  }
  bool shaderResourceResidency() const {
    return data_->shaderResourceResidency;
  }
  bool shaderResourceMinLod() const {
    return data_->shaderResourceMinLod;
  }
  bool sparseBinding() const {
    return data_->sparseBinding;
  }
  bool sparseResidencyBuffer() const {
    return data_->sparseResidencyBuffer;
  }
  bool sparseResidencyImage2D() const {
    return data_->sparseResidencyImage2D;
  }
  bool sparseResidencyImage3D() const {
    return data_->sparseResidencyImage3D;
  }
  bool sparseResidency2Samples() const {
    return data_->sparseResidency2Samples;
  }
  bool sparseResidency4Samples() const {
    return data_->sparseResidency4Samples;
  }
  bool sparseResidency8Samples() const {
    return data_->sparseResidency8Samples;
  }
  bool sparseResidency16Samples() const {
    return data_->sparseResidency16Samples;
  }
  bool sparseResidencyAliased() const {
    return data_->sparseResidencyAliased;
  }
  bool variableMultisampleRate() const {
    return data_->variableMultisampleRate;
  }
  bool inheritedQueries() const {
    return data_->inheritedQueries;
  }
 private:
  internal::VkPhysicalDeviceFeatures_Data* data_ = nullptr;
};


class VkExtent3DDataView {
 public:
  VkExtent3DDataView() = default;

  VkExtent3DDataView(
      internal::VkExtent3D_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t width() const {
    return data_->width;
  }
  uint32_t height() const {
    return data_->height;
  }
  uint32_t depth() const {
    return data_->depth;
  }
 private:
  internal::VkExtent3D_Data* data_ = nullptr;
};


class VkQueueFamilyPropertiesDataView {
 public:
  VkQueueFamilyPropertiesDataView() = default;

  VkQueueFamilyPropertiesDataView(
      internal::VkQueueFamilyProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t queueFlags() const {
    return data_->queueFlags;
  }
  uint32_t queueCount() const {
    return data_->queueCount;
  }
  uint32_t timestampValidBits() const {
    return data_->timestampValidBits;
  }
  inline void GetMinImageTransferGranularityDataView(
      VkExtent3DDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinImageTransferGranularity(UserType* output) {
    
    auto* pointer = data_->minImageTransferGranularity.Get();
    return mojo::internal::Deserialize<::gpu::mojom::VkExtent3DDataView>(
        pointer, output, message_);
  }
 private:
  internal::VkQueueFamilyProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gpu::mojom

namespace std {

template <>
struct hash<::gpu::mojom::VkPhysicalDeviceType>
    : public mojo::internal::EnumHashImpl<::gpu::mojom::VkPhysicalDeviceType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gpu::mojom::VkPhysicalDeviceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gpu::mojom::VkPhysicalDeviceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtensionPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtensionPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkExtensionProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::extensionName(input)) in_extensionName = Traits::extensionName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extensionName)::BaseType> extensionName_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extensionName, extensionName_fragment);
    fragment->extensionName.Set(
        extensionName_fragment.is_null() ? nullptr : extensionName_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extensionName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extensionName in VkExtensionProperties struct");
    fragment->specVersion = Traits::specVersion(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtensionProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtensionPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkLayerPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkLayerPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkLayerProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::layerName(input)) in_layerName = Traits::layerName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->layerName)::BaseType> layerName_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_layerName, layerName_fragment);
    fragment->layerName.Set(
        layerName_fragment.is_null() ? nullptr : layerName_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->layerName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null layerName in VkLayerProperties struct");
    fragment->specVersion = Traits::specVersion(input);
    fragment->implementationVersion = Traits::implementationVersion(input);
    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, description_fragment);
    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in VkLayerProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkLayerProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkLayerPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceLimitsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceLimitsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceLimits_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->maxImageDimension1D = Traits::maxImageDimension1D(input);
    fragment->maxImageDimension2D = Traits::maxImageDimension2D(input);
    fragment->maxImageDimension3D = Traits::maxImageDimension3D(input);
    fragment->maxImageDimensionCube = Traits::maxImageDimensionCube(input);
    fragment->maxImageArrayLayers = Traits::maxImageArrayLayers(input);
    fragment->maxTexelBufferElements = Traits::maxTexelBufferElements(input);
    fragment->maxUniformBufferRange = Traits::maxUniformBufferRange(input);
    fragment->maxStorageBufferRange = Traits::maxStorageBufferRange(input);
    fragment->maxPushConstantsSize = Traits::maxPushConstantsSize(input);
    fragment->maxMemoryAllocationCount = Traits::maxMemoryAllocationCount(input);
    fragment->maxSamplerAllocationCount = Traits::maxSamplerAllocationCount(input);
    fragment->bufferImageGranularity = Traits::bufferImageGranularity(input);
    fragment->sparseAddressSpaceSize = Traits::sparseAddressSpaceSize(input);
    fragment->maxBoundDescriptorSets = Traits::maxBoundDescriptorSets(input);
    fragment->maxPerStageDescriptorSamplers = Traits::maxPerStageDescriptorSamplers(input);
    fragment->maxPerStageDescriptorUniformBuffers = Traits::maxPerStageDescriptorUniformBuffers(input);
    fragment->maxPerStageDescriptorStorageBuffers = Traits::maxPerStageDescriptorStorageBuffers(input);
    fragment->maxPerStageDescriptorSampledImages = Traits::maxPerStageDescriptorSampledImages(input);
    fragment->maxPerStageDescriptorStorageImages = Traits::maxPerStageDescriptorStorageImages(input);
    fragment->maxPerStageDescriptorInputAttachments = Traits::maxPerStageDescriptorInputAttachments(input);
    fragment->maxPerStageResources = Traits::maxPerStageResources(input);
    fragment->maxDescriptorSetSamplers = Traits::maxDescriptorSetSamplers(input);
    fragment->maxDescriptorSetUniformBuffers = Traits::maxDescriptorSetUniformBuffers(input);
    fragment->maxDescriptorSetUniformBuffersDynamic = Traits::maxDescriptorSetUniformBuffersDynamic(input);
    fragment->maxDescriptorSetStorageBuffers = Traits::maxDescriptorSetStorageBuffers(input);
    fragment->maxDescriptorSetStorageBuffersDynamic = Traits::maxDescriptorSetStorageBuffersDynamic(input);
    fragment->maxDescriptorSetSampledImages = Traits::maxDescriptorSetSampledImages(input);
    fragment->maxDescriptorSetStorageImages = Traits::maxDescriptorSetStorageImages(input);
    fragment->maxDescriptorSetInputAttachments = Traits::maxDescriptorSetInputAttachments(input);
    fragment->maxVertexInputAttributes = Traits::maxVertexInputAttributes(input);
    fragment->maxVertexInputBindings = Traits::maxVertexInputBindings(input);
    fragment->maxVertexInputAttributeOffset = Traits::maxVertexInputAttributeOffset(input);
    fragment->maxVertexInputBindingStride = Traits::maxVertexInputBindingStride(input);
    fragment->maxVertexOutputComponents = Traits::maxVertexOutputComponents(input);
    fragment->maxTessellationGenerationLevel = Traits::maxTessellationGenerationLevel(input);
    fragment->maxTessellationPatchSize = Traits::maxTessellationPatchSize(input);
    fragment->maxTessellationControlPerVertexInputComponents = Traits::maxTessellationControlPerVertexInputComponents(input);
    fragment->maxTessellationControlPerVertexOutputComponents = Traits::maxTessellationControlPerVertexOutputComponents(input);
    fragment->maxTessellationControlPerPatchOutputComponents = Traits::maxTessellationControlPerPatchOutputComponents(input);
    fragment->maxTessellationControlTotalOutputComponents = Traits::maxTessellationControlTotalOutputComponents(input);
    fragment->maxTessellationEvaluationInputComponents = Traits::maxTessellationEvaluationInputComponents(input);
    fragment->maxTessellationEvaluationOutputComponents = Traits::maxTessellationEvaluationOutputComponents(input);
    fragment->maxGeometryShaderInvocations = Traits::maxGeometryShaderInvocations(input);
    fragment->maxGeometryInputComponents = Traits::maxGeometryInputComponents(input);
    fragment->maxGeometryOutputComponents = Traits::maxGeometryOutputComponents(input);
    fragment->maxGeometryOutputVertices = Traits::maxGeometryOutputVertices(input);
    fragment->maxGeometryTotalOutputComponents = Traits::maxGeometryTotalOutputComponents(input);
    fragment->maxFragmentInputComponents = Traits::maxFragmentInputComponents(input);
    fragment->maxFragmentOutputAttachments = Traits::maxFragmentOutputAttachments(input);
    fragment->maxFragmentDualSrcAttachments = Traits::maxFragmentDualSrcAttachments(input);
    fragment->maxFragmentCombinedOutputResources = Traits::maxFragmentCombinedOutputResources(input);
    fragment->maxComputeSharedMemorySize = Traits::maxComputeSharedMemorySize(input);
    decltype(Traits::maxComputeWorkGroupCount(input)) in_maxComputeWorkGroupCount = Traits::maxComputeWorkGroupCount(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxComputeWorkGroupCount)::BaseType>
        maxComputeWorkGroupCount_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupCount_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxComputeWorkGroupCount, maxComputeWorkGroupCount_fragment, &maxComputeWorkGroupCount_validate_params);
    fragment->maxComputeWorkGroupCount.Set(
        maxComputeWorkGroupCount_fragment.is_null() ? nullptr : maxComputeWorkGroupCount_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->maxComputeWorkGroupCount.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxComputeWorkGroupCount in VkPhysicalDeviceLimits struct");
    fragment->maxComputeWorkGroupInvocations = Traits::maxComputeWorkGroupInvocations(input);
    decltype(Traits::maxComputeWorkGroupSize(input)) in_maxComputeWorkGroupSize = Traits::maxComputeWorkGroupSize(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxComputeWorkGroupSize)::BaseType>
        maxComputeWorkGroupSize_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxComputeWorkGroupSize_validate_params =
        mojo::internal::GetArrayValidator<3, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxComputeWorkGroupSize, maxComputeWorkGroupSize_fragment, &maxComputeWorkGroupSize_validate_params);
    fragment->maxComputeWorkGroupSize.Set(
        maxComputeWorkGroupSize_fragment.is_null() ? nullptr : maxComputeWorkGroupSize_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->maxComputeWorkGroupSize.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxComputeWorkGroupSize in VkPhysicalDeviceLimits struct");
    fragment->subPixelPrecisionBits = Traits::subPixelPrecisionBits(input);
    fragment->subTexelPrecisionBits = Traits::subTexelPrecisionBits(input);
    fragment->mipmapPrecisionBits = Traits::mipmapPrecisionBits(input);
    fragment->maxDrawIndexedIndexValue = Traits::maxDrawIndexedIndexValue(input);
    fragment->maxDrawIndirectCount = Traits::maxDrawIndirectCount(input);
    fragment->maxSamplerLodBias = Traits::maxSamplerLodBias(input);
    fragment->maxSamplerAnisotropy = Traits::maxSamplerAnisotropy(input);
    fragment->maxViewports = Traits::maxViewports(input);
    decltype(Traits::maxViewportDimensions(input)) in_maxViewportDimensions = Traits::maxViewportDimensions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->maxViewportDimensions)::BaseType>
        maxViewportDimensions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& maxViewportDimensions_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
        in_maxViewportDimensions, maxViewportDimensions_fragment, &maxViewportDimensions_validate_params);
    fragment->maxViewportDimensions.Set(
        maxViewportDimensions_fragment.is_null() ? nullptr : maxViewportDimensions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->maxViewportDimensions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maxViewportDimensions in VkPhysicalDeviceLimits struct");
    decltype(Traits::viewportBoundsRange(input)) in_viewportBoundsRange = Traits::viewportBoundsRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->viewportBoundsRange)::BaseType>
        viewportBoundsRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& viewportBoundsRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_viewportBoundsRange, viewportBoundsRange_fragment, &viewportBoundsRange_validate_params);
    fragment->viewportBoundsRange.Set(
        viewportBoundsRange_fragment.is_null() ? nullptr : viewportBoundsRange_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->viewportBoundsRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewportBoundsRange in VkPhysicalDeviceLimits struct");
    fragment->viewportSubPixelBits = Traits::viewportSubPixelBits(input);
    fragment->minMemoryMapAlignment = Traits::minMemoryMapAlignment(input);
    fragment->minTexelBufferOffsetAlignment = Traits::minTexelBufferOffsetAlignment(input);
    fragment->minUniformBufferOffsetAlignment = Traits::minUniformBufferOffsetAlignment(input);
    fragment->minStorageBufferOffsetAlignment = Traits::minStorageBufferOffsetAlignment(input);
    fragment->minTexelOffset = Traits::minTexelOffset(input);
    fragment->maxTexelOffset = Traits::maxTexelOffset(input);
    fragment->minTexelGatherOffset = Traits::minTexelGatherOffset(input);
    fragment->maxTexelGatherOffset = Traits::maxTexelGatherOffset(input);
    fragment->minInterpolationOffset = Traits::minInterpolationOffset(input);
    fragment->maxInterpolationOffset = Traits::maxInterpolationOffset(input);
    fragment->subPixelInterpolationOffsetBits = Traits::subPixelInterpolationOffsetBits(input);
    fragment->maxFramebufferWidth = Traits::maxFramebufferWidth(input);
    fragment->maxFramebufferHeight = Traits::maxFramebufferHeight(input);
    fragment->maxFramebufferLayers = Traits::maxFramebufferLayers(input);
    fragment->framebufferColorSampleCounts = Traits::framebufferColorSampleCounts(input);
    fragment->framebufferDepthSampleCounts = Traits::framebufferDepthSampleCounts(input);
    fragment->framebufferStencilSampleCounts = Traits::framebufferStencilSampleCounts(input);
    fragment->framebufferNoAttachmentsSampleCounts = Traits::framebufferNoAttachmentsSampleCounts(input);
    fragment->maxColorAttachments = Traits::maxColorAttachments(input);
    fragment->sampledImageColorSampleCounts = Traits::sampledImageColorSampleCounts(input);
    fragment->sampledImageIntegerSampleCounts = Traits::sampledImageIntegerSampleCounts(input);
    fragment->sampledImageDepthSampleCounts = Traits::sampledImageDepthSampleCounts(input);
    fragment->sampledImageStencilSampleCounts = Traits::sampledImageStencilSampleCounts(input);
    fragment->storageImageSampleCounts = Traits::storageImageSampleCounts(input);
    fragment->maxSampleMaskWords = Traits::maxSampleMaskWords(input);
    fragment->timestampComputeAndGraphics = Traits::timestampComputeAndGraphics(input);
    fragment->timestampPeriod = Traits::timestampPeriod(input);
    fragment->maxClipDistances = Traits::maxClipDistances(input);
    fragment->maxCullDistances = Traits::maxCullDistances(input);
    fragment->maxCombinedClipAndCullDistances = Traits::maxCombinedClipAndCullDistances(input);
    fragment->discreteQueuePriorities = Traits::discreteQueuePriorities(input);
    decltype(Traits::pointSizeRange(input)) in_pointSizeRange = Traits::pointSizeRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pointSizeRange)::BaseType>
        pointSizeRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pointSizeRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_pointSizeRange, pointSizeRange_fragment, &pointSizeRange_validate_params);
    fragment->pointSizeRange.Set(
        pointSizeRange_fragment.is_null() ? nullptr : pointSizeRange_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pointSizeRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pointSizeRange in VkPhysicalDeviceLimits struct");
    decltype(Traits::lineWidthRange(input)) in_lineWidthRange = Traits::lineWidthRange(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->lineWidthRange)::BaseType>
        lineWidthRange_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& lineWidthRange_validate_params =
        mojo::internal::GetArrayValidator<2, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<float>>(
        in_lineWidthRange, lineWidthRange_fragment, &lineWidthRange_validate_params);
    fragment->lineWidthRange.Set(
        lineWidthRange_fragment.is_null() ? nullptr : lineWidthRange_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->lineWidthRange.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null lineWidthRange in VkPhysicalDeviceLimits struct");
    fragment->pointSizeGranularity = Traits::pointSizeGranularity(input);
    fragment->lineWidthGranularity = Traits::lineWidthGranularity(input);
    fragment->strictLines = Traits::strictLines(input);
    fragment->standardSampleLocations = Traits::standardSampleLocations(input);
    fragment->optimalBufferCopyOffsetAlignment = Traits::optimalBufferCopyOffsetAlignment(input);
    fragment->optimalBufferCopyRowPitchAlignment = Traits::optimalBufferCopyRowPitchAlignment(input);
    fragment->nonCoherentAtomSize = Traits::nonCoherentAtomSize(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceLimits_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceLimitsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->residencyStandard2DBlockShape = Traits::residencyStandard2DBlockShape(input);
    fragment->residencyStandard2DMultisampleBlockShape = Traits::residencyStandard2DMultisampleBlockShape(input);
    fragment->residencyStandard3DBlockShape = Traits::residencyStandard3DBlockShape(input);
    fragment->residencyAlignedMipSize = Traits::residencyAlignedMipSize(input);
    fragment->residencyNonResidentStrict = Traits::residencyNonResidentStrict(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceSparseProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDevicePropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDevicePropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->apiVersion = Traits::apiVersion(input);
    fragment->driverVersion = Traits::driverVersion(input);
    fragment->vendorID = Traits::vendorID(input);
    fragment->deviceID = Traits::deviceID(input);
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceType>(
        Traits::deviceType(input), &fragment->deviceType);
    decltype(Traits::deviceName(input)) in_deviceName = Traits::deviceName(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deviceName)::BaseType> deviceName_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_deviceName, deviceName_fragment);
    fragment->deviceName.Set(
        deviceName_fragment.is_null() ? nullptr : deviceName_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->deviceName.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deviceName in VkPhysicalDeviceProperties struct");
    decltype(Traits::pipelineCacheUUID(input)) in_pipelineCacheUUID = Traits::pipelineCacheUUID(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pipelineCacheUUID)::BaseType>
        pipelineCacheUUID_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& pipelineCacheUUID_validate_params =
        mojo::internal::GetArrayValidator<16, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_pipelineCacheUUID, pipelineCacheUUID_fragment, &pipelineCacheUUID_validate_params);
    fragment->pipelineCacheUUID.Set(
        pipelineCacheUUID_fragment.is_null() ? nullptr : pipelineCacheUUID_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pipelineCacheUUID.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pipelineCacheUUID in VkPhysicalDeviceProperties struct");
    decltype(Traits::limits(input)) in_limits = Traits::limits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->limits)::BaseType> limits_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceLimitsDataView>(
        in_limits, limits_fragment);
    fragment->limits.Set(
        limits_fragment.is_null() ? nullptr : limits_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null limits in VkPhysicalDeviceProperties struct");
    decltype(Traits::sparseProperties(input)) in_sparseProperties = Traits::sparseProperties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sparseProperties)::BaseType> sparseProperties_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::VkPhysicalDeviceSparsePropertiesDataView>(
        in_sparseProperties, sparseProperties_fragment);
    fragment->sparseProperties.Set(
        sparseProperties_fragment.is_null() ? nullptr : sparseProperties_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sparseProperties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sparseProperties in VkPhysicalDeviceProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDevicePropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkPhysicalDeviceFeaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->robustBufferAccess = Traits::robustBufferAccess(input);
    fragment->fullDrawIndexUint32 = Traits::fullDrawIndexUint32(input);
    fragment->imageCubeArray = Traits::imageCubeArray(input);
    fragment->independentBlend = Traits::independentBlend(input);
    fragment->geometryShader = Traits::geometryShader(input);
    fragment->tessellationShader = Traits::tessellationShader(input);
    fragment->sampleRateShading = Traits::sampleRateShading(input);
    fragment->dualSrcBlend = Traits::dualSrcBlend(input);
    fragment->logicOp = Traits::logicOp(input);
    fragment->multiDrawIndirect = Traits::multiDrawIndirect(input);
    fragment->drawIndirectFirstInstance = Traits::drawIndirectFirstInstance(input);
    fragment->depthClamp = Traits::depthClamp(input);
    fragment->depthBiasClamp = Traits::depthBiasClamp(input);
    fragment->fillModeNonSolid = Traits::fillModeNonSolid(input);
    fragment->depthBounds = Traits::depthBounds(input);
    fragment->wideLines = Traits::wideLines(input);
    fragment->largePoints = Traits::largePoints(input);
    fragment->alphaToOne = Traits::alphaToOne(input);
    fragment->multiViewport = Traits::multiViewport(input);
    fragment->samplerAnisotropy = Traits::samplerAnisotropy(input);
    fragment->textureCompressionETC2 = Traits::textureCompressionETC2(input);
    fragment->textureCompressionASTC_LDR = Traits::textureCompressionASTC_LDR(input);
    fragment->textureCompressionBC = Traits::textureCompressionBC(input);
    fragment->occlusionQueryPrecise = Traits::occlusionQueryPrecise(input);
    fragment->pipelineStatisticsQuery = Traits::pipelineStatisticsQuery(input);
    fragment->vertexPipelineStoresAndAtomics = Traits::vertexPipelineStoresAndAtomics(input);
    fragment->fragmentStoresAndAtomics = Traits::fragmentStoresAndAtomics(input);
    fragment->shaderTessellationAndGeometryPointSize = Traits::shaderTessellationAndGeometryPointSize(input);
    fragment->shaderImageGatherExtended = Traits::shaderImageGatherExtended(input);
    fragment->shaderStorageImageExtendedFormats = Traits::shaderStorageImageExtendedFormats(input);
    fragment->shaderStorageImageMultisample = Traits::shaderStorageImageMultisample(input);
    fragment->shaderStorageImageReadWithoutFormat = Traits::shaderStorageImageReadWithoutFormat(input);
    fragment->shaderStorageImageWriteWithoutFormat = Traits::shaderStorageImageWriteWithoutFormat(input);
    fragment->shaderUniformBufferArrayDynamicIndexing = Traits::shaderUniformBufferArrayDynamicIndexing(input);
    fragment->shaderSampledImageArrayDynamicIndexing = Traits::shaderSampledImageArrayDynamicIndexing(input);
    fragment->shaderStorageBufferArrayDynamicIndexing = Traits::shaderStorageBufferArrayDynamicIndexing(input);
    fragment->shaderStorageImageArrayDynamicIndexing = Traits::shaderStorageImageArrayDynamicIndexing(input);
    fragment->shaderClipDistance = Traits::shaderClipDistance(input);
    fragment->shaderCullDistance = Traits::shaderCullDistance(input);
    fragment->shaderFloat64 = Traits::shaderFloat64(input);
    fragment->shaderInt64 = Traits::shaderInt64(input);
    fragment->shaderInt16 = Traits::shaderInt16(input);
    fragment->shaderResourceResidency = Traits::shaderResourceResidency(input);
    fragment->shaderResourceMinLod = Traits::shaderResourceMinLod(input);
    fragment->sparseBinding = Traits::sparseBinding(input);
    fragment->sparseResidencyBuffer = Traits::sparseResidencyBuffer(input);
    fragment->sparseResidencyImage2D = Traits::sparseResidencyImage2D(input);
    fragment->sparseResidencyImage3D = Traits::sparseResidencyImage3D(input);
    fragment->sparseResidency2Samples = Traits::sparseResidency2Samples(input);
    fragment->sparseResidency4Samples = Traits::sparseResidency4Samples(input);
    fragment->sparseResidency8Samples = Traits::sparseResidency8Samples(input);
    fragment->sparseResidency16Samples = Traits::sparseResidency16Samples(input);
    fragment->sparseResidencyAliased = Traits::sparseResidencyAliased(input);
    fragment->variableMultisampleRate = Traits::variableMultisampleRate(input);
    fragment->inheritedQueries = Traits::inheritedQueries(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkPhysicalDeviceFeatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkPhysicalDeviceFeaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkExtent3DDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkExtent3DDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkExtent3D_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->width = Traits::width(input);
    fragment->height = Traits::height(input);
    fragment->depth = Traits::depth(input);
  }

  static bool Deserialize(::gpu::mojom::internal::VkExtent3D_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkExtent3DDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gpu::mojom::VkQueueFamilyPropertiesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gpu::mojom::VkQueueFamilyPropertiesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gpu::mojom::internal::VkQueueFamilyProperties_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->queueFlags = Traits::queueFlags(input);
    fragment->queueCount = Traits::queueCount(input);
    fragment->timestampValidBits = Traits::timestampValidBits(input);
    decltype(Traits::minImageTransferGranularity(input)) in_minImageTransferGranularity = Traits::minImageTransferGranularity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->minImageTransferGranularity)::BaseType> minImageTransferGranularity_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::VkExtent3DDataView>(
        in_minImageTransferGranularity, minImageTransferGranularity_fragment);
    fragment->minImageTransferGranularity.Set(
        minImageTransferGranularity_fragment.is_null() ? nullptr : minImageTransferGranularity_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->minImageTransferGranularity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null minImageTransferGranularity in VkQueueFamilyProperties struct");
  }

  static bool Deserialize(::gpu::mojom::internal::VkQueueFamilyProperties_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gpu::mojom::VkQueueFamilyPropertiesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gpu::mojom {

inline void VkExtensionPropertiesDataView::GetExtensionNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extensionName.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void VkLayerPropertiesDataView::GetLayerNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->layerName.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VkLayerPropertiesDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupCountDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupCount.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxComputeWorkGroupSizeDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxComputeWorkGroupSize.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetMaxViewportDimensionsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->maxViewportDimensions.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetViewportBoundsRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->viewportBoundsRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetPointSizeRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->pointSizeRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}
inline void VkPhysicalDeviceLimitsDataView::GetLineWidthRangeDataView(
    mojo::ArrayDataView<float>* output) {
  auto pointer = data_->lineWidthRange.Get();
  *output = mojo::ArrayDataView<float>(pointer, message_);
}




inline void VkPhysicalDevicePropertiesDataView::GetDeviceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->deviceName.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetPipelineCacheUuidDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->pipelineCacheUUID.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetLimitsDataView(
    VkPhysicalDeviceLimitsDataView* output) {
  auto pointer = data_->limits.Get();
  *output = VkPhysicalDeviceLimitsDataView(pointer, message_);
}
inline void VkPhysicalDevicePropertiesDataView::GetSparsePropertiesDataView(
    VkPhysicalDeviceSparsePropertiesDataView* output) {
  auto pointer = data_->sparseProperties.Get();
  *output = VkPhysicalDeviceSparsePropertiesDataView(pointer, message_);
}






inline void VkQueueFamilyPropertiesDataView::GetMinImageTransferGranularityDataView(
    VkExtent3DDataView* output) {
  auto pointer = data_->minImageTransferGranularity.Get();
  *output = VkExtent3DDataView(pointer, message_);
}



}  // gpu::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_GPU_EXPORT) TraceFormatTraits<::gpu::mojom::VkPhysicalDeviceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gpu::mojom::VkPhysicalDeviceType value);
};

} // namespace perfetto

#endif  // GPU_IPC_COMMON_VULKAN_TYPES_MOJOM_SHARED_H_