// media/capture/mojom/video_capture_buffer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/capture/mojom/video_capture_buffer.mojom-params-data.h"
namespace media {
namespace mojom {

namespace internal {
// static
bool VideoBufferHandle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const VideoBufferHandle_Data* object = static_cast<const VideoBufferHandle_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case VideoBufferHandle_Tag::kUnsafeShmemRegion: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_unsafe_shmem_region, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_unsafe_shmem_region, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::kReadOnlyShmemRegion: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_read_only_shmem_region, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_read_only_shmem_region, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::kSharedImageHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_shared_image_handle, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_shared_image_handle, validation_context))
        return false;
      return true;
    }
    case VideoBufferHandle_Tag::kGpuMemoryBufferHandle: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_gpu_memory_buffer_handle, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_gpu_memory_buffer_handle, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in VideoBufferHandle");
      return false;
    }
  }
}


// static
bool VideoFrameInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoFrameInfo_Data* object =
      static_cast<const VideoFrameInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;


  if (!::media::mojom::internal::VideoCapturePixelFormat_Data
        ::Validate(object->pixel_format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coded_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->coded_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_rect, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_rect, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->strides, validation_context))
    return false;

  return true;
}

VideoFrameInfo_Data::VideoFrameInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ReadyBuffer_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ReadyBuffer_Data* object =
      static_cast<const ReadyBuffer_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

ReadyBuffer_Data::ReadyBuffer_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedImageBufferHandleSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedImageBufferHandleSet_Data* object =
      static_cast<const SharedImageBufferHandleSet_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_image, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

SharedImageBufferHandleSet_Data::SharedImageBufferHandleSet_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media