// media/mojo/mojom/audio_encoder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/audio_encoder.mojom-shared-internal.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
class AacAudioEncoderConfigDataView;

class AudioEncoderConfigDataView;

class EncodedAudioBufferDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::AacAudioEncoderConfigDataView> {
  using Data = ::media::mojom::internal::AacAudioEncoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::AudioEncoderConfigDataView> {
  using Data = ::media::mojom::internal::AudioEncoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::EncodedAudioBufferDataView> {
  using Data = ::media::mojom::internal::EncodedAudioBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class AacOutputFormat : int32_t {
  
  kAAC = 0,
  
  kADTS = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, AacOutputFormat value);
inline bool IsKnownEnumValue(AacOutputFormat value) {
  return internal::AacOutputFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AudioEncoderInterfaceBase {};

using AudioEncoderPtrDataView =
    mojo::InterfacePtrDataView<AudioEncoderInterfaceBase>;
using AudioEncoderRequestDataView =
    mojo::InterfaceRequestDataView<AudioEncoderInterfaceBase>;
using AudioEncoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioEncoderInterfaceBase>;
using AudioEncoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioEncoderInterfaceBase>;
class AudioEncoderClientInterfaceBase {};

using AudioEncoderClientPtrDataView =
    mojo::InterfacePtrDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientRequestDataView =
    mojo::InterfaceRequestDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioEncoderClientInterfaceBase>;
using AudioEncoderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioEncoderClientInterfaceBase>;


class AacAudioEncoderConfigDataView {
 public:
  AacAudioEncoderConfigDataView() = default;

  AacAudioEncoderConfigDataView(
      internal::AacAudioEncoderConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::media::mojom::AacOutputFormat>(
        data_value, output);
  }
  AacOutputFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AacOutputFormat>(data_->format));
  }
 private:
  internal::AacAudioEncoderConfig_Data* data_ = nullptr;
};


class AudioEncoderConfigDataView {
 public:
  AudioEncoderConfigDataView() = default;

  AudioEncoderConfigDataView(
      internal::AudioEncoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::media::mojom::AudioCodec>(
        data_value, output);
  }
  ::media::mojom::AudioCodec codec() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::AudioCodec>(data_->codec));
  }
  uint8_t channel_count() const {
    return data_->channel_count;
  }
  uint32_t sample_rate() const {
    return data_->sample_rate;
  }
  uint32_t bitrate() const {
    return data_->bitrate;
  }
  inline void GetAacDataView(
      AacAudioEncoderConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAac(UserType* output) {
    
    auto* pointer = data_->aac.Get();
    return mojo::internal::Deserialize<::media::mojom::AacAudioEncoderConfigDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioEncoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EncodedAudioBufferDataView {
 public:
  EncodedAudioBufferDataView() = default;

  EncodedAudioBufferDataView(
      internal::EncodedAudioBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::EncodedAudioBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::AacOutputFormat>
    : public mojo::internal::EnumHashImpl<::media::mojom::AacOutputFormat> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AacOutputFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::AacOutputFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::AacOutputFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AacAudioEncoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AacAudioEncoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AacAudioEncoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::AacOutputFormat>(
        Traits::format(input), &fragment->format);
  }

  static bool Deserialize(::media::mojom::internal::AacAudioEncoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AacAudioEncoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::AudioEncoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::AudioEncoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::AudioEncoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::AudioCodec>(
        Traits::codec(input), &fragment->codec);
    fragment->channel_count = Traits::channel_count(input);
    fragment->sample_rate = Traits::sample_rate(input);
    fragment->bitrate = Traits::bitrate(input);
    decltype(Traits::aac(input)) in_aac = Traits::aac(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aac)::BaseType> aac_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::AacAudioEncoderConfigDataView>(
        in_aac, aac_fragment);
    fragment->aac.Set(
        aac_fragment.is_null() ? nullptr : aac_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->aac.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null aac in AudioEncoderConfig struct");
  }

  static bool Deserialize(::media::mojom::internal::AudioEncoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::AudioEncoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EncodedAudioBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::EncodedAudioBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::EncodedAudioBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType> params_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
        in_params, params_fragment);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in EncodedAudioBuffer struct");
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in EncodedAudioBuffer struct");
    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_duration, duration_fragment);
    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in EncodedAudioBuffer struct");
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_data, data_fragment, &data_validate_params);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in EncodedAudioBuffer struct");
  }

  static bool Deserialize(::media::mojom::internal::EncodedAudioBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::EncodedAudioBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {



inline void AudioEncoderConfigDataView::GetAacDataView(
    AacAudioEncoderConfigDataView* output) {
  auto pointer = data_->aac.Get();
  *output = AacAudioEncoderConfigDataView(pointer, message_);
}


inline void EncodedAudioBufferDataView::GetParamsDataView(
    ::media::mojom::AudioParametersDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::media::mojom::AudioParametersDataView(pointer, message_);
}
inline void EncodedAudioBufferDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void EncodedAudioBufferDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void EncodedAudioBufferDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::AacOutputFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::AacOutputFormat value);
};

} // namespace perfetto

#endif  // MEDIA_MOJO_MOJOM_AUDIO_ENCODER_MOJOM_SHARED_H_