// media/mojo/mojom/speech_recognition_service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_service.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_service.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_service.mojom-blink-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/audio_data.mojom-blink-forward.h"
#include "media/mojo/mojom/audio_parameters.mojom-blink.h"
#include "media/mojo/mojom/audio_stream_factory.mojom-blink-forward.h"
#include "media/mojo/mojom/media_types.mojom-blink-forward.h"
#include "media/mojo/mojom/speech_recognition.mojom-blink-forward.h"
#include "mojo/public/mojom/base/file_path.mojom-blink.h"
#include "sandbox/policy/mojom/context.mojom-blink-forward.h"
#include "sandbox/policy/mojom/sandbox.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {

class AudioSourceSpeechRecognitionContextProxy;

template <typename ImplRefTraits>
class AudioSourceSpeechRecognitionContextStub;

class AudioSourceSpeechRecognitionContextRequestValidator;
class AudioSourceSpeechRecognitionContextResponseValidator;


class BLINK_PLATFORM_EXPORT AudioSourceSpeechRecognitionContext
    : public AudioSourceSpeechRecognitionContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioSourceSpeechRecognitionContextInterfaceBase;
  using Proxy_ = AudioSourceSpeechRecognitionContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioSourceSpeechRecognitionContextStub<ImplRefTraits>;

  using RequestValidator_ = AudioSourceSpeechRecognitionContextRequestValidator;
  using ResponseValidator_ = AudioSourceSpeechRecognitionContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindAudioSourceFetcherMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAudioSourceFetcher_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioSourceSpeechRecognitionContext() = default;


  using BindAudioSourceFetcherCallback = base::OnceCallback<void(bool)>;
  
  virtual void BindAudioSourceFetcher(::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> client, ::media::mojom::blink::SpeechRecognitionOptionsPtr options, BindAudioSourceFetcherCallback callback) = 0;
};

class SpeechRecognitionServiceProxy;

template <typename ImplRefTraits>
class SpeechRecognitionServiceStub;

class SpeechRecognitionServiceRequestValidator;


class BLINK_PLATFORM_EXPORT SpeechRecognitionService
    : public SpeechRecognitionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kSpeechRecognition;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeechRecognitionServiceInterfaceBase;
  using Proxy_ = SpeechRecognitionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechRecognitionServiceStub<ImplRefTraits>;

  using RequestValidator_ = SpeechRecognitionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindSpeechRecognitionContextMinVersion = 0,
    kBindAudioSourceSpeechRecognitionContextMinVersion = 0,
    kSetSodaPathsMinVersion = 0,
    kSetSodaParamsMinVersion = 0,
    kSetSodaConfigPathsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindSpeechRecognitionContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindAudioSourceSpeechRecognitionContext_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSodaPaths_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSodaParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSodaConfigPaths_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeechRecognitionService() = default;

  
  virtual void BindSpeechRecognitionContext(::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext> context) = 0;

  
  virtual void BindAudioSourceSpeechRecognitionContext(::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext> context) = 0;

  
  virtual void SetSodaPaths(const ::base::FilePath& binary_path, const WTF::HashMap<WTF::String, ::base::FilePath>& config_paths, const WTF::String& primary_language_name) = 0;

  
  virtual void SetSodaParams(bool mask_offensive_words) = 0;

  
  virtual void SetSodaConfigPaths(const WTF::HashMap<WTF::String, ::base::FilePath>& config_paths) = 0;
};

class AudioSourceFetcherProxy;

template <typename ImplRefTraits>
class AudioSourceFetcherStub;

class AudioSourceFetcherRequestValidator;


class BLINK_PLATFORM_EXPORT AudioSourceFetcher
    : public AudioSourceFetcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioSourceFetcherInterfaceBase;
  using Proxy_ = AudioSourceFetcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioSourceFetcherStub<ImplRefTraits>;

  using RequestValidator_ = AudioSourceFetcherRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartMinVersion = 0,
    kStopMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Start_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Stop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioSourceFetcher() = default;

  
  virtual void Start(::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> factory, const WTF::String& device_id, const ::media::AudioParameters& audio_parameters) = 0;

  
  virtual void Stop() = 0;
};



class BLINK_PLATFORM_EXPORT AudioSourceSpeechRecognitionContextProxy
    : public AudioSourceSpeechRecognitionContext {
 public:
  using InterfaceType = AudioSourceSpeechRecognitionContext;

  explicit AudioSourceSpeechRecognitionContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAudioSourceFetcher(::mojo::PendingReceiver<AudioSourceFetcher> fetcher_receiver, ::mojo::PendingRemote<::media::mojom::blink::SpeechRecognitionRecognizerClient> client, ::media::mojom::blink::SpeechRecognitionOptionsPtr options, BindAudioSourceFetcherCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT SpeechRecognitionServiceProxy
    : public SpeechRecognitionService {
 public:
  using InterfaceType = SpeechRecognitionService;

  explicit SpeechRecognitionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindSpeechRecognitionContext(::mojo::PendingReceiver<::media::mojom::blink::SpeechRecognitionContext> context) final;
  
  void BindAudioSourceSpeechRecognitionContext(::mojo::PendingReceiver<AudioSourceSpeechRecognitionContext> context) final;
  
  void SetSodaPaths(const ::base::FilePath& binary_path, const WTF::HashMap<WTF::String, ::base::FilePath>& config_paths, const WTF::String& primary_language_name) final;
  
  void SetSodaParams(bool mask_offensive_words) final;
  
  void SetSodaConfigPaths(const WTF::HashMap<WTF::String, ::base::FilePath>& config_paths) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AudioSourceFetcherProxy
    : public AudioSourceFetcher {
 public:
  using InterfaceType = AudioSourceFetcher;

  explicit AudioSourceFetcherProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Start(::mojo::PendingRemote<::media::mojom::blink::AudioStreamFactory> factory, const WTF::String& device_id, const ::media::AudioParameters& audio_parameters) final;
  
  void Stop() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT AudioSourceSpeechRecognitionContextStubDispatch {
 public:
  static bool Accept(AudioSourceSpeechRecognitionContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioSourceSpeechRecognitionContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioSourceSpeechRecognitionContext>>
class AudioSourceSpeechRecognitionContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioSourceSpeechRecognitionContextStub() = default;
  ~AudioSourceSpeechRecognitionContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioSourceSpeechRecognitionContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioSourceSpeechRecognitionContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SpeechRecognitionServiceStubDispatch {
 public:
  static bool Accept(SpeechRecognitionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechRecognitionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechRecognitionService>>
class SpeechRecognitionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechRecognitionServiceStub() = default;
  ~SpeechRecognitionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechRecognitionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioSourceFetcherStubDispatch {
 public:
  static bool Accept(AudioSourceFetcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioSourceFetcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioSourceFetcher>>
class AudioSourceFetcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioSourceFetcherStub() = default;
  ~AudioSourceFetcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioSourceFetcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioSourceFetcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioSourceSpeechRecognitionContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SpeechRecognitionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioSourceFetcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioSourceSpeechRecognitionContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_SERVICE_MOJOM_BLINK_H_