// mojo/public/mojom/base/safe_base_name.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MOJO_PUBLIC_MOJOM_BASE_SAFE_BASE_NAME_MOJOM_SHARED_H_
#define MOJO_PUBLIC_MOJOM_BASE_SAFE_BASE_NAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "mojo/public/mojom/base/safe_base_name.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"



#include "base/component_export.h"




namespace mojo_base::mojom {
class SafeBaseNameDataView;



}  // mojo_base::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojo_base::mojom::SafeBaseNameDataView> {
  using Data = ::mojo_base::mojom::internal::SafeBaseName_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojo_base::mojom {


class SafeBaseNameDataView {
 public:
  SafeBaseNameDataView() = default;

  SafeBaseNameDataView(
      internal::SafeBaseName_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
 private:
  internal::SafeBaseName_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojo_base::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojo_base::mojom::SafeBaseNameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojo_base::mojom::SafeBaseNameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojo_base::mojom::internal::SafeBaseName_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in SafeBaseName struct");
  }

  static bool Deserialize(::mojo_base::mojom::internal::SafeBaseName_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojo_base::mojom::SafeBaseNameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojo_base::mojom {

inline void SafeBaseNameDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}



}  // mojo_base::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MOJO_PUBLIC_MOJOM_BASE_SAFE_BASE_NAME_MOJOM_SHARED_H_