// services/data_decoder/public/mojom/image_decoder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_SHARED_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/image_decoder.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace data_decoder::mojom {
class AnimationFrameDataView;



}  // data_decoder::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::data_decoder::mojom::AnimationFrameDataView> {
  using Data = ::data_decoder::mojom::internal::AnimationFrame_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace data_decoder::mojom {


enum class ImageCodec : int32_t {
  
  kDefault = 0,
  
  kPng = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ImageCodec value);
inline bool IsKnownEnumValue(ImageCodec value) {
  return internal::ImageCodec_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ImageDecoderInterfaceBase {};

using ImageDecoderPtrDataView =
    mojo::InterfacePtrDataView<ImageDecoderInterfaceBase>;
using ImageDecoderRequestDataView =
    mojo::InterfaceRequestDataView<ImageDecoderInterfaceBase>;
using ImageDecoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageDecoderInterfaceBase>;
using ImageDecoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageDecoderInterfaceBase>;


class AnimationFrameDataView {
 public:
  AnimationFrameDataView() = default;

  AnimationFrameDataView(
      internal::AnimationFrame_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitmapDataView(
      ::skia::mojom::InlineBitmapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::InlineBitmapDataView>(
        pointer, output, message_);
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AnimationFrame_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // data_decoder::mojom

namespace std {

template <>
struct hash<::data_decoder::mojom::ImageCodec>
    : public mojo::internal::EnumHashImpl<::data_decoder::mojom::ImageCodec> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_decoder::mojom::ImageCodec, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::data_decoder::mojom::ImageCodec, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::data_decoder::mojom::ImageCodec>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_decoder::mojom::AnimationFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_decoder::mojom::AnimationFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_decoder::mojom::internal::AnimationFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::InlineBitmapDataView>(
        in_bitmap, bitmap_fragment);
    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bitmap.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitmap in AnimationFrame struct");
    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_duration, duration_fragment);
    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in AnimationFrame struct");
  }

  static bool Deserialize(::data_decoder::mojom::internal::AnimationFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_decoder::mojom::AnimationFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace data_decoder::mojom {

inline void AnimationFrameDataView::GetBitmapDataView(
    ::skia::mojom::InlineBitmapDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::InlineBitmapDataView(pointer, message_);
}
inline void AnimationFrameDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // data_decoder::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::data_decoder::mojom::ImageCodec> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::data_decoder::mojom::ImageCodec value);
};

} // namespace perfetto

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_SHARED_H_