// services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/connection_endpoint_metadata.mojom-shared.h"







namespace network::mojom {
class HostResolverEndpointResultDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HostResolverEndpointResultDataView> {
  using Data = ::network::mojom::internal::HostResolverEndpointResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class HostResolverEndpointResultDataView {
 public:
  HostResolverEndpointResultDataView() = default;

  HostResolverEndpointResultDataView(
      internal::HostResolverEndpointResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIpEndpointsDataView(
      mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIpEndpoints(UserType* output) {
    
    auto* pointer = data_->ip_endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::network::mojom::ConnectionEndpointMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::network::mojom::ConnectionEndpointMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::HostResolverEndpointResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HostResolverEndpointResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HostResolverEndpointResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HostResolverEndpointResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::ip_endpoints(input)) in_ip_endpoints = Traits::ip_endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ip_endpoints)::BaseType>
        ip_endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ip_endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
        in_ip_endpoints, ip_endpoints_fragment, &ip_endpoints_validate_params);
    fragment->ip_endpoints.Set(
        ip_endpoints_fragment.is_null() ? nullptr : ip_endpoints_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ip_endpoints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ip_endpoints in HostResolverEndpointResult struct");
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ConnectionEndpointMetadataDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in HostResolverEndpointResult struct");
  }

  static bool Deserialize(::network::mojom::internal::HostResolverEndpointResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HostResolverEndpointResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void HostResolverEndpointResultDataView::GetIpEndpointsDataView(
    mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output) {
  auto pointer = data_->ip_endpoints.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPEndPointDataView>(pointer, message_);
}
inline void HostResolverEndpointResultDataView::GetMetadataDataView(
    ::network::mojom::ConnectionEndpointMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::network::mojom::ConnectionEndpointMetadataDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_SHARED_H_