// services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace viz::mojom {
class ContentFrameIntervalInfoDataView;

class FrameIntervalInputsDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::ContentFrameIntervalInfoDataView> {
  using Data = ::viz::mojom::internal::ContentFrameIntervalInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::FrameIntervalInputsDataView> {
  using Data = ::viz::mojom::internal::FrameIntervalInputs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class ContentFrameIntervalType : int32_t {
  
  kVideo = 0,
  
  kAnimatingImage = 1,
  
  kScrollBarFadeOutAnimation = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ContentFrameIntervalType value);
inline bool IsKnownEnumValue(ContentFrameIntervalType value) {
  return internal::ContentFrameIntervalType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ContentFrameIntervalInfoDataView {
 public:
  ContentFrameIntervalInfoDataView() = default;

  ContentFrameIntervalInfoDataView(
      internal::ContentFrameIntervalInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::ContentFrameIntervalType>(
        data_value, output);
  }
  ContentFrameIntervalType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::ContentFrameIntervalType>(data_->type));
  }
  inline void GetFrameIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterval(UserType* output) {
    
    auto* pointer = data_->frame_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint32_t duplicate_count() const {
    return data_->duplicate_count;
  }
 private:
  internal::ContentFrameIntervalInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameIntervalInputsDataView {
 public:
  FrameIntervalInputsDataView() = default;

  FrameIntervalInputsDataView(
      internal::FrameIntervalInputs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTime(UserType* output) {
    
    auto* pointer = data_->frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  bool has_input() const {
    return data_->has_input;
  }
  inline void GetContentIntervalInfoDataView(
      mojo::ArrayDataView<ContentFrameIntervalInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentIntervalInfo(UserType* output) {
    
    auto* pointer = data_->content_interval_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::ContentFrameIntervalInfoDataView>>(
        pointer, output, message_);
  }
  bool has_only_content_frame_interval_updates() const {
    return data_->has_only_content_frame_interval_updates;
  }
 private:
  internal::FrameIntervalInputs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::ContentFrameIntervalType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::ContentFrameIntervalType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ContentFrameIntervalType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::ContentFrameIntervalType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::ContentFrameIntervalType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::ContentFrameIntervalInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::ContentFrameIntervalInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::ContentFrameIntervalInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::viz::mojom::ContentFrameIntervalType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::frame_interval(input)) in_frame_interval = Traits::frame_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interval)::BaseType> frame_interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_frame_interval, frame_interval_fragment);
    fragment->frame_interval.Set(
        frame_interval_fragment.is_null() ? nullptr : frame_interval_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_interval.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_interval in ContentFrameIntervalInfo struct");
    fragment->duplicate_count = Traits::duplicate_count(input);
  }

  static bool Deserialize(::viz::mojom::internal::ContentFrameIntervalInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::ContentFrameIntervalInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameIntervalInputsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameIntervalInputsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameIntervalInputs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_time(input)) in_frame_time = Traits::frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_time)::BaseType> frame_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_frame_time, frame_time_fragment);
    fragment->frame_time.Set(
        frame_time_fragment.is_null() ? nullptr : frame_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_time in FrameIntervalInputs struct");
    fragment->has_input = Traits::has_input(input);
    decltype(Traits::content_interval_info(input)) in_content_interval_info = Traits::content_interval_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_interval_info)::BaseType>
        content_interval_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& content_interval_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ContentFrameIntervalInfoDataView>>(
        in_content_interval_info, content_interval_info_fragment, &content_interval_info_validate_params);
    fragment->content_interval_info.Set(
        content_interval_info_fragment.is_null() ? nullptr : content_interval_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->content_interval_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_interval_info in FrameIntervalInputs struct");
    fragment->has_only_content_frame_interval_updates = Traits::has_only_content_frame_interval_updates(input);
  }

  static bool Deserialize(::viz::mojom::internal::FrameIntervalInputs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameIntervalInputsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void ContentFrameIntervalInfoDataView::GetFrameIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->frame_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void FrameIntervalInputsDataView::GetFrameTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->frame_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void FrameIntervalInputsDataView::GetContentIntervalInfoDataView(
    mojo::ArrayDataView<ContentFrameIntervalInfoDataView>* output) {
  auto pointer = data_->content_interval_info.Get();
  *output = mojo::ArrayDataView<ContentFrameIntervalInfoDataView>(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::ContentFrameIntervalType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::ContentFrameIntervalType value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_SHARED_H_