// storage/browser/quota/quota_manager_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "storage/browser/quota/quota_manager_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "storage/browser/quota/quota_manager_observer.mojom-params-data.h"
#include "storage/browser/quota/quota_manager_observer.mojom-shared-message-ids.h"

#include "storage/browser/quota/quota_manager_observer.mojom-import-headers.h"
#include "storage/browser/quota/quota_manager_observer.mojom-test-utils.h"


namespace storage::mojom {
const char QuotaManagerObserver::Name_[] = "storage.mojom.QuotaManagerObserver";

QuotaManagerObserver::IPCStableHashFunction QuotaManagerObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::QuotaManagerObserver>(message.name())) {
    case messages::QuotaManagerObserver::kOnCreateOrUpdateBucket: {
      return &QuotaManagerObserver::OnCreateOrUpdateBucket_Sym::IPCStableHash;
    }
    case messages::QuotaManagerObserver::kOnDeleteBucket: {
      return &QuotaManagerObserver::OnDeleteBucket_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* QuotaManagerObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::QuotaManagerObserver>(message.name())) {
      case messages::QuotaManagerObserver::kOnCreateOrUpdateBucket:
            return "Receive storage::mojom::QuotaManagerObserver::OnCreateOrUpdateBucket";
      case messages::QuotaManagerObserver::kOnDeleteBucket:
            return "Receive storage::mojom::QuotaManagerObserver::OnDeleteBucket";
    }
  } else {
    switch (static_cast<messages::QuotaManagerObserver>(message.name())) {
      case messages::QuotaManagerObserver::kOnCreateOrUpdateBucket:
            return "Receive reply storage::mojom::QuotaManagerObserver::OnCreateOrUpdateBucket";
      case messages::QuotaManagerObserver::kOnDeleteBucket:
            return "Receive reply storage::mojom::QuotaManagerObserver::OnDeleteBucket";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t QuotaManagerObserver::OnCreateOrUpdateBucket_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaManagerObserver::OnCreateOrUpdateBucket");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaManagerObserver::OnDeleteBucket_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaManagerObserver::OnDeleteBucket");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

QuotaManagerObserverProxy::QuotaManagerObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaManagerObserverProxy::OnCreateOrUpdateBucket(
    const ::storage::BucketInfo& in_bucket_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaManagerObserver::OnCreateOrUpdateBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_info"), in_bucket_info,
                        "<value of type const ::storage::BucketInfo&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaManagerObserver::kOnCreateOrUpdateBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaManagerObserver_OnCreateOrUpdateBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_info)::BaseType> bucket_info_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketInfoDataView>(
      in_bucket_info, bucket_info_fragment);
  params->bucket_info.Set(
      bucket_info_fragment.is_null() ? nullptr : bucket_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_info in QuotaManagerObserver.OnCreateOrUpdateBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerObserver::Name_);
  message.set_method_name("OnCreateOrUpdateBucket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void QuotaManagerObserverProxy::OnDeleteBucket(
    const ::storage::BucketLocator& in_bucket_locator) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaManagerObserver::OnDeleteBucket", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket_locator"), in_bucket_locator,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaManagerObserver::kOnDeleteBucket), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaManagerObserver_OnDeleteBucket_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket_locator)::BaseType> bucket_locator_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket_locator, bucket_locator_fragment);
  params->bucket_locator.Set(
      bucket_locator_fragment.is_null() ? nullptr : bucket_locator_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket_locator.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket_locator in QuotaManagerObserver.OnDeleteBucket request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaManagerObserver::Name_);
  message.set_method_name("OnDeleteBucket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool QuotaManagerObserverStubDispatch::Accept(
    QuotaManagerObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::QuotaManagerObserver>(message->header()->name)) {
    case messages::QuotaManagerObserver::kOnCreateOrUpdateBucket: {
      DCHECK(message->is_serialized());
      internal::QuotaManagerObserver_OnCreateOrUpdateBucket_Params_Data* params =
          reinterpret_cast<internal::QuotaManagerObserver_OnCreateOrUpdateBucket_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for QuotaManagerObserver.0
      bool success = true;
      ::storage::BucketInfo p_bucket_info{};
      QuotaManagerObserver_OnCreateOrUpdateBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketInfo(&p_bucket_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCreateOrUpdateBucket(        
        std::move(p_bucket_info));
      return true;
    }
    case messages::QuotaManagerObserver::kOnDeleteBucket: {
      DCHECK(message->is_serialized());
      internal::QuotaManagerObserver_OnDeleteBucket_Params_Data* params =
          reinterpret_cast<internal::QuotaManagerObserver_OnDeleteBucket_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for QuotaManagerObserver.1
      bool success = true;
      ::storage::BucketLocator p_bucket_locator{};
      QuotaManagerObserver_OnDeleteBucket_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucketLocator(&p_bucket_locator))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaManagerObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeleteBucket(        
        std::move(p_bucket_locator));
      return true;
    }
  }
  return false;
}

// static
bool QuotaManagerObserverStubDispatch::AcceptWithResponder(
    QuotaManagerObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::QuotaManagerObserver>(message->header()->name)) {
    case messages::QuotaManagerObserver::kOnCreateOrUpdateBucket: {
      break;
    }
    case messages::QuotaManagerObserver::kOnDeleteBucket: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuotaManagerObserverValidationInfo[] = {
    {base::to_underlying(messages::QuotaManagerObserver::kOnCreateOrUpdateBucket),
     { &internal::QuotaManagerObserver_OnCreateOrUpdateBucket_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::QuotaManagerObserver::kOnDeleteBucket),
     { &internal::QuotaManagerObserver_OnDeleteBucket_Params_Data::Validate,
      nullptr /* no response */}},
};

bool QuotaManagerObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaManagerObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuotaManagerObserverValidationInfo);
}



}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void QuotaManagerObserverInterceptorForTesting::OnCreateOrUpdateBucket(const ::storage::BucketInfo& bucket_info) {
  GetForwardingInterface()->OnCreateOrUpdateBucket(
    std::move(bucket_info)
    );
}
void QuotaManagerObserverInterceptorForTesting::OnDeleteBucket(const ::storage::BucketLocator& bucket_locator) {
  GetForwardingInterface()->OnDeleteBucket(
    std::move(bucket_locator)
    );
}
QuotaManagerObserverAsyncWaiter::QuotaManagerObserverAsyncWaiter(
    QuotaManagerObserver* proxy) : proxy_(proxy) {}

QuotaManagerObserverAsyncWaiter::~QuotaManagerObserverAsyncWaiter() = default;






}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif