/* THIS FILE IS AUTOGENERATED FROM CSS.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "CSSBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CSS.h"
#include "mozilla/dom/CSSUnitValue.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/HighlightRegistry.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



PropertyDefinition::PropertyDefinition()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
PropertyDefinition::InitIds(JSContext* cx, PropertyDefinitionAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->syntax_id.init(cx, "syntax") ||
      !atomsCache->name_id.init(cx, "name") ||
      !atomsCache->initialValue_id.init(cx, "initialValue") ||
      !atomsCache->inherits_id.init(cx, "inherits")) {
    return false;
  }
  return true;
}

bool
PropertyDefinition::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  PropertyDefinitionAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<PropertyDefinitionAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->inherits_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'inherits' member of PropertyDefinition", &mInherits)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'inherits' member of PropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->initialValue_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mInitialValue.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mInitialValue.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of PropertyDefinition");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->syntax_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mSyntax)) {
      return false;
    }
  } else {
    mSyntax.AssignLiteral("*");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
PropertyDefinition::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
PropertyDefinition::TraceDictionary(JSTracer* trc)
{
}

PropertyDefinition&
PropertyDefinition::operator=(const PropertyDefinition& aOther)
{
  DictionaryBase::operator=(aOther);
  mInherits = aOther.mInherits;
  mInitialValue.Reset();
  if (aOther.mInitialValue.WasPassed()) {
    mInitialValue.Construct(aOther.mInitialValue.Value());
  }
  mName = aOther.mName;
  mSyntax = aOther.mSyntax;
  return *this;
}


namespace CSS_Binding {

MOZ_CAN_RUN_SCRIPT static bool
supports(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.supports");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "supports", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 1: {
      GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
      if (global.Failed()) {
        return false;
      }

      binding_detail::FakeString<char> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      bool result(mozilla::dom::CSS::Supports(global, Constify(arg0)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    case 2: {
      GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
      if (global.Failed()) {
        return false;
      }

      binding_detail::FakeString<char> arg0;
      if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
        return false;
      }
      binding_detail::FakeString<char> arg1;
      if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
        return false;
      }
      bool result(mozilla::dom::CSS::Supports(global, Constify(arg0), Constify(arg1)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
escape(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "escape", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.escape", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::CSS::Escape(global, NonNullHelper(Constify(arg0)), result))>, "Should be returning void here");
  mozilla::dom::CSS::Escape(global, NonNullHelper(Constify(arg0)), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
get_highlights(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "highlights", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::HighlightRegistry>(mozilla::dom::CSS::GetHighlights(global, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSS.highlights getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
registerProperty(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.registerProperty");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "registerProperty", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.registerProperty", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  binding_detail::FastPropertyDefinition arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::CSS::RegisterProperty(global, Constify(arg0), rv))>, "Should be returning void here");
  mozilla::dom::CSS::RegisterProperty(global, Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "CSS.registerProperty"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
number(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.number");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "number", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.number", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Number(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
percent(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.percent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "percent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.percent", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Percent(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cap(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cap");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cap", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cap(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
ch(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.ch");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "ch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.ch", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Ch(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
em(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.em");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "em", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.em", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Em(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
ex(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.ex");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "ex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.ex", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Ex(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
ic(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.ic");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "ic", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.ic", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Ic(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rcap(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rcap");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rcap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rcap", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rcap(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rch(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rch");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rch", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rch(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rem(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rem");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rem", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rem", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rem(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rex(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rex");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rex", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rex", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rex(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
ric(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.ric");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "ric", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.ric", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Ric(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rlh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rlh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rlh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rlh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rlh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vw(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vw");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vw", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vw", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vw(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vb", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vb(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vmin(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vmin");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vmin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vmin", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vmin(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
vmax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.vmax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "vmax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.vmax", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Vmax(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svw(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svw");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svw", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svw", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svw(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svb", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svb(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svmin(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svmin");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svmin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svmin", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svmin(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
svmax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.svmax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "svmax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.svmax", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Svmax(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvw(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvw");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvw", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvw", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvw(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvb", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvb(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvmin(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvmin");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvmin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvmin", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvmin(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
lvmax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.lvmax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "lvmax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.lvmax", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Lvmax(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvw(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvw");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvw", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvw", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvw(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvb", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvb(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvmin(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvmin");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvmin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvmin", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvmin(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dvmax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dvmax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dvmax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dvmax", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dvmax(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqw(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqw");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqw", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqw", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqw(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqh(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqh");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqh", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqh", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqh(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqb(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqb");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqb", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqb", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqb(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqmin(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqmin");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqmin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqmin", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqmin(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cqmax(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cqmax");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cqmax", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cqmax", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cqmax(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
cm(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.cm");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "cm", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.cm", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Cm(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
mm(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.mm");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "mm", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.mm", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Mm(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
Q(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.Q");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "Q", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.Q", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Q(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
in(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.in");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "in", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.in", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::In(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
pt(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.pt");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "pt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.pt", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Pt(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
pc(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.pc");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "pc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.pc", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Pc(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
px(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.px");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "px", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.px", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Px(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
deg(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.deg");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "deg", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.deg", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Deg(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
grad(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.grad");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "grad", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.grad", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Grad(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
rad(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.rad");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "rad", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.rad", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Rad(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
turn(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.turn");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "turn", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.turn", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Turn(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
s(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.s");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "s", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.s", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::S(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
ms(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.ms");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "ms", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.ms", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Ms(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
Hz(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.Hz");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "Hz", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.Hz", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Hz(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
kHz(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.kHz");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "kHz", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.kHz", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::KHz(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dpi(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dpi");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dpi", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dpi", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dpi(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dpcm(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dpcm");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dpcm", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dpcm", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dpcm(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
dppx(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.dppx");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "dppx", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.dppx", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Dppx(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
fr(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "CSS.fr");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "CSS", "fr", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "CSS.fr", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CSSUnitValue>(mozilla::dom::CSS::Fr(global, arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("supports", supports, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("escape", escape, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("registerProperty", registerProperty, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("number", number, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("percent", percent, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cap", cap, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ch", ch, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("em", em, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ex", ex, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ic", ic, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lh", lh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rcap", rcap, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rch", rch, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rem", rem, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rex", rex, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ric", ric, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rlh", rlh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vw", vw, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vh", vh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vi", vi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vb", vb, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vmin", vmin, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("vmax", vmax, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svw", svw, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svh", svh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svi", svi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svb", svb, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svmin", svmin, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("svmax", svmax, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvw", lvw, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvh", lvh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvi", lvi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvb", lvb, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvmin", lvmin, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lvmax", lvmax, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvw", dvw, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvh", dvh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvi", dvi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvb", dvb, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvmin", dvmin, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dvmax", dvmax, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqw", cqw, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqh", cqh, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqi", cqi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqb", cqb, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqmin", cqmin, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cqmax", cqmax, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("cm", cm, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("mm", mm, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("Q", Q, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("in", in, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("pt", pt, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("pc", pc, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("px", px, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("deg", deg, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("grad", grad, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rad", rad, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("turn", turn, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("s", s, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ms", ms, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("Hz", Hz, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("kHz", kHz, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dpi", dpi, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dpcm", dpcm, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("dppx", dppx, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fr", fr, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sStaticMethods_disablers3 = {
  WebIDLPrefIndex::layout_css_properties_and_values_enabled, 0, false, OriginTrial(0), nullptr
};

static const PrefableDisablers sStaticMethods_disablers5 = {
  WebIDLPrefIndex::layout_css_typed_om_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { &sStaticMethods_disablers3, &sStaticMethods_specs[3] },
  { &sStaticMethods_disablers5, &sStaticMethods_specs[5] },
  { nullptr, nullptr }
};

static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(63 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sStaticAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("highlights", JSPROP_ENUMERATE, get_highlights, nullptr, nullptr, nullptr),
  JS_PS_END
};

static const PrefableDisablers sStaticAttributes_disablers0 = {
  WebIDLPrefIndex::dom_customHighlightAPI_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sStaticAttributes[] = {
  { &sStaticAttributes_disablers0, &sStaticAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[67];
static PropertyInfo sNativeProperties_propertyInfos[67];

static const NativePropertiesN<2> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  true,  1 /* sStaticAttributes */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  67,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] },
    { sStaticAttributes, &sNativeProperties_propertyInfos[66] }
  }
};
static_assert(67 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::CSS,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "CSS",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::CSS);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             nullptr,
                             "CSS",
                             aDefineOnGlobal != DefineInterfaceProperty::No);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::CSS,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace CSS_Binding



} // namespace mozilla::dom
