// python wrapper for ttkMandatoryCriticalPoints
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMandatoryCriticalPoints.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMandatoryCriticalPoints(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMandatoryCriticalPoints_ClassNew(); }


static PyObject *
PyttkMandatoryCriticalPoints_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMandatoryCriticalPoints::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMandatoryCriticalPoints::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMandatoryCriticalPoints *tempr = ttkMandatoryCriticalPoints::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMandatoryCriticalPoints *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMandatoryCriticalPoints::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMandatoryCriticalPoints::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMandatoryCriticalPoints::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SetSimplificationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSimplificationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSimplificationThreshold(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::SetSimplificationThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SetOutputMinimumComponentId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputMinimumComponentId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputMinimumComponentId(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::SetOutputMinimumComponentId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SetOutputJoinSaddleComponentId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputJoinSaddleComponentId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputJoinSaddleComponentId(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::SetOutputJoinSaddleComponentId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SetOutputSplitSaddleComponentId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputSplitSaddleComponentId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputSplitSaddleComponentId(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::SetOutputSplitSaddleComponentId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_SetOutputMaximumComponentId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputMaximumComponentId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputMaximumComponentId(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::SetOutputMaximumComponentId(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_setOutputAllMinimumComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "setOutputAllMinimumComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->setOutputAllMinimumComponents(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::setOutputAllMinimumComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_setOutputAllJoinSaddleComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "setOutputAllJoinSaddleComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->setOutputAllJoinSaddleComponents(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::setOutputAllJoinSaddleComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_setOutputAllSplitSaddleComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "setOutputAllSplitSaddleComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->setOutputAllSplitSaddleComponents(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::setOutputAllSplitSaddleComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMandatoryCriticalPoints_setOutputAllMaximumComponents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "setOutputAllMaximumComponents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMandatoryCriticalPoints *op = static_cast<ttkMandatoryCriticalPoints *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->setOutputAllMaximumComponents(temp0);
    }
    else
    {
      op->ttkMandatoryCriticalPoints::setOutputAllMaximumComponents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkMandatoryCriticalPoints_Methods[] = {
  {"IsTypeOf", PyttkMandatoryCriticalPoints_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMandatoryCriticalPoints_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMandatoryCriticalPoints_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMandatoryCriticalPoints\nC++: static ttkMandatoryCriticalPoints *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMandatoryCriticalPoints_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMandatoryCriticalPoints\nC++: ttkMandatoryCriticalPoints *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMandatoryCriticalPoints_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMandatoryCriticalPoints_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetSimplificationThreshold", PyttkMandatoryCriticalPoints_SetSimplificationThreshold, METH_VARARGS,
   "SetSimplificationThreshold(self, threshold:float) -> None\nC++: void SetSimplificationThreshold(double threshold)\n\n"},
  {"SetOutputMinimumComponentId", PyttkMandatoryCriticalPoints_SetOutputMinimumComponentId, METH_VARARGS,
   "SetOutputMinimumComponentId(self, id:int) -> None\nC++: void SetOutputMinimumComponentId(int id)\n\n"},
  {"SetOutputJoinSaddleComponentId", PyttkMandatoryCriticalPoints_SetOutputJoinSaddleComponentId, METH_VARARGS,
   "SetOutputJoinSaddleComponentId(self, id:int) -> None\nC++: void SetOutputJoinSaddleComponentId(int id)\n\n"},
  {"SetOutputSplitSaddleComponentId", PyttkMandatoryCriticalPoints_SetOutputSplitSaddleComponentId, METH_VARARGS,
   "SetOutputSplitSaddleComponentId(self, id:int) -> None\nC++: void SetOutputSplitSaddleComponentId(int id)\n\n"},
  {"SetOutputMaximumComponentId", PyttkMandatoryCriticalPoints_SetOutputMaximumComponentId, METH_VARARGS,
   "SetOutputMaximumComponentId(self, id:int) -> None\nC++: void SetOutputMaximumComponentId(int id)\n\n"},
  {"setOutputAllMinimumComponents", PyttkMandatoryCriticalPoints_setOutputAllMinimumComponents, METH_VARARGS,
   "setOutputAllMinimumComponents(self, outputAll:bool) -> None\nC++: void setOutputAllMinimumComponents(bool outputAll)\n\n"},
  {"setOutputAllJoinSaddleComponents", PyttkMandatoryCriticalPoints_setOutputAllJoinSaddleComponents, METH_VARARGS,
   "setOutputAllJoinSaddleComponents(self, outputAll:bool) -> None\nC++: void setOutputAllJoinSaddleComponents(bool outputAll)\n\n"},
  {"setOutputAllSplitSaddleComponents", PyttkMandatoryCriticalPoints_setOutputAllSplitSaddleComponents, METH_VARARGS,
   "setOutputAllSplitSaddleComponents(self, outputAll:bool) -> None\nC++: void setOutputAllSplitSaddleComponents(bool outputAll)\n\n"},
  {"setOutputAllMaximumComponents", PyttkMandatoryCriticalPoints_setOutputAllMaximumComponents, METH_VARARGS,
   "setOutputAllMaximumComponents(self, outputAll:bool) -> None\nC++: void setOutputAllMaximumComponents(bool outputAll)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMandatoryCriticalPoints_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("simplification_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMandatoryCriticalPoints_SetSimplificationThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMandatoryCriticalPoints_SetSimplificationThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSimplificationThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_minimum_component_id"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMandatoryCriticalPoints_SetOutputMinimumComponentId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMandatoryCriticalPoints_SetOutputMinimumComponentId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputMinimumComponentId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_join_saddle_component_id"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMandatoryCriticalPoints_SetOutputJoinSaddleComponentId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMandatoryCriticalPoints_SetOutputJoinSaddleComponentId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputJoinSaddleComponentId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_split_saddle_component_id"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMandatoryCriticalPoints_SetOutputSplitSaddleComponentId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMandatoryCriticalPoints_SetOutputSplitSaddleComponentId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputSplitSaddleComponentId\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_maximum_component_id"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMandatoryCriticalPoints_SetOutputMaximumComponentId(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMandatoryCriticalPoints_SetOutputMaximumComponentId(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputMaximumComponentId\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMandatoryCriticalPoints_Doc =
  "ttkMandatoryCriticalPoints - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Michael Michaux <michauxmichael89@gmail.com>\\author Julien\n"
  "Tierny <julien.tierny@lip6.fr>\\date August 2016.\n\n"
  "TTK VTK-filter for the computation of mandatory critical\n"
  "points in uncertain scalar data.\n\n"
  "This filter computes the mandatory critical points of uncertain\n"
  "scalar fields defined on triangulations. The input uncertain data is\n"
  "represented by reliable bound fields for each vertex. In particular,\n"
  "the input geometry must be associated with two point data scalar\n"
  "fields, representing the lower and upper bounds for each vertex.\n\n"
  "The output is a domain segmentation into the mandatory critical\n"
  "points.\n\n"
  "\\param Input Input uncertain scalar field represented by lower and\n"
  "    upper\n"
  "bounds, either 2D or 3D, either regular grid or triangulation\n"
  "(vtkDataSet) triangulation (vtkDataSet)\n"
  "\\param Output0 Output mandatory minimum segmentation (vtkDataSet)\n"
  "\\param Output1 Output mandatory join saddle segmentation (vtkDataSet)\n"
  "\\param Output2 Output mandatory split saddle segmentation\n"
  "    (vtkDataSet)\n"
  "\\param Output3 Output mandatory maximum segmentation (vtkDataSet)\n"
  "\\param Output4 Output mandatory join tree (vtkUnstructuredGrid)\n"
  "\\param Output5 Output mandatory split tree (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "The input data arrays needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 for the lowerBoundField, 1 for the upperBoundField\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Mandatory Critical Points of 2D Uncertain Scalar Fields\"\n\n"
  "David Guenther, Joseph Salmon, Julien Tierny\n\n"
  "Proc. of EuroVis 2014.\n\n"
  "Computer Graphics Forum, 2014.\n\n"
  "\\sa ttk::MandatoryCriticalPoints\n"
  "\\sa vtkUncertainDataEstimator\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/uncertainStartingVortex/\"\n"
  "  > Uncertain Starting Vortex example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMandatoryCriticalPoints_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMandatoryCriticalPoints.ttkMandatoryCriticalPoints", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMandatoryCriticalPoints_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMandatoryCriticalPoints_StaticNew()
{
  return ttkMandatoryCriticalPoints::New();
}

PyObject *PyttkMandatoryCriticalPoints_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMandatoryCriticalPoints_Type, PyttkMandatoryCriticalPoints_Methods,
    "ttkMandatoryCriticalPoints",
 &PyttkMandatoryCriticalPoints_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMandatoryCriticalPoints_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMandatoryCriticalPoints(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMandatoryCriticalPoints_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMandatoryCriticalPoints", o) != 0)
  {
    Py_DECREF(o);
  }

}

