//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////
// This file is generated by a script.  Do not edit directly.  Edit the
// wrapRange.template.cpp file to make changes.

#include "pxr/pxr.h"
#include "pxr/base/gf/range2d.h"
#include "pxr/base/gf/range2f.h"

#include "pxr/base/tf/hash.h"
#include "pxr/base/tf/pyUtils.h"
#include "pxr/base/tf/wrapTypeHelpers.h"
#include "pxr/base/tf/pyContainerConversions.h"

#include "pxr/external/boost/python/class.hpp"
#include "pxr/external/boost/python/copy_const_reference.hpp"
#include "pxr/external/boost/python/operators.hpp"
#include "pxr/external/boost/python/return_arg.hpp"

#include <string>

using std::string;

PXR_NAMESPACE_USING_DIRECTIVE

using namespace pxr_boost::python;

namespace {

static const int _dimension = 2;

static string _Repr(GfRange2d const &self) {
    return TF_PY_REPR_PREFIX + "Range2d(" +
        TfPyRepr(self.GetMin()) + ", " + TfPyRepr(self.GetMax()) + ")";
}

static GfRange2d __truediv__(const GfRange2d &self, double value)
{
    return self / value;
}

static GfRange2d& __itruediv__(GfRange2d &self, double value)
{
    return self /= value;
}

static size_t __hash__(GfRange2d const &r) { return TfHash{}(r); }

} // anonymous namespace 

void wrapRange2d()
{    
    object getMin = make_function(&GfRange2d::GetMin,
                                  return_value_policy<return_by_value>());

    object getMax = make_function(&GfRange2d::GetMax,
                                  return_value_policy<return_by_value>());

    class_<GfRange2d> cls("Range2d", init<>());
    cls
        .def(init<GfRange2d>())
        .def(init<const GfVec2d &, const GfVec2d &>())

        .def(init<GfRange2f>())
        
        .def(TfTypePythonClass())

        .def_readonly("dimension", _dimension)
        
        .add_property("min", getMin, &GfRange2d::SetMin)
        .add_property("max", getMax, &GfRange2d::SetMax)

        .def("GetMin", getMin)
        .def("GetMax", getMax)

        .def("GetSize", &GfRange2d::GetSize)
        .def("GetMidpoint", &GfRange2d::GetMidpoint)
    
        .def("SetMin", &GfRange2d::SetMin)
        .def("SetMax", &GfRange2d::SetMax)
    
        .def("IsEmpty", &GfRange2d::IsEmpty)
    
        .def("SetEmpty", &GfRange2d::SetEmpty)

        .def("Contains", (bool (GfRange2d::*)(const GfVec2d &) const)
             &GfRange2d::Contains)
        .def("Contains", (bool (GfRange2d::*)(const GfRange2d &) const)
             &GfRange2d::Contains)
    
        .def("GetUnion", &GfRange2d::GetUnion)
        .staticmethod("GetUnion")
    
        .def("UnionWith", (const GfRange2d & (GfRange2d::*)(const GfVec2d &))
             &GfRange2d::UnionWith, return_self<>())
        .def("UnionWith", (const GfRange2d & (GfRange2d::*)(const GfRange2d &))
             &GfRange2d::UnionWith, return_self<>())
    
        .def("GetIntersection", &GfRange2d::GetIntersection)
        .staticmethod("GetIntersection")
    
        .def("IntersectWith", (const GfRange2d & (GfRange2d::*)(const GfRange2d &))
             &GfRange2d::IntersectWith, return_self<>())
    
        .def("GetDistanceSquared", &GfRange2d::GetDistanceSquared)
    
        .def(str(self))
        .def(self += self)
        .def(self -= self)
        .def(self *= double())
        .def(self /= double())
        .def(self + self)
        .def(self - self)
        .def(double() * self)
        .def(self * double())
        .def(self / double())
        .def(self == GfRange2f())
        .def(self != GfRange2f())
        .def(self == self)
        .def(self != self)
        .def("__repr__", _Repr)
        .def("__hash__", __hash__)

        .def("GetCorner", &GfRange2d::GetCorner)
        .def("GetQuadrant", &GfRange2d::GetQuadrant)
        .def_readonly("unitSquare", &GfRange2d::UnitSquare)
        
        ;
    to_python_converter<std::vector<GfRange2d>,
        TfPySequenceToPython<std::vector<GfRange2d> > >();

    if (!PyObject_HasAttrString(cls.ptr(), "__truediv__")) {
        // __truediv__ not added by .def( self / double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division"
        cls.def("__truediv__", __truediv__);
    }
    if (!PyObject_HasAttrString(cls.ptr(), "__itruediv__")) {
        // __itruediv__ not added by .def( self /= double() ) above, which
        // happens when building with python 2, but we need it to support
        // "from __future__ import division". This is also a workaround for a 
        // bug in the current version of pxr_boost::python that incorrectly wraps
        // in-place division with __idiv__ when building with python 3.
        cls.def("__itruediv__", __itruediv__, return_self<>());
    }

}
