//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialBindingSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialBindingSchemaTokens,
    HD_MATERIAL_BINDING_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdPathDataSourceHandle
HdMaterialBindingSchema::GetPath() const
{
    return _GetTypedDataSource<HdPathDataSource>(
        HdMaterialBindingSchemaTokens->path);
}

/*static*/
HdContainerDataSourceHandle
HdMaterialBindingSchema::BuildRetained(
        const HdPathDataSourceHandle &path
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (path) {
        _names[_count] = HdMaterialBindingSchemaTokens->path;
        _values[_count++] = path;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialBindingSchema::Builder &
HdMaterialBindingSchema::Builder::SetPath(
    const HdPathDataSourceHandle &path)
{
    _path = path;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialBindingSchema::Builder::Build()
{
    return HdMaterialBindingSchema::BuildRetained(
        _path
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE