//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/renderSettingsSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdRenderSettingsSchemaTokens,
    HD_RENDER_SETTINGS_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

TF_DEFINE_PRIVATE_TOKENS(
    _tokens,
    (frame)
);

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetFrameLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(_tokens->frame);
    return locator;
}

// --(END CUSTOM CODE: Schema Methods)--

HdContainerDataSourceHandle
HdRenderSettingsSchema::GetNamespacedSettings() const
{
    return _GetTypedDataSource<HdContainerDataSource>(
        HdRenderSettingsSchemaTokens->namespacedSettings);
}

HdBoolDataSourceHandle
HdRenderSettingsSchema::GetActive() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdRenderSettingsSchemaTokens->active);
}

HdRenderProductVectorSchema
HdRenderSettingsSchema::GetRenderProducts() const
{
    return HdRenderProductVectorSchema(_GetTypedDataSource<HdVectorDataSource>(
        HdRenderSettingsSchemaTokens->renderProducts));
}

HdTokenArrayDataSourceHandle
HdRenderSettingsSchema::GetIncludedPurposes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        HdRenderSettingsSchemaTokens->includedPurposes);
}

HdTokenArrayDataSourceHandle
HdRenderSettingsSchema::GetMaterialBindingPurposes() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        HdRenderSettingsSchemaTokens->materialBindingPurposes);
}

HdTokenDataSourceHandle
HdRenderSettingsSchema::GetRenderingColorSpace() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdRenderSettingsSchemaTokens->renderingColorSpace);
}

HdVec2dDataSourceHandle
HdRenderSettingsSchema::GetShutterInterval() const
{
    return _GetTypedDataSource<HdVec2dDataSource>(
        HdRenderSettingsSchemaTokens->shutterInterval);
}

/*static*/
HdContainerDataSourceHandle
HdRenderSettingsSchema::BuildRetained(
        const HdContainerDataSourceHandle &namespacedSettings,
        const HdBoolDataSourceHandle &active,
        const HdVectorDataSourceHandle &renderProducts,
        const HdTokenArrayDataSourceHandle &includedPurposes,
        const HdTokenArrayDataSourceHandle &materialBindingPurposes,
        const HdTokenDataSourceHandle &renderingColorSpace,
        const HdVec2dDataSourceHandle &shutterInterval
)
{
    TfToken _names[7];
    HdDataSourceBaseHandle _values[7];

    size_t _count = 0;

    if (namespacedSettings) {
        _names[_count] = HdRenderSettingsSchemaTokens->namespacedSettings;
        _values[_count++] = namespacedSettings;
    }

    if (active) {
        _names[_count] = HdRenderSettingsSchemaTokens->active;
        _values[_count++] = active;
    }

    if (renderProducts) {
        _names[_count] = HdRenderSettingsSchemaTokens->renderProducts;
        _values[_count++] = renderProducts;
    }

    if (includedPurposes) {
        _names[_count] = HdRenderSettingsSchemaTokens->includedPurposes;
        _values[_count++] = includedPurposes;
    }

    if (materialBindingPurposes) {
        _names[_count] = HdRenderSettingsSchemaTokens->materialBindingPurposes;
        _values[_count++] = materialBindingPurposes;
    }

    if (renderingColorSpace) {
        _names[_count] = HdRenderSettingsSchemaTokens->renderingColorSpace;
        _values[_count++] = renderingColorSpace;
    }

    if (shutterInterval) {
        _names[_count] = HdRenderSettingsSchemaTokens->shutterInterval;
        _values[_count++] = shutterInterval;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetNamespacedSettings(
    const HdContainerDataSourceHandle &namespacedSettings)
{
    _namespacedSettings = namespacedSettings;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetActive(
    const HdBoolDataSourceHandle &active)
{
    _active = active;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetRenderProducts(
    const HdVectorDataSourceHandle &renderProducts)
{
    _renderProducts = renderProducts;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetIncludedPurposes(
    const HdTokenArrayDataSourceHandle &includedPurposes)
{
    _includedPurposes = includedPurposes;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetMaterialBindingPurposes(
    const HdTokenArrayDataSourceHandle &materialBindingPurposes)
{
    _materialBindingPurposes = materialBindingPurposes;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetRenderingColorSpace(
    const HdTokenDataSourceHandle &renderingColorSpace)
{
    _renderingColorSpace = renderingColorSpace;
    return *this;
}

HdRenderSettingsSchema::Builder &
HdRenderSettingsSchema::Builder::SetShutterInterval(
    const HdVec2dDataSourceHandle &shutterInterval)
{
    _shutterInterval = shutterInterval;
    return *this;
}

HdContainerDataSourceHandle
HdRenderSettingsSchema::Builder::Build()
{
    return HdRenderSettingsSchema::BuildRetained(
        _namespacedSettings,
        _active,
        _renderProducts,
        _includedPurposes,
        _materialBindingPurposes,
        _renderingColorSpace,
        _shutterInterval
    );
}

/*static*/
HdRenderSettingsSchema
HdRenderSettingsSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdRenderSettingsSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdRenderSettingsSchemaTokens->renderSettings))
        : nullptr);
}

/*static*/
const TfToken &
HdRenderSettingsSchema::GetSchemaToken()
{
    return HdRenderSettingsSchemaTokens->renderSettings;
}

/*static*/
const HdDataSourceLocator &
HdRenderSettingsSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetNamespacedSettingsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->namespacedSettings);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetActiveLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->active);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetRenderProductsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->renderProducts);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetIncludedPurposesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->includedPurposes);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetMaterialBindingPurposesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->materialBindingPurposes);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetRenderingColorSpaceLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->renderingColorSpace);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdRenderSettingsSchema::GetShutterIntervalLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdRenderSettingsSchemaTokens->shutterInterval);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE