// Envelope.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef EnvelopeUI_h
#define EnvelopeUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009, Alan Calvert
// Copyright 2016-2024 Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "UI/ScaleTrackedWindow.h"
#include "UI/WidgetPDial.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/fl_draw.H>
#include <FL/fl_ask.H>
#include "Params/EnvelopeParams.h"
#include "PresetsUI.h"
#include "Misc/SynthEngine.h"

class EnvelopeFreeEdit : public Fl_Box {
public:
  EnvelopeFreeEdit(int x,int y, int w, int h, const char *label=0);
  void send_data(int action, int control, int offset, float value, int type);
  void init(EnvelopeParams *env_, int npart_, int kititem_, int engine_, int group_);
  void setpair(Fl_Box *pair_);
  int getpointx(size_t n);
  int getpointy(int n);
  size_t getnearest(int x,int y);
private:
  void draw();
public:
  int handle(int event);
private:
  Fl_Box *pair;
  EnvelopeParams *env;
  int oldx;
  int currentpoint,cpx,cpdt;
public:
  int lastpoint;
private:
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
  int group;
};
#include <FL/Fl_Button.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Group.H>

class EnvelopeUI : public Fl_Group,PresetsUI_ {
public:
  EnvelopeUI(int x,int y, int w, int h, const char *label=0);
  ~EnvelopeUI();
  ScaleTrackedWindow* make_freemode_edit_window();
  ScaleTrackedWindow *freemodeeditwindow;
private:
  inline void cb_freemodeeditwindow_i(ScaleTrackedWindow*, void*);
  static void cb_freemodeeditwindow(ScaleTrackedWindow*, void*);
public:
  EnvelopeFreeEdit *freeedit;
  Fl_Check_Button2 *freemodebutton;
private:
  inline void cb_freemodebutton_i(Fl_Check_Button2*, void*);
  static void cb_freemodebutton(Fl_Check_Button2*, void*);
public:
  Fl_Button *addpoint;
private:
  inline void cb_addpoint_i(Fl_Button*, void*);
  static void cb_addpoint(Fl_Button*, void*);
public:
  Fl_Button *deletepoint;
private:
  inline void cb_deletepoint_i(Fl_Button*, void*);
  static void cb_deletepoint(Fl_Button*, void*);
public:
  Fl_Counter *sustaincounter;
private:
  inline void cb_sustaincounter_i(Fl_Counter*, void*);
  static void cb_sustaincounter(Fl_Counter*, void*);
public:
  WidgetPDial *envstretchdial;
private:
  inline void cb_envstretchdial_i(WidgetPDial*, void*);
  static void cb_envstretchdial(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *linearenvelopecheck;
private:
  inline void cb_linearenvelopecheck_i(Fl_Check_Button2*, void*);
  static void cb_linearenvelopecheck(Fl_Check_Button2*, void*);
public:
  Fl_Check_Button2 *forcedreleasecheck;
private:
  inline void cb_forcedreleasecheck_i(Fl_Check_Button2*, void*);
  static void cb_forcedreleasecheck(Fl_Check_Button2*, void*);
public:
  Fl_Button *freecopy;
private:
  inline void cb_freecopy_i(Fl_Button*, void*);
  static void cb_freecopy(Fl_Button*, void*);
public:
  Fl_Button *freepaste;
private:
  inline void cb_freepaste_i(Fl_Button*, void*);
  static void cb_freepaste(Fl_Button*, void*);
public:
  Fl_Button *freeClose;
private:
  inline void cb_freeClose_i(Fl_Button*, void*);
  static void cb_freeClose(Fl_Button*, void*);
public:
  Fl_Group* make_ADSR_window();
  Fl_Group *envADSR;
  Fl_Group *e1name;
  WidgetPDial *e1adt;
private:
  inline void cb_e1adt_i(WidgetPDial*, void*);
  static void cb_e1adt(WidgetPDial*, void*);
public:
  WidgetPDial *e1ddt;
private:
  inline void cb_e1ddt_i(WidgetPDial*, void*);
  static void cb_e1ddt(WidgetPDial*, void*);
public:
  WidgetPDial *e1rdt;
private:
  inline void cb_e1rdt_i(WidgetPDial*, void*);
  static void cb_e1rdt(WidgetPDial*, void*);
public:
  WidgetPDial *e1sval;
private:
  inline void cb_e1sval_i(WidgetPDial*, void*);
  static void cb_e1sval(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *e1forcedrelease;
private:
  inline void cb_e1forcedrelease_i(Fl_Check_Button2*, void*);
  static void cb_e1forcedrelease(Fl_Check_Button2*, void*);
public:
  WidgetPDial *e1envstretch;
private:
  inline void cb_e1envstretch_i(WidgetPDial*, void*);
  static void cb_e1envstretch(WidgetPDial*, void*);
public:
  Fl_Button *e1E;
private:
  inline void cb_e1E_i(Fl_Button*, void*);
  static void cb_e1E(Fl_Button*, void*);
public:
  Fl_Check_Button2 *e1linearenvelope;
private:
  inline void cb_e1linearenvelope_i(Fl_Check_Button2*, void*);
  static void cb_e1linearenvelope(Fl_Check_Button2*, void*);
public:
  Fl_Button *e1C;
private:
  inline void cb_e1C_i(Fl_Button*, void*);
  static void cb_e1C(Fl_Button*, void*);
public:
  Fl_Button *e1P;
private:
  inline void cb_e1P_i(Fl_Button*, void*);
  static void cb_e1P(Fl_Button*, void*);
public:
  Fl_Group* make_ASR_window();
  Fl_Group *envASR;
  Fl_Group *e2name;
  WidgetPDial *e2aval;
private:
  inline void cb_e2aval_i(WidgetPDial*, void*);
  static void cb_e2aval(WidgetPDial*, void*);
public:
  WidgetPDial *e2adt;
private:
  inline void cb_e2adt_i(WidgetPDial*, void*);
  static void cb_e2adt(WidgetPDial*, void*);
public:
  WidgetPDial *e2rval;
private:
  inline void cb_e2rval_i(WidgetPDial*, void*);
  static void cb_e2rval(WidgetPDial*, void*);
public:
  WidgetPDial *e2rdt;
private:
  inline void cb_e2rdt_i(WidgetPDial*, void*);
  static void cb_e2rdt(WidgetPDial*, void*);
public:
  WidgetPDial *e2envstretch;
private:
  inline void cb_e2envstretch_i(WidgetPDial*, void*);
  static void cb_e2envstretch(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *e2forcedrelease;
private:
  inline void cb_e2forcedrelease_i(Fl_Check_Button2*, void*);
  static void cb_e2forcedrelease(Fl_Check_Button2*, void*);
public:
  Fl_Button *e2C;
private:
  inline void cb_e2C_i(Fl_Button*, void*);
  static void cb_e2C(Fl_Button*, void*);
public:
  Fl_Button *e2P;
private:
  inline void cb_e2P_i(Fl_Button*, void*);
  static void cb_e2P(Fl_Button*, void*);
public:
  Fl_Button *e2E;
private:
  inline void cb_e2E_i(Fl_Button*, void*);
  static void cb_e2E(Fl_Button*, void*);
public:
  Fl_Group* make_ADSRfilter_window();
  Fl_Group *envADSRfilter;
  Fl_Group *e3name;
  WidgetPDial *e3aval;
private:
  inline void cb_e3aval_i(WidgetPDial*, void*);
  static void cb_e3aval(WidgetPDial*, void*);
public:
  WidgetPDial *e3adt;
private:
  inline void cb_e3adt_i(WidgetPDial*, void*);
  static void cb_e3adt(WidgetPDial*, void*);
public:
  WidgetPDial *e3dval;
private:
  inline void cb_e3dval_i(WidgetPDial*, void*);
  static void cb_e3dval(WidgetPDial*, void*);
public:
  WidgetPDial *e3ddt;
private:
  inline void cb_e3ddt_i(WidgetPDial*, void*);
  static void cb_e3ddt(WidgetPDial*, void*);
public:
  WidgetPDial *e3rdt;
private:
  inline void cb_e3rdt_i(WidgetPDial*, void*);
  static void cb_e3rdt(WidgetPDial*, void*);
public:
  WidgetPDial *e3rval;
private:
  inline void cb_e3rval_i(WidgetPDial*, void*);
  static void cb_e3rval(WidgetPDial*, void*);
public:
  WidgetPDial *e3envstretch;
private:
  inline void cb_e3envstretch_i(WidgetPDial*, void*);
  static void cb_e3envstretch(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *e3forcedrelease;
private:
  inline void cb_e3forcedrelease_i(Fl_Check_Button2*, void*);
  static void cb_e3forcedrelease(Fl_Check_Button2*, void*);
public:
  Fl_Button *e3E;
private:
  inline void cb_e3E_i(Fl_Button*, void*);
  static void cb_e3E(Fl_Button*, void*);
public:
  Fl_Button *e3C;
private:
  inline void cb_e3C_i(Fl_Button*, void*);
  static void cb_e3C(Fl_Button*, void*);
public:
  Fl_Button *e3P;
private:
  inline void cb_e3P_i(Fl_Button*, void*);
  static void cb_e3P(Fl_Button*, void*);
public:
  Fl_Group* make_ASRbw_window();
  Fl_Group *envASRbw;
  Fl_Group *e4name;
  WidgetPDial *e4aval;
private:
  inline void cb_e4aval_i(WidgetPDial*, void*);
  static void cb_e4aval(WidgetPDial*, void*);
public:
  WidgetPDial *e4adt;
private:
  inline void cb_e4adt_i(WidgetPDial*, void*);
  static void cb_e4adt(WidgetPDial*, void*);
public:
  WidgetPDial *e4rval;
private:
  inline void cb_e4rval_i(WidgetPDial*, void*);
  static void cb_e4rval(WidgetPDial*, void*);
public:
  WidgetPDial *e4rdt;
private:
  inline void cb_e4rdt_i(WidgetPDial*, void*);
  static void cb_e4rdt(WidgetPDial*, void*);
public:
  WidgetPDial *e4envstretch;
private:
  inline void cb_e4envstretch_i(WidgetPDial*, void*);
  static void cb_e4envstretch(WidgetPDial*, void*);
public:
  Fl_Check_Button2 *e4forcedrelease;
private:
  inline void cb_e4forcedrelease_i(Fl_Check_Button2*, void*);
  static void cb_e4forcedrelease(Fl_Check_Button2*, void*);
public:
  Fl_Button *e4C;
private:
  inline void cb_e4C_i(Fl_Button*, void*);
  static void cb_e4C(Fl_Button*, void*);
public:
  Fl_Button *e4P;
private:
  inline void cb_e4P_i(Fl_Button*, void*);
  static void cb_e4P(Fl_Button*, void*);
public:
  Fl_Button *e4E;
private:
  inline void cb_e4E_i(Fl_Button*, void*);
  static void cb_e4E(Fl_Button*, void*);
public:
  Fl_Group* make_free_window();
  Fl_Group *envfree;
  Fl_Group *envfreegroup;
  EnvelopeFreeEdit *freeeditsmall;
private:
  inline void cb_freeeditsmall_i(EnvelopeFreeEdit*, void*);
  static void cb_freeeditsmall(EnvelopeFreeEdit*, void*);
public:
  Fl_Button *efC;
private:
  inline void cb_efC_i(Fl_Button*, void*);
  static void cb_efC(Fl_Button*, void*);
public:
  Fl_Button *efP;
private:
  inline void cb_efP_i(Fl_Button*, void*);
  static void cb_efP(Fl_Button*, void*);
public:
  Fl_Button *efE;
private:
  inline void cb_efE_i(Fl_Button*, void*);
  static void cb_efE(Fl_Button*, void*);
public:
  void send_data(int action, int group, int control, float value, int type, int insert = TOPLEVEL::insert::envelopeGroup, int offset = UNUSED);
  void returns_update(CommandBlock *getData);
  void init(EnvelopeParams *env_, int npart_, int kititem_, int engine_, int group_);
  void reinitcore(bool freemode);
  void refresh();
  void theme();
  void showfree();
  void wincheck();
  void envfreeRtext();
  void envRtext(float dScale);
  void setAmpSusVType(bool linear);
private:
  EnvelopeParams *env;
  Fl_Group *envwindow;
  SynthEngine *synth;
  int npart;
  int kititem;
  int engine;
  int group;
  int lastfreeX;
  int lastfreeY;
  int lastfreeW;
  int freeDW;
  int freeDH;
};
#endif
