﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/panorama/Panorama_EXPORTS.h>
#include <aws/panorama/model/NodeCategory.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Panorama {
namespace Model {

/**
 * <p>An application node that represents a camera stream, a model, code, or
 * output.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/panorama-2019-07-24/Node">AWS API
 * Reference</a></p>
 */
class Node {
 public:
  AWS_PANORAMA_API Node() = default;
  AWS_PANORAMA_API Node(Aws::Utils::Json::JsonView jsonValue);
  AWS_PANORAMA_API Node& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_PANORAMA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The node's category.</p>
   */
  inline NodeCategory GetCategory() const { return m_category; }
  inline bool CategoryHasBeenSet() const { return m_categoryHasBeenSet; }
  inline void SetCategory(NodeCategory value) {
    m_categoryHasBeenSet = true;
    m_category = value;
  }
  inline Node& WithCategory(NodeCategory value) {
    SetCategory(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the node was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  Node& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's description.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Node& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  Node& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's ID.</p>
   */
  inline const Aws::String& GetNodeId() const { return m_nodeId; }
  inline bool NodeIdHasBeenSet() const { return m_nodeIdHasBeenSet; }
  template <typename NodeIdT = Aws::String>
  void SetNodeId(NodeIdT&& value) {
    m_nodeIdHasBeenSet = true;
    m_nodeId = std::forward<NodeIdT>(value);
  }
  template <typename NodeIdT = Aws::String>
  Node& WithNodeId(NodeIdT&& value) {
    SetNodeId(std::forward<NodeIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The account ID of the node's owner.</p>
   */
  inline const Aws::String& GetOwnerAccount() const { return m_ownerAccount; }
  inline bool OwnerAccountHasBeenSet() const { return m_ownerAccountHasBeenSet; }
  template <typename OwnerAccountT = Aws::String>
  void SetOwnerAccount(OwnerAccountT&& value) {
    m_ownerAccountHasBeenSet = true;
    m_ownerAccount = std::forward<OwnerAccountT>(value);
  }
  template <typename OwnerAccountT = Aws::String>
  Node& WithOwnerAccount(OwnerAccountT&& value) {
    SetOwnerAccount(std::forward<OwnerAccountT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's ARN.</p>
   */
  inline const Aws::String& GetPackageArn() const { return m_packageArn; }
  inline bool PackageArnHasBeenSet() const { return m_packageArnHasBeenSet; }
  template <typename PackageArnT = Aws::String>
  void SetPackageArn(PackageArnT&& value) {
    m_packageArnHasBeenSet = true;
    m_packageArn = std::forward<PackageArnT>(value);
  }
  template <typename PackageArnT = Aws::String>
  Node& WithPackageArn(PackageArnT&& value) {
    SetPackageArn(std::forward<PackageArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's package ID.</p>
   */
  inline const Aws::String& GetPackageId() const { return m_packageId; }
  inline bool PackageIdHasBeenSet() const { return m_packageIdHasBeenSet; }
  template <typename PackageIdT = Aws::String>
  void SetPackageId(PackageIdT&& value) {
    m_packageIdHasBeenSet = true;
    m_packageId = std::forward<PackageIdT>(value);
  }
  template <typename PackageIdT = Aws::String>
  Node& WithPackageId(PackageIdT&& value) {
    SetPackageId(std::forward<PackageIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's package name.</p>
   */
  inline const Aws::String& GetPackageName() const { return m_packageName; }
  inline bool PackageNameHasBeenSet() const { return m_packageNameHasBeenSet; }
  template <typename PackageNameT = Aws::String>
  void SetPackageName(PackageNameT&& value) {
    m_packageNameHasBeenSet = true;
    m_packageName = std::forward<PackageNameT>(value);
  }
  template <typename PackageNameT = Aws::String>
  Node& WithPackageName(PackageNameT&& value) {
    SetPackageName(std::forward<PackageNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's package version.</p>
   */
  inline const Aws::String& GetPackageVersion() const { return m_packageVersion; }
  inline bool PackageVersionHasBeenSet() const { return m_packageVersionHasBeenSet; }
  template <typename PackageVersionT = Aws::String>
  void SetPackageVersion(PackageVersionT&& value) {
    m_packageVersionHasBeenSet = true;
    m_packageVersion = std::forward<PackageVersionT>(value);
  }
  template <typename PackageVersionT = Aws::String>
  Node& WithPackageVersion(PackageVersionT&& value) {
    SetPackageVersion(std::forward<PackageVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The node's patch version.</p>
   */
  inline const Aws::String& GetPatchVersion() const { return m_patchVersion; }
  inline bool PatchVersionHasBeenSet() const { return m_patchVersionHasBeenSet; }
  template <typename PatchVersionT = Aws::String>
  void SetPatchVersion(PatchVersionT&& value) {
    m_patchVersionHasBeenSet = true;
    m_patchVersion = std::forward<PatchVersionT>(value);
  }
  template <typename PatchVersionT = Aws::String>
  Node& WithPatchVersion(PatchVersionT&& value) {
    SetPatchVersion(std::forward<PatchVersionT>(value));
    return *this;
  }
  ///@}
 private:
  NodeCategory m_category{NodeCategory::NOT_SET};
  bool m_categoryHasBeenSet = false;

  Aws::Utils::DateTime m_createdTime{};
  bool m_createdTimeHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_nodeId;
  bool m_nodeIdHasBeenSet = false;

  Aws::String m_ownerAccount;
  bool m_ownerAccountHasBeenSet = false;

  Aws::String m_packageArn;
  bool m_packageArnHasBeenSet = false;

  Aws::String m_packageId;
  bool m_packageIdHasBeenSet = false;

  Aws::String m_packageName;
  bool m_packageNameHasBeenSet = false;

  Aws::String m_packageVersion;
  bool m_packageVersionHasBeenSet = false;

  Aws::String m_patchVersion;
  bool m_patchVersionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Panorama
}  // namespace Aws
