/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class UniOnSubscribeCall<T>
extends UniOperator<T, T> {
    private final Function<? super UniSubscription, Uni<?>> callback;

    public UniOnSubscribeCall(Uni<? extends T> upstream, Function<? super UniSubscription, Uni<?>> callback) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.callback = callback;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnSubscribeCallProcessor(subscriber));
    }

    private class UniOnSubscribeCallProcessor
    extends UniOperatorProcessor<T, T> {
        private volatile T item;
        private volatile Throwable failure;
        private final AtomicBoolean done;

        public UniOnSubscribeCallProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
            this.done = new AtomicBoolean();
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            Uni<?> uni;
            try {
                uni = Objects.requireNonNull(UniOnSubscribeCall.this.callback.apply(subscription), "The produced Uni must not be `null`");
            }
            catch (Throwable e) {
                this.downstream.onSubscribe(EmptyUniSubscription.DONE);
                this.downstream.onFailure(e);
                return;
            }
            uni.subscribe().with(this.context(), ignored -> {
                this.downstream.onSubscribe(subscription);
                if (this.done.compareAndSet(false, true)) {
                    this.forwardPendingEvent();
                }
            }, failed -> {
                this.done.set(true);
                subscription.cancel();
                this.downstream.onSubscribe(EmptyUniSubscription.DONE);
                this.downstream.onFailure((Throwable)failed);
            });
        }

        private void forwardPendingEvent() {
            if (this.item != null) {
                this.downstream.onItem(this.item);
            } else if (this.failure != null) {
                this.downstream.onFailure(this.failure);
            }
        }

        @Override
        public void onItem(T item) {
            if (this.done.get()) {
                this.downstream.onItem(item);
            } else {
                this.item = item;
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.done.get()) {
                this.downstream.onFailure(failure);
            } else {
                this.failure = failure;
            }
        }
    }
}

