/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskCode;
import net.sourceforge.plantuml.project.lang.SentenceDisplayOnSameRowAs;
import net.sourceforge.plantuml.project.lang.SentenceEnds;
import net.sourceforge.plantuml.project.lang.SentenceHappens;
import net.sourceforge.plantuml.project.lang.SentenceHappensDate;
import net.sourceforge.plantuml.project.lang.SentenceIsColored;
import net.sourceforge.plantuml.project.lang.SentenceIsColoredForCompletion;
import net.sourceforge.plantuml.project.lang.SentenceIsDeleted;
import net.sourceforge.plantuml.project.lang.SentenceIsDisplayedAs;
import net.sourceforge.plantuml.project.lang.SentenceIsForTask;
import net.sourceforge.plantuml.project.lang.SentenceLinksTo;
import net.sourceforge.plantuml.project.lang.SentenceOccurs;
import net.sourceforge.plantuml.project.lang.SentencePausesAbsoluteDate;
import net.sourceforge.plantuml.project.lang.SentencePausesAbsoluteIntervals;
import net.sourceforge.plantuml.project.lang.SentencePausesAbsoluteIntervalsSmart;
import net.sourceforge.plantuml.project.lang.SentencePausesDayOfWeek;
import net.sourceforge.plantuml.project.lang.SentenceRequire;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.SentenceTaskEndsAbsolute;
import net.sourceforge.plantuml.project.lang.SentenceTaskEndsOnlyRelative;
import net.sourceforge.plantuml.project.lang.SentenceTaskStarts;
import net.sourceforge.plantuml.project.lang.SentenceTaskStartsAbsolute;
import net.sourceforge.plantuml.project.lang.SentenceTaskStartsOnlyRelative;
import net.sourceforge.plantuml.project.lang.SentenceTaskStartsWithColor;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Words;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;

public class SubjectTask
implements Subject<GanttDiagram> {
    public static final Subject<GanttDiagram> ME = new SubjectTask();
    public static final String REGEX_TASK_CODE = "\\[([^\\[\\]]+?)\\]";

    private SubjectTask() {
    }

    @Override
    public Failable<Task> getMe(GanttDiagram gantt, RegexResult arg) {
        Task result;
        if (arg.get("IT", 0) != null) {
            result = gantt.getIt();
            if (result == null) {
                return Failable.error("Not sure what are you refering to?");
            }
        } else {
            String subject = arg.get("SUBJECT", 0);
            String shortName = arg.get("SHORTNAME", 0);
            String then = arg.get("THEN", 0);
            String stereotype = arg.get("STEREOTYPE", 0);
            TaskCode code = TaskCode.fromIdAndDisplay(shortName, subject);
            result = gantt.getOrCreateTask(code, then != null);
            if (stereotype != null) {
                result.setStereotype(Stereotype.build(arg.get("STEREOTYPE", 0)));
            }
            gantt.setIt(result);
        }
        if (result == null) {
            throw new IllegalStateException();
        }
        String resource = arg.get("RESOURCE", 0);
        if (resource != null) {
            StringTokenizer st = new StringTokenizer(resource, "{}");
            while (st.hasMoreTokens()) {
                boolean ok;
                String part = st.nextToken().trim();
                if (part.length() <= 0 || (ok = gantt.affectResource(result, part))) continue;
                return Failable.error("Bad argument for resource");
            }
        }
        return Failable.ok(result);
    }

    @Override
    public Collection<? extends SentenceSimple<GanttDiagram>> getSentences() {
        return Arrays.asList(new SentenceRequire(), new SentenceTaskStarts(), new SentenceTaskStartsWithColor(), new SentenceTaskStartsOnlyRelative(), new SentenceTaskStartsAbsolute(), new SentenceHappens(), new SentenceHappensDate(), new SentenceEnds(), new SentenceTaskEndsOnlyRelative(), new SentenceTaskEndsAbsolute(), new SentenceIsColored(), new SentenceIsColoredForCompletion(), new SentenceIsDeleted(), new SentenceIsForTask(), new SentenceLinksTo(), new SentenceOccurs(), new SentenceDisplayOnSameRowAs(), new SentencePausesAbsoluteDate(), new SentencePausesAbsoluteIntervals(), new SentencePausesAbsoluteIntervalsSmart(), new SentencePausesDayOfWeek(), new SentenceIsDisplayedAs());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(new RegexLeaf(1, "IT", "(it)"), new RegexConcat(new RegexLeaf(1, "THEN", "(then[%s]+)?"), new RegexLeaf(1, "SUBJECT", REGEX_TASK_CODE), StereotypePattern.optional("STEREOTYPE"), new RegexOptional((IRegex)new RegexConcat(Words.exactly("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "SHORTNAME", REGEX_TASK_CODE))), new RegexOptional((IRegex)new RegexConcat(Words.exactly("on"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "RESOURCE", "((?:\\{[^{}]+\\}[%s]*)+)")))));
    }
}

