/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;

public final class HgConflictResolver {
    @NotNull
    private final Project myProject;
    private final UpdatedFiles updatedFiles;

    public HgConflictResolver(@NotNull Project project) {
        if (project == null) {
            HgConflictResolver.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public HgConflictResolver(@NotNull Project project, UpdatedFiles updatedFiles) {
        if (project == null) {
            HgConflictResolver.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.updatedFiles = updatedFiles;
    }

    public void resolve(VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(this.myProject).getListSynchronously(repo);
        ArrayList<File> conflictFiles = new ArrayList<File>();
        for (HgFile hgFile : resolves.keySet()) {
            File file = hgFile.getFile();
            if (resolves.get(hgFile) == HgResolveStatusEnum.UNRESOLVED) {
                conflictFiles.add(file);
                this.updateUpdatedFiles(file, true);
                continue;
            }
            this.updateUpdatedFiles(file, false);
        }
        if (conflictFiles.isEmpty()) {
            return;
        }
        HgVcs vcs = HgVcs.getInstance(this.myProject);
        if (vcs == null) {
            return;
        }
        List conflicts = DvcsUtil.sortVirtualFilesByPresentation((Collection)DvcsUtil.findVirtualFilesWithRefresh(conflictFiles));
        ApplicationManager.getApplication().invokeAndWait(() -> AbstractVcsHelper.getInstance((Project)this.myProject).showMergeDialog(conflicts, vcs.getMergeProvider()));
    }

    private void updateUpdatedFiles(@NotNull File file, boolean unresolved) {
        if (file == null) {
            HgConflictResolver.$$$reportNull$$$0(2);
        }
        if (this.updatedFiles != null) {
            this.updatedFiles.getGroupById("UPDATED").remove(file.getAbsolutePath());
            this.updatedFiles.getGroupById(unresolved ? "MERGED_WITH_CONFLICTS" : "MERGED").add(file.getPath(), "hg4idea", null);
        }
    }

    public static boolean hasConflicts(Project project, VirtualFile repo) {
        Map<HgFile, HgResolveStatusEnum> resolves = new HgResolveCommand(project).getListSynchronously(repo);
        return ContainerUtil.exists(resolves.values(), resolveStatus -> resolveStatus == HgResolveStatusEnum.UNRESOLVED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/provider/update/HgConflictResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUpdatedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

