/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSimilarityIndexImageFilter_h
#define sitkSimilarityIndexImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class SimilarityIndexImageFilter
\brief Measures the similarity between the set of non-zero pixels of two images.

SimilarityIndexImageFilter measures the similarity between the set non-zero pixels of two images using the following formula: \f[ S = \frac{2 | A \cap B |}{|A| + |B|} \f] where \f$A\f$ and \f$B\f$ are respectively the set of non-zero pixels in the first and second input images. Operator \f$|\cdot|\f$ represents the size of a set and \f$\cap\f$ represents the intersection of two sets.

The measure is derived from a reliability measure known as the kappa statistic. \f$S\f$ is sensitive to both differences in size and in location and have been in the literature for comparing two segmentation masks. For more information see: "Morphometric Analysis of White Matter Lesions in MR Images: Method and
Validation", A. P. Zijdenbos, B. M. Dawant, R. A. Margolin and A. C. Palmer, IEEE Trans. on Medical Imaging, 13(4) pp 716-724,1994

This filter requires the largest possible region of the first image and the same corresponding region in the second image. It behaves as filter with two input and one output. Thus it can be inserted in a pipeline with other filters. The filter passes the first input through unmodified.

This filter is templated over the two input image type. It assume both image have the same number of dimensions.

\sa itk::SimilarityIndexImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SimilarityIndexImageFilter : public ImageFilter {
    public:
      using Self = SimilarityIndexImageFilter;

      /** Destructor */
      virtual ~SimilarityIndexImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SimilarityIndexImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;

     /**
      * Return the computed similarity index.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetSimilarityIndex() const { return this->m_SimilarityIndex; };


      /** Name of this class */
      std::string GetName() const { return std::string ("SimilarityIndexImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */

      void Execute ( const Image& image1, const Image& image2 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = void (Self::*)( const Image& image1, const Image& image2 );
      template <class TImageType> void ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Some global documentation */
      double m_SimilarityIndex{0.0};


    };


}
#endif
